/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.lang.reflect.Method;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import org.dita.dost.log.DITAOTJavaLogger;

public class DITAOTCollator
implements Comparator {
    static HashMap cache = new HashMap();
    private Object collatorInstance = null;
    private Method compareMethod = null;
    private DITAOTJavaLogger logger = new DITAOTJavaLogger();

    public static DITAOTCollator getInstance() {
        return DITAOTCollator.getInstance(Locale.US);
    }

    public static DITAOTCollator getInstance(Locale locale) {
        DITAOTCollator instance = null;
        instance = (DITAOTCollator)cache.get(locale);
        if (instance == null) {
            instance = new DITAOTCollator(locale);
            cache.put(locale, instance);
        }
        return instance;
    }

    private DITAOTCollator() {
        this(Locale.US);
    }

    private DITAOTCollator(Locale locale) {
        this.init(locale);
    }

    public int compare(Object source, Object target) {
        try {
            return (Integer)this.compareMethod.invoke(this.collatorInstance, source, target);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void init(Locale locale) {
        Class<Object> c = null;
        try {
            c = Class.forName("com.ibm.icu.text.Collator");
            this.logger.logInfo("Using ICU collator for " + locale.toString());
        }
        catch (Exception e) {
            c = Collator.class;
            this.logger.logInfo("Using JDK collator for " + locale.toString());
        }
        try {
            Method m = c.getDeclaredMethod("getInstance", Locale.class);
            this.collatorInstance = m.invoke(null, locale);
            this.compareMethod = c.getDeclaredMethod("compare", Object.class, Object.class);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }
}

