/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;
import org.dita.dost.log.DITAOTJavaLogger;

public class DITAOTCopy
extends Task {
    private String includes = null;
    private String relativePaths = null;
    private String destDir = null;
    private DITAOTJavaLogger logger = new DITAOTJavaLogger();

    public void setIncludes(String incld) {
        this.includes = incld;
    }

    public void setTodir(String destdir) {
        this.destDir = destdir;
    }

    public void setRelativePaths(String relPaths) {
        this.relativePaths = relPaths;
    }

    public void execute() throws BuildException {
        FileUtils fileUitls = FileUtils.newFileUtils();
        if (this.includes == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.includes, ",");
        if (this.relativePaths == null) {
            try {
                while (tokenizer.hasMoreTokens()) {
                    File srcFile = new File(tokenizer.nextToken());
                    if (!srcFile.exists()) continue;
                    File destFile = new File(this.destDir, srcFile.getName());
                    fileUitls.copyFile(srcFile, destFile);
                }
            }
            catch (IOException e) {
                this.logger.logException(e);
            }
        } else {
            StringTokenizer pathTokenizer = new StringTokenizer(this.relativePaths, ",");
            StringBuffer realDest = null;
            try {
                while (tokenizer.hasMoreTokens()) {
                    File srcFile;
                    realDest = new StringBuffer();
                    if (this.destDir != null && this.destDir.trim().length() > 0) {
                        realDest.append(this.destDir).append(File.separator).append(pathTokenizer.nextToken());
                    }
                    if (!(srcFile = new File(tokenizer.nextToken())).exists()) continue;
                    File destFile = new File(realDest.toString());
                    fileUitls.copyFile(srcFile, destFile);
                }
            }
            catch (IOException e) {
                this.logger.logException(e);
            }
        }
    }
}

