/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.TopicIdParser;
import org.dita.dost.writer.AbstractXMLWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkTopicParser
extends AbstractXMLWriter {
    private static final String OS_NAME_WINDOWS = "windows";
    private static final String PI_END = "?>";
    private static final String PI_WORKDIR_HEAD = "<?workdir ";
    private LinkedHashMap<String, String> changeTable = null;
    private Hashtable<String, String> conflictTable = null;
    private Element elem = null;
    private boolean separate = false;
    private String filePath = null;
    private String currentParsingFile = null;
    private String outputFile = null;
    private Stack<String> outputFileNameStack = null;
    private String targetTopicId = null;
    private String selectMethod = "select-document";
    private boolean include = false;
    private boolean skip = false;
    private int includelevel = 0;
    private int skipLevel = 0;
    private HashSet<String> topicSpecSet = new HashSet(16);
    private boolean insideCDATA = false;
    private boolean needResolveEntity = true;
    private boolean startFromFirstTopic = false;
    private static XMLReader reader = null;
    private Writer output = null;
    private StringBuffer temp = null;
    private Stack<Writer> fileWriterStack = new Stack();
    private Stack<Element> stubStack = new Stack();
    private Element stub = null;
    private Element siblingStub = null;
    DITAOTJavaLogger logger = null;
    private String ditaext = null;
    private Set<String> topicID;
    private Set<String> copyto;
    private Set<String> copytoSource;
    private HashMap<String, String> copytotarget2source;
    private final String ditaarchNSQName = "xmlns:ditaarch";
    private final String ditaarchNSValue = "http://dita.oasis-open.org/architecture/2005/";

    public ChunkTopicParser() {
        this.outputFileNameStack = new Stack();
        this.logger = new DITAOTJavaLogger();
        this.topicID = new HashSet<String>();
        this.copyto = new HashSet<String>();
        this.copytoSource = new HashSet<String>();
        this.copytotarget2source = new HashMap();
        new HashSet();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.include && this.needResolveEntity) {
            try {
                if (this.insideCDATA) {
                    this.output.write(ch, start, length);
                } else {
                    this.output.write(StringUtils.escapeXML(ch, start, length));
                }
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        super.comment(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.include = false;
        this.skip = false;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.skip && this.skipLevel > 0) {
            --this.skipLevel;
        } else if (this.skip) {
            this.include = true;
            this.skip = false;
            this.skipLevel = 0;
        }
        if (this.include) {
            try {
                --this.includelevel;
                if (this.includelevel >= 0) {
                    this.output.write("</" + qName + ">");
                }
                if (this.includelevel == 0 && !"select-document".equals(this.selectMethod)) {
                    this.include = false;
                }
                if (this.topicSpecSet.contains(qName) && this.separate && !this.fileWriterStack.isEmpty()) {
                    this.output.close();
                    this.output = (OutputStreamWriter)this.fileWriterStack.pop();
                    this.outputFile = this.outputFileNameStack.pop();
                    this.stub.getParentNode().removeChild(this.stub);
                    this.stub = this.stubStack.pop();
                }
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (!this.needResolveEntity) {
            this.needResolveEntity = true;
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.include) {
            try {
                this.output.write(ch, start, length);
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.include || "workdir".equalsIgnoreCase(target) || "path2proj".equalsIgnoreCase(target)) {
            try {
                String pi = data != null ? target + " " + data : target;
                this.output.write("<?" + pi + "?" + ">");
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    @Override
    public void setContent(Content content) {
        super.setContent(content);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.include) {
            try {
                this.output.write(StringUtils.getEntity(name));
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if ("select-document".equals(this.selectMethod)) {
            if (this.currentParsingFile.equals(this.outputFile)) {
                this.include = true;
                this.skip = false;
                this.skipLevel = 0;
            } else {
                this.include = false;
                this.startFromFirstTopic = true;
                this.skip = false;
                this.skipLevel = 0;
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String classValue = atts.getValue("class");
        String idValue = atts.getValue("id");
        if (this.skip && this.skipLevel > 0) {
            ++this.skipLevel;
        }
        try {
            if (classValue != null && classValue.indexOf(" topic/topic ") != -1) {
                this.topicSpecSet.add(qName);
                if (this.separate && this.include && !"select-topic".equals(this.selectMethod)) {
                    this.fileWriterStack.push(this.output);
                    this.outputFileNameStack.push(this.outputFile);
                    Random random = new Random();
                    String newFileName = FileUtils.resolveFile(this.filePath, idValue + this.ditaext);
                    if (StringUtils.isEmptyString(idValue) || FileUtils.fileExists(newFileName)) {
                        String t = newFileName;
                        newFileName = FileUtils.resolveFile(this.filePath, "Chunk" + new Integer(Math.abs(random.nextInt())).toString()) + this.ditaext;
                        this.conflictTable.put(newFileName, t);
                    }
                    this.outputFile = newFileName;
                    this.output = new OutputStreamWriter((OutputStream)new FileOutputStream(newFileName), "UTF-8");
                    this.output.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                    if (Constants.OS_NAME.toLowerCase().indexOf(OS_NAME_WINDOWS) == -1) {
                        this.output.write(PI_WORKDIR_HEAD + this.filePath + PI_END);
                    } else {
                        this.output.write("<?workdir /" + this.filePath + PI_END);
                    }
                    this.changeTable.put(newFileName, newFileName);
                    if (idValue != null) {
                        this.changeTable.put(this.currentParsingFile + "#" + idValue, newFileName + "#" + idValue);
                    } else {
                        this.changeTable.put(this.currentParsingFile, newFileName);
                    }
                    Element newChild = this.elem.getOwnerDocument().createElement("topicref");
                    newChild.setAttribute("href", FileUtils.getRelativePathFromMap(this.filePath + "/" + "stub.ditamap", newFileName));
                    newChild.setAttribute("class", "- map/topicref ");
                    newChild.setAttribute("xtrf", "generated_by_chunk");
                    if (this.stub != null) {
                        if (this.includelevel == 0 && this.siblingStub != null) {
                            this.siblingStub.getParentNode().insertBefore(newChild, this.siblingStub);
                        } else {
                            this.stub.getParentNode().insertBefore(newChild, this.stub);
                        }
                        this.stubStack.push(this.stub);
                        this.stub = (Element)this.stub.cloneNode(false);
                        newChild.appendChild(this.stub);
                    }
                }
                if (this.include && "select-topic".equals(this.selectMethod)) {
                    this.include = false;
                    this.skipLevel = 1;
                    this.skip = true;
                } else if (this.include) {
                    if (!this.currentParsingFile.equals(this.outputFile)) {
                        if (idValue != null) {
                            this.changeTable.put(this.currentParsingFile + "#" + idValue, this.outputFile + "#" + idValue);
                        } else {
                            this.changeTable.put(this.currentParsingFile, this.outputFile);
                        }
                    }
                } else if (this.skip) {
                    this.skipLevel = 1;
                } else if (!this.include && idValue != null && (idValue.equals(this.targetTopicId) || this.startFromFirstTopic)) {
                    this.include = true;
                    this.includelevel = 0;
                    this.skip = false;
                    this.skipLevel = 0;
                    this.startFromFirstTopic = false;
                    if (!this.currentParsingFile.equals(this.outputFile)) {
                        this.changeTable.put(this.currentParsingFile + "#" + idValue, this.outputFile + "#" + idValue);
                    }
                }
            }
            if (this.include) {
                ++this.includelevel;
                this.output.write("<" + qName);
                for (int i = 0; i < atts.getLength(); ++i) {
                    String attrName = atts.getQName(i);
                    String attrValue = atts.getValue(i);
                    attrValue = StringUtils.escapeXML(attrValue);
                    if ("id".equals(attrName) && classValue.indexOf(" topic/topic ") != -1) {
                        if (this.topicID.contains(attrValue)) {
                            Random random = new Random();
                            attrValue = "unique_" + new Integer(Math.abs(random.nextInt())).toString();
                            this.topicID.add(attrValue);
                        } else {
                            this.topicID.add(attrValue);
                        }
                    }
                    if ("href".equals(attrName)) {
                        this.output.write(" ");
                        this.output.write("href");
                        this.output.write("=\"");
                        if (this.checkHREF(atts)) {
                            String relative = FileUtils.getRelativePathFromMap(this.outputFile, this.currentParsingFile);
                            if (attrValue.startsWith("#")) {
                                this.output.write(relative + attrValue);
                            } else if (relative.indexOf("/") != -1) {
                                relative = relative.substring(0, relative.lastIndexOf("/"));
                                this.output.write(FileUtils.resolveTopic(relative, attrValue));
                            } else {
                                this.output.write(attrValue);
                            }
                        } else {
                            this.output.write(attrValue);
                        }
                        this.output.write("\"");
                        continue;
                    }
                    this.output.write(" ");
                    this.output.write(attrName);
                    this.output.write("=\"");
                    this.output.write(attrValue);
                    this.output.write("\"");
                }
                if (classValue != null && classValue.contains(" topic/topic ") && atts.getValue("xmlns:ditaarch") == null) {
                    this.output.write(" ");
                    this.output.write("xmlns:ditaarch");
                    this.output.write("=\"");
                    this.output.write("http://dita.oasis-open.org/architecture/2005/");
                    this.output.write("\"");
                }
                this.output.write(">");
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.include) {
            try {
                this.needResolveEntity = StringUtils.checkEntity(name);
                if (!this.needResolveEntity) {
                    this.output.write(StringUtils.getEntity(name));
                }
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        this.insideCDATA = false;
        try {
            this.output.write("]]>");
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        try {
            this.insideCDATA = true;
            this.output.write("<![CDATA[");
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void write(String filename) throws DITAOTException {
        this.filePath = filename;
        this.needResolveEntity = true;
        if (!this.separate) {
            this.output = new StringWriter();
            this.processChunk(this.elem, null);
        } else {
            this.separateChunk(this.elem);
        }
        if (!this.copyto.isEmpty()) {
            this.updateList();
        }
    }

    private void updateList() {
        Properties property = new Properties();
        FileOutputStream output = null;
        FileOutputStream xmlDitaList = null;
        String key = null;
        String filename = null;
        BufferedWriter bufferedWriter = null;
        try {
            property.loadFromXML(new FileInputStream(new File(FileUtils.resolveFile(this.filePath, "dita.xml.properties"))));
            output = new FileOutputStream(new File(FileUtils.resolveFile(this.filePath, "dita.list")));
            xmlDitaList = new FileOutputStream(new File(FileUtils.resolveFile(this.filePath, "dita.xml.properties")));
            String[] copytosourcelist = property.getProperty("copytosourcelist").split(",");
            String[] copytotarget2sourcemaplist = property.getProperty("copytotarget2sourcemaplist").split(",");
            for (String source : copytosourcelist) {
                this.copytoSource.add(source);
            }
            for (String target2source : copytotarget2sourcemaplist) {
                if (target2source.indexOf("=") == -1) continue;
                this.copytotarget2source.put(target2source.substring(0, target2source.indexOf("=")), target2source.substring(target2source.indexOf("=") - 1));
            }
            this.temp = new StringBuffer();
            Iterator<String> it = this.copytoSource.iterator();
            filename = "copytosourcelist".substring(0, "copytosourcelist".lastIndexOf("list")) + ".list";
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(FileUtils.resolveFile(this.filePath, filename)))));
            while (it.hasNext()) {
                key = it.next();
                this.temp.append(key);
                if (it.hasNext()) {
                    this.temp.append(",");
                }
                bufferedWriter.append("\n");
            }
            property.setProperty("copytosourcelist", this.temp.toString());
            bufferedWriter.flush();
            this.temp = new StringBuffer();
            it = this.copytotarget2source.keySet().iterator();
            filename = "copytotarget2sourcemaplist".substring(0, "copytotarget2sourcemaplist".lastIndexOf("list")) + ".list";
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(FileUtils.resolveFile(this.filePath, filename)))));
            while (it.hasNext()) {
                key = it.next();
                this.temp.append(key).append("=").append(this.copytotarget2source.get(key));
                bufferedWriter.append(key).append("=").append(this.copytotarget2source.get(key));
                if (it.hasNext()) {
                    this.temp.append(",");
                }
                bufferedWriter.append("\n");
            }
            property.setProperty("copytotarget2sourcemaplist", this.temp.toString());
            bufferedWriter.flush();
            bufferedWriter.close();
            property.store(output, null);
            property.storeToXML(xmlDitaList, null);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void separateChunk(Element element) {
        block40: {
            boolean dotchunk;
            Writer tempOutput;
            block39: {
                String hrefValue = element.getAttribute("href");
                String copytoValue = element.getAttribute("copy-to");
                String scopeValue = element.getAttribute("scope");
                String parseFilePath = null;
                tempOutput = null;
                String chunkValue = element.getAttribute("chunk");
                String processRoleValue = element.getAttribute("processing-role");
                dotchunk = false;
                parseFilePath = !copytoValue.equals("") && !chunkValue.contains("to-content") ? (hrefValue.indexOf("#") != -1 ? copytoValue + hrefValue.substring(hrefValue.indexOf("#")) : copytoValue) : hrefValue;
                if (!copytoValue.equals("") && chunkValue.contains("to-content")) {
                    this.copyto.add(copytoValue);
                    if (hrefValue.indexOf("#") != -1) {
                        this.copytoSource.add(hrefValue.substring(0, hrefValue.indexOf("#")));
                        this.copytotarget2source.put(copytoValue, hrefValue.substring(0, hrefValue.indexOf("#")));
                    } else {
                        this.copytoSource.add(hrefValue);
                        this.copytotarget2source.put(copytoValue, hrefValue);
                    }
                }
                if (StringUtils.isEmptyString(parseFilePath) || "external".equalsIgnoreCase(scopeValue) || "resource-only".equalsIgnoreCase(processRoleValue)) break block39;
                this.currentParsingFile = FileUtils.resolveFile(this.filePath, parseFilePath);
                String outputFileName = null;
                String id = null;
                String firstTopicID = null;
                if (parseFilePath.contains("#") && parseFilePath.indexOf("#") < parseFilePath.length() - 1) {
                    id = parseFilePath.substring(parseFilePath.indexOf("#") + 1);
                    if (chunkValue.contains("select-branch")) {
                        outputFileName = FileUtils.resolveFile(this.filePath, id) + this.ditaext;
                        this.targetTopicId = id;
                        this.startFromFirstTopic = false;
                        this.selectMethod = "select-branch";
                    } else if (chunkValue.contains("select-document")) {
                        firstTopicID = this.getFirstTopicId(FileUtils.resolveFile(this.filePath, parseFilePath));
                        if (!StringUtils.isEmptyString(firstTopicID)) {
                            outputFileName = FileUtils.resolveFile(this.filePath, firstTopicID) + this.ditaext;
                            this.targetTopicId = firstTopicID;
                        } else {
                            outputFileName = this.currentParsingFile + ".chunk";
                            dotchunk = true;
                            this.targetTopicId = null;
                        }
                        this.selectMethod = "select-document";
                    } else {
                        outputFileName = FileUtils.resolveFile(this.filePath, id) + this.ditaext;
                        this.targetTopicId = id;
                        this.startFromFirstTopic = false;
                        this.selectMethod = "select-topic";
                    }
                } else {
                    firstTopicID = this.getFirstTopicId(FileUtils.resolveFile(this.filePath, parseFilePath));
                    if (!StringUtils.isEmptyString(firstTopicID)) {
                        outputFileName = FileUtils.resolveFile(this.filePath, firstTopicID) + this.ditaext;
                        this.targetTopicId = firstTopicID;
                    } else {
                        outputFileName = this.currentParsingFile + ".chunk";
                        dotchunk = true;
                        this.targetTopicId = null;
                    }
                    this.selectMethod = "select-document";
                }
                if (!copytoValue.equals("")) {
                    outputFileName = FileUtils.resolveFile(this.filePath, copytoValue);
                }
                if (FileUtils.fileExists(outputFileName)) {
                    Random random = new Random();
                    String t = outputFileName;
                    outputFileName = FileUtils.resolveFile(this.filePath, "Chunk" + new Integer(Math.abs(random.nextInt())).toString()) + this.ditaext;
                    this.conflictTable.put(outputFileName, t);
                    dotchunk = false;
                }
                tempOutput = this.output;
                this.output = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileName), "UTF-8");
                this.outputFile = outputFileName;
                if (!dotchunk) {
                    this.changeTable.put(FileUtils.resolveTopic(this.filePath, parseFilePath), outputFileName + (id == null ? "" : "#" + id));
                    this.changeTable.put(outputFileName, outputFileName);
                }
                if (StringUtils.isEmptyString(firstTopicID)) {
                    element.setAttribute("href", FileUtils.getRelativePathFromMap(this.filePath + "/" + "stub.ditamap", outputFileName) + (id == null ? "" : "#" + id));
                } else {
                    element.setAttribute("href", FileUtils.getRelativePathFromMap(this.filePath + "/" + "stub.ditamap", outputFileName) + "#" + firstTopicID);
                }
                this.include = false;
                this.stub = element.getOwnerDocument().createElement("stub");
                this.siblingStub = element.getOwnerDocument().createElement("stub");
                if (element.hasChildNodes()) {
                    element.insertBefore(this.stub, element.getFirstChild());
                } else {
                    element.appendChild(this.stub);
                }
                if (element.getNextSibling() != null) {
                    element.getParentNode().insertBefore(this.siblingStub, element.getNextSibling());
                } else {
                    element.getParentNode().appendChild(this.siblingStub);
                }
                reader.setErrorHandler(new DITAOTXMLErrorHandler(this.currentParsingFile));
                reader.parse(this.currentParsingFile);
                this.output.flush();
                this.stub.getParentNode().removeChild(this.stub);
                this.siblingStub.getParentNode().removeChild(this.siblingStub);
            }
            Object var16_16 = null;
            try {
                if (this.output != null) {
                    Properties prop;
                    this.output.close();
                    if (dotchunk && !new File(this.currentParsingFile).delete()) {
                        prop = new Properties();
                        prop.put("%1", this.currentParsingFile);
                        prop.put("%2", this.outputFile);
                        this.logger.logError(MessageUtils.getMessage("DOTJ009E", prop).toString());
                    }
                    if (dotchunk && !new File(this.outputFile).renameTo(new File(this.currentParsingFile))) {
                        prop = new Properties();
                        prop.put("%1", this.currentParsingFile);
                        prop.put("%2", this.outputFile);
                        this.logger.logError(MessageUtils.getMessage("DOTJ009E", prop).toString());
                    }
                }
                this.output = tempOutput;
            }
            catch (Exception ex) {
                this.logger.logException(ex);
            }
            break block40;
            {
                catch (Exception e) {
                    this.logger.logException(e);
                    Object var16_17 = null;
                    try {
                        if (this.output != null) {
                            Properties prop;
                            this.output.close();
                            if (dotchunk && !new File(this.currentParsingFile).delete()) {
                                prop = new Properties();
                                prop.put("%1", this.currentParsingFile);
                                prop.put("%2", this.outputFile);
                                this.logger.logError(MessageUtils.getMessage("DOTJ009E", prop).toString());
                            }
                            if (dotchunk && !new File(this.outputFile).renameTo(new File(this.currentParsingFile))) {
                                prop = new Properties();
                                prop.put("%1", this.currentParsingFile);
                                prop.put("%2", this.outputFile);
                                this.logger.logError(MessageUtils.getMessage("DOTJ009E", prop).toString());
                            }
                        }
                        this.output = tempOutput;
                    }
                    catch (Exception ex) {
                        this.logger.logException(ex);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                try {
                    if (this.output != null) {
                        Properties prop;
                        this.output.close();
                        if (dotchunk && !new File(this.currentParsingFile).delete()) {
                            prop = new Properties();
                            prop.put("%1", this.currentParsingFile);
                            prop.put("%2", this.outputFile);
                            this.logger.logError(MessageUtils.getMessage("DOTJ009E", prop).toString());
                        }
                        if (dotchunk && !new File(this.outputFile).renameTo(new File(this.currentParsingFile))) {
                            prop = new Properties();
                            prop.put("%1", this.currentParsingFile);
                            prop.put("%2", this.outputFile);
                            this.logger.logError(MessageUtils.getMessage("DOTJ009E", prop).toString());
                        }
                    }
                    this.output = tempOutput;
                }
                catch (Exception ex) {
                    this.logger.logException(ex);
                }
                throw throwable;
            }
        }
    }

    private void processChunk(Element element, String outputFile) {
        String hrefValue = element.getAttribute("href");
        String chunkValue = element.getAttribute("chunk");
        String copytoValue = element.getAttribute("copy-to");
        String scopeValue = element.getAttribute("scope");
        String classValue = element.getAttribute("class");
        String processRoleValue = element.getAttribute("processing-role");
        String parseFilePath = null;
        String outputFileName = outputFile;
        Writer tempWriter = null;
        Set<String> tempTopicID = null;
        this.targetTopicId = null;
        this.selectMethod = "select-document";
        this.include = false;
        boolean needWriteDitaTag = true;
        try {
            parseFilePath = !copytoValue.equals("") && !chunkValue.contains("to-content") ? (hrefValue.indexOf("#") != -1 ? copytoValue + hrefValue.substring(hrefValue.indexOf("#")) : copytoValue) : hrefValue;
            if (!copytoValue.equals("") && chunkValue.contains("to-content")) {
                this.copyto.add(copytoValue);
                if (hrefValue.indexOf("#") != -1) {
                    this.copytoSource.add(hrefValue.substring(0, hrefValue.indexOf("#")));
                    this.copytotarget2source.put(copytoValue, hrefValue.substring(0, hrefValue.indexOf("#")));
                } else {
                    this.copytoSource.add(hrefValue);
                    this.copytotarget2source.put(copytoValue, hrefValue);
                }
            }
            if (!StringUtils.isEmptyString(classValue)) {
                if (!(classValue.contains(" mapgroup-d/topicgroup ") || StringUtils.isEmptyString(parseFilePath) || "external".equalsIgnoreCase(scopeValue))) {
                    String firstTopicID;
                    if (chunkValue.indexOf("to-content") != -1) {
                        tempWriter = this.output;
                        tempTopicID = this.topicID;
                        this.output = new StringWriter();
                        this.topicID = new HashSet<String>();
                        if (classValue.contains(" map/map ")) {
                            outputFileName = FileUtils.resolveFile(this.filePath, parseFilePath);
                            needWriteDitaTag = false;
                        } else if (!copytoValue.equals("")) {
                            outputFileName = FileUtils.resolveFile(this.filePath, copytoValue);
                        } else if (!hrefValue.equals("")) {
                            String firstTopic;
                            outputFileName = chunkValue.contains("select-topic") || chunkValue.contains("select-branch") ? (hrefValue.contains("#") && hrefValue.indexOf("#") < hrefValue.length() - 1 ? FileUtils.resolveFile(this.filePath, hrefValue.substring(hrefValue.indexOf("#") + 1)) + this.ditaext : (!StringUtils.isEmptyString(firstTopic = this.getFirstTopicId(FileUtils.resolveFile(this.filePath, hrefValue))) ? FileUtils.resolveFile(this.filePath, firstTopic) + this.ditaext : FileUtils.resolveFile(this.filePath, hrefValue))) : FileUtils.resolveFile(this.filePath, hrefValue);
                        } else {
                            Random random = new Random();
                            outputFileName = FileUtils.resolveFile(this.filePath, "Chunk" + new Integer(Math.abs(random.nextInt())).toString()) + this.ditaext;
                        }
                        if (FileUtils.fileExists(outputFileName) && !classValue.contains(" map/map ")) {
                            String t = outputFileName;
                            Random random = new Random();
                            outputFileName = FileUtils.resolveFile(this.filePath, "Chunk" + new Integer(Math.abs(random.nextInt())).toString()) + this.ditaext;
                            this.conflictTable.put(outputFileName, t);
                        }
                        this.changeTable.put(outputFileName, outputFileName);
                    }
                    this.outputFile = outputFileName;
                    String path = FileUtils.resolveTopic(this.filePath, parseFilePath);
                    String newpath = null;
                    newpath = path.indexOf("#") != -1 ? outputFileName + path.substring(path.indexOf("#")) : (!StringUtils.isEmptyString(firstTopicID = this.getFirstTopicId(path)) ? outputFileName + "#" + firstTopicID : outputFileName);
                    this.changeTable.put(path, newpath);
                    element.setAttribute("href", FileUtils.getRelativePathFromMap(this.filePath + "/" + "stub.ditamap", newpath));
                    if (parseFilePath.indexOf("#") != -1) {
                        this.targetTopicId = parseFilePath.substring(parseFilePath.indexOf("#") + 1);
                    }
                    if (chunkValue.indexOf("select") != -1) {
                        int endIndex = chunkValue.indexOf(" ", chunkValue.indexOf("select"));
                        this.selectMethod = endIndex == -1 ? chunkValue.substring(chunkValue.indexOf("select")) : chunkValue.substring(chunkValue.indexOf("select"), endIndex);
                        if (("select-topic".equals(this.selectMethod) || "select-branch".equals(this.selectMethod)) && this.targetTopicId == null) {
                            this.selectMethod = "select-document";
                        }
                    }
                    String tempPath = this.currentParsingFile;
                    this.currentParsingFile = FileUtils.resolveFile(this.filePath, parseFilePath);
                    if (!"resource-only".equalsIgnoreCase(processRoleValue)) {
                        reader.parse(this.currentParsingFile);
                    }
                    this.currentParsingFile = tempPath;
                }
                if (element.hasChildNodes()) {
                    StringWriter temp = (StringWriter)this.output;
                    this.output = new StringWriter();
                    NodeList children = element.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node current = children.item(i);
                        if (current.getNodeType() != 1 || ((Element)current).getAttribute("class").indexOf(" map/topicref ") == -1) continue;
                        this.processChunk((Element)current, outputFileName);
                    }
                    StringBuffer parentResult = temp.getBuffer();
                    if (parentResult.length() > 0 && !StringUtils.isEmptyString(parseFilePath) && !"resource-only".equalsIgnoreCase(processRoleValue)) {
                        int insertpoint = parentResult.lastIndexOf("</");
                        int end = parentResult.indexOf(">", insertpoint);
                        if (insertpoint == -1 || end == -1) {
                            Properties prop = new Properties();
                            prop.put("%1", hrefValue);
                            this.logger.logError(MessageUtils.getMessage("DOTJ033E", prop).toString());
                        } else {
                            if ("dita".equalsIgnoreCase(parentResult.substring(insertpoint, end).trim())) {
                                insertpoint = parentResult.lastIndexOf("</", insertpoint);
                            }
                            parentResult.insert(insertpoint, ((StringWriter)this.output).getBuffer());
                        }
                    } else {
                        parentResult.append(((StringWriter)this.output).getBuffer());
                    }
                    this.output = temp;
                }
                if (chunkValue.indexOf("to-content") != -1) {
                    FileOutputStream fileOutput = new FileOutputStream(outputFileName);
                    OutputStreamWriter ditaFileOutput = new OutputStreamWriter((OutputStream)fileOutput, "UTF-8");
                    if (outputFileName.equals(this.changeTable.get(outputFileName))) {
                        ditaFileOutput.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                        if (Constants.OS_NAME.toLowerCase().indexOf(OS_NAME_WINDOWS) == -1) {
                            ditaFileOutput.write(PI_WORKDIR_HEAD + new File(outputFileName).getParent() + PI_END);
                        } else {
                            ditaFileOutput.write("<?workdir /" + new File(outputFileName).getParent() + PI_END);
                        }
                    }
                    if (needWriteDitaTag) {
                        ditaFileOutput.write("<dita>");
                    }
                    ditaFileOutput.write(((StringWriter)this.output).getBuffer().toString());
                    if (needWriteDitaTag) {
                        ditaFileOutput.write("</dita>");
                    }
                    ditaFileOutput.flush();
                    ditaFileOutput.close();
                    this.output = tempWriter;
                    this.topicID = tempTopicID;
                }
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public void setup(LinkedHashMap<String, String> changeTable, Hashtable<String, String> conflictTable, HashSet<String> refFileSet, Element elem, boolean separate, boolean chunkByTopic, String ditaext) {
        this.changeTable = changeTable;
        this.elem = elem;
        this.separate = separate;
        this.ditaext = ditaext;
        this.conflictTable = conflictTable;
        this.logger = new DITAOTJavaLogger();
        if (System.getProperty("org.xml.sax.driver") == null) {
            StringUtils.initSaxDriver();
        }
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                StringUtils.initSaxDriver();
            }
            reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(this);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            reader.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    private boolean checkHREF(Attributes atts) {
        String scopeValue = atts.getValue("scope");
        String hrefValue = atts.getValue("href");
        hrefValue = StringUtils.escapeXML(hrefValue);
        if (scopeValue == null) {
            scopeValue = "local";
        }
        if (hrefValue == null || hrefValue.indexOf("://") != -1) {
            return false;
        }
        return scopeValue == null || !scopeValue.equalsIgnoreCase("external");
    }

    private String getFirstTopicId(String absolutePathToFile) {
        StringBuffer firstTopicId = new StringBuffer("");
        if (absolutePathToFile == null || !FileUtils.isAbsolutePath(absolutePathToFile)) {
            return firstTopicId.toString();
        }
        TopicIdParser parser = new TopicIdParser(firstTopicId);
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                StringUtils.initSaxDriver();
            }
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(parser);
            reader.parse(absolutePathToFile);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
        return firstTopicId.toString();
    }
}

