/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.index.IndexTermTarget;
import org.dita.dost.module.Content;
import org.dita.dost.writer.AbstractWriter;
import org.dita.dost.writer.IDitaTranstypeIndexWriter;

public class JavaHelpIndexWriter
implements AbstractWriter,
IDitaTranstypeIndexWriter {
    private List termList = null;

    public void setContent(Content content) {
        this.termList = (List)content.getCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream) throws UnsupportedEncodingException {
        PrintWriter printWriter = null;
        int termNum = this.termList.size();
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            printWriter.println("<?xml version='1.0' encoding='UTF-8' ?>");
            printWriter.println("<!DOCTYPE index PUBLIC ");
            printWriter.println("\"-//Sun Microsystems Inc.//DTD JavaHelp Index Version 1.0//EN\" ");
            printWriter.println("\"http://java.sun.com/products/javahelp/index_1_0.dtd\">");
            printWriter.println("<index version=\"1.0\">");
            for (int i = 0; i < termNum; ++i) {
                IndexTerm term = (IndexTerm)this.termList.get(i);
                this.outputIndexTerm(term, printWriter);
            }
            printWriter.println("</index>");
        }
        finally {
            printWriter.close();
        }
    }

    public void write(String filename) throws DITAOTException {
        try {
            this.write(new FileOutputStream(filename));
        }
        catch (Exception e) {
            throw new DITAOTException(e);
        }
    }

    private void outputIndexTerm(IndexTerm term, PrintWriter printWriter) {
        int subTermNum;
        List targets = term.getTargetList();
        List subTerms = term.getSubTerms();
        int targetNum = targets == null ? 0 : targets.size();
        int n = subTermNum = subTerms == null ? 0 : subTerms.size();
        if (subTermNum > 0) {
            printWriter.print("<indexitem text=\"");
            printWriter.print(term.getTermFullName());
            printWriter.print("\">");
            for (int i = 0; i < subTermNum; ++i) {
                IndexTerm subTerm = (IndexTerm)subTerms.get(i);
                this.outputIndexTerm(subTerm, printWriter);
            }
            printWriter.println("</indexitem>");
        } else {
            for (int i = 0; i < targetNum; ++i) {
                IndexTermTarget target = (IndexTermTarget)targets.get(i);
                String targetURL = target.getTargetURI();
                targetURL = targetURL.substring(0, targetURL.lastIndexOf("."));
                targetURL = targetURL.replace('\\', '_');
                targetURL = targetURL.replace('/', '_');
                targetURL = targetURL.replace('.', '_');
                printWriter.print("<indexitem text=\"");
                printWriter.print(term.getTermFullName());
                printWriter.print("\"");
                printWriter.print(" target=\"");
                printWriter.print(targetURL);
                printWriter.println("\"/>");
            }
        }
    }

    public String getIndexFileName(String outputFileRoot) {
        StringBuffer indexFilename = new StringBuffer(outputFileRoot);
        indexFilename.append("_index.xml");
        return indexFilename.toString();
    }
}

