/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.AbstractXMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyrefPaser
extends AbstractXMLWriter {
    private XMLReader parser = null;
    private DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
    private OutputStreamWriter output = null;
    private Content content;
    private String tempDir;
    private Stack<Integer> keyrefLevalStack = new Stack();
    private int keyrefLeval = 0;
    private String filepath;
    private static Set<String> withHref = new HashSet<String>();
    private static Set<String> withOutHref = new HashSet<String>();
    private static Set<String> no_copy = new HashSet<String>();
    private static Set<String> no_copy_topic = new HashSet<String>();
    private Map<String, String> keyMap;
    private Stack<Boolean> validKeyref = new Stack();
    private boolean empty = true;
    private Stack<String> elemName;
    private String classValue;
    private boolean hasChecked;
    private Stack<Boolean> hasSubElem;
    private Document doc;
    private String fileName;
    private String extName;

    public KeyrefPaser() {
        this.keyMap = new HashMap<String, String>();
        this.elemName = new Stack();
        this.hasSubElem = new Stack();
        try {
            this.parser = XMLReaderFactory.createXMLReader();
            this.parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.parser.setFeature("http://xml.org/sax/features/namespaces", true);
            this.parser.setContentHandler(this);
        }
        catch (Exception e) {
            this.javaLogger.logException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.keyrefLeval != 0 && new String(ch, start, length).trim().length() == 0) {
                if (!this.hasChecked) {
                    this.empty = true;
                }
            } else {
                this.hasChecked = true;
                this.empty = false;
            }
            this.output.write(StringUtils.escapeXML(ch, start, length));
        }
        catch (IOException e) {
            this.javaLogger.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endDocument() throws SAXException {
        try {
            this.output.flush();
            this.output.close();
        }
        catch (Exception e) {
            this.javaLogger.logException(e);
        }
        finally {
            try {
                this.output.close();
            }
            catch (Exception e) {
                this.javaLogger.logException(e);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        try {
            if (this.keyrefLeval != 0 && this.empty && !this.elemName.peek().equals("topicref") && !this.validKeyref.isEmpty() && this.validKeyref.peek().booleanValue()) {
                Element elem = this.doc.getDocumentElement();
                NodeList nodeList = null;
                if (!name.equals(this.elemName.peek())) {
                    nodeList = elem.getElementsByTagName(name);
                    if (nodeList.getLength() > 0) {
                        Node node = nodeList.item(0);
                        NodeList nList = node.getChildNodes();
                        int index = 0;
                        while (index < nList.getLength()) {
                            Node n;
                            if ((n = nList.item(index++)).getNodeType() != 3) continue;
                            this.output.write(n.getNodeValue());
                            break;
                        }
                        this.output.flush();
                    }
                } else {
                    nodeList = elem.getElementsByTagName("keyword");
                    if (nodeList.getLength() == 0) {
                        nodeList = elem.getElementsByTagName("term");
                    }
                    if (!this.hasSubElem.peek().booleanValue()) {
                        if (nodeList.getLength() > 0) {
                            if (withOutHref.contains(this.classValue)) {
                                this.output.write(this.nodeToString((Element)nodeList.item(0), false));
                                this.output.flush();
                            } else if (withHref.contains(this.classValue)) {
                                if (this.classValue.equals("topic/link")) {
                                    this.output.write("<linktext class=\" topic/linktext \">");
                                }
                                for (int index = 0; index < nodeList.getLength(); ++index) {
                                    Node node = nodeList.item(index);
                                    if (node.getNodeType() != 1) continue;
                                    this.output.write(this.nodeToString((Element)node, true));
                                }
                                if (this.classValue.equals("topic/link")) {
                                    this.output.write("</linktext>");
                                }
                                this.output.flush();
                            }
                        } else {
                            if (this.classValue.equals("topic/link")) {
                                NodeList linktext = elem.getElementsByTagName("linktext");
                                if (linktext.getLength() > 0) {
                                    this.output.write(this.nodeToString((Element)linktext.item(0), true));
                                } else if (!StringUtils.isEmptyString(elem.getAttribute("navtitle"))) {
                                    this.output.write("<linktext class=\" topic/linktext \">");
                                    this.output.append(elem.getAttribute("navtitle"));
                                    this.output.write("</linktext>");
                                }
                            } else if (withHref.contains(this.classValue)) {
                                NodeList linktext = elem.getElementsByTagName("linktext");
                                if (linktext.getLength() > 0) {
                                    this.output.write(this.nodeToString((Element)linktext.item(0), false));
                                } else {
                                    this.output.append(elem.getAttribute("navtitle"));
                                }
                            }
                            this.output.flush();
                        }
                    }
                }
            }
            if (this.keyrefLeval != 0) {
                --this.keyrefLeval;
                this.empty = false;
            }
            if (this.keyrefLeval == 0 && !this.keyrefLevalStack.empty()) {
                this.keyrefLeval = this.keyrefLevalStack.pop();
                this.validKeyref.pop();
                this.elemName.pop();
                this.hasSubElem.pop();
            }
            this.output.write("<");
            this.output.write("/");
            this.output.write(name);
            this.output.write(">");
        }
        catch (Exception e) {
            this.javaLogger.logException(e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.output.write(ch, start, length);
        }
        catch (Exception e) {
            this.javaLogger.logException(e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            String pi = data != null ? target + " " + data : target;
            this.output.write("<?" + pi + "?" + ">");
        }
        catch (Exception e) {
            this.javaLogger.logException(e);
        }
    }

    @Override
    public void setContent(Content content) {
        this.content = content;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        try {
            this.hasChecked = false;
            this.empty = true;
            this.output.write("<");
            this.output.write(name);
            boolean valid = false;
            this.classValue = atts.getValue("class");
            this.classValue = this.classValue.substring(this.classValue.indexOf(" ") + 1, this.classValue.indexOf(" ", 4));
            if (atts.getIndex("keyref") == -1) {
                if (this.keyrefLeval != 0) {
                    ++this.keyrefLeval;
                    this.hasSubElem.pop();
                    this.hasSubElem.push(true);
                }
                for (int index = 0; index < atts.getLength(); ++index) {
                    this.output.write(" ");
                    this.output.write(atts.getQName(index));
                    this.output.write("=\"");
                    this.output.write(StringUtils.escapeXML(atts.getValue(index)));
                    this.output.write("\"");
                }
            } else {
                String definition;
                this.elemName.push(name);
                HashSet<String> aset = new HashSet<String>();
                if (this.keyrefLeval != 0) {
                    this.keyrefLevalStack.push(this.keyrefLeval);
                    this.hasSubElem.pop();
                    this.hasSubElem.push(true);
                }
                this.hasSubElem.push(false);
                this.keyrefLeval = 0;
                ++this.keyrefLeval;
                String keyrefValue = atts.getValue("keyref");
                int slashIndex = keyrefValue.indexOf("/");
                String keyName = keyrefValue;
                String tail = "";
                if (slashIndex != -1) {
                    keyName = keyrefValue.substring(0, slashIndex);
                    tail = keyrefValue.substring(slashIndex);
                }
                if ((definition = (String)((Hashtable)this.content.getValue()).get(keyName)) != null) {
                    Properties prop;
                    String target;
                    this.doc = this.keyDefToDoc(definition);
                    Element elem = this.doc.getDocumentElement();
                    NamedNodeMap namedNodeMap = elem.getAttributes();
                    if (withHref.contains(this.classValue)) {
                        target = this.keyMap.get(keyName);
                        if (target != null && !target.equals("")) {
                            String target_output = target;
                            String scopeValue = elem.getAttribute("scope");
                            if (("".equals(scopeValue) || "local".equals(scopeValue)) && !"topic/image".equals(this.classValue)) {
                                if (new File(FileUtils.resolveFile(this.tempDir, target = FileUtils.replaceExtName(target, this.extName))).exists()) {
                                    target_output = FileUtils.getRelativePathFromMap(this.filepath, new File(this.tempDir, target).getAbsolutePath());
                                    valid = true;
                                    aset.add("href");
                                    aset.add("scope");
                                    aset.add("type");
                                    aset.add("format");
                                    this.output.write(" ");
                                    this.output.write("href");
                                    this.output.write("=\"");
                                    target_output = KeyrefPaser.normalizeHrefValue(target_output, tail);
                                    this.output.write(target_output);
                                    this.output.write("\"");
                                }
                            } else {
                                if ("topic/image".equals(this.classValue)) {
                                    target_output = FileUtils.getRelativePathFromMap(this.fileName, target_output);
                                }
                                valid = true;
                                aset.add("scope");
                                aset.add("href");
                                aset.add("type");
                                aset.add("format");
                                this.output.write(" ");
                                this.output.write("href");
                                this.output.write("=\"");
                                target_output = KeyrefPaser.normalizeHrefValue(target_output, tail);
                                this.output.write(target_output);
                                this.output.write("\"");
                            }
                        } else if (target.equals("")) {
                            valid = true;
                            aset.add("scope");
                            aset.add("href");
                            aset.add("type");
                            aset.add("format");
                        } else {
                            prop = new Properties();
                            prop.put("%1", atts.getValue("keyref"));
                            this.javaLogger.logInfo(MessageUtils.getMessage("DOTJ047I", prop).toString());
                        }
                    } else if (withOutHref.contains(this.classValue)) {
                        target = this.keyMap.get(keyName);
                        if (target != null) {
                            valid = true;
                            aset.add("scope");
                            aset.add("href");
                            aset.add("type");
                            aset.add("format");
                        } else {
                            prop = new Properties();
                            prop.put("%1", atts.getValue("keyref"));
                            this.javaLogger.logInfo(MessageUtils.getMessage("DOTJ047I", prop).toString());
                        }
                    }
                    if (valid) {
                        Node node;
                        if (this.classValue.contains("map/topicref")) {
                            for (int index = 0; index < namedNodeMap.getLength(); ++index) {
                                node = namedNodeMap.item(index);
                                if (node.getNodeType() != 2 || no_copy.contains(node.getNodeName())) continue;
                                aset.add(node.getNodeName());
                                this.output.append(" ");
                                this.output.append(node.getNodeName());
                                this.output.write("=\"");
                                this.output.write(node.getNodeValue());
                                this.output.write("\"");
                            }
                        } else if (withHref.contains(this.classValue)) {
                            for (int index = 0; index < namedNodeMap.getLength(); ++index) {
                                node = namedNodeMap.item(index);
                                if (node.getNodeType() != 2 || no_copy_topic.contains(node.getNodeName())) continue;
                                aset.add(node.getNodeName());
                                this.output.append(" ");
                                this.output.append(node.getNodeName());
                                this.output.write("=\"");
                                this.output.write(node.getNodeValue());
                                this.output.write("\"");
                            }
                        } else if (withOutHref.contains(this.classValue)) {
                            for (int index = 0; index < namedNodeMap.getLength(); ++index) {
                                node = namedNodeMap.item(index);
                                if (node.getNodeType() != 2 || no_copy_topic.contains(node.getNodeName()) || node.getNodeName().equals("scope") || node.getNodeName().equals("format") || node.getNodeName().equals("type")) continue;
                                aset.add(node.getNodeName());
                                this.output.append(" ");
                                this.output.append(node.getNodeName());
                                this.output.write("=\"");
                                this.output.write(node.getNodeValue());
                                this.output.write("\"");
                            }
                        }
                    }
                } else {
                    Properties prop = new Properties();
                    prop.put("%1", atts.getValue("keyref"));
                    this.javaLogger.logInfo(MessageUtils.getMessage("DOTJ047I", prop).toString());
                }
                this.validKeyref.push(valid);
                for (int index = 0; index < atts.getLength(); ++index) {
                    if (aset.contains(atts.getQName(index))) continue;
                    this.output.append(" ");
                    this.output.append(atts.getQName(index));
                    this.output.write("=\"");
                    this.output.write(StringUtils.escapeXML(atts.getValue(index)));
                    this.output.write("\"");
                }
            }
            this.output.write(">");
            this.output.flush();
        }
        catch (IOException e) {
            this.javaLogger.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String filename) throws DITAOTException {
        this.fileName = filename;
        try {
            Properties prop;
            File inputFile = new File(this.tempDir, filename);
            this.filepath = inputFile.getAbsolutePath();
            File outputFile = new File(this.tempDir, filename + "keyref");
            this.output = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
            this.parser.parse(inputFile.getAbsolutePath());
            this.output.close();
            if (!inputFile.delete()) {
                prop = new Properties();
                prop.put("%1", inputFile.getPath());
                prop.put("%2", outputFile.getPath());
                this.javaLogger.logError(MessageUtils.getMessage("DOTJ009E", prop).toString());
            }
            if (!outputFile.renameTo(inputFile)) {
                prop = new Properties();
                prop.put("%1", inputFile.getPath());
                prop.put("%2", outputFile.getPath());
                this.javaLogger.logError(MessageUtils.getMessage("DOTJ009E", prop).toString());
            }
        }
        catch (Exception e) {
            this.javaLogger.logException(e);
        }
        finally {
            try {
                this.output.close();
            }
            catch (Exception ex) {
                this.javaLogger.logException(ex);
            }
        }
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public void setKeyMap(Map<String, String> map) {
        this.keyMap = map;
    }

    private Document keyDefToDoc(String key) {
        InputSource inputSource = null;
        Document document = null;
        inputSource = new InputSource(new StringReader(key));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            document = documentBuilder.parse(inputSource);
            return document;
        }
        catch (Exception e) {
            this.javaLogger.logException(e);
            return document;
        }
    }

    private String nodeToString(Element elem, boolean flag) {
        int i;
        StringBuffer stringBuffer = new StringBuffer();
        if (flag) {
            stringBuffer.append("<").append(elem.getNodeName());
            NamedNodeMap namedNodeMap = elem.getAttributes();
            for (i = 0; i < namedNodeMap.getLength(); ++i) {
                String classValue = namedNodeMap.item(i).getNodeValue();
                if (namedNodeMap.item(i).getNodeName().equals("class")) {
                    classValue = this.changeclassValue(classValue);
                }
                stringBuffer.append(" ").append(namedNodeMap.item(i).getNodeName()).append("=").append("\"" + classValue + "\"");
            }
            stringBuffer.append(">");
        }
        NodeList nodeList = elem.getChildNodes();
        for (i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                stringBuffer.append(this.nodeToString((Element)node, flag));
            }
            if (node.getNodeType() != 3) continue;
            stringBuffer.append(node.getNodeValue());
        }
        if (flag) {
            stringBuffer.append("</").append(elem.getNodeName()).append(">");
        }
        return stringBuffer.toString();
    }

    private String changeclassValue(String classValue) {
        return classValue.replaceAll("map/", "topic/");
    }

    public String getExtName() {
        return this.extName;
    }

    public void setExtName(String extName) {
        this.extName = extName;
    }

    private static String normalizeHrefValue(String keyName, String tail) {
        int sharpIndex = keyName.indexOf("#");
        if (sharpIndex == -1) {
            return keyName + tail.replaceAll("/", "#");
        }
        return keyName + tail;
    }

    static {
        withHref.add("topic/author");
        withHref.add("topic/data");
        withHref.add("topic/data-about");
        withHref.add("topic/image");
        withHref.add("topic/link");
        withHref.add("topic/lq");
        withHref.add("topic/navref");
        withHref.add("topic/publisher");
        withHref.add("topic/source");
        withHref.add("map/topicref");
        withHref.add("topic/xref");
        no_copy.add("id");
        no_copy.add("class");
        no_copy.add("xtrc");
        no_copy.add("xtrf");
        no_copy.add("href");
        no_copy.add("keys");
        no_copy.add("toc");
        no_copy.add("processing-role");
        no_copy_topic.addAll(no_copy);
        no_copy_topic.add("query");
        no_copy_topic.add("search");
        no_copy_topic.add("toc");
        no_copy_topic.add("print");
        no_copy_topic.add("copy-to");
        no_copy_topic.add("chunk");
        no_copy_topic.add("navtitle");
        withOutHref.add("topic/cite");
        withOutHref.add("topic/dt");
        withOutHref.add("topic/keyword");
        withOutHref.add("topic/term");
        withOutHref.add("topic/ph");
        withOutHref.add("topic/indexterm");
        withOutHref.add("topic/index-base");
        withOutHref.add("topic/indextermref");
    }
}

