/*
Jaxe - Editeur XML en Java

Copyright (C) 2006 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package pluginsjaxe;

import java.io.File;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.text.Position;

import jaxe.JaxeDocument;
import jaxe.JaxeResourceBundle;
import jaxe.elements.JEFichier;

import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


/**
 * Plugin pour diter des quations TeX  l'aide d'un serveur distant
 * ou en local avec latex, dvips et convert.
 *
 * paramtre: serveur: l'URL du script tex.php qui convertit les quations en images
 * paramtre: texteAtt: le nom de l'attribut donnant le texte de l'quation
 * paramtre: srcAtt: le nom de l'attribut donnant le nom de l'image
 * paramtre: labelAtt: le nom de l'attribut donnant le label de l'image
 *
 * Peut utiliser des lments DEFCMDTEX pour dfinir des commandes TeX.
 * DEFCMDTEX doit avoir les attributs commande, nb-params et remplacement.
 *
 * compilation:
 * javac -source 1.5 -target 1.5 -encoding ISO-8859-1 -classpath .:Jaxe.jar pluginsjaxe/JEEquaTeX.java
 */
public class JEEquaTeX extends JEFichier {

    public final static String defTexteAtt = "texte";
    private String serveur = null;
    
    public JEEquaTeX(JaxeDocument doc) {
        super(doc);
        alignementY = (float)0.70;
        // 70% du composant au-dessus de la base de la ligne
        // donc pas parfait (il faudrait se placer par rapport au milieu vertical d'un 'x'
        // et non par rapport  la base de la ligne pour obtenir un rsulat parfait,
        // mais ce n'est pas possible avec Swing)
    }

    public void init(Position pos, Node noeud) {
        // l'image est cre si elle n'existe pas
        // (elle peut avoir t efface lors d'un couper-coller)
        Element el = (Element)noeud;
        Element refElement = doc.cfg.getElementRef(el);
        File fimg;
        serveur = doc.cfg.valeurParametreElement(refElement, "serveur", null);
        srcAttr = doc.cfg.valeurParametreElement(refElement, "srcAtt", defaultSrcAttr);
        String nomf = el.getAttribute(srcAttr);
        if (doc.fsave == null)
            fimg = new File(nomf);
        else
            fimg = new File(doc.fsave.getParent() + File.separatorChar + nomf);
        if (fimg.exists()) {
            // le cas o deux quations utilisent le mme fichier image peut se produire
            // aprs un copier-coller
            // il faut donc vrifier toutes les quations du fichier XML
            // et recrer l'image si ncessaire
            NodeList l;
            if (noeud.getNamespaceURI() == null)
                l = doc.DOMdoc.getElementsByTagName(noeud.getNodeName());
            else
                l = doc.DOMdoc.getElementsByTagNameNS(noeud.getNamespaceURI(), noeud.getLocalName());
            for (int i=0; i<l.getLength(); i++)
                if (l.item(i) != noeud)
                    if (nomf.equals(((Element)l.item(i)).getAttribute(srcAttr))) {
                        fimg = null;
                        break;
                    }
        }
        if (fimg == null || !fimg.exists()) {
            String texteAtt = doc.cfg.valeurParametreElement(refElement, "texteAtt", defTexteAtt);
            String texteEquation = el.getAttribute(texteAtt);
            String nomImage;
            if (fimg == null)
                nomImage = DialogueEquaTeX.creerImage(doc.textPane, serveur, texteEquation, null, doc);
            else
                nomImage = DialogueEquaTeX.creerImage(doc.textPane, serveur, texteEquation, fimg.getPath(), doc);
            el.setAttribute(srcAttr, nomImage);
        }
        super.init(pos, noeud);
    }
    
    public Node nouvelElement(Element refElement) {
        if (doc.fsave == null) {
            JOptionPane.showMessageDialog(doc.jframe,
                JaxeResourceBundle.getRB().getString("equation.SauverAvant"),
                JaxeResourceBundle.getRB().getString("erreur.Erreur"), JOptionPane.ERROR_MESSAGE);
            return(null);
        }
        
        serveur = doc.cfg.valeurParametreElement(refElement, "serveur", null);
        srcAttr = doc.cfg.valeurParametreElement(refElement, "srcAtt", defaultSrcAttr);
        String texteAtt = doc.cfg.valeurParametreElement(refElement, "texteAtt", defTexteAtt);
        String labelAtt = doc.cfg.valeurParametreElement(refElement, "labelAtt", null);
        
        Element newel = nouvelElementDOM(doc, refElement);
        
        DialogueEquaTeX dlg = new DialogueEquaTeX(doc, serveur, "", null, labelAtt, null);
        if (!dlg.afficher())
            return null;
        String texte = dlg.getTexte();
        String nomImage = dlg.getImage();
        String valeurLabel = dlg.getLabel();
        
        try {
            newel.setAttribute(texteAtt, texte);
            newel.setAttribute(srcAttr, nomImage);
            if (labelAtt != null && valeurLabel != null && !"".equals(valeurLabel))
                newel.setAttribute(labelAtt, valeurLabel);
        } catch (DOMException ex) {
            System.err.println("DOMException: " + ex.getMessage());
            return null;
        }

        return(newel);
    }
    
    public void afficherDialogue(JFrame jframe) {
        Element el = (Element)noeud;

        Element refElement = doc.cfg.getElementRef(el);
        String texteAtt = doc.cfg.valeurParametreElement(refElement, "texteAtt", defTexteAtt);
        String labelAtt = doc.cfg.valeurParametreElement(refElement, "labelAtt", null);
        String texteEquation = el.getAttribute(texteAtt);
        String nomImage = el.getAttribute(srcAttr);
        String valeurLabel1;
        if (labelAtt != null)
            valeurLabel1 = el.getAttribute(labelAtt);
        else
            valeurLabel1 = null;
        DialogueEquaTeX dlg = new DialogueEquaTeX(doc, serveur, texteEquation, nomImage, labelAtt, valeurLabel1);
        if (!dlg.afficher())
            return;
        texteEquation = dlg.getTexte();
        nomImage = dlg.getImage();
        String valeurLabel2 = dlg.getLabel();
        
        try {
            el.setAttribute(texteAtt, texteEquation);
            el.setAttribute(srcAttr, nomImage);
            if (labelAtt != null) {
                if (valeurLabel1 != null && "".equals(valeurLabel2))
                    el.removeAttribute(labelAtt);
                else
                    el.setAttribute(labelAtt, valeurLabel2);
            }
        } catch (DOMException ex) {
            System.err.println("DOMException: " + ex.getMessage());
            return;
        }
        doc.modif = true;
        
        majAffichage();
    }
    
    public void effacer() {
        File fimg;
        String nomf = ((Element)noeud).getAttribute(srcAttr);
        if (doc.fsave == null)
            fimg = new File(nomf);
        else
            fimg = new File(doc.fsave.getParent() + File.separatorChar + nomf);
        if (fimg.exists() && fimg.isFile())
            fimg.delete();
    }
    
}
