/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jxpdl;

import java.util.Vector;

public class GraphChecker {
    private boolean[][] mat;
    private boolean[][] tempMat;
    private int dim = 0;

    private boolean isLinked(int n, int n2) {
        return this.mat[n][n2];
    }

    private void unlink(int n, int n2) {
        this.mat[n][n2] = false;
    }

    private void unlinkParents(int n) {
        for (int i = 0; i < this.dim; ++i) {
            this.unlink(i, n);
        }
    }

    private void unlinkChildren(int n) {
        for (int i = 0; i < this.dim; ++i) {
            this.unlink(n, i);
        }
    }

    private Integer node(int n) {
        return new Integer(n);
    }

    private int index(Integer n) {
        return n;
    }

    private int indexAt(Vector vector, int n) {
        return this.index((Integer)vector.elementAt(n));
    }

    private boolean isInSet(Vector vector, int n) {
        for (int i = 0; i < vector.size(); ++i) {
            if (n != this.indexAt(vector, i)) continue;
            return true;
        }
        return false;
    }

    private boolean isGraphEmpty() {
        boolean bl = false;
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                bl = bl || this.isLinked(i, j);
            }
        }
        return !bl;
    }

    private boolean isSplit(int n) {
        int n2 = 0;
        for (int i = 0; i < this.dim; ++i) {
            if (!this.isLinked(n, i)) continue;
            ++n2;
        }
        return n2 > 1;
    }

    private boolean isIsolated(int n) {
        return !this.hasChild(n) || !this.hasParent(n);
    }

    private boolean hasChild(int n) {
        boolean bl = false;
        for (int i = 0; i < this.dim; ++i) {
            bl = bl || this.isLinked(n, i);
        }
        return bl;
    }

    private boolean hasParent(int n) {
        boolean bl = false;
        for (int i = 0; i < this.dim; ++i) {
            bl = bl || this.isLinked(i, n);
        }
        return bl;
    }

    public GraphChecker(boolean[][] blArray) {
        this.tempMat = blArray;
        this.dim = this.tempMat.length;
        this.mat = new boolean[this.dim][this.dim];
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                this.mat[i][j] = this.tempMat[i][j];
            }
        }
    }

    private void undo() {
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                this.mat[i][j] = this.tempMat[i][j];
            }
        }
    }

    public boolean isGraphCyclic() {
        boolean bl = false;
        boolean bl2 = true;
        this.undo();
        while (bl2) {
            bl2 = false;
            for (int i = 0; i < this.dim; ++i) {
                if (this.hasChild(i) && this.hasParent(i)) continue;
                if (this.hasChild(i)) {
                    this.unlinkChildren(i);
                    bl2 = true;
                }
                if (!this.hasParent(i)) continue;
                this.unlinkParents(i);
                bl2 = true;
            }
        }
        bl = !this.isGraphEmpty();
        this.undo();
        return bl;
    }

    public int[] getCyclicNodes() {
        int n;
        this.undo();
        boolean bl = true;
        while (bl) {
            bl = false;
            for (n = 0; n < this.dim; ++n) {
                if (this.hasChild(n) && this.hasParent(n)) continue;
                if (this.hasChild(n)) {
                    this.unlinkChildren(n);
                    bl = true;
                }
                if (!this.hasParent(n)) continue;
                this.unlinkParents(n);
                bl = true;
            }
        }
        if (!this.isGraphEmpty()) {
            n = 0;
            for (int i = 0; i < this.dim; ++i) {
                if (this.isIsolated(i)) continue;
                ++n;
            }
            int[] nArray = new int[n];
            int n2 = 0;
            for (int i = 0; i < this.dim; ++i) {
                if (this.isIsolated(i)) continue;
                nArray[n2++] = i;
            }
            this.undo();
            return nArray;
        }
        this.undo();
        return null;
    }

    public int getJoinIndex(int n) {
        this.undo();
        if (!this.isGraphCyclic()) {
            this.undo();
            if (this.isSplit(n)) {
                int n2;
                Vector<Integer> vector = new Vector<Integer>();
                for (n2 = 0; n2 < this.dim; ++n2) {
                    if (!this.isLinked(n, n2)) continue;
                    this.unlink(n, n2);
                    vector.addElement(this.node(n2));
                }
                n2 = 1;
                while (n2 != 0) {
                    int n3;
                    int n4;
                    n2 = 0;
                    Vector<Integer> vector2 = new Vector<Integer>();
                    for (n4 = vector.size() - 1; n4 >= 0; --n4) {
                        n3 = this.indexAt(vector, n4);
                        if (!this.hasParent(n3) || this.isInSet(vector2, n3)) continue;
                        vector2.addElement(this.node(n3));
                        vector.remove(n4);
                    }
                    if (vector.size() == 1 && vector2.size() == 0) {
                        return this.indexAt(vector, 0);
                    }
                    for (n4 = 0; n4 < vector.size(); ++n4) {
                        n3 = this.indexAt(vector, n4);
                        boolean bl = false;
                        for (int i = 0; i < this.dim; ++i) {
                            if (!this.isLinked(n3, i)) continue;
                            this.unlink(n3, i);
                            n2 = 1;
                            bl = true;
                            if (this.isInSet(vector2, i)) continue;
                            vector2.addElement(this.node(i));
                        }
                        if (bl || this.isInSet(vector2, n3)) continue;
                        vector2.addElement(this.node(n3));
                    }
                    vector = vector2;
                }
            }
            return -1;
        }
        return -1;
    }
}

