/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jxpdl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.enhydra.jxpdl.XMLBaseForCollectionAndComplex;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexChoice;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLElementChangeInfo;
import org.enhydra.jxpdl.XMLInterface;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.utilities.SequencedHashMap;

public abstract class XMLCollection
extends XMLBaseForCollectionAndComplex {
    public XMLCollection(XMLComplexElement xMLComplexElement, boolean bl) {
        super(xMLComplexElement, bl);
    }

    public XMLCollection(XMLComplexElement xMLComplexElement, boolean bl, boolean bl2) {
        super((XMLElement)xMLComplexElement, bl, bl2);
    }

    public XMLCollection(XMLComplexElement xMLComplexElement, String string, boolean bl) {
        super((XMLElement)xMLComplexElement, string, bl);
    }

    public XMLCollection(XMLComplexChoice xMLComplexChoice, boolean bl) {
        super(xMLComplexChoice, bl);
    }

    public XMLCollection(XMLComplexChoice xMLComplexChoice, String string, boolean bl) {
        super((XMLElement)xMLComplexChoice, string, bl);
    }

    public XMLCollection(XMLCollection xMLCollection, boolean bl) {
        super(xMLCollection, bl);
    }

    public XMLCollection(XMLCollection xMLCollection, String string, boolean bl) {
        super((XMLElement)xMLCollection, string, bl);
    }

    @Override
    public void makeAs(XMLElement xMLElement) {
        int n;
        Cloneable cloneable;
        Cloneable cloneable2;
        Cloneable cloneable32;
        if (xMLElement == null || !xMLElement.getClass().equals(this.getClass()) || !xMLElement.toName().equals(this.toName())) {
            throw new RuntimeException("Can't perform makeAs!");
        }
        this.xpdl1support = ((XMLCollection)xMLElement).xpdl1support;
        SequencedHashMap sequencedHashMap = new SequencedHashMap();
        SequencedHashMap sequencedHashMap2 = new SequencedHashMap();
        for (Cloneable cloneable32 : this.toElements()) {
            sequencedHashMap.put(((XMLElement)cloneable32).getOriginalElementHashCode(), cloneable32);
        }
        for (Cloneable cloneable32 : ((XMLCollection)xMLElement).toElements()) {
            if (!sequencedHashMap.containsKey(((XMLElement)cloneable32).getOriginalElementHashCode())) {
                cloneable2 = null;
                cloneable2 = this.xpdl1support ? this.generateNewElementWithXPDL1Support() : this.generateNewElement();
                ((XMLElement)cloneable2).makeAs((XMLElement)cloneable32);
                sequencedHashMap2.put(((XMLElement)cloneable2).getOriginalElementHashCode(), cloneable2);
                continue;
            }
            sequencedHashMap2.put(((XMLElement)cloneable32).getOriginalElementHashCode(), cloneable32);
        }
        cloneable32 = new ArrayList(sequencedHashMap2.keySet());
        cloneable32.removeAll(sequencedHashMap.keySet());
        cloneable2 = new ArrayList(sequencedHashMap.keySet());
        cloneable2.removeAll(sequencedHashMap2.keySet());
        ArrayList arrayList = new ArrayList(sequencedHashMap.keySet());
        arrayList.retainAll(sequencedHashMap2.keySet());
        ArrayList<Cloneable> arrayList2 = new ArrayList<Cloneable>();
        Iterator iterator = cloneable2.iterator();
        while (iterator.hasNext()) {
            cloneable = (XMLElement)sequencedHashMap.get(iterator.next());
            arrayList2.add(cloneable);
        }
        cloneable = new ArrayList();
        iterator = cloneable32.iterator();
        while (iterator.hasNext()) {
            cloneable.add(sequencedHashMap2.get(iterator.next()));
        }
        for (Object e : arrayList) {
            XMLElement xMLElement2 = (XMLElement)sequencedHashMap.get(e);
            XMLElement xMLElement3 = (XMLElement)sequencedHashMap2.get(e);
            xMLElement2.makeAs(xMLElement3);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            this.remove((XMLElement)arrayList2.get(n));
        }
        for (n = 0; n < cloneable.size(); ++n) {
            this.add((XMLElement)cloneable.get(n));
        }
        sequencedHashMap.clear();
        for (XMLElement xMLElement4 : this.toElements()) {
            sequencedHashMap.put(xMLElement4.getOriginalElementHashCode(), xMLElement4);
        }
        this.checkRepositioning(sequencedHashMap, sequencedHashMap2);
    }

    @Override
    public void initCaches(XMLInterface xMLInterface) {
        super.initCaches(xMLInterface);
        if (this.elements.size() > 0 && this.elements.get(0) instanceof XMLCollectionElement) {
            this.elementMap.clear();
            for (XMLCollectionElement xMLCollectionElement : this.elements) {
                this.elementMap.put(xMLCollectionElement.getId(), xMLCollectionElement);
            }
        }
        this.cachesInitialized = true;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.elementMap.clear();
    }

    @Override
    public void add(XMLElement xMLElement) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't set the value of read only element!");
        }
        if (xMLElement.getClass() != this.generateNewElement().getClass()) {
            throw new RuntimeException("Can't add element " + xMLElement.getClass().getName() + " into " + this.getClass().getName() + " collection!");
        }
        ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
        arrayList.add(xMLElement);
        this.elements.add(xMLElement);
        xMLElement.setParent(this);
        xMLElement.setNotifyListeners(this.notifyListeners);
        xMLElement.setNotifyMainListeners(this.notifyMainListeners);
        XMLElementChangeInfo xMLElementChangeInfo = this.createInfo(this.value, this.value, arrayList, 3);
        if (this.notifyListeners) {
            this.notifyListeners(xMLElementChangeInfo);
        }
        if (this.notifyMainListeners) {
            this.notifyMainListeners(xMLElementChangeInfo);
        }
    }

    @Override
    public boolean add(int n, XMLElement xMLElement) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't set the value of read only element!");
        }
        if (xMLElement.getClass() != this.generateNewElement().getClass()) {
            throw new RuntimeException("Can't add element " + xMLElement.getClass().getName() + " into " + this.getClass().getName() + " collection!");
        }
        if (n < 0 || n > this.size()) {
            throw new RuntimeException("Can't add element to position " + n + "!");
        }
        ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
        arrayList.add(xMLElement);
        this.elements.add(xMLElement);
        xMLElement.setParent(this);
        xMLElement.setNotifyListeners(this.notifyListeners);
        xMLElement.setNotifyMainListeners(this.notifyMainListeners);
        XMLElementChangeInfo xMLElementChangeInfo = this.createInfo(this.value, this.value, arrayList, 3);
        if (this.notifyListeners) {
            this.notifyListeners(xMLElementChangeInfo);
        }
        if (this.notifyMainListeners) {
            this.notifyMainListeners(xMLElementChangeInfo);
        }
        this.reposition(xMLElement, n);
        return true;
    }

    public boolean addAll(List list) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't set the value of read only element!");
        }
        Class<?> clazz = this.generateNewElement().getClass();
        if (list != null && list.size() > 0) {
            Cloneable cloneable2;
            for (Cloneable cloneable2 : list) {
                if (cloneable2.getClass() != clazz) {
                    throw new RuntimeException("Can't add element " + cloneable2.getClass().getName() + " into " + this.getClass().getName() + " collection!");
                }
                this.elements.add(cloneable2);
                ((XMLElement)cloneable2).setParent(this);
                ((XMLElement)cloneable2).setNotifyListeners(this.notifyListeners);
                ((XMLElement)cloneable2).setNotifyMainListeners(this.notifyMainListeners);
            }
            cloneable2 = new ArrayList(list);
            XMLElementChangeInfo xMLElementChangeInfo = this.createInfo(this.value, this.value, (List)((Object)cloneable2), 3);
            if (this.notifyListeners) {
                this.notifyListeners(xMLElementChangeInfo);
            }
            if (this.notifyMainListeners) {
                this.notifyMainListeners(xMLElementChangeInfo);
            }
            return true;
        }
        return false;
    }

    public int remove(XMLElement xMLElement) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't remove element from read only structure!");
        }
        int n = this.indexOf(xMLElement);
        if (n >= 0) {
            this.removeElement(n);
        }
        return n;
    }

    public XMLElement remove(int n) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't remove element from read only structure!");
        }
        if (n < 0 || n >= this.size()) {
            throw new RuntimeException("There is no element at position " + n + "!");
        }
        return this.removeElement(n);
    }

    protected XMLElement removeElement(int n) {
        XMLElement xMLElement = (XMLElement)this.elements.remove(n);
        if (xMLElement != null) {
            Object object;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(new Integer(n));
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            arrayList2.add(new Integer(n));
            ArrayList<XMLElement> arrayList3 = new ArrayList<XMLElement>();
            arrayList3.add(xMLElement);
            if (arrayList3.size() > 0) {
                object = this.createInfo(arrayList, arrayList2, arrayList3, 7);
                if (this.notifyListeners) {
                    this.notifyListeners((XMLElementChangeInfo)object);
                }
                if (this.notifyMainListeners) {
                    this.notifyMainListeners((XMLElementChangeInfo)object);
                }
            }
            xMLElement.setNotifyListeners(false);
            xMLElement.setNotifyMainListeners(false);
            object = new ArrayList();
            object.add(xMLElement);
            this.elementMap.remove(xMLElement);
            XMLElementChangeInfo xMLElementChangeInfo = this.createInfo(this.value, this.value, (List)object, 5);
            if (this.notifyListeners) {
                this.notifyListeners(xMLElementChangeInfo);
            }
            if (this.notifyMainListeners) {
                this.notifyMainListeners(xMLElementChangeInfo);
            }
        }
        return xMLElement;
    }

    public boolean removeAll(List list) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't remove element from read only structure!");
        }
        if (list != null && list.size() > 0) {
            Object object2;
            ArrayList arrayList = new ArrayList(list);
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            for (Object object2 : list) {
                int n = this.indexOf((XMLElement)object2);
                if (n < 0) {
                    XMLUtil.removeXMLElementFromList(arrayList, (XMLElement)object2);
                    continue;
                }
                arrayList2.add(new Integer(n));
                arrayList3.add(new Integer(n));
            }
            if (arrayList.size() > 0) {
                object2 = this.createInfo(arrayList2, arrayList3, arrayList, 7);
                if (this.notifyListeners) {
                    this.notifyListeners((XMLElementChangeInfo)object2);
                }
                if (this.notifyMainListeners) {
                    this.notifyMainListeners((XMLElementChangeInfo)object2);
                }
            }
            for (Object object2 : arrayList) {
                ((XMLElement)object2).setNotifyListeners(false);
                ((XMLElement)object2).setNotifyMainListeners(false);
                this.elements.remove(this.indexOf((XMLElement)object2));
                this.elementMap.remove(object2);
            }
            object2 = this.createInfo(this.value, this.value, arrayList, 5);
            if (this.notifyListeners) {
                this.notifyListeners((XMLElementChangeInfo)object2);
            }
            if (this.notifyMainListeners) {
                this.notifyMainListeners((XMLElementChangeInfo)object2);
            }
            return true;
        }
        return false;
    }

    public boolean reposition(XMLElement xMLElement, int n) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't reposition element from read only structure!");
        }
        int n2 = this.indexOf(xMLElement);
        if (n < 0 || n > this.size() || n2 < 0 || n2 == n) {
            return false;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(this.indexOf(xMLElement)));
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        arrayList2.add(new Integer(n));
        ArrayList<XMLElement> arrayList3 = new ArrayList<XMLElement>();
        arrayList3.add(xMLElement);
        this.elements.remove((Integer)arrayList.get(0));
        this.elements.add(n, xMLElement);
        if (arrayList3.size() > 0) {
            XMLElementChangeInfo xMLElementChangeInfo = this.createInfo(arrayList, arrayList2, arrayList3, 7);
            if (this.notifyListeners) {
                this.notifyListeners(xMLElementChangeInfo);
            }
            if (this.notifyMainListeners) {
                this.notifyMainListeners(xMLElementChangeInfo);
            }
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public XMLCollectionElement getCollectionElement(String string) {
        if (this.isReadOnly && this.cachesInitialized) {
            return (XMLCollectionElement)this.elementMap.get(string);
        }
        for (XMLCollectionElement xMLCollectionElement : this.elements) {
            if (!xMLCollectionElement.getId().equals(string)) continue;
            return xMLCollectionElement;
        }
        return null;
    }

    public boolean containsElement(String string) {
        return this.getCollectionElement(string) != null;
    }

    public int indexOf(XMLElement xMLElement) {
        return XMLUtil.indexOfXMLElementWithinList(this.elements, xMLElement);
    }

    public void clear() {
        int n = this.elements.size();
        ArrayList arrayList = new ArrayList(this.elements);
        for (Object object : this.elements) {
            ((XMLElement)object).setNotifyListeners(false);
            ((XMLElement)object).setNotifyMainListeners(false);
        }
        this.elements.clear();
        this.elementMap.clear();
        if (n > 0) {
            Object object;
            object = this.createInfo(this.value, this.value, arrayList, 5);
            if (this.notifyListeners) {
                this.notifyListeners((XMLElementChangeInfo)object);
            }
            if (this.notifyMainListeners) {
                this.notifyMainListeners((XMLElementChangeInfo)object);
            }
        }
    }

    public abstract XMLElement generateNewElement();

    public XMLElement generateNewElementWithXPDL1Support() {
        return this.generateNewElement();
    }

    protected void checkRepositioning(SequencedHashMap sequencedHashMap, SequencedHashMap sequencedHashMap2) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList(sequencedHashMap2.sequence());
        for (n = 0; n < arrayList4.size(); ++n) {
            int n2;
            int n3 = sequencedHashMap.indexOf(arrayList4.get(n));
            if (n3 == (n2 = sequencedHashMap2.indexOf(arrayList4.get(n)))) continue;
            Object e = this.elements.get(n3);
            arrayList3.add(e);
            arrayList.add(new Integer(n3));
            arrayList2.add(new Integer(n2));
        }
        if (arrayList3.size() > 0) {
            for (n = 0; n < arrayList3.size(); ++n) {
                XMLElement xMLElement = (XMLElement)arrayList3.get(n);
                this.elements.remove(this.indexOf(xMLElement));
                this.elements.add((Integer)arrayList2.get(n), xMLElement);
            }
            XMLElementChangeInfo xMLElementChangeInfo = this.createInfo(arrayList, arrayList2, arrayList3, 7);
            if (this.notifyListeners) {
                this.notifyListeners(xMLElementChangeInfo);
            }
            if (this.notifyMainListeners) {
                this.notifyMainListeners(xMLElementChangeInfo);
            }
        }
    }

    @Override
    public Object clone() {
        XMLCollection xMLCollection = (XMLCollection)super.clone();
        xMLCollection.elements = new ArrayList();
        xMLCollection.elementMap = new SequencedHashMap();
        xMLCollection.cachesInitialized = false;
        for (Object e : this.elements) {
            XMLElement xMLElement = (XMLElement)e;
            XMLElement xMLElement2 = (XMLElement)xMLElement.clone();
            xMLElement2.setParent(xMLCollection);
            xMLCollection.elements.add(xMLElement2);
        }
        return xMLCollection;
    }
}

