/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jxpdl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.tools.Tool;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.util.XMLChar;
import org.enhydra.jxpdl.ParsingErrors;
import org.enhydra.jxpdl.ShowLicense;
import org.enhydra.jxpdl.StandardPackageValidator;
import org.enhydra.jxpdl.XMLBaseForCollectionAndComplex;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLElementChangeInfo;
import org.enhydra.jxpdl.XMLElementChangeListener;
import org.enhydra.jxpdl.XMLInterface;
import org.enhydra.jxpdl.XMLInterfaceImpl;
import org.enhydra.jxpdl.XPDLRepositoryHandler;
import org.enhydra.jxpdl.elements.Activities;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.ActivitySets;
import org.enhydra.jxpdl.elements.Application;
import org.enhydra.jxpdl.elements.Applications;
import org.enhydra.jxpdl.elements.ArrayType;
import org.enhydra.jxpdl.elements.Artifact;
import org.enhydra.jxpdl.elements.Artifacts;
import org.enhydra.jxpdl.elements.Association;
import org.enhydra.jxpdl.elements.Associations;
import org.enhydra.jxpdl.elements.BasicType;
import org.enhydra.jxpdl.elements.BlockActivity;
import org.enhydra.jxpdl.elements.DataField;
import org.enhydra.jxpdl.elements.DataFields;
import org.enhydra.jxpdl.elements.DataTypes;
import org.enhydra.jxpdl.elements.Deadline;
import org.enhydra.jxpdl.elements.DeclaredType;
import org.enhydra.jxpdl.elements.ExtendedAttribute;
import org.enhydra.jxpdl.elements.ExtendedAttributes;
import org.enhydra.jxpdl.elements.ExternalPackage;
import org.enhydra.jxpdl.elements.ExternalReference;
import org.enhydra.jxpdl.elements.FormalParameter;
import org.enhydra.jxpdl.elements.FormalParameters;
import org.enhydra.jxpdl.elements.Join;
import org.enhydra.jxpdl.elements.Lane;
import org.enhydra.jxpdl.elements.Lanes;
import org.enhydra.jxpdl.elements.ListType;
import org.enhydra.jxpdl.elements.Member;
import org.enhydra.jxpdl.elements.NestedLane;
import org.enhydra.jxpdl.elements.NestedLanes;
import org.enhydra.jxpdl.elements.NodeGraphicsInfo;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.Participant;
import org.enhydra.jxpdl.elements.Participants;
import org.enhydra.jxpdl.elements.Performer;
import org.enhydra.jxpdl.elements.Pool;
import org.enhydra.jxpdl.elements.Pools;
import org.enhydra.jxpdl.elements.RecordType;
import org.enhydra.jxpdl.elements.RedefinableHeader;
import org.enhydra.jxpdl.elements.Responsible;
import org.enhydra.jxpdl.elements.Responsibles;
import org.enhydra.jxpdl.elements.SchemaType;
import org.enhydra.jxpdl.elements.Split;
import org.enhydra.jxpdl.elements.SubFlow;
import org.enhydra.jxpdl.elements.TaskApplication;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.TransitionRef;
import org.enhydra.jxpdl.elements.TransitionRefs;
import org.enhydra.jxpdl.elements.TransitionRestriction;
import org.enhydra.jxpdl.elements.TransitionRestrictions;
import org.enhydra.jxpdl.elements.Transitions;
import org.enhydra.jxpdl.elements.TypeDeclaration;
import org.enhydra.jxpdl.elements.TypeDeclarations;
import org.enhydra.jxpdl.elements.UnionType;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.enhydra.jxpdl.elements.WorkflowProcesses;
import org.enhydra.jxpdl.utilities.SequencedHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLUtil {
    public static final String XMLNS = "http://www.wfmc.org/2008/XPDL2.1";
    public static final String XMLNS_XPDL = "http://www.wfmc.org/2008/XPDL2.1";
    public static final String XMLNS_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSI_SCHEMA_LOCATION = "http://www.wfmc.org/2008/XPDL2.1 http://www.wfmc.org/standards/docs/bpmnxpdl_31.xsd";
    public static Map basicTypesMap = new HashMap();

    public static int howManyStringsWithinString(String string, String string2) {
        return XMLUtil.getStringPositionsWithinString(string, string2).size();
    }

    public static String replaceLFwithCRLF(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        List list = XMLUtil.getStringPositionsWithinString(string, "\n");
        List list2 = XMLUtil.getStringPositionsWithinString(string, "\r\n");
        if (list2.size() == 0) {
            if (list.size() > 0) {
                string2 = string2.replaceAll("\n", "\r\n");
            }
        } else if (list.size() > 0) {
            Integer n;
            int n2;
            string2 = "";
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n3 = 0;
            for (n2 = 0; n2 < list.size(); ++n2) {
                n = (Integer)list.get(n2);
                if (list2.contains(new Integer(n - 1))) continue;
                arrayList.add(n);
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                n = (Integer)arrayList.get(n2);
                string2 = string2 + string.substring(n3, n) + "\r\n";
                n3 = n + 1;
            }
            if (n3 < string.length()) {
                string2 = string2 + string.substring(n3);
            }
        }
        return string2;
    }

    public static List getStringPositionsWithinString(String string, String string2) {
        try {
            int n;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n2 = 0;
            while ((n = string.indexOf(string2, n2)) != -1) {
                arrayList.add(new Integer(n));
                n2 = n + string2.length();
            }
            return arrayList;
        }
        catch (Exception exception) {
            return new ArrayList();
        }
    }

    public static String getCanonicalPath(String string, String string2, boolean bl) {
        try {
            File file = null;
            if (string2 == null || string2.equals("")) {
                file = new File(string);
                if (!file.isAbsolute() && !(file = file.getAbsoluteFile()).exists()) {
                    file = new File(XMLUtil.createPath(string2, string));
                }
            } else {
                file = new File(XMLUtil.createPath(string2, string));
            }
            if (!file.exists() || file.isDirectory() && !bl) {
                System.err.println("The file " + file.getAbsolutePath() + " does not exist");
                return null;
            }
            return XMLUtil.getCanonicalPath(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String getCanonicalPath(String string, boolean bl) {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.dir") + File.separator + string);
        }
        if (!file.exists() || file.isDirectory() && !bl) {
            System.err.println("The file " + file.getAbsolutePath() + " does not exist");
            return null;
        }
        return XMLUtil.getCanonicalPath(file);
    }

    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception exception) {
            return file.getAbsolutePath();
        }
    }

    public static String getNameSpacePrefix(Node node) {
        String string = node.getPrefix();
        string = string != null ? string + ":" : "";
        return string;
    }

    public static Node getChildByName(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            return node2;
        }
        return null;
    }

    public static String getId(Node node) {
        try {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("Id");
            String string = node2.hasChildNodes() ? node2.getChildNodes().item(0).getNodeValue() : node2.getNodeValue();
            return string.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String getIdFromFile(String string) {
        try {
            Object object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = null;
            try {
                object = new File(string);
                if (!((File)object).exists()) {
                    object = new File(((File)object).getCanonicalPath());
                }
                document = documentBuilder.parse(new InputSource(new FileInputStream((File)object)));
            }
            catch (Exception exception) {
                document = documentBuilder.parse(new InputSource(new StringReader(string)));
            }
            object = XMLUtil.getId(document.getDocumentElement());
            return object;
        }
        catch (Exception exception) {
            String string2 = "";
            return string2;
        }
    }

    public static String getContent(Node node, boolean bl) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("encoding", "UTF-8");
            if (bl) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            DOMSource dOMSource = new DOMSource(node);
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            transformer.transform(dOMSource, streamResult);
            String string = byteArrayOutputStream.toString("UTF8");
            byteArrayOutputStream.close();
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getChildNodesContent(Node node) {
        String string = "";
        if (node != null && node.hasChildNodes()) {
            string = XMLUtil.getContent(node, true);
            try {
                Node node2 = node.getFirstChild();
                String string2 = XMLUtil.getContent(node2, true);
                String string3 = "</" + node.getNodeName() + ">";
                if (string2.trim().length() > 0) {
                    string2 = string2.trim();
                }
                int n = string.indexOf(string2);
                int n2 = string.lastIndexOf(string3);
                string = string.substring(n, n2).trim();
            }
            catch (Exception exception) {
                NodeList nodeList = node.getChildNodes();
                string = "";
                try {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node3 = nodeList.item(i);
                        if (node3 instanceof Element) {
                            string = string + XMLUtil.getContent(node3, true);
                            continue;
                        }
                        String string4 = node3.getNodeValue();
                        if (i > 0) {
                            string = string + string4.substring(1);
                            continue;
                        }
                        if (i == 0 && string4.trim().length() == 0) continue;
                        string = string + string4;
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    public static String getShortClassName(String string) {
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    public static String getExternalPackageId(String string) {
        int n = string.lastIndexOf("\\");
        int n2 = string.lastIndexOf("/");
        int n3 = string.lastIndexOf(".xpdl");
        if (n2 != -1 || n != -1) {
            int n4 = n2;
            if (n > n2) {
                n4 = n;
            }
            string = string.substring(n4 + 1);
        }
        if (n3 != -1) {
            string = string.substring(0, string.length() - 5);
        }
        return string;
    }

    public static Node parseSchemaNode(String string, boolean bl) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            Object object;
            ParsingErrors parsingErrors = new ParsingErrors();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(parsingErrors);
            if (bl) {
                object = new File(string);
                if (!((File)object).exists()) {
                    throw new Exception();
                }
                document = documentBuilder.parse(new InputSource(new FileInputStream((File)object)));
            } else {
                document = documentBuilder.parse(new InputSource(new StringReader(string)));
            }
            object = parsingErrors.getErrorMessages();
            if (object.size() > 0) {
                System.err.println("Errors in schema type");
            }
        }
        catch (Exception exception) {
            System.err.println("Fatal error while parsing xml schema document");
            return null;
        }
        if (document != null) {
            return document.getDocumentElement();
        }
        return null;
    }

    public static String stringifyExtendedAttributes(ExtendedAttributes extendedAttributes) throws Exception {
        try {
            ExtendedAttributes extendedAttributes2 = (ExtendedAttributes)extendedAttributes.clone();
            extendedAttributes2.setParent(null);
            for (ExtendedAttribute extendedAttribute : extendedAttributes2.toElements()) {
                extendedAttribute.setParent(null);
                extendedAttribute.get("Name").setParent(null);
                extendedAttribute.get("Value").setParent(null);
            }
            return XMLUtil.getExtendedAttributesString(extendedAttributes2);
        }
        catch (Throwable throwable) {
            throw new Exception("Can't stringify extended attributes, error=" + throwable.getMessage() + " !");
        }
    }

    public static ExtendedAttributes destringyfyExtendedAttributes(String string) throws Exception {
        ExtendedAttributes extendedAttributes = null;
        if (string != null && !string.trim().equals("")) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = null;
                document = documentBuilder.parse(new InputSource(new StringReader(string)));
                extendedAttributes = new ExtendedAttributes(null);
                if (document != null) {
                    XPDLRepositoryHandler xPDLRepositoryHandler = new XPDLRepositoryHandler();
                    xPDLRepositoryHandler.fromXML((Node)document.getDocumentElement(), extendedAttributes);
                }
                return extendedAttributes;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new Exception("Failed to destringify extended attributes, error=" + throwable.getMessage() + " !");
            }
        }
        return extendedAttributes;
    }

    public static Node parseExtendedAttributeContent(String string) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            ParsingErrors parsingErrors = new ParsingErrors();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(parsingErrors);
            string = "<ExtAttribsAddition>" + string + "</ExtAttribsAddition>";
            document = documentBuilder.parse(new InputSource(new StringReader(string)));
            List list = parsingErrors.getErrorMessages();
            if (list.size() > 0) {
                System.err.println("Errors in ext attribs complex content");
            }
        }
        catch (Exception exception) {
            System.err.println("Fatal error while parsing ext. attributes complex content " + string);
            return null;
        }
        if (document != null) {
            return document.getDocumentElement();
        }
        return null;
    }

    public static String getExtendedAttributeValue(String[][] stringArray, String string) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i][0].equals(string)) continue;
                return stringArray[i][1];
            }
        }
        return null;
    }

    public static String getJavaType(XMLInterface xMLInterface, XMLCollectionElement xMLCollectionElement) {
        DataTypes dataTypes = null;
        dataTypes = xMLCollectionElement instanceof DataField ? ((DataField)xMLCollectionElement).getDataType().getDataTypes() : ((FormalParameter)xMLCollectionElement).getDataType().getDataTypes();
        return XMLUtil.getChoosenType(xMLInterface, dataTypes, XMLUtil.getPackage(xMLCollectionElement));
    }

    public static String getChoosenType(XMLInterface xMLInterface, DataTypes dataTypes, Package package_) {
        XMLElement xMLElement = dataTypes.getChoosen();
        if (xMLElement instanceof BasicType) {
            String string = ((BasicType)xMLElement).getType();
            if (basicTypesMap.containsKey(string)) {
                return (String)basicTypesMap.get(string);
            }
        } else {
            if (xMLElement instanceof DeclaredType) {
                TypeDeclaration typeDeclaration = XMLUtil.getTypeDeclaration(xMLInterface, package_, ((DeclaredType)xMLElement).getId());
                DataTypes dataTypes2 = typeDeclaration.getDataTypes();
                return XMLUtil.getChoosenType(xMLInterface, dataTypes2, package_);
            }
            if (xMLElement instanceof SchemaType) {
                return "org.w3c.dom.Node";
            }
            if (xMLElement instanceof ExternalReference) {
                return ((ExternalReference)xMLElement).getLocation();
            }
        }
        return "java.lang.Object";
    }

    public static Package getPackage(XMLElement xMLElement) {
        if (xMLElement == null) {
            return null;
        }
        while (!(xMLElement instanceof Package) && (xMLElement = xMLElement.getParent()) != null) {
        }
        return (Package)xMLElement;
    }

    public static WorkflowProcess getWorkflowProcess(XMLElement xMLElement) {
        if (xMLElement == null) {
            return null;
        }
        while (!(xMLElement instanceof WorkflowProcess) && (xMLElement = xMLElement.getParent()) != null) {
        }
        return (WorkflowProcess)xMLElement;
    }

    public static Application getApplication(XMLElement xMLElement) {
        if (xMLElement == null) {
            return null;
        }
        while (!(xMLElement instanceof Application) && (xMLElement = xMLElement.getParent()) != null) {
        }
        return (Application)xMLElement;
    }

    public static Pool getPool(XMLElement xMLElement) {
        if (xMLElement == null) {
            return null;
        }
        while (!(xMLElement instanceof Pool) && (xMLElement = xMLElement.getParent()) != null) {
        }
        return (Pool)xMLElement;
    }

    public static ActivitySet getActivitySet(XMLElement xMLElement) {
        if (xMLElement == null) {
            return null;
        }
        while (!(xMLElement instanceof ActivitySet) && (xMLElement = xMLElement.getParent()) != null) {
        }
        return (ActivitySet)xMLElement;
    }

    public static XMLCollectionElement getActivitySetOrWorkflowProcess(XMLElement xMLElement) {
        if (xMLElement == null) {
            return null;
        }
        while (!(xMLElement instanceof ActivitySet) && !(xMLElement instanceof WorkflowProcess) && (xMLElement = xMLElement.getParent()) != null) {
        }
        return (XMLCollectionElement)xMLElement;
    }

    public static Activity getActivity(XMLElement xMLElement) {
        if (xMLElement == null) {
            return null;
        }
        while (!(xMLElement instanceof Activity) && (xMLElement = xMLElement.getParent()) != null) {
        }
        return (Activity)xMLElement;
    }

    public static Artifact getArtifact(XMLElement xMLElement) {
        if (xMLElement == null) {
            return null;
        }
        while (!(xMLElement instanceof Artifact) && (xMLElement = xMLElement.getParent()) != null) {
        }
        return (Artifact)xMLElement;
    }

    public static Transition getTransition(XMLElement xMLElement) {
        if (xMLElement == null) {
            return null;
        }
        while (!(xMLElement instanceof Transition) && (xMLElement = xMLElement.getParent()) != null) {
        }
        return (Transition)xMLElement;
    }

    public static Association getAssociation(XMLElement xMLElement) {
        if (xMLElement == null) {
            return null;
        }
        while (!(xMLElement instanceof Association) && (xMLElement = xMLElement.getParent()) != null) {
        }
        return (Association)xMLElement;
    }

    public static Participant getParticipant(XMLElement xMLElement) {
        if (xMLElement == null) {
            return null;
        }
        while (!(xMLElement instanceof Participant) && (xMLElement = xMLElement.getParent()) != null) {
        }
        return (Participant)xMLElement;
    }

    public static Lane getLane(XMLElement xMLElement) {
        if (xMLElement == null) {
            return null;
        }
        while (!(xMLElement instanceof Lane) && (xMLElement = xMLElement.getParent()) != null) {
        }
        return (Lane)xMLElement;
    }

    public static XMLElement getParentElement(Class clazz, XMLElement xMLElement) {
        if (xMLElement == null || clazz == null) {
            return null;
        }
        while (xMLElement.getClass() != clazz && (xMLElement = xMLElement.getParent()) != null) {
        }
        return xMLElement;
    }

    public static XMLElement getParentElementByAssignableType(Class clazz, XMLElement xMLElement) {
        if (xMLElement == null || clazz == null) {
            return null;
        }
        while (!clazz.isAssignableFrom(xMLElement.getClass()) && (xMLElement = xMLElement.getParent()) != null) {
        }
        return xMLElement;
    }

    public static boolean isParentsChild(XMLElement xMLElement, XMLElement xMLElement2) {
        if (xMLElement2 == null || xMLElement == null) {
            return false;
        }
        if ((xMLElement2 = xMLElement2.getParent()) == null) {
            return false;
        }
        while (xMLElement2 != xMLElement && (xMLElement2 = xMLElement2.getParent()) != null) {
        }
        return xMLElement2 != null;
    }

    public static boolean isChildsParent(XMLElement xMLElement, XMLElement xMLElement2) {
        if (xMLElement2 == null || xMLElement == null) {
            return false;
        }
        XMLElement xMLElement3 = xMLElement2.getParent();
        if (xMLElement3 == null) {
            return false;
        }
        while (xMLElement3 != xMLElement && (xMLElement3 = xMLElement3.getParent()) != null) {
        }
        return xMLElement3 != null;
    }

    public static Set getAllParents(XMLElement xMLElement) {
        HashSet<XMLElement> hashSet = new HashSet<XMLElement>();
        while (xMLElement != null) {
            xMLElement = xMLElement.getParent();
            hashSet.add(xMLElement);
        }
        return hashSet;
    }

    public static WorkflowProcess findWorkflowProcess(XMLInterface xMLInterface, Package package_, String string) {
        WorkflowProcess workflowProcess;
        block1: {
            Package package_2;
            workflowProcess = package_.getWorkflowProcess(string);
            if (workflowProcess != null) break block1;
            List list = XMLUtil.getAllExternalPackageIds(xMLInterface, package_, new HashSet());
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && ((package_2 = xMLInterface.getPackageById((String)iterator.next())) == null || (workflowProcess = package_2.getWorkflowProcess(string)) == null)) {
            }
        }
        return workflowProcess;
    }

    public static Participant findParticipant(XMLInterface xMLInterface, WorkflowProcess workflowProcess, String string) {
        Participant participant = workflowProcess.getParticipant(string);
        if (participant == null) {
            Package package_ = XMLUtil.getPackage(workflowProcess);
            participant = XMLUtil.findParticipant(xMLInterface, package_, string);
        }
        return participant;
    }

    public static Participant findParticipant(XMLInterface xMLInterface, Package package_, String string) {
        Participant participant;
        block1: {
            Package package_2;
            participant = package_.getParticipant(string);
            if (participant != null) break block1;
            List list = XMLUtil.getAllExternalPackageIds(xMLInterface, package_, new HashSet());
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && ((package_2 = xMLInterface.getPackageById((String)iterator.next())) == null || (participant = package_2.getParticipant(string)) == null)) {
            }
        }
        return participant;
    }

    public static Application findApplication(XMLInterface xMLInterface, WorkflowProcess workflowProcess, String string) {
        Application application = workflowProcess.getApplication(string);
        if (application == null) {
            Package package_ = XMLUtil.getPackage(workflowProcess);
            application = XMLUtil.getApplication(xMLInterface, package_, string);
        }
        return application;
    }

    public static Application getApplication(XMLInterface xMLInterface, Package package_, String string) {
        Application application;
        block1: {
            Package package_2;
            application = package_.getApplication(string);
            if (application != null) break block1;
            List list = XMLUtil.getAllExternalPackageIds(xMLInterface, package_, new HashSet());
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && ((package_2 = xMLInterface.getPackageById((String)iterator.next())) == null || (application = package_2.getApplication(string)) == null)) {
            }
        }
        return application;
    }

    public static TypeDeclaration getTypeDeclaration(XMLInterface xMLInterface, Package package_, String string) {
        TypeDeclaration typeDeclaration;
        block1: {
            Package package_2;
            typeDeclaration = package_.getTypeDeclaration(string);
            if (typeDeclaration != null) break block1;
            List list = XMLUtil.getAllExternalPackageIds(xMLInterface, package_, new HashSet());
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && ((package_2 = xMLInterface.getPackageById((String)iterator.next())) == null || (typeDeclaration = package_2.getTypeDeclaration(string)) == null)) {
            }
        }
        return typeDeclaration;
    }

    public static boolean canBeExpression(String string, Map map, boolean bl) {
        boolean bl2;
        String string2 = new String(string);
        boolean bl3 = false;
        if (bl && string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
            bl3 = true;
        }
        if (!bl3 && (bl2 = XMLUtil.isIdValid(string2)) && map.containsKey(string2)) {
            bl3 = true;
        }
        if (!bl3) {
            for (String string3 : map.keySet()) {
                if (XMLUtil.getUsingPositions(string2, string3, map).size() <= 0) continue;
                bl3 = true;
                break;
            }
        }
        return bl3;
    }

    public static List getUsingPositions(String string, String string2, Map map) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (string.trim().equals("") || string2.trim().equals("")) {
            return arrayList;
        }
        String string3 = new String(string);
        int n = -1;
        while ((n = string3.indexOf(string2)) >= 0 && n >= 0) {
            boolean bl;
            int n2;
            if (string3.equals(string2)) {
                n2 = n;
                if (arrayList.size() > 0) {
                    n2 += (Integer)arrayList.get(arrayList.size() - 1) + string2.length();
                }
                arrayList.add(new Integer(n2));
                break;
            }
            if (n == 0) {
                n2 = 1;
            } else {
                char c = string3.charAt(n - 1);
                int n3 = n2 = !XMLUtil.isIdValid(String.valueOf(c)) || c == ':' ? 1 : 0;
            }
            if (n + string2.length() == string3.length()) {
                bl = true;
            } else {
                char c = string3.charAt(n + string2.length());
                boolean bl2 = bl = !XMLUtil.isIdValid(String.valueOf(c));
                if (!(bl || c != '-' && c != '.')) {
                    bl = true;
                    ArrayList arrayList2 = new ArrayList(map.keySet());
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        String string4 = (String)iterator.next();
                        if (string4.indexOf(c) > 0) continue;
                        iterator.remove();
                    }
                    if (arrayList2.size() > 0) {
                        for (String string4 : arrayList2) {
                            int n4 = string3.indexOf(string4);
                            if (n4 != n) continue;
                            bl = false;
                            break;
                        }
                    }
                }
            }
            if (n2 != 0 && bl) {
                int n5 = n;
                if (arrayList.size() > 0) {
                    n5 += (Integer)arrayList.get(arrayList.size() - 1) + string2.length();
                }
                arrayList.add(new Integer(n5));
            }
            string3 = string3.substring(n + string2.length());
        }
        return arrayList;
    }

    public static Join getJoin(Activity activity) {
        Join join = null;
        TransitionRestrictions transitionRestrictions = activity.getTransitionRestrictions();
        if (transitionRestrictions.size() > 0) {
            join = ((TransitionRestriction)transitionRestrictions.get(0)).getJoin();
        }
        return join;
    }

    public static Split getSplit(Activity activity) {
        Split split = null;
        TransitionRestrictions transitionRestrictions = activity.getTransitionRestrictions();
        if (transitionRestrictions.size() > 0) {
            split = ((TransitionRestriction)transitionRestrictions.get(0)).getSplit();
        }
        return split;
    }

    public static Set getOutgoingTransitions(Activity activity) {
        return XMLUtil.getOutgoingTransitions(activity, (Transitions)((XMLCollectionElement)activity.getParent().getParent()).get("Transitions"));
    }

    public static Set getOutgoingTransitions(Activity activity, Transitions transitions) {
        HashSet<Transition> hashSet = new HashSet<Transition>();
        for (Transition transition : transitions.toElements()) {
            if (!transition.getFrom().equals(activity.getId())) continue;
            hashSet.add(transition);
        }
        return hashSet;
    }

    public static Set getExceptionalOutgoingTransitions(Activity activity) {
        Transitions transitions = (Transitions)((XMLCollectionElement)activity.getParent().getParent()).get("Transitions");
        return XMLUtil.getExceptionalOutgoingTransitions(activity, transitions);
    }

    public static Set getExceptionalOutgoingTransitions(Activity activity, Transitions transitions) {
        HashSet<Transition> hashSet = new HashSet<Transition>();
        for (Transition transition : transitions.toElements()) {
            if (!transition.getFrom().equals(activity.getId()) || !XMLUtil.isExceptionalTransition(transition)) continue;
            hashSet.add(transition);
        }
        return hashSet;
    }

    public static Set getNonExceptionalOutgoingTransitions(Activity activity) {
        Transitions transitions = (Transitions)((XMLCollectionElement)activity.getParent().getParent()).get("Transitions");
        return XMLUtil.getNonExceptionalOutgoingTransitions(activity, transitions);
    }

    public static Set getNonExceptionalOutgoingTransitions(Activity activity, Transitions transitions) {
        HashSet<Transition> hashSet = new HashSet<Transition>();
        for (Transition transition : transitions.toElements()) {
            if (!transition.getFrom().equals(activity.getId()) || XMLUtil.isExceptionalTransition(transition)) continue;
            hashSet.add(transition);
        }
        return hashSet;
    }

    public static Set getIncomingTransitions(Activity activity) {
        return XMLUtil.getIncomingTransitions(activity, (Transitions)((XMLCollectionElement)activity.getParent().getParent()).get("Transitions"));
    }

    public static Set getIncomingTransitions(Activity activity, Transitions transitions) {
        HashSet<Transition> hashSet = new HashSet<Transition>();
        for (Transition transition : transitions.toElements()) {
            if (!transition.getTo().equals(activity.getId())) continue;
            hashSet.add(transition);
        }
        return hashSet;
    }

    public static boolean isExceptionalTransition(Transition transition) {
        String string;
        boolean bl = false;
        if (transition != null && ((string = transition.getCondition().getType()).equals("EXCEPTION") || string.equals("DEFAULTEXCEPTION"))) {
            bl = true;
        }
        return bl;
    }

    public static Activity getFromActivity(Transition transition) {
        return ((Activities)((XMLCollectionElement)transition.getParent().getParent()).get("Activities")).getActivity(transition.getFrom());
    }

    public static Activity getToActivity(Transition transition) {
        return ((Activities)((XMLCollectionElement)transition.getParent().getParent()).get("Activities")).getActivity(transition.getTo());
    }

    public static Set getOutgoingAssociations(XMLCollectionElement xMLCollectionElement) {
        HashSet<Association> hashSet = new HashSet<Association>();
        Iterator iterator = XMLUtil.getPackage(xMLCollectionElement).getAssociations().toElements().iterator();
        String string = xMLCollectionElement.getId();
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            if (!association.getSource().equals(string)) continue;
            hashSet.add(association);
        }
        return hashSet;
    }

    public static Set getIncomingAssociations(XMLCollectionElement xMLCollectionElement) {
        HashSet<Association> hashSet = new HashSet<Association>();
        Iterator iterator = XMLUtil.getPackage(xMLCollectionElement).getAssociations().toElements().iterator();
        String string = xMLCollectionElement.getId();
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            if (!association.getTarget().equals(string)) continue;
            hashSet.add(association);
        }
        return hashSet;
    }

    public static XMLCollectionElement getAssociationSource(Association association) {
        return XMLUtil.getAssociationSourceOrTarget(association, true);
    }

    public static XMLCollectionElement getAssociationTarget(Association association) {
        return XMLUtil.getAssociationSourceOrTarget(association, false);
    }

    protected static XMLCollectionElement getAssociationSourceOrTarget(Association association, boolean bl) {
        String string = "Source";
        if (!bl) {
            string = "Target";
        }
        String string2 = association.get(string).toValue();
        XMLCollectionElement xMLCollectionElement = XMLUtil.getPackage(association).getArtifact(string2);
        if (xMLCollectionElement == null) {
            xMLCollectionElement = XMLUtil.getPackage(association).getActivity(string2);
        }
        return xMLCollectionElement;
    }

    public static List getAllArtifactsAndAssociationsForWorkflowProcessOrActivitySet(XMLCollectionElement xMLCollectionElement) {
        XMLComplexElement xMLComplexElement;
        ArrayList<XMLCollectionElement> arrayList = new ArrayList<XMLCollectionElement>();
        Iterator iterator = XMLUtil.getPoolForProcessOrActivitySet(xMLCollectionElement).getLanes().toElements().iterator();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (iterator.hasNext()) {
            xMLComplexElement = (Lane)iterator.next();
            arrayList2.add(((XMLCollectionElement)xMLComplexElement).getId());
        }
        xMLComplexElement = XMLUtil.getPackage(xMLCollectionElement);
        for (Artifact artifact : ((Package)xMLComplexElement).getArtifacts().toElements()) {
            if (artifact.getNodeGraphicsInfos().size() <= 0) continue;
            Iterator iterator2 = artifact.getNodeGraphicsInfos().toElements().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                NodeGraphicsInfo nodeGraphicsInfo = (NodeGraphicsInfo)iterator2.next();
                if (!arrayList2.contains(nodeGraphicsInfo.getLaneId()) || bl) continue;
                arrayList.add(artifact);
                List list = XMLUtil.getArtifactReferences((Package)xMLComplexElement, artifact.getId());
                for (int i = 0; i < list.size(); ++i) {
                    Association association = XMLUtil.getAssociation((XMLElement)list.get(i));
                    arrayList.add(association);
                }
                bl = true;
            }
        }
        return arrayList;
    }

    public static boolean isIdValid(String string) {
        return string != null && XMLChar.isValidNmtoken((String)string) && !string.trim().equals("");
    }

    public static int cntIds(XMLCollection xMLCollection, String string) {
        int n = 0;
        for (XMLElement xMLElement : xMLCollection.toElements()) {
            if (xMLElement instanceof XMLCollectionElement) {
                XMLCollectionElement xMLCollectionElement = (XMLCollectionElement)xMLElement;
                String string2 = xMLCollectionElement.getId();
                if (!string2.equals(string)) continue;
                ++n;
                continue;
            }
            return 0;
        }
        return n;
    }

    public static WorkflowProcess getSubflowProcess(XMLInterface xMLInterface, Activity activity) {
        WorkflowProcess workflowProcess;
        block2: {
            Package package_;
            SubFlow subFlow;
            String string;
            if (activity.getActivityType() != 3) {
                return null;
            }
            Package package_2 = XMLUtil.getPackage(activity);
            workflowProcess = package_2.getWorkflowProcess(string = (subFlow = activity.getActivityTypes().getImplementation().getImplementationTypes().getSubFlow()).getId());
            if (workflowProcess != null) break block2;
            List list = XMLUtil.getAllExternalPackageIds(xMLInterface, package_2, new HashSet());
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && ((package_ = xMLInterface.getPackageById((String)iterator.next())) == null || (workflowProcess = package_.getWorkflowProcess(string)) == null)) {
            }
        }
        return workflowProcess;
    }

    public static ActivitySet getBlockActivitySet(Activity activity) {
        if (activity.getActivityType() != 4) {
            return null;
        }
        String string = activity.getActivityTypes().getBlockActivity().getActivitySetId();
        ActivitySet activitySet = XMLUtil.getWorkflowProcess(activity).getActivitySet(string);
        return activitySet;
    }

    public static List getAllExternalPackageIds(XMLInterface xMLInterface, Package package_, Set set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList(package_.getExternalPackageIds());
        arrayList2.removeAll(set);
        for (String string : arrayList2) {
            Package package_2 = xMLInterface.getPackageById(string);
            if (package_2 == null || arrayList.contains(package_2.getId())) continue;
            arrayList.add(string);
            set.addAll(arrayList);
            arrayList.addAll(XMLUtil.getAllExternalPackageIds(xMLInterface, package_2, set));
        }
        return arrayList;
    }

    public static List getImmediateExternalPackages(XMLInterface xMLInterface, Package package_) {
        ArrayList<Package> arrayList = new ArrayList<Package>();
        for (String string : package_.getExternalPackageIds()) {
            Package package_2 = xMLInterface.getPackageById(string);
            if (package_2 == null || arrayList.contains(package_2.getId())) continue;
            arrayList.add(package_2);
        }
        return arrayList;
    }

    public static Set getSplitOrJoinActivities(Collection collection, int n) {
        HashSet<Activity> hashSet = new HashSet<Activity>();
        if (collection == null) {
            return hashSet;
        }
        for (Activity activity : collection) {
            int n2 = 0;
            n2 = n == 0 ? XMLUtil.getOutgoingTransitions(activity).size() : XMLUtil.getIncomingTransitions(activity).size();
            if (n2 <= 1) continue;
            hashSet.add(activity);
        }
        return hashSet;
    }

    public static Set getBlockActivities(XMLComplexElement xMLComplexElement, boolean bl) {
        ArrayList arrayList = ((Activities)xMLComplexElement.get("Activities")).toElements();
        HashSet<Activity> hashSet = new HashSet<Activity>();
        for (Activity activity : arrayList) {
            BlockActivity blockActivity = activity.getActivityTypes().getBlockActivity();
            if (blockActivity == null) continue;
            hashSet.add(activity);
            if (!bl) continue;
            String string = blockActivity.getActivitySetId();
            ActivitySet activitySet = XMLUtil.getWorkflowProcess(activity).getActivitySet(string);
            if (activitySet == null) continue;
            hashSet.addAll(XMLUtil.getBlockActivities(activitySet, true));
        }
        return hashSet;
    }

    public static int getConformanceClassNo(String string) {
        if (string.equals("NON_BLOCKED")) {
            return 0;
        }
        if (string.equals("LOOP_BLOCKED")) {
            return 1;
        }
        if (string.equals("FULL_BLOCKED")) {
            return 2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileToString(String string) {
        if (string != null) {
            String string2 = new String();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                int n = fileInputStream.available();
                if (n > 0) {
                    byte[] byArray = new byte[n];
                    fileInputStream.read(byArray);
                    string2 = new String(byArray, "UTF8");
                }
            }
            catch (Exception exception) {
                String string3 = null;
                return string3;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return string2;
        }
        return null;
    }

    public static String getCurrentDateAndTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(new Date());
    }

    public static String replaceBackslashesWithSlashes(String string) {
        if (string != null) {
            int n = -1;
            while ((n = string.indexOf("\\")) != -1) {
                string = string.substring(0, n) + "/" + string.substring(n + 1);
            }
        }
        return string;
    }

    public static String getExtendedAttributesString(ExtendedAttributes extendedAttributes) throws Exception {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        document = documentBuilder.newDocument();
        Element element = document.createElement("EAC");
        XPDLRepositoryHandler xPDLRepositoryHandler = new XPDLRepositoryHandler();
        xPDLRepositoryHandler.toXML((Node)element, extendedAttributes);
        return XMLUtil.getContent(element.getFirstChild(), true);
    }

    public static String getExtendedAttributesString(Node node) {
        String string = node.getPrefix();
        string = string != null ? string + ":" : "";
        Node node2 = XMLUtil.getChildByName(node, string + "ExtendedAttributes");
        return XMLUtil.getContent(node2, true);
    }

    public static Set getStartingActivities(XMLCollectionElement xMLCollectionElement) {
        Activities activities = (Activities)xMLCollectionElement.get("Activities");
        HashSet<Activity> hashSet = new HashSet<Activity>();
        for (Activity activity : activities.toElements()) {
            Transition transition;
            Set set = XMLUtil.getIncomingTransitions(activity);
            if (set.size() == 0) {
                hashSet.add(activity);
                continue;
            }
            if (set.size() != 1 || !(transition = (Transition)set.toArray()[0]).getFrom().equals(transition.getTo())) continue;
            hashSet.add(activity);
        }
        return hashSet;
    }

    public static Set getEndingActivities(XMLCollectionElement xMLCollectionElement) {
        Activities activities = (Activities)xMLCollectionElement.get("Activities");
        HashSet<Activity> hashSet = new HashSet<Activity>();
        for (Activity activity : activities.toElements()) {
            Transition transition;
            Set set = XMLUtil.getNonExceptionalOutgoingTransitions(activity);
            if (set.size() == 0) {
                hashSet.add(activity);
                continue;
            }
            if (set.size() != 1 || !(transition = (Transition)set.toArray()[0]).getFrom().equals(transition.getTo())) continue;
            hashSet.add(activity);
        }
        return hashSet;
    }

    public static List getResponsibles(WorkflowProcess workflowProcess) {
        ArrayList<Responsible> arrayList = new ArrayList<Responsible>();
        RedefinableHeader redefinableHeader = workflowProcess.getRedefinableHeader();
        Responsibles responsibles = redefinableHeader.getResponsibles();
        for (Responsible responsible : responsibles.toElements()) {
            if (arrayList.contains(responsible)) continue;
            arrayList.add(responsible);
        }
        redefinableHeader = XMLUtil.getPackage(workflowProcess).getRedefinableHeader();
        responsibles = redefinableHeader.getResponsibles();
        for (Responsible responsible : responsibles.toElements()) {
            if (arrayList.contains(responsible)) continue;
            arrayList.add(responsible);
        }
        return arrayList;
    }

    public static SequencedHashMap getPossibleParticipants(Package package_, XMLInterface xMLInterface) {
        SequencedHashMap sequencedHashMap = new SequencedHashMap();
        List list = XMLUtil.getAllExternalPackageIds(xMLInterface, package_, new HashSet());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Package package_2 = xMLInterface.getPackageById((String)iterator.next());
            if (package_2 == null) continue;
            for (Participant participant : package_2.getParticipants().toElements()) {
                sequencedHashMap.put(participant.getId(), participant);
            }
        }
        for (Object object : package_.getParticipants().toElements()) {
            sequencedHashMap.put(((XMLCollectionElement)object).getId(), object);
        }
        return sequencedHashMap;
    }

    public static SequencedHashMap getPossibleParticipants(WorkflowProcess workflowProcess, XMLInterface xMLInterface) {
        ArrayList arrayList = workflowProcess.getParticipants().toElements();
        SequencedHashMap sequencedHashMap = XMLUtil.getPossibleParticipants(XMLUtil.getPackage(workflowProcess), xMLInterface);
        for (Participant participant : arrayList) {
            sequencedHashMap.put(participant.getId(), participant);
        }
        return sequencedHashMap;
    }

    public static SequencedHashMap getPossibleApplications(Package package_, XMLInterface xMLInterface) {
        SequencedHashMap sequencedHashMap = new SequencedHashMap();
        List list = XMLUtil.getAllExternalPackageIds(xMLInterface, package_, new HashSet());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Package package_2 = xMLInterface.getPackageById((String)iterator.next());
            if (package_2 == null) continue;
            for (Application application : package_2.getApplications().toElements()) {
                sequencedHashMap.put(application.getId(), application);
            }
        }
        for (Object object : package_.getApplications().toElements()) {
            sequencedHashMap.put(((XMLCollectionElement)object).getId(), object);
        }
        return sequencedHashMap;
    }

    public static SequencedHashMap getPossibleApplications(WorkflowProcess workflowProcess, XMLInterface xMLInterface) {
        ArrayList arrayList = workflowProcess.getApplications().toElements();
        SequencedHashMap sequencedHashMap = XMLUtil.getPossibleApplications(XMLUtil.getPackage(workflowProcess), xMLInterface);
        for (Application application : arrayList) {
            sequencedHashMap.put(application.getId(), application);
        }
        return sequencedHashMap;
    }

    public static SequencedHashMap getPossibleDataFields(XMLComplexElement xMLComplexElement) {
        ArrayList arrayList = ((DataFields)xMLComplexElement.get("DataFields")).toElements();
        SequencedHashMap sequencedHashMap = new SequencedHashMap();
        if (xMLComplexElement instanceof WorkflowProcess) {
            sequencedHashMap.putAll((Map)XMLUtil.getPossibleDataFields(XMLUtil.getPackage(xMLComplexElement)));
        }
        for (DataField dataField : arrayList) {
            sequencedHashMap.put(dataField.getId(), dataField);
        }
        return sequencedHashMap;
    }

    public static SequencedHashMap getPossibleVariables(XMLElement xMLElement) {
        SequencedHashMap sequencedHashMap = null;
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess(xMLElement);
        if (workflowProcess != null) {
            sequencedHashMap = XMLUtil.getPossibleDataFields(workflowProcess);
            for (FormalParameter formalParameter : workflowProcess.getFormalParameters().toElements()) {
                if (sequencedHashMap.containsKey(formalParameter.getId())) continue;
                sequencedHashMap.put(formalParameter.getId(), formalParameter);
            }
        } else {
            sequencedHashMap = XMLUtil.getPossibleDataFields(XMLUtil.getPackage(xMLElement));
        }
        return sequencedHashMap;
    }

    public static SequencedHashMap getPossibleSubflowProcesses(SubFlow subFlow, XMLInterface xMLInterface) {
        SequencedHashMap sequencedHashMap = new SequencedHashMap();
        List list = XMLUtil.getAllExternalPackageIds(xMLInterface, XMLUtil.getPackage(subFlow), new HashSet());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Package package_ = xMLInterface.getPackageById((String)iterator.next());
            if (package_ == null) continue;
            for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
                sequencedHashMap.put(workflowProcess.getId(), workflowProcess);
            }
        }
        for (Object object : ((WorkflowProcesses)XMLUtil.getParentElement(WorkflowProcesses.class, subFlow)).toElements()) {
            sequencedHashMap.put(((XMLCollectionElement)object).getId(), object);
        }
        return sequencedHashMap;
    }

    public static SequencedHashMap getPossibleTypeDeclarations(Package package_, XMLInterface xMLInterface) {
        SequencedHashMap sequencedHashMap = new SequencedHashMap();
        List list = XMLUtil.getAllExternalPackageIds(xMLInterface, package_, new HashSet());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Package package_2 = xMLInterface.getPackageById((String)iterator.next());
            if (package_2 == null) continue;
            for (TypeDeclaration typeDeclaration : package_2.getTypeDeclarations().toElements()) {
                sequencedHashMap.put(typeDeclaration.getId(), typeDeclaration);
            }
        }
        for (Object object : package_.getTypeDeclarations().toElements()) {
            sequencedHashMap.put(((XMLCollectionElement)object).getId(), object);
        }
        return sequencedHashMap;
    }

    public static boolean isANDTypeSplitOrJoin(Activity activity, int n) {
        String string = "Exclusive";
        if (n == 0) {
            Split split = XMLUtil.getSplit(activity);
            if (split != null) {
                string = split.getType();
            }
        } else {
            Join join = XMLUtil.getJoin(activity);
            if (join != null) {
                string = join.getType();
            }
        }
        return string.equals("Parallel");
    }

    public static boolean isSubflowSynchronous(Activity activity) {
        String string = "SYNCHR";
        SubFlow subFlow = activity.getActivityTypes().getImplementation().getImplementationTypes().getSubFlow();
        string = subFlow.getExecution();
        return !string.equals("ASYNCHR");
    }

    public static int getStartMode(Activity activity) {
        int n = 0;
        String string = activity.getStartMode();
        if ("Manual".equals(string)) {
            n = 1;
        }
        return n;
    }

    public static int getFinishMode(Activity activity) {
        int n = 0;
        String string = activity.getFinishMode();
        if ("Manual".equals(string)) {
            n = 1;
        }
        return n;
    }

    public static int removeXMLElementFromList(List list, XMLElement xMLElement) {
        int n = XMLUtil.indexOfXMLElementWithinList(list, xMLElement);
        if (n != -1) {
            list.remove(n);
        }
        return n;
    }

    public static int indexOfXMLElementWithinList(List list, XMLElement xMLElement) {
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e != xMLElement) continue;
            n = i;
            break;
        }
        return n;
    }

    public static OutputStream packageToStream(Package package_, OutputStream outputStream) {
        try {
            Document document = null;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            XPDLRepositoryHandler xPDLRepositoryHandler = new XPDLRepositoryHandler();
            xPDLRepositoryHandler.toXML(document, package_);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.transform(dOMSource, streamResult);
            return outputStream;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static List getOrderedOutgoingTransitions(Activity activity, Set set) {
        XMLComplexElement xMLComplexElement2;
        HashSet hashSet = new HashSet(set);
        ArrayList<Transition> arrayList = new ArrayList<Transition>();
        HashMap<String, XMLComplexElement> hashMap = new HashMap<String, XMLComplexElement>();
        for (XMLComplexElement xMLComplexElement2 : set) {
            hashMap.put(((XMLCollectionElement)xMLComplexElement2).getId(), xMLComplexElement2);
        }
        xMLComplexElement2 = XMLUtil.getSplit(activity);
        if (xMLComplexElement2 != null) {
            TransitionRefs transitionRefs = ((Split)xMLComplexElement2).getTransitionRefs();
            for (TransitionRef transitionRef : transitionRefs.toElements()) {
                Transition transition = (Transition)hashMap.get(transitionRef.getId());
                if (transition == null) continue;
                arrayList.add(transition);
                hashSet.remove(transition);
            }
        }
        arrayList.addAll(hashSet);
        return arrayList;
    }

    public static String createPath(String string, String string2) {
        string = XMLUtil.convertToSystemPath(string);
        string2 = XMLUtil.convertToSystemPath(string2);
        return string + File.separator + string2;
    }

    public static String convertToSystemPath(String string) {
        char c = File.separatorChar;
        char c2 = c == '\\' ? (char)'/' : '\\';
        String string2 = string.replace(c2, c);
        return string2;
    }

    public static void main(String[] stringArray) throws Throwable {
        if (ShowLicense.showLicense(stringArray)) {
            return;
        }
        if ("convert".equals(stringArray[0])) {
            XMLUtil.testConvert(stringArray[1], true);
            return;
        }
        if ("create".equals(stringArray[0])) {
            XMLUtil.testCreate(stringArray[1]);
            return;
        }
        long l = System.currentTimeMillis();
        boolean bl = false;
        bl = new Boolean(stringArray[0]);
        XMLElementChangeListener xMLElementChangeListener = new XMLElementChangeListener(){

            @Override
            public void xmlElementChanged(XMLElementChangeInfo xMLElementChangeInfo) {
                System.out.println(xMLElementChangeInfo.toString());
            }
        };
        Package package_ = null;
        String string = null;
        Package package_2 = null;
        XMLInterfaceImpl xMLInterfaceImpl = new XMLInterfaceImpl();
        for (int i = 1; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (i == 1) {
                string = string2;
            }
            System.out.println("Handling file " + string2);
            long l2 = System.currentTimeMillis();
            package_2 = XMLUtil.readFromFile(xMLInterfaceImpl, string2, bl);
            if (i == 1) {
                package_ = package_2;
            }
            package_2.addListener(xMLElementChangeListener);
            System.out.println("PKGL1=" + package_2.getListeners());
            Package package_3 = package_2;
            StandardPackageValidator standardPackageValidator = new StandardPackageValidator();
            standardPackageValidator.init(new Properties(), xMLInterfaceImpl);
            System.out.println("VALIDATING ...");
            ArrayList arrayList = new ArrayList();
            standardPackageValidator.validateElement(package_2, arrayList, true);
            System.out.println("VALID=" + (arrayList.size() == 0));
            if (arrayList.size() > 0) {
                System.out.println("VERRS=" + arrayList);
            }
            long l3 = System.currentTimeMillis();
            XMLUtil.writeToFile(string2 + "r", package_2);
            long l4 = System.currentTimeMillis();
            package_2 = XMLUtil.clonePackage(xMLInterfaceImpl, package_2);
            System.out.println("PKGL2=" + package_2.getListeners());
            Package package_4 = package_2;
            long l5 = System.currentTimeMillis();
            XMLUtil.writeToFile(string2 + "rr", package_2);
            long l6 = System.currentTimeMillis();
            package_2 = XMLUtil.clonePackageBySerialization(package_2);
            System.out.println("PKGL3=" + package_2.getListeners());
            System.out.println("P1=P2=" + package_3.equals(package_4) + ", P2=P3=" + package_4.equals(package_2));
            long l7 = System.currentTimeMillis();
            XMLUtil.writeToFile(string2 + "rrr", package_2);
            long l8 = System.currentTimeMillis();
            System.out.println("TOverall   =" + (l7 - l2));
            System.out.println("TOpenPKG   " + (l3 - l2));
            System.out.println("TSavePKG1  =" + (l4 - l3));
            System.out.println("TClonePkg1 =" + (l5 - l4));
            System.out.println("TSavePKG2  =" + (l6 - l4));
            System.out.println("TClonePkg2 =" + (l7 - l6));
            System.out.println("TSavePKG4  =" + (l8 - l7));
        }
        if (!package_.equals(package_2)) {
            XMLUtil.writeToFile(string + "testma", package_2);
        }
        long l9 = System.currentTimeMillis();
        System.out.println("Handling of " + (stringArray.length - 1) + " XPDLs lasted " + (l9 - l) / 1000L + " sec");
    }

    public static void testConvert(String string, boolean bl) throws Exception {
        XMLElementChangeListener xMLElementChangeListener = new XMLElementChangeListener(){

            @Override
            public void xmlElementChanged(XMLElementChangeInfo xMLElementChangeInfo) {
                System.out.println(xMLElementChangeInfo.toString());
            }
        };
        XMLInterfaceImpl xMLInterfaceImpl = new XMLInterfaceImpl();
        File file = new File(string);
        string = file.getCanonicalPath();
        System.out.println("Converting XPDL model from file \"" + string + "\".\n");
        System.out.println("...reading file and creating XPDL model");
        Package package_ = XMLUtil.readFromFile(xMLInterfaceImpl, string, bl);
        package_.addListener(xMLElementChangeListener);
        StandardPackageValidator standardPackageValidator = new StandardPackageValidator();
        standardPackageValidator.init(new Properties(), xMLInterfaceImpl);
        System.out.println("...validating XPDL");
        ArrayList arrayList = new ArrayList();
        standardPackageValidator.validateElement(package_, arrayList, true);
        if (arrayList.size() > 0) {
            if (standardPackageValidator.hasErrors(arrayList)) {
                System.out.println("...XPDL is NOT valid");
                System.out.println("...errors=" + arrayList);
            } else {
                System.out.println("...XPDL is valid ");
                System.out.println("...There are following warnings:" + arrayList);
            }
        } else {
            System.out.println("...XPDL is valid");
        }
        int n = string.lastIndexOf(".");
        String string2 = null;
        string2 = n >= 0 ? string.substring(0, n) + "-out" + string.substring(n) : string + "-out";
        System.out.println("\nWritting converted XPDL model into file \"" + string2 + "\".");
        XMLUtil.writeToFile(string2, package_);
    }

    public static void testCreate(String string) throws Exception {
        if (!string.endsWith(".xpdl")) {
            string = string + ".xpdl";
        }
        File file = new File(string);
        string = file.getCanonicalPath();
        String string2 = file.getName().substring(0, file.getName().lastIndexOf("."));
        System.out.println("Creating XPDL Model.\n");
        String string3 = string2;
        if (!XMLUtil.isIdValid(string3)) {
            string3 = "test";
        }
        System.out.println("...creating Package [Id=" + string3 + ",Name=" + string2 + ",Script-type=text/javascript]");
        Package package_ = new Package();
        package_.setId(string3);
        package_.setName(string2);
        package_.getPackageHeader().setXPDLVersion("2.1");
        package_.getPackageHeader().setVendor("(c) Together Teamsolutions Co., Ltd.");
        package_.getPackageHeader().setCreated(XMLUtil.getCurrentDateAndTime());
        package_.getScript().setType("text/javascript");
        System.out.println("......creating Participant[Id=manager,Name=Manager,Type=ROLE]");
        Participant participant = (Participant)package_.getParticipants().generateNewElement();
        participant.setId("manager");
        participant.setName("Manager");
        participant.getParticipantType().setTypeROLE();
        System.out.println("......creating Participant[Id=programmer,Name=Programmer,Type=ROLE]");
        Participant participant2 = (Participant)package_.getParticipants().generateNewElement();
        participant2.setId("programmer");
        participant2.setName("Programmer");
        participant2.getParticipantType().setTypeROLE();
        System.out.println("......creating Participant[Id=secretary,Name=Secretary,Type=ROLE]");
        Participant participant3 = (Participant)package_.getParticipants().generateNewElement();
        participant3.setId("secretary");
        participant3.setName("Secretary");
        participant3.getParticipantType().setTypeROLE();
        System.out.println("......creating Pool [Id=" + string3 + ",Name=" + string2 + ",Process=" + string3 + "]");
        Pool pool = (Pool)package_.getPools().generateNewElement();
        pool.setId(string3);
        pool.setName(string2);
        pool.setProcess(string3);
        System.out.println(".........creating Lane[Id=lane1,Name=Manager]");
        Lane lane = (Lane)pool.getLanes().generateNewElement();
        lane.setId("lane1");
        lane.setName("Manager");
        System.out.println("............creating Performer[manager]");
        Performer performer = (Performer)lane.getPerformers().generateNewElement();
        performer.setValue("manager");
        lane.getPerformers().add(performer);
        System.out.println(".........creating Lane[Id=lane2,Name=Programmer]");
        Lane lane2 = (Lane)pool.getLanes().generateNewElement();
        lane2.setId("lane2");
        lane2.setName("Programmer");
        System.out.println("............creating Performer[programmer]");
        Performer performer2 = (Performer)lane2.getPerformers().generateNewElement();
        performer2.setValue("programmer");
        lane2.getPerformers().add(performer2);
        System.out.println(".........creating Lane[Id=lane3,Name=Secretary]");
        Lane lane3 = (Lane)pool.getLanes().generateNewElement();
        lane3.setId("lane3");
        lane3.setName("Secretary");
        System.out.println("............creating Performer[secretary]");
        Performer performer3 = (Performer)lane3.getPerformers().generateNewElement();
        performer3.setValue("secretary");
        lane3.getPerformers().add(performer3);
        pool.getLanes().add(lane);
        pool.getLanes().add(lane2);
        pool.getLanes().add(lane3);
        System.out.println("......creating Artifact [Id=comment, Name=Second activity comment, Type=Annotation, TextAnnotation=This is a comment for 2nd activity]");
        Artifact artifact = (Artifact)package_.getArtifacts().generateNewElement();
        artifact.setId("comment");
        artifact.setName("Second activity comment");
        artifact.setArtifactTypeAnnotation();
        artifact.setTextAnnotation("This is a comment for 2nd activity");
        NodeGraphicsInfo nodeGraphicsInfo = (NodeGraphicsInfo)artifact.getNodeGraphicsInfos().generateNewElement();
        System.out.println(".........creating NodeGraphicsInfo[LaneId=lane2,Coordinates=50,50]");
        nodeGraphicsInfo.setLaneId("lane2");
        nodeGraphicsInfo.setWidth(95);
        nodeGraphicsInfo.setHeight(40);
        nodeGraphicsInfo.getCoordinates().setXCoordinate("50");
        nodeGraphicsInfo.getCoordinates().setYCoordinate("60");
        artifact.getNodeGraphicsInfos().add(nodeGraphicsInfo);
        package_.getArtifacts().add(artifact);
        System.out.println("......creating WorkflowProcess [Id=" + string3 + ",Name=" + string2 + "]");
        WorkflowProcess workflowProcess = (WorkflowProcess)package_.getWorkflowProcesses().generateNewElement();
        workflowProcess.setId(string3);
        workflowProcess.setName(string2);
        System.out.println(".........creating DataField[Id=decision,Name=Decision,Type=Basic-BOOLEAN]");
        DataField dataField = (DataField)workflowProcess.getDataFields().generateNewElement();
        dataField.setId("decision");
        dataField.setName("Decision");
        dataField.getDataType().getDataTypes().getBasicType().setTypeBOOLEAN();
        workflowProcess.getDataFields().add(dataField);
        System.out.println(".........creating Activity[Id=act1,Name=First,Type=NO]");
        Activity activity = (Activity)workflowProcess.getActivities().generateNewElement();
        activity.setId("act1");
        activity.setName("First");
        activity.getActivityTypes().setImplementation();
        activity.getActivityTypes().getImplementation().getImplementationTypes().setNo();
        activity.setFirstPerformer("manager");
        System.out.println("............creating NodeGraphicsInfo[LaneId=lane1,Coordinates=50,50]");
        NodeGraphicsInfo nodeGraphicsInfo2 = (NodeGraphicsInfo)activity.getNodeGraphicsInfos().generateNewElement();
        nodeGraphicsInfo2.setLaneId("lane1");
        nodeGraphicsInfo2.setWidth(90);
        nodeGraphicsInfo2.setHeight(60);
        nodeGraphicsInfo2.getCoordinates().setXCoordinate("50");
        nodeGraphicsInfo2.getCoordinates().setYCoordinate("50");
        activity.getNodeGraphicsInfos().add(nodeGraphicsInfo2);
        System.out.println(".........creating Activity[Id=actd,Name=Decision,Type=Route,Split-type=Exclusive]");
        Activity activity2 = (Activity)workflowProcess.getActivities().generateNewElement();
        activity2.setId("actd");
        activity2.setName("Decision");
        activity2.getActivityTypes().setRoute();
        System.out.println("............creating TransitionRestriction");
        TransitionRestriction transitionRestriction = (TransitionRestriction)activity.getTransitionRestrictions().generateNewElement();
        System.out.println("...............creating TransitionRef[Id=tra2]");
        TransitionRef transitionRef = (TransitionRef)transitionRestriction.getSplit().getTransitionRefs().generateNewElement();
        transitionRef.setId("tra2");
        System.out.println("...............creating TransitionRef[Id=tra3]");
        TransitionRef transitionRef2 = (TransitionRef)transitionRestriction.getSplit().getTransitionRefs().generateNewElement();
        transitionRef2.setId("tra3");
        transitionRestriction.getSplit().getTransitionRefs().add(transitionRef);
        transitionRestriction.getSplit().getTransitionRefs().add(transitionRef2);
        transitionRestriction.getSplit().setTypeExclusive();
        activity2.getTransitionRestrictions().add(transitionRestriction);
        System.out.println("............creating NodeGraphicsInfo[LaneId=lane1,Coordinates=200,60]");
        NodeGraphicsInfo nodeGraphicsInfo3 = (NodeGraphicsInfo)activity2.getNodeGraphicsInfos().generateNewElement();
        nodeGraphicsInfo3.setLaneId("lane1");
        nodeGraphicsInfo3.setWidth(40);
        nodeGraphicsInfo3.setHeight(40);
        nodeGraphicsInfo3.getCoordinates().setXCoordinate("200");
        nodeGraphicsInfo3.getCoordinates().setYCoordinate("60");
        activity2.getNodeGraphicsInfos().add(nodeGraphicsInfo3);
        System.out.println(".........creating Activity[Id=act2,Name=Second,Type=NO]");
        Activity activity3 = (Activity)workflowProcess.getActivities().generateNewElement();
        activity3.setId("act2");
        activity3.setName("Second");
        activity3.getActivityTypes().setImplementation();
        activity3.getActivityTypes().getImplementation().getImplementationTypes().setNo();
        activity3.setFirstPerformer("programmer");
        System.out.println("............creating NodeGraphicsInfo[LaneId=lane2,Coordinates=350,50]");
        NodeGraphicsInfo nodeGraphicsInfo4 = (NodeGraphicsInfo)activity3.getNodeGraphicsInfos().generateNewElement();
        nodeGraphicsInfo4.setLaneId("lane2");
        nodeGraphicsInfo4.setWidth(90);
        nodeGraphicsInfo4.setHeight(60);
        nodeGraphicsInfo4.getCoordinates().setXCoordinate("350");
        nodeGraphicsInfo4.getCoordinates().setYCoordinate("50");
        activity3.getNodeGraphicsInfos().add(nodeGraphicsInfo4);
        System.out.println(".........creating Activity[Id=act3,Name=Third,Type=NO]");
        Activity activity4 = (Activity)workflowProcess.getActivities().generateNewElement();
        activity4.setId("act3");
        activity4.setName("Third");
        activity4.getActivityTypes().setImplementation();
        activity4.getActivityTypes().getImplementation().getImplementationTypes().setNo();
        activity4.setFirstPerformer("secretary");
        System.out.println("............creating NodeGraphicsInfo[LaneId=lane3,Coordinates=350,50]");
        NodeGraphicsInfo nodeGraphicsInfo5 = (NodeGraphicsInfo)activity4.getNodeGraphicsInfos().generateNewElement();
        nodeGraphicsInfo5.setLaneId("lane3");
        nodeGraphicsInfo5.setWidth(90);
        nodeGraphicsInfo5.setHeight(60);
        nodeGraphicsInfo5.getCoordinates().setXCoordinate("350");
        nodeGraphicsInfo5.getCoordinates().setYCoordinate("50");
        activity4.getNodeGraphicsInfos().add(nodeGraphicsInfo5);
        System.out.println(".........creating Transition[Id=tra1,From=act1,To=actd,Type=]");
        Transition transition = (Transition)workflowProcess.getTransitions().generateNewElement();
        transition.setId("tra1");
        transition.setFrom("act1");
        transition.setTo("actd");
        transition.getCondition().setTypeNONE();
        System.out.println(".........creating Transition[Id=tra2,From=actd,To=act2,Type=CONDITION,Condition=decision]");
        Transition transition2 = (Transition)workflowProcess.getTransitions().generateNewElement();
        transition2.setId("tra2");
        transition2.setFrom("actd");
        transition2.setTo("act2");
        transition2.getCondition().setTypeCONDITION();
        transition2.getCondition().setValue("decision");
        System.out.println(".........creating Transition[Id=tra3,From=actd,To=act3,Type=OTHERWISE]");
        Transition transition3 = (Transition)workflowProcess.getTransitions().generateNewElement();
        transition3.setId("tra3");
        transition3.setFrom("actd");
        transition3.setTo("act3");
        transition3.getCondition().setTypeOTHERWISE();
        workflowProcess.getActivities().add(activity);
        workflowProcess.getActivities().add(activity2);
        workflowProcess.getActivities().add(activity3);
        workflowProcess.getActivities().add(activity4);
        workflowProcess.getTransitions().add(transition);
        workflowProcess.getTransitions().add(transition2);
        workflowProcess.getTransitions().add(transition3);
        System.out.println("......creating Association [Id=c2a, Name=Connection1, Source=comment, Target=act2, Direction=None]");
        Association association = (Association)package_.getAssociations().generateNewElement();
        association.setId("c2a");
        association.setName("Connection1");
        association.setSource("comment");
        association.setTarget("act2");
        association.setAssociationDirectionNONE();
        package_.getAssociations().add(association);
        package_.getWorkflowProcesses().add(workflowProcess);
        package_.getPools().add(pool);
        package_.getParticipants().add(participant);
        package_.getParticipants().add(participant2);
        package_.getParticipants().add(participant3);
        XMLUtil.writeToFile(string, package_);
        System.out.println("\nWritting XPDL model into file \"" + string + "\".");
    }

    public static Package readFromFile(XMLInterface xMLInterface, String string, boolean bl) throws Exception {
        return xMLInterface.openPackage(string, bl);
    }

    public static void writeToFile(String string, Package package_) throws Exception {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        document = documentBuilder.newDocument();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        XPDLRepositoryHandler xPDLRepositoryHandler = new XPDLRepositoryHandler();
        xPDLRepositoryHandler.setXPDLPrefixEnabled(true);
        xPDLRepositoryHandler.toXML(document, package_);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("encoding", "UTF8");
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(fileOutputStream);
        transformer.transform(dOMSource, streamResult);
        fileOutputStream.close();
    }

    public static Package clonePackage(XMLInterface xMLInterface, Package package_) throws Exception {
        Package package_2 = (Package)package_.clone();
        if (package_2.isReadOnly()) {
            package_2.initCaches(xMLInterface);
        }
        return package_2;
    }

    public static Package clonePackageBySerialization(Package package_) throws Exception {
        byte[] byArray = XMLUtil.serialize(package_);
        Package package_2 = (Package)XMLUtil.deserialize(byArray);
        return package_2;
    }

    public static byte[] serialize(Object object) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        objectOutputStream.close();
        byteArrayOutputStream.close();
        return byArray;
    }

    public static Object deserialize(byte[] byArray) throws Exception {
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        return object;
    }

    public static String[] tokenize(String string, String string2) {
        if (string == null) {
            string = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String generateUniqueId(XMLCollection xMLCollection, Set set) {
        String string;
        long l = 0L;
        String string2 = XMLUtil.getPackage(xMLCollection).getId() + "_";
        if (XMLUtil.getWorkflowProcess(xMLCollection) != null) {
            string2 = XMLUtil.getWorkflowProcess(xMLCollection).getId() + "_";
        } else if (XMLUtil.getPool(xMLCollection) != null) {
            string2 = XMLUtil.getPool(xMLCollection).getId() + "_";
        }
        if (xMLCollection instanceof Activities) {
            string2 = string2 + "act";
        } else if (xMLCollection instanceof ActivitySets) {
            string2 = string2 + "ase";
        } else if (xMLCollection instanceof Applications) {
            string2 = string2 + "app";
        } else if (xMLCollection instanceof Artifacts) {
            string2 = string2 + "art";
        } else if (xMLCollection instanceof Associations) {
            string2 = string2 + "ass";
        } else if (xMLCollection instanceof DataFields) {
            string2 = string2 + "df";
        } else if (xMLCollection instanceof FormalParameters) {
            string2 = string2 + "fp";
        } else if (xMLCollection instanceof Lanes) {
            string2 = string2 + "lan";
        } else if (xMLCollection instanceof Participants) {
            string2 = string2 + "par";
        } else if (xMLCollection instanceof Pools) {
            string2 = string2 + "pool";
        } else if (xMLCollection instanceof Transitions) {
            string2 = string2 + "tra";
        } else if (xMLCollection instanceof TypeDeclarations) {
            string2 = string2 + "td";
        } else if (xMLCollection instanceof WorkflowProcesses) {
            string2 = XMLUtil.getPackage(xMLCollection).getId() + "_wp";
        }
        XMLCollectionElement xMLCollectionElement = (XMLCollectionElement)xMLCollection.generateNewElement();
        while (set.contains(string = string2 + new Long(++l).toString()) || !XMLUtil.isIdUnique(xMLCollectionElement, string)) {
        }
        return string;
    }

    public static String generateSimilarOrIdenticalUniqueId(XMLCollection xMLCollection, Set set, String string) {
        String string2 = string;
        long l = 0L;
        XMLCollectionElement xMLCollectionElement = (XMLCollectionElement)xMLCollection.generateNewElement();
        while (string2.equals("") || set.contains(string2) || !XMLUtil.isIdUnique(xMLCollectionElement, string2)) {
            string2 = string + new Long(++l).toString();
        }
        return string2;
    }

    public static boolean isIdUnique(XMLCollectionElement xMLCollectionElement, String string) {
        XMLElement xMLElement = xMLCollectionElement.getParent();
        if (xMLCollectionElement instanceof Tool) {
            return true;
        }
        if (xMLCollectionElement instanceof Activity) {
            return XMLUtil.checkActivityId((Activity)xMLCollectionElement, string);
        }
        if (xMLCollectionElement instanceof Artifact) {
            return XMLUtil.checkArtifactId((Artifact)xMLCollectionElement, string);
        }
        if (xMLCollectionElement instanceof Transition) {
            return XMLUtil.checkTransitionId((Transition)xMLCollectionElement, string);
        }
        if (xMLCollectionElement instanceof ActivitySet) {
            return XMLUtil.checkActivitySetId((ActivitySet)xMLCollectionElement, string);
        }
        if (xMLCollectionElement instanceof Lane) {
            return XMLUtil.checkLaneId((Lane)xMLCollectionElement, string);
        }
        if (xMLElement instanceof XMLCollection) {
            List list = XMLUtil.getElementsForId((XMLCollection)xMLElement, string);
            return list.size() == 0 || list.size() == 1 && list.contains(xMLCollectionElement);
        }
        return true;
    }

    public static boolean checkActivityId(Activity activity, String string) {
        return XMLUtil.checkActivityOrArtifactId(activity, string);
    }

    public static boolean checkArtifactId(Artifact artifact, String string) {
        return XMLUtil.checkActivityOrArtifactId(artifact, string);
    }

    protected static boolean checkActivityOrArtifactId(XMLCollectionElement xMLCollectionElement, String string) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(XMLUtil.getElementsForId(XMLUtil.getPackage(xMLCollectionElement).getArtifacts(), string));
        for (WorkflowProcess workflowProcess : XMLUtil.getPackage(xMLCollectionElement).getWorkflowProcesses().toElements()) {
            arrayList.addAll(XMLUtil.getElementsForId(workflowProcess.getActivities(), string));
            ActivitySets activitySets = workflowProcess.getActivitySets();
            for (int i = 0; i < activitySets.size(); ++i) {
                ActivitySet activitySet = (ActivitySet)activitySets.get(i);
                arrayList.addAll(XMLUtil.getElementsForId(activitySet.getActivities(), string));
            }
        }
        return arrayList.size() == 0 || arrayList.size() == 1 && arrayList.contains(xMLCollectionElement);
    }

    public static boolean checkTransitionId(Transition transition, String string) {
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess(transition);
        List list = XMLUtil.getElementsForId(workflowProcess.getTransitions(), string);
        ActivitySets activitySets = workflowProcess.getActivitySets();
        for (int i = 0; i < activitySets.size(); ++i) {
            ActivitySet activitySet = (ActivitySet)activitySets.get(i);
            list.addAll(XMLUtil.getElementsForId(activitySet.getTransitions(), string));
        }
        return list.size() == 0 || list.size() == 1 && list.contains(transition);
    }

    public static boolean checkActivitySetId(ActivitySet activitySet, String string) {
        WorkflowProcesses workflowProcesses = XMLUtil.getPackage(activitySet).getWorkflowProcesses();
        Iterator iterator = workflowProcesses.toElements().iterator();
        List list = XMLUtil.getElementsForId(workflowProcesses, string);
        while (iterator.hasNext()) {
            WorkflowProcess workflowProcess = (WorkflowProcess)iterator.next();
            list.addAll(XMLUtil.getElementsForId(workflowProcess.getActivitySets(), string));
        }
        return list.size() == 0 || list.size() == 1 && list.contains(activitySet);
    }

    public static boolean checkLaneId(Lane lane, String string) {
        Iterator iterator = XMLUtil.getPackage(lane).getPools().toElements().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Pool pool = (Pool)iterator.next();
            arrayList.addAll(XMLUtil.getElementsForId(pool.getLanes(), string));
        }
        return arrayList.size() == 0 || arrayList.size() == 1 && arrayList.contains(lane);
    }

    public static List getElementsForId(XMLCollection xMLCollection, String string) {
        ArrayList<XMLCollectionElement> arrayList = new ArrayList<XMLCollectionElement>();
        Iterator iterator = xMLCollection.toElements().iterator();
        if (xMLCollection.generateNewElement() instanceof XMLCollectionElement) {
            while (iterator.hasNext()) {
                XMLCollectionElement xMLCollectionElement = (XMLCollectionElement)iterator.next();
                if (!xMLCollectionElement.getId().equals(string)) continue;
                arrayList.add(xMLCollectionElement);
            }
        }
        return arrayList;
    }

    public static boolean hasCircularTransitions(Set set) {
        for (Transition transition : set) {
            if (!transition.getFrom().equals(transition.getTo())) continue;
            return true;
        }
        return false;
    }

    public static boolean isStartingActivity(Activity activity) {
        Set set = XMLUtil.getIncomingTransitions(activity);
        return set.size() == 0 || set.size() == 1 && XMLUtil.hasCircularTransitions(set);
    }

    public static boolean isEndingActivity(Activity activity) {
        Set set = XMLUtil.getNonExceptionalOutgoingTransitions(activity);
        return set.size() == 0 || set.size() == 1 && XMLUtil.hasCircularTransitions(set);
    }

    public static List getReferences(XMLComplexElement xMLComplexElement, XMLComplexElement xMLComplexElement2, XMLInterface xMLInterface) {
        if (xMLComplexElement instanceof Package) {
            return XMLUtil.getReferences((Package)xMLComplexElement, xMLComplexElement2, xMLInterface);
        }
        if (xMLComplexElement instanceof WorkflowProcess) {
            return XMLUtil.getReferences((WorkflowProcess)xMLComplexElement, xMLComplexElement2);
        }
        return new ArrayList();
    }

    public static List getReferences(Package package_, XMLComplexElement xMLComplexElement, XMLInterface xMLInterface) {
        if (xMLComplexElement instanceof Package) {
            return XMLUtil.getReferences((Package)xMLComplexElement, xMLInterface);
        }
        if (xMLComplexElement instanceof TypeDeclaration) {
            return XMLUtil.getReferences(package_, (TypeDeclaration)xMLComplexElement);
        }
        if (xMLComplexElement instanceof Participant) {
            return XMLUtil.getReferences(package_, (Participant)xMLComplexElement);
        }
        if (xMLComplexElement instanceof Application) {
            return XMLUtil.getReferences(package_, (Application)xMLComplexElement);
        }
        if (xMLComplexElement instanceof DataField) {
            return XMLUtil.getReferences(package_, (DataField)xMLComplexElement);
        }
        if (xMLComplexElement instanceof WorkflowProcess) {
            return XMLUtil.getReferences(package_, (WorkflowProcess)xMLComplexElement);
        }
        if (xMLComplexElement instanceof Lane) {
            return XMLUtil.getReferences(package_, (Lane)xMLComplexElement);
        }
        return new ArrayList();
    }

    public static List getReferences(WorkflowProcess workflowProcess, XMLComplexElement xMLComplexElement) {
        if (xMLComplexElement instanceof Participant) {
            return XMLUtil.getReferences(workflowProcess, (Participant)xMLComplexElement);
        }
        if (xMLComplexElement instanceof Application) {
            return XMLUtil.getReferences(workflowProcess, (Application)xMLComplexElement);
        }
        if (xMLComplexElement instanceof DataField) {
            return XMLUtil.getReferences(workflowProcess, (DataField)xMLComplexElement);
        }
        if (xMLComplexElement instanceof WorkflowProcess) {
            return XMLUtil.getReferences(workflowProcess, (WorkflowProcess)xMLComplexElement);
        }
        if (xMLComplexElement instanceof FormalParameter) {
            return XMLUtil.getReferences(workflowProcess, (FormalParameter)xMLComplexElement);
        }
        if (xMLComplexElement instanceof ActivitySet) {
            return XMLUtil.getReferences(workflowProcess, (ActivitySet)xMLComplexElement);
        }
        if (xMLComplexElement instanceof Lane) {
            return XMLUtil.getReferences(workflowProcess, (Lane)xMLComplexElement);
        }
        return new ArrayList();
    }

    public static List getReferences(Package package_, XMLInterface xMLInterface) {
        ArrayList<Package> arrayList = new ArrayList<Package>();
        String string = package_.getId();
        for (Package package_2 : xMLInterface.getAllPackages()) {
            if (!package_2.getExternalPackageIds().contains(string)) continue;
            arrayList.add(package_2);
        }
        return arrayList;
    }

    public static List getAllExternalPackageReferences(Package package_, Package package_2) {
        ArrayList arrayList = new ArrayList();
        if (package_2 != null) {
            for (XMLCollectionElement xMLCollectionElement : package_2.getApplications().toElements()) {
                arrayList.addAll(XMLUtil.getReferences(package_, xMLCollectionElement));
            }
            for (XMLCollectionElement xMLCollectionElement : package_2.getParticipants().toElements()) {
                arrayList.addAll(XMLUtil.getReferences(package_, (Participant)xMLCollectionElement));
            }
            for (XMLCollectionElement xMLCollectionElement : package_2.getWorkflowProcesses().toElements()) {
                arrayList.addAll(XMLUtil.getReferences(package_, (WorkflowProcess)xMLCollectionElement));
            }
            for (XMLCollectionElement xMLCollectionElement : package_2.getTypeDeclarations().toElements()) {
                arrayList.addAll(XMLUtil.getReferences(package_, (TypeDeclaration)xMLCollectionElement));
            }
        }
        return arrayList;
    }

    public static List getReferences(Package package_, TypeDeclaration typeDeclaration) {
        return XMLUtil.getTypeDeclarationReferences(package_, typeDeclaration.getId());
    }

    public static List getReferences(WorkflowProcess workflowProcess, TypeDeclaration typeDeclaration) {
        return XMLUtil.tGetTypeDeclarationReferences(workflowProcess, typeDeclaration.getId());
    }

    public static List getReferences(TypeDeclaration typeDeclaration, TypeDeclaration typeDeclaration2) {
        if (typeDeclaration.getId().equals(typeDeclaration2.getId())) {
            return new ArrayList();
        }
        return XMLUtil.getReferencingDeclaredTypes(typeDeclaration.getDataTypes(), typeDeclaration2.getId());
    }

    public static List getTypeDeclarationReferences(Package package_, String string) {
        ArrayList arrayList = new ArrayList();
        if (string.equals("")) {
            return arrayList;
        }
        for (XMLCollectionElement xMLCollectionElement : package_.getTypeDeclarations().toElements()) {
            if (xMLCollectionElement.getId().equals(string)) continue;
            arrayList.addAll(XMLUtil.getReferencingDeclaredTypes(xMLCollectionElement.getDataTypes(), string));
        }
        arrayList.addAll(XMLUtil.tGetTypeDeclarationReferences(package_, string));
        for (XMLCollectionElement xMLCollectionElement : package_.getWorkflowProcesses().toElements()) {
            arrayList.addAll(XMLUtil.tGetTypeDeclarationReferences(xMLCollectionElement, string));
        }
        return arrayList;
    }

    protected static List tGetTypeDeclarationReferences(XMLComplexElement xMLComplexElement, String string) {
        ArrayList arrayList = new ArrayList();
        if (string.equals("")) {
            return arrayList;
        }
        for (XMLCollectionElement xMLCollectionElement : ((Applications)xMLComplexElement.get("Applications")).toElements()) {
            for (Object e : ((Application)xMLCollectionElement).getApplicationTypes().getFormalParameters().toElements()) {
                FormalParameter formalParameter = (FormalParameter)e;
                arrayList.addAll(XMLUtil.getReferencingDeclaredTypes(formalParameter.getDataType().getDataTypes(), string));
            }
        }
        for (XMLCollectionElement xMLCollectionElement : ((DataFields)xMLComplexElement.get("DataFields")).toElements()) {
            arrayList.addAll(XMLUtil.getReferencingDeclaredTypes(((DataField)xMLCollectionElement).getDataType().getDataTypes(), string));
        }
        if (xMLComplexElement instanceof WorkflowProcess) {
            for (XMLCollectionElement xMLCollectionElement : ((WorkflowProcess)xMLComplexElement).getFormalParameters().toElements()) {
                arrayList.addAll(XMLUtil.getReferencingDeclaredTypes(((FormalParameter)xMLCollectionElement).getDataType().getDataTypes(), string));
            }
        }
        return arrayList;
    }

    public static List getReferencingDeclaredTypes(DataTypes dataTypes, String string) {
        ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
        if (string.equals("")) {
            return arrayList;
        }
        XMLElement xMLElement = dataTypes.getChoosen();
        if (xMLElement instanceof DeclaredType) {
            if (((DeclaredType)xMLElement).getId().equals(string)) {
                arrayList.add(xMLElement);
            }
        } else {
            if (xMLElement instanceof ArrayType) {
                return XMLUtil.getReferencingDeclaredTypes(((ArrayType)xMLElement).getDataTypes(), string);
            }
            if (xMLElement instanceof ListType) {
                return XMLUtil.getReferencingDeclaredTypes(((ListType)xMLElement).getDataTypes(), string);
            }
            if (xMLElement instanceof RecordType || xMLElement instanceof UnionType) {
                for (Member member : ((XMLCollection)xMLElement).toElements()) {
                    arrayList.addAll(XMLUtil.getReferencingDeclaredTypes(member.getDataTypes(), string));
                }
            }
        }
        return arrayList;
    }

    public static List getReferences(Artifact artifact) {
        return XMLUtil.getArtifactReferences(XMLUtil.getPackage(artifact), artifact.getId());
    }

    public static List getArtifactReferences(Package package_, String string) {
        ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
        if (string.equals("")) {
            return arrayList;
        }
        for (Association association : package_.getAssociations().toElements()) {
            if (association.getSource().equals(string)) {
                arrayList.add(association.get("Source"));
                continue;
            }
            if (!association.getTarget().equals(string)) continue;
            arrayList.add(association.get("Target"));
        }
        return arrayList;
    }

    public static List getReferences(Package package_, Association association) {
        ArrayList arrayList = new ArrayList();
        if (association.getId().equals("")) {
            return arrayList;
        }
        arrayList.addAll(XMLUtil.tGetAssociationReferences(package_, association));
        for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
            arrayList.addAll(XMLUtil.getReferences(workflowProcess, association));
        }
        return arrayList;
    }

    public static List getReferences(WorkflowProcess workflowProcess, Association association) {
        ArrayList arrayList = new ArrayList();
        if (association.getId().equals("")) {
            return arrayList;
        }
        arrayList.addAll(XMLUtil.tGetAssociationReferences(workflowProcess, association));
        for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
            arrayList.addAll(XMLUtil.tGetAssociationReferences(activitySet, association));
        }
        return arrayList;
    }

    public static List getReferences(ActivitySet activitySet, Association association) {
        return XMLUtil.tGetAssociationReferences(activitySet, association);
    }

    protected static List tGetAssociationReferences(XMLComplexElement xMLComplexElement, Association association) {
        ArrayList<Association> arrayList = new ArrayList<Association>();
        if (association.getId().equals("")) {
            return arrayList;
        }
        if (xMLComplexElement instanceof Package) {
            for (Artifact artifact : ((Package)xMLComplexElement).getArtifacts().toElements()) {
                if (!association.getSource().equals(artifact.getId()) && !association.getTarget().equals(artifact.getId())) continue;
                arrayList.add(association);
            }
        } else {
            for (Activity activity : ((Activities)xMLComplexElement.get("Activities")).toElements()) {
                if (!association.getSource().equals(activity.getId()) && !association.getTarget().equals(activity.getId())) continue;
                arrayList.add(association);
            }
        }
        return arrayList;
    }

    public static List getParticipantReferences(XMLComplexElement xMLComplexElement, String string) {
        if (string.equals("")) {
            return new ArrayList();
        }
        if (xMLComplexElement instanceof Package) {
            return XMLUtil.getParticipantReferences((Package)xMLComplexElement, string);
        }
        return XMLUtil.getParticipantReferences((WorkflowProcess)xMLComplexElement, string);
    }

    public static List getReferences(Package package_, Participant participant) {
        if (XMLUtil.getPackage(participant) != package_ && package_.getParticipant(participant.getId()) != null) {
            return new ArrayList();
        }
        return XMLUtil.getParticipantReferences(package_, participant.getId());
    }

    public static List getParticipantReferences(Package package_, String string) {
        ArrayList arrayList = new ArrayList();
        if (string.equals("")) {
            return arrayList;
        }
        arrayList.addAll(XMLUtil.tGetParticipantReferences(package_, string));
        for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
            if (workflowProcess.getParticipant(string) != null) continue;
            arrayList.addAll(XMLUtil.getParticipantReferences(workflowProcess, string));
        }
        return arrayList;
    }

    public static List getReferences(WorkflowProcess workflowProcess, Participant participant) {
        if (XMLUtil.getWorkflowProcess(participant) == null && workflowProcess.getParticipant(participant.getId()) != null) {
            return new ArrayList();
        }
        Package package_ = XMLUtil.getPackage(workflowProcess);
        if (XMLUtil.getPackage(participant) != package_ && package_.getParticipant(participant.getId()) != null) {
            return new ArrayList();
        }
        return XMLUtil.getParticipantReferences(workflowProcess, participant.getId());
    }

    public static List getParticipantReferences(WorkflowProcess workflowProcess, String string) {
        ArrayList arrayList = new ArrayList();
        if (string.equals("")) {
            return arrayList;
        }
        arrayList.addAll(XMLUtil.tGetParticipantReferences(workflowProcess, string));
        for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
            arrayList.addAll(XMLUtil.tGetParticipantReferences(activitySet, string));
        }
        return arrayList;
    }

    protected static List tGetParticipantReferences(XMLComplexElement xMLComplexElement, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string.equals("")) {
            return arrayList;
        }
        for (Iterator iterator : XMLUtil.getPackage(xMLComplexElement).getPools().toElements()) {
            for (Object object2 : ((Pool)((Object)iterator)).getLanes().toElements()) {
                for (Performer performer : ((Lane)object2).getPerformers().toElements()) {
                    if (!performer.toValue().equals(string) || arrayList.contains(performer)) continue;
                    arrayList.add(performer);
                }
            }
        }
        if (!(xMLComplexElement instanceof ActivitySet)) {
            for (Object object : ((RedefinableHeader)xMLComplexElement.get("RedefinableHeader")).getResponsibles().toElements()) {
                if (!((XMLElement)object).toValue().equals(string)) continue;
                arrayList.add(object);
            }
        }
        if (!(xMLComplexElement instanceof Package)) {
            for (Object object : ((Activities)xMLComplexElement.get("Activities")).toElements()) {
                Object object2;
                object2 = ((Activity)object).getFirstPerformer();
                if (!((String)object2).equals(string)) continue;
                arrayList.add(((Activity)object).getFirstPerformerObj());
            }
        }
        return arrayList;
    }

    public static List getApplicationReferences(XMLComplexElement xMLComplexElement, String string) {
        if (string.equals("")) {
            return new ArrayList();
        }
        if (xMLComplexElement instanceof Package) {
            return XMLUtil.getApplicationReferences((Package)xMLComplexElement, string);
        }
        return XMLUtil.getApplicationReferences((WorkflowProcess)xMLComplexElement, string);
    }

    public static List getReferences(Package package_, Application application) {
        if (XMLUtil.getPackage(application) != package_ && package_.getApplication(application.getId()) != null) {
            return new ArrayList();
        }
        return XMLUtil.getApplicationReferences(package_, application.getId());
    }

    public static List getApplicationReferences(Package package_, String string) {
        ArrayList arrayList = new ArrayList();
        if (string.equals("")) {
            return arrayList;
        }
        for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
            if (workflowProcess.getApplication(string) != null) continue;
            arrayList.addAll(XMLUtil.getApplicationReferences(workflowProcess, string));
        }
        return arrayList;
    }

    public static List getReferences(WorkflowProcess workflowProcess, Application application) {
        if (XMLUtil.getWorkflowProcess(application) == null && workflowProcess.getApplication(application.getId()) != null) {
            return new ArrayList();
        }
        Package package_ = XMLUtil.getPackage(workflowProcess);
        if (XMLUtil.getPackage(application) != package_ && package_.getParticipant(application.getId()) != null) {
            return new ArrayList();
        }
        return XMLUtil.getApplicationReferences(workflowProcess, application.getId());
    }

    public static List getApplicationReferences(WorkflowProcess workflowProcess, String string) {
        ArrayList arrayList = new ArrayList();
        if (string.equals("")) {
            return arrayList;
        }
        arrayList.addAll(XMLUtil.tGetApplicationReferences(workflowProcess, string));
        for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
            arrayList.addAll(XMLUtil.tGetApplicationReferences(activitySet, string));
        }
        return arrayList;
    }

    protected static List tGetApplicationReferences(XMLCollectionElement xMLCollectionElement, String string) {
        ArrayList<TaskApplication> arrayList = new ArrayList<TaskApplication>();
        if (string.equals("")) {
            return arrayList;
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        arrayList2.add(new Integer(2));
        for (Activity activity : XMLUtil.getActivities((Activities)xMLCollectionElement.get("Activities"), arrayList2)) {
            TaskApplication taskApplication = activity.getActivityTypes().getImplementation().getImplementationTypes().getTask().getTaskTypes().getTaskApplication();
            if (!taskApplication.getId().equals(string)) continue;
            arrayList.add(taskApplication);
        }
        return arrayList;
    }

    public static List getLaneReferences(XMLComplexElement xMLComplexElement, String string) {
        if (string.equals("")) {
            return new ArrayList();
        }
        if (xMLComplexElement instanceof Package) {
            return XMLUtil.getLaneReferences((Package)xMLComplexElement, string);
        }
        return XMLUtil.getLaneReferences((WorkflowProcess)xMLComplexElement, string);
    }

    public static List getReferences(Package package_, Lane lane) {
        return XMLUtil.getLaneReferences(package_, lane.getId());
    }

    public static List getLaneReferences(Package package_, String string) {
        ArrayList arrayList = new ArrayList();
        if (string.equals("")) {
            return arrayList;
        }
        arrayList.addAll(XMLUtil.tGetLaneReferences(package_, string));
        for (Pool pool : package_.getPools().toElements()) {
            WorkflowProcess workflowProcess = XMLUtil.getProcessForPool(pool);
            if (workflowProcess != null) {
                arrayList.addAll(XMLUtil.tGetLaneReferences(workflowProcess, string));
                continue;
            }
            ActivitySet activitySet = XMLUtil.getActivitySetForPool(pool);
            if (activitySet == null) continue;
            arrayList.addAll(XMLUtil.tGetLaneReferences(activitySet, string));
        }
        return arrayList;
    }

    public static List getReferences(WorkflowProcess workflowProcess, Lane lane) {
        return XMLUtil.getLaneReferences(workflowProcess, lane.getId());
    }

    public static List getLaneReferences(WorkflowProcess workflowProcess, String string) {
        ArrayList arrayList = new ArrayList();
        if (string.equals("")) {
            return arrayList;
        }
        arrayList.addAll(XMLUtil.tGetLaneReferences(workflowProcess, string));
        for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
            arrayList.addAll(XMLUtil.tGetLaneReferences(activitySet, string));
        }
        return arrayList;
    }

    public static List tGetLaneReferences(XMLComplexElement xMLComplexElement, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string.equals("")) {
            return arrayList;
        }
        if (xMLComplexElement instanceof Package) {
            for (Pool pool : ((Package)xMLComplexElement).getPools().toElements()) {
                for (Lane lane : pool.getLanes().toElements()) {
                    Object object2;
                    for (Object object2 : lane.getNestedLanes().toElements()) {
                        if (!((NestedLane)object2).getLaneId().equals(string)) continue;
                        arrayList.add(object2);
                    }
                    object2 = ((Package)xMLComplexElement).getArtifacts().toElements().iterator();
                    while (object2.hasNext()) {
                        Artifact artifact = (Artifact)object2.next();
                        for (NodeGraphicsInfo nodeGraphicsInfo : artifact.getNodeGraphicsInfos().toElements()) {
                            if (!string.equals(nodeGraphicsInfo.getLaneId())) continue;
                            arrayList.add(nodeGraphicsInfo);
                        }
                    }
                }
            }
        } else {
            for (Activity activity : ((Activities)xMLComplexElement.get("Activities")).toElements()) {
                for (NodeGraphicsInfo nodeGraphicsInfo : activity.getNodeGraphicsInfos().toElements()) {
                    if (!nodeGraphicsInfo.getLaneId().equals(string)) continue;
                    arrayList.add(nodeGraphicsInfo);
                }
            }
        }
        return arrayList;
    }

    public static List getDataFieldReferences(XMLComplexElement xMLComplexElement, String string) {
        if (string.equals("")) {
            return new ArrayList();
        }
        if (xMLComplexElement instanceof Package) {
            return XMLUtil.getDataFieldReferences((Package)xMLComplexElement, string);
        }
        return XMLUtil.getDataFieldReferences((WorkflowProcess)xMLComplexElement, string);
    }

    public static List getReferences(Package package_, DataField dataField) {
        return XMLUtil.getDataFieldReferences(package_, dataField.getId());
    }

    public static List getDataFieldReferences(Package package_, String string) {
        ArrayList arrayList = new ArrayList();
        if (string.equals("")) {
            return arrayList;
        }
        for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
            if (workflowProcess.getDataField(string) != null) continue;
            arrayList.addAll(XMLUtil.getDataFieldReferences(workflowProcess, string));
        }
        return arrayList;
    }

    public static List getReferences(WorkflowProcess workflowProcess, DataField dataField) {
        if (XMLUtil.getWorkflowProcess(dataField) == null && (workflowProcess.getDataField(dataField.getId()) != null || workflowProcess.getFormalParameter(dataField.getId()) != null)) {
            return new ArrayList();
        }
        return XMLUtil.getDataFieldReferences(workflowProcess, dataField.getId());
    }

    public static List getDataFieldReferences(WorkflowProcess workflowProcess, String string) {
        ArrayList arrayList = new ArrayList();
        if (string.equals("")) {
            return arrayList;
        }
        arrayList.addAll(XMLUtil.getVariableReferences(workflowProcess, string));
        for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
            arrayList.addAll(XMLUtil.getVariableReferences(activitySet, string));
        }
        return arrayList;
    }

    public static List getReferences(Package package_, WorkflowProcess workflowProcess) {
        ArrayList arrayList = new ArrayList();
        if (XMLUtil.getPackage(workflowProcess) != package_ && package_.getWorkflowProcess(workflowProcess.getId()) != null) {
            return arrayList;
        }
        return XMLUtil.getWorkflowProcessReferences(package_, workflowProcess.getId());
    }

    public static List getWorkflowProcessReferences(Package package_, String string) {
        ArrayList<Pool> arrayList = new ArrayList<Pool>();
        if (string.equals("")) {
            return arrayList;
        }
        for (XMLCollectionElement xMLCollectionElement : package_.getPools().toElements()) {
            if (!xMLCollectionElement.getProcess().equals(string)) continue;
            arrayList.add((Pool)xMLCollectionElement);
        }
        for (XMLCollectionElement xMLCollectionElement : package_.getWorkflowProcesses().toElements()) {
            arrayList.addAll(XMLUtil.getWorkflowProcessReferences((WorkflowProcess)xMLCollectionElement, string));
        }
        return arrayList;
    }

    public static List getReferences(WorkflowProcess workflowProcess, WorkflowProcess workflowProcess2) {
        return XMLUtil.getWorkflowProcessReferences(workflowProcess, workflowProcess2.getId());
    }

    public static List getWorkflowProcessReferences(WorkflowProcess workflowProcess, String string) {
        ArrayList arrayList = new ArrayList();
        if (string.equals("")) {
            return arrayList;
        }
        arrayList.addAll(XMLUtil.tGetWorkflowProcessReferences(workflowProcess, string));
        for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
            arrayList.addAll(XMLUtil.tGetWorkflowProcessReferences(activitySet, string));
        }
        return arrayList;
    }

    protected static List tGetWorkflowProcessReferences(XMLCollectionElement xMLCollectionElement, String string) {
        ArrayList<SubFlow> arrayList = new ArrayList<SubFlow>();
        if (string.equals("")) {
            return arrayList;
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        arrayList2.add(new Integer(3));
        for (Activity activity : XMLUtil.getActivities((Activities)xMLCollectionElement.get("Activities"), arrayList2)) {
            SubFlow subFlow = activity.getActivityTypes().getImplementation().getImplementationTypes().getSubFlow();
            if (!subFlow.getId().equals(string)) continue;
            arrayList.add(subFlow);
        }
        return arrayList;
    }

    public static List getReferences(WorkflowProcess workflowProcess, FormalParameter formalParameter) {
        ArrayList arrayList = new ArrayList();
        if (!(formalParameter.getParent().getParent() instanceof WorkflowProcess)) {
            return arrayList;
        }
        return XMLUtil.getFormalParameterReferences(workflowProcess, formalParameter.getId());
    }

    public static List getFormalParameterReferences(WorkflowProcess workflowProcess, String string) {
        ArrayList arrayList = new ArrayList();
        if (string.equals("")) {
            return arrayList;
        }
        if (workflowProcess.getDataField(string) != null) {
            return arrayList;
        }
        arrayList.addAll(XMLUtil.getVariableReferences(workflowProcess, string));
        for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
            arrayList.addAll(XMLUtil.getVariableReferences(activitySet, string));
        }
        return arrayList;
    }

    public static List getVariableReferences(XMLCollectionElement xMLCollectionElement, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string.equals("")) {
            return arrayList;
        }
        Map map = XMLUtil.getWorkflowProcess(xMLCollectionElement).getAllVariables();
        for (XMLCollectionElement xMLCollectionElement2 : ((Activities)xMLCollectionElement.get("Activities")).toElements()) {
            Object object;
            Object object22;
            int n = ((Activity)xMLCollectionElement2).getActivityType();
            ArrayList arrayList2 = new ArrayList();
            if (n == 3) {
                arrayList2.addAll(((Activity)xMLCollectionElement2).getActivityTypes().getImplementation().getImplementationTypes().getSubFlow().getActualParameters().toElements());
            } else if (n == 2) {
                TaskApplication taskApplication = ((Activity)xMLCollectionElement2).getActivityTypes().getImplementation().getImplementationTypes().getTask().getTaskTypes().getTaskApplication();
                arrayList2.addAll(taskApplication.getActualParameters().toElements());
            }
            for (Object object22 : arrayList2) {
                if (XMLUtil.getUsingPositions(((XMLElement)object22).toValue(), string, map).size() <= 0) continue;
                arrayList.add(object22);
            }
            object22 = ((Activity)xMLCollectionElement2).getDeadlines().toElements().iterator();
            while (object22.hasNext()) {
                object = (Deadline)object22.next();
                String string2 = ((Deadline)object).getDeadlineDuration();
                if (XMLUtil.getUsingPositions(string2, string, map).size() <= 0) continue;
                arrayList.add(((XMLComplexElement)object).get("DeadlineCondition"));
            }
            object = ((Activity)xMLCollectionElement2).getFirstPerformer();
            if (XMLUtil.getUsingPositions((String)object, string, map).size() <= 0) continue;
            arrayList.add(((Activity)xMLCollectionElement2).getFirstPerformerObj());
        }
        for (XMLCollectionElement xMLCollectionElement2 : ((Transitions)xMLCollectionElement.get("Transitions")).toElements()) {
            if (XMLUtil.getUsingPositions(((Transition)xMLCollectionElement2).getCondition().toValue(), string, map).size() <= 0) continue;
            arrayList.add(((Transition)xMLCollectionElement2).getCondition());
        }
        return arrayList;
    }

    public static List getReferences(WorkflowProcess workflowProcess, ActivitySet activitySet) {
        return XMLUtil.getActivitySetReferences(workflowProcess, activitySet.getId());
    }

    public static List getActivitySetReferences(WorkflowProcess workflowProcess, String string) {
        ArrayList<Pool> arrayList = new ArrayList<Pool>();
        if (string.equals("")) {
            return arrayList;
        }
        for (XMLCollectionElement xMLCollectionElement : XMLUtil.getPackage(workflowProcess).getPools().toElements()) {
            if (!xMLCollectionElement.getProcess().equals(string)) continue;
            arrayList.add((Pool)xMLCollectionElement);
        }
        arrayList.addAll(XMLUtil.tGetActivitySetReferences(workflowProcess, string));
        for (XMLCollectionElement xMLCollectionElement : workflowProcess.getActivitySets().toElements()) {
            arrayList.addAll(XMLUtil.tGetActivitySetReferences(xMLCollectionElement, string));
        }
        return arrayList;
    }

    public static List getReferences(ActivitySet activitySet, ActivitySet activitySet2) {
        return XMLUtil.getReferences(activitySet, activitySet2.getId());
    }

    public static List getReferences(ActivitySet activitySet, String string) {
        ArrayList<Pool> arrayList = new ArrayList<Pool>();
        for (Pool pool : XMLUtil.getPackage(activitySet).getPools().toElements()) {
            if (!pool.getProcess().equals(string)) continue;
            arrayList.add(pool);
        }
        arrayList.addAll(XMLUtil.tGetActivitySetReferences(activitySet, string));
        return arrayList;
    }

    public static List tGetActivitySetReferences(XMLCollectionElement xMLCollectionElement, String string) {
        ArrayList<BlockActivity> arrayList = new ArrayList<BlockActivity>();
        if (string.equals("")) {
            return arrayList;
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        arrayList2.add(new Integer(4));
        for (Activity activity : XMLUtil.getActivities((Activities)xMLCollectionElement.get("Activities"), arrayList2)) {
            BlockActivity blockActivity = activity.getActivityTypes().getBlockActivity();
            if (!blockActivity.getActivitySetId().equals(string)) continue;
            arrayList.add(blockActivity);
        }
        return arrayList;
    }

    public static List getReferences(Activity activity) {
        return XMLUtil.getActivityReferences((XMLCollectionElement)activity.getParent().getParent(), activity.getId());
    }

    public static List getActivityReferences(XMLCollectionElement xMLCollectionElement, String string) {
        ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
        Transitions transitions = (Transitions)xMLCollectionElement.get("Transitions");
        Iterator iterator = XMLUtil.getTransitions(transitions, string, true).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Transition)iterator.next()).get("To"));
        }
        iterator = XMLUtil.getTransitions(transitions, string, false).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Transition)iterator.next()).get("From"));
        }
        Associations associations = XMLUtil.getPackage(xMLCollectionElement).getAssociations();
        iterator = XMLUtil.getAssociations(associations, string, true).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Association)iterator.next()).get("Target"));
        }
        iterator = XMLUtil.getAssociations(associations, string, false).iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Association)iterator.next()).get("Source"));
        }
        return new ArrayList(arrayList);
    }

    public static List getReferences(Transition transition) {
        Activities activities = (Activities)((XMLCollectionElement)transition.getParent().getParent()).get("Activities");
        Activity activity = activities.getActivity(transition.getFrom());
        Activity activity2 = activities.getActivity(transition.getTo());
        HashSet<Activity> hashSet = new HashSet<Activity>();
        if (activity != null) {
            hashSet.add(activity);
        }
        if (activity2 != null && activity2 != activity) {
            hashSet.add(activity2);
        }
        return new ArrayList(hashSet);
    }

    public static boolean correctSplitsAndJoins(Package package_) {
        boolean bl = false;
        for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
            bl = XMLUtil.correctSplitsAndJoins(workflowProcess) || bl;
        }
        return bl;
    }

    public static boolean correctSplitsAndJoins(WorkflowProcess workflowProcess) {
        boolean bl = XMLUtil.correctSplitsAndJoins(workflowProcess.getActivities().toElements());
        for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
            bl = XMLUtil.correctSplitsAndJoins(activitySet.getActivities().toElements()) || bl;
        }
        return bl;
    }

    public static boolean correctSplitsAndJoins(List list) {
        boolean bl = false;
        for (Activity activity : list) {
            bl = XMLUtil.correctSplitAndJoin(activity) || bl;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean correctSplitAndJoin(Activity activity) {
        Set set = XMLUtil.getOutgoingTransitions(activity);
        Set set2 = XMLUtil.getIncomingTransitions(activity);
        TransitionRestrictions transitionRestrictions = activity.getTransitionRestrictions();
        TransitionRestriction transitionRestriction = null;
        boolean bl = false;
        boolean bl2 = false;
        if (transitionRestrictions.size() == 0) {
            if (set.size() <= 1) {
                if (set2.size() <= 1) return false;
            }
            transitionRestriction = (TransitionRestriction)transitionRestrictions.generateNewElement();
            bl = true;
        } else {
            transitionRestriction = (TransitionRestriction)transitionRestrictions.get(0);
        }
        Split split = transitionRestriction.getSplit();
        Join join = transitionRestriction.getJoin();
        TransitionRefs transitionRefs = split.getTransitionRefs();
        if (set.size() <= 1) {
            if (transitionRefs.size() > 0) {
                transitionRefs.clear();
                bl2 = true;
            }
            if (!split.getType().equals("")) {
                split.setTypeNONE();
                bl2 = true;
            }
        }
        if (set.size() > 1) {
            TransitionRef transitionRef;
            int n;
            Cloneable cloneable2;
            if (split.getType().equals("")) {
                if (activity.getActivityType() != 0) {
                    split.setTypeParallel();
                } else {
                    split.set("Type", activity.getActivityTypes().getRoute().getGatewayType());
                }
                bl2 = true;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < transitionRefs.size(); ++i) {
                TransitionRef transitionRef2 = (TransitionRef)transitionRefs.get(i);
                arrayList.add(transitionRef2.getId());
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Cloneable cloneable2 : set) {
                arrayList2.add(((XMLCollectionElement)cloneable2).getId());
            }
            cloneable2 = new ArrayList(arrayList);
            cloneable2.removeAll(arrayList2);
            ArrayList arrayList3 = new ArrayList(arrayList2);
            arrayList3.removeAll(arrayList);
            for (n = 0; n < cloneable2.size(); ++n) {
                transitionRef = transitionRefs.getTransitionRef((String)cloneable2.get(n));
                transitionRefs.remove(transitionRef);
                bl2 = true;
            }
            for (n = 0; n < arrayList3.size(); ++n) {
                transitionRef = (TransitionRef)transitionRefs.generateNewElement();
                transitionRef.setId((String)arrayList3.get(n));
                transitionRefs.add(transitionRef);
                bl2 = true;
            }
        }
        if (set2.size() <= 1) {
            if (!join.getType().equals("")) {
                join.setTypeNONE();
                bl2 = true;
            }
        } else if (join.getType().equals("")) {
            if (activity.getActivityType() != 0) {
                join.setTypeExclusive();
            } else {
                join.set("Type", activity.getActivityTypes().getRoute().getGatewayType());
            }
            bl2 = true;
        }
        if (split.getType().equals("") && join.getType().equals("")) {
            if (bl) return bl2;
            transitionRestrictions.remove(transitionRestriction);
            return true;
        }
        if (!bl) return bl2;
        transitionRestrictions.add(transitionRestriction);
        return bl2;
    }

    public static void updateActivityReferences(List list, String string, String string2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((XMLElement)iterator.next()).setValue(string2);
        }
    }

    public static void updateArtifactReferences(List list, String string, String string2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((XMLElement)iterator.next()).setValue(string2);
        }
    }

    public static void updateActivityOnTransitionIdChange(Activities activities, String string, String string2, String string3) {
        Activity activity = activities.getActivity(string);
        XMLUtil.updateActivityOnTransitionIdChange(activity, string2, string3);
    }

    public static void updateActivityOnTransitionIdChange(Activity activity, String string, String string2) {
        TransitionRef transitionRef;
        Split split;
        if (activity != null && (split = XMLUtil.getSplit(activity)) != null && (transitionRef = split.getTransitionRefs().getTransitionRef(string)) != null) {
            transitionRef.setId(string2);
        }
    }

    public static void updateActivitiesOnTransitionFromChange(Activities activities, String string, String string2, String string3) {
        Activity activity;
        if (string2 != null && (activity = activities.getActivity(string2)) != null) {
            XMLUtil.correctSplitAndJoin(activity);
        }
        if (string3 != null && (activity = activities.getActivity(string3)) != null) {
            XMLUtil.correctSplitAndJoin(activity);
        }
    }

    public static void updateActivitiesOnTransitionToChange(Activities activities, String string, String string2, String string3) {
        Activity activity;
        if (string2 != null && (activity = activities.getActivity(string2)) != null) {
            XMLUtil.correctSplitAndJoin(activity);
        }
        if (string3 != null && (activity = activities.getActivity(string3)) != null) {
            XMLUtil.correctSplitAndJoin(activity);
        }
    }

    public static void removeTransitionsForActivity(Activity activity) {
        Set set = XMLUtil.getTransitionsForActivity(activity);
        Transitions transitions = (Transitions)((XMLCollectionElement)activity.getParent().getParent()).get("Transitions");
        Activities activities = (Activities)activity.getParent();
        if (set.size() > 0) {
            for (Transition transition : set) {
                Activity activity2 = activities.getActivity(transition.getFrom());
                Activity activity3 = activities.getActivity(transition.getTo());
                if (activity2 != activity && activity2 != null) {
                    XMLUtil.correctSplitAndJoin(activity2);
                }
                if (activity3 != activity && activity3 != null) {
                    XMLUtil.correctSplitAndJoin(activity3);
                }
                transitions.remove(transition);
            }
        }
    }

    public static void removeTransitionsForActivities(List list) {
        if (list.size() == 0) {
            return;
        }
        Activities activities = (Activities)((Activity)list.get(0)).getParent();
        HashSet hashSet = new HashSet();
        for (XMLBaseForCollectionAndComplex xMLBaseForCollectionAndComplex : list) {
            hashSet.addAll(XMLUtil.getTransitionsForActivity((Activity)xMLBaseForCollectionAndComplex));
        }
        if (hashSet.size() > 0) {
            XMLBaseForCollectionAndComplex xMLBaseForCollectionAndComplex;
            xMLBaseForCollectionAndComplex = (Transitions)((XMLCollectionElement)hashSet.toArray()[0]).getParent();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((XMLCollection)xMLBaseForCollectionAndComplex).remove((Transition)iterator.next());
            }
            for (Transition transition : hashSet) {
                Activity activity = activities.getActivity(transition.getFrom());
                Activity activity2 = activities.getActivity(transition.getTo());
                if (activity != null && !list.contains(activity)) {
                    XMLUtil.correctSplitAndJoin(activity);
                }
                if (activity2 == null || list.contains(activity2)) continue;
                XMLUtil.correctSplitAndJoin(activity2);
            }
        }
    }

    protected static Set getTransitionsForActivity(Activity activity) {
        Set set = XMLUtil.getIncomingTransitions(activity);
        set.addAll(XMLUtil.getOutgoingTransitions(activity));
        return set;
    }

    public static List getTransitions(Transitions transitions, String string, boolean bl) {
        ArrayList<Transition> arrayList = new ArrayList<Transition>();
        for (Transition transition : transitions.toElements()) {
            if (bl) {
                if (!transition.getTo().equals(string)) continue;
                arrayList.add(transition);
                continue;
            }
            if (!transition.getFrom().equals(string)) continue;
            arrayList.add(transition);
        }
        return arrayList;
    }

    public static void removeAssociationsForActivityOrArtifact(XMLCollectionElement xMLCollectionElement) {
        Set set = XMLUtil.getAssociationsForActivityOrArtifact(xMLCollectionElement);
        Associations associations = XMLUtil.getPackage(xMLCollectionElement).getAssociations();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            associations.remove((Association)iterator.next());
        }
    }

    public static void removeAssociationsForActivitiesOrArtifacts(List list) {
        XMLBaseForCollectionAndComplex xMLBaseForCollectionAndComplex2;
        if (list.size() == 0) {
            return;
        }
        HashSet hashSet = new HashSet();
        for (XMLBaseForCollectionAndComplex xMLBaseForCollectionAndComplex2 : list) {
            hashSet.addAll(XMLUtil.getAssociationsForActivityOrArtifact((XMLCollectionElement)xMLBaseForCollectionAndComplex2));
        }
        xMLBaseForCollectionAndComplex2 = XMLUtil.getPackage((XMLElement)list.toArray()[0]).getAssociations();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((XMLCollection)xMLBaseForCollectionAndComplex2).remove((Association)iterator.next());
        }
    }

    protected static Set getAssociationsForActivityOrArtifact(XMLCollectionElement xMLCollectionElement) {
        Set set = XMLUtil.getIncomingAssociations(xMLCollectionElement);
        set.addAll(XMLUtil.getOutgoingAssociations(xMLCollectionElement));
        return set;
    }

    public static List getAssociations(Associations associations, String string, boolean bl) {
        ArrayList<Association> arrayList = new ArrayList<Association>();
        for (Association association : associations.toElements()) {
            if (bl) {
                if (!association.getTarget().equals(string)) continue;
                arrayList.add(association);
                continue;
            }
            if (!association.getSource().equals(string)) continue;
            arrayList.add(association);
        }
        return arrayList;
    }

    public static void removeNestedLanesForLanes(List list) {
        for (Lane lane : list) {
            XMLUtil.removeNestedLanesForLane(lane);
        }
    }

    public static void removeNestedLanesForLane(Lane lane) {
        Set set = XMLUtil.getNestedLanesForLane(lane);
        for (NestedLane nestedLane : set) {
            ((NestedLanes)nestedLane.getParent()).remove(nestedLane);
        }
    }

    protected static Set getNestedLanesForLane(Lane lane) {
        HashSet<NestedLane> hashSet = new HashSet<NestedLane>();
        Pool pool = XMLUtil.getPool(lane);
        for (Lane lane2 : pool.getLanes().toElements()) {
            if (lane2 == lane) continue;
            for (NestedLane nestedLane : lane2.getNestedLanes().toElements()) {
                if (!nestedLane.getLaneId().equals(lane.getId())) continue;
                hashSet.add(nestedLane);
            }
        }
        return hashSet;
    }

    public static void createPoolsForProcesses(List list) {
        for (WorkflowProcess workflowProcess : list) {
            if (XMLUtil.getPoolForProcessOrActivitySet(workflowProcess) != null) continue;
            XMLUtil.createPoolForProcess(workflowProcess);
        }
    }

    public static Pool createPoolForProcess(WorkflowProcess workflowProcess) {
        Pools pools = XMLUtil.getPackage(workflowProcess).getPools();
        Pool pool = (Pool)pools.generateNewElement();
        pool.setId(XMLUtil.generateUniqueId(pools, new HashSet()));
        pool.setProcess(workflowProcess.getId());
        pool.setMainPool(true);
        pool.setName(workflowProcess.getName().equals("") ? workflowProcess.getId() : workflowProcess.getName());
        pools.add(pool);
        return pool;
    }

    public static void removePoolsForProcesses(List list) {
        for (WorkflowProcess workflowProcess : list) {
            XMLUtil.removePoolForProcess(workflowProcess);
        }
    }

    public static Pool removePoolForProcess(WorkflowProcess workflowProcess) {
        Pool pool = XMLUtil.getPoolForProcessOrActivitySet(workflowProcess);
        ((Pools)pool.getParent()).remove(pool);
        return pool;
    }

    public static WorkflowProcess getProcessForPool(Pool pool) {
        return XMLUtil.getPackage(pool).getWorkflowProcess(pool.getProcess());
    }

    public static void createPoolsForActivitySets(List list) {
        for (ActivitySet activitySet : list) {
            if (XMLUtil.getPoolForProcessOrActivitySet(activitySet) != null) continue;
            XMLUtil.createPoolForActivitySet(activitySet);
        }
    }

    public static Pool createPoolForActivitySet(ActivitySet activitySet) {
        Pools pools = XMLUtil.getPackage(activitySet).getPools();
        Pool pool = (Pool)pools.generateNewElement();
        pool.setId(XMLUtil.generateUniqueId(pools, new HashSet()));
        pool.setProcess(activitySet.getId());
        pool.setMainPool(true);
        pool.setName(activitySet.getName().equals("") ? activitySet.getId() : activitySet.getName());
        pools.add(pool);
        return pool;
    }

    public static void removePoolsForActivitySets(List list) {
        for (ActivitySet activitySet : list) {
            XMLUtil.removePoolForActivitySet(activitySet);
        }
    }

    public static Pool removePoolForActivitySet(ActivitySet activitySet) {
        Pool pool = XMLUtil.getPoolForProcessOrActivitySet(activitySet);
        ((Pools)pool.getParent()).remove(pool);
        return pool;
    }

    public static ActivitySet getActivitySetForPool(Pool pool) {
        return XMLUtil.getPackage(pool).getActivitySet(pool.getProcess());
    }

    public static Pool getPoolForProcessOrActivitySet(XMLCollectionElement xMLCollectionElement) {
        Pool pool;
        Iterator iterator = XMLUtil.getPackage(xMLCollectionElement).getPools().toElements().iterator();
        ArrayList<Pool> arrayList = new ArrayList<Pool>();
        while (iterator.hasNext()) {
            pool = (Pool)iterator.next();
            if (!pool.getProcess().equals(xMLCollectionElement.getId())) continue;
            arrayList.add(pool);
        }
        if (arrayList.size() == 1) {
            return (Pool)arrayList.get(0);
        }
        if (arrayList.size() > 1) {
            pool = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                Pool pool2 = (Pool)arrayList.get(i);
                if (pool2.getLanes().size() <= 0) continue;
                pool = pool2;
                break;
            }
            if (pool == null) {
                pool = (Pool)arrayList.get(0);
            }
            return pool;
        }
        return null;
    }

    public static void removeArtifactAndAssociationsForProcessesOrActivitySets(List list) {
        for (XMLCollectionElement xMLCollectionElement : list) {
            XMLUtil.removeArtifactAndAssociationsForProcessOrActivitySet(xMLCollectionElement);
        }
    }

    public static List removeArtifactAndAssociationsForProcessOrActivitySet(XMLCollectionElement xMLCollectionElement) {
        List list = XMLUtil.getAllArtifactsAndAssociationsForWorkflowProcessOrActivitySet(xMLCollectionElement);
        for (XMLElement xMLElement : list) {
            ((XMLCollection)xMLElement.getParent()).remove(xMLElement);
        }
        return list;
    }

    public static void updateTypeDeclarationReferences(List list, String string) {
        for (DeclaredType declaredType : list) {
            declaredType.setId(string);
        }
    }

    public static void updateApplicationReferences(List list, String string) {
        for (TaskApplication taskApplication : list) {
            taskApplication.setId(string);
        }
    }

    public static void updateLaneReferences(List list, String string) {
        for (XMLComplexElement xMLComplexElement : list) {
            xMLComplexElement.set("LaneId", string);
        }
    }

    public static void updateParticipantReferences(List list, String string) {
        for (XMLElement xMLElement : list) {
            xMLElement.setValue(string);
        }
    }

    public static void updateWorkflowProcessReferences(List list, String string) {
        for (Object e : list) {
            if (e instanceof SubFlow) {
                ((SubFlow)e).setId(string);
                continue;
            }
            ((Pool)e).setProcess(string);
        }
    }

    public static void updateActivitySetReferences(List list, String string) {
        for (Object e : list) {
            if (e instanceof BlockActivity) {
                BlockActivity blockActivity = (BlockActivity)e;
                blockActivity.setActivitySetId(string);
                continue;
            }
            ((Pool)e).setProcess(string);
        }
    }

    public static void updateVariableReferences(List list, String string, String string2) {
        Iterator iterator = list.iterator();
        int n = string2.length() - string.length();
        while (iterator.hasNext()) {
            XMLElement xMLElement = (XMLElement)iterator.next();
            String string3 = xMLElement.toValue();
            List list2 = XMLUtil.getUsingPositions(string3, string, XMLUtil.getWorkflowProcess(xMLElement).getAllVariables());
            for (int i = 0; i < list2.size(); ++i) {
                int n2 = (Integer)list2.get(i);
                int n3 = n2 + n * i;
                String string4 = string3.substring(0, n3);
                String string5 = string3.substring(n3 + string.length());
                string3 = string4 + string2 + string5;
            }
            xMLElement.setValue(string3);
        }
    }

    public static List getActivities(Package package_, List list) {
        ArrayList arrayList = new ArrayList();
        for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
            arrayList.addAll(XMLUtil.getActivities(workflowProcess, list));
        }
        return arrayList;
    }

    public static List getActivities(WorkflowProcess workflowProcess, List list) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(XMLUtil.getActivities(workflowProcess.getActivities(), list));
        for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
            arrayList.addAll(XMLUtil.getActivities(activitySet.getActivities(), list));
        }
        return arrayList;
    }

    public static List getActivities(Activities activities, List list) {
        ArrayList<Activity> arrayList = new ArrayList<Activity>();
        for (Activity activity : activities.toElements()) {
            int n = activity.getActivityType();
            if (!list.contains(new Integer(n))) continue;
            arrayList.add(activity);
        }
        return arrayList;
    }

    public static SequencedHashMap getPossibleResponsibles(Responsibles responsibles, Responsible responsible, XMLInterface xMLInterface) {
        SequencedHashMap sequencedHashMap = null;
        sequencedHashMap = XMLUtil.getWorkflowProcess(responsibles) != null ? XMLUtil.getPossibleParticipants(XMLUtil.getWorkflowProcess(responsibles), xMLInterface) : XMLUtil.getPossibleParticipants(XMLUtil.getPackage(responsibles), xMLInterface);
        for (Responsible responsible2 : responsibles.toElements()) {
            if (responsible2 == responsible) continue;
            sequencedHashMap.remove(responsible2.toValue());
        }
        return sequencedHashMap;
    }

    public static boolean doesCrossreferenceExist(Package package_, XMLInterface xMLInterface) {
        boolean bl = false;
        Iterator iterator = package_.getExternalPackageIds().iterator();
        while (iterator.hasNext()) {
            try {
                Package package_2 = xMLInterface.getPackageById((String)iterator.next());
                if (!XMLUtil.getAllExternalPackageIds(xMLInterface, package_2, new HashSet()).contains(package_.getId())) continue;
                bl = true;
                break;
            }
            catch (Exception exception) {
            }
        }
        return bl;
    }

    public static Set getAllExtendedAttributeNames(XMLComplexElement xMLComplexElement, XMLInterface xMLInterface) {
        HashSet hashSet = new HashSet();
        Iterator iterator = xMLInterface.getAllPackages().iterator();
        while (iterator.hasNext()) {
            hashSet.addAll(XMLUtil.getAllExtendedAttributeNames((Package)iterator.next(), xMLComplexElement));
        }
        return hashSet;
    }

    public static Set getAllExtendedAttributeNames(Package package_, XMLComplexElement xMLComplexElement) {
        HashSet hashSet = new HashSet();
        if (xMLComplexElement instanceof Activity) {
            for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
                hashSet.addAll(XMLUtil.getAllExtendedAttributeNamesForElements(workflowProcess.getActivities().toElements()));
                for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
                    hashSet.addAll(XMLUtil.getAllExtendedAttributeNamesForElements(activitySet.getActivities().toElements()));
                }
            }
        } else if (xMLComplexElement instanceof Application) {
            hashSet.addAll(XMLUtil.getAllExtendedAttributeNamesForElements(package_.getApplications().toElements()));
            for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
                hashSet.addAll(XMLUtil.getAllExtendedAttributeNamesForElements(workflowProcess.getApplications().toElements()));
            }
        } else if (xMLComplexElement instanceof DataField) {
            hashSet.addAll(XMLUtil.getAllExtendedAttributeNamesForElements(package_.getDataFields().toElements()));
            for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
                hashSet.addAll(XMLUtil.getAllExtendedAttributeNamesForElements(workflowProcess.getDataFields().toElements()));
            }
        } else if (xMLComplexElement instanceof ExternalPackage) {
            hashSet.addAll(XMLUtil.getAllExtendedAttributeNamesForElements(package_.getExternalPackages().toElements()));
        } else if (xMLComplexElement instanceof Package) {
            hashSet.addAll(XMLUtil.getAllExtendedAttributeNames(package_.getExtendedAttributes().toElements()));
        } else if (xMLComplexElement instanceof Participant) {
            hashSet.addAll(XMLUtil.getAllExtendedAttributeNamesForElements(package_.getParticipants().toElements()));
            for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
                hashSet.addAll(XMLUtil.getAllExtendedAttributeNamesForElements(workflowProcess.getParticipants().toElements()));
            }
        } else if (xMLComplexElement instanceof Transition) {
            for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
                hashSet.addAll(XMLUtil.getAllExtendedAttributeNamesForElements(workflowProcess.getTransitions().toElements()));
                for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
                    hashSet.addAll(XMLUtil.getAllExtendedAttributeNamesForElements(activitySet.getTransitions().toElements()));
                }
            }
        } else if (xMLComplexElement instanceof TypeDeclaration) {
            hashSet.addAll(XMLUtil.getAllExtendedAttributeNamesForElements(package_.getTypeDeclarations().toElements()));
        } else if (xMLComplexElement instanceof WorkflowProcess) {
            hashSet.addAll(XMLUtil.getAllExtendedAttributeNamesForElements(package_.getWorkflowProcesses().toElements()));
        }
        return hashSet;
    }

    public static Set getAllExtendedAttributeNamesForElements(Collection collection) {
        HashSet hashSet = new HashSet();
        for (XMLComplexElement xMLComplexElement : collection) {
            hashSet.addAll(((ExtendedAttributes)xMLComplexElement.get("ExtendedAttributes")).toElements());
        }
        return XMLUtil.getAllExtendedAttributeNames(hashSet);
    }

    public static Set getAllExtendedAttributeNames(Collection collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (ExtendedAttribute extendedAttribute : collection) {
            String string = extendedAttribute.getName();
            hashSet.add(string);
        }
        return hashSet;
    }

    static {
        basicTypesMap.put("BOOLEAN", "java.lang.Boolean");
        basicTypesMap.put("STRING", "java.lang.String");
        basicTypesMap.put("INTEGER", "java.lang.Long");
        basicTypesMap.put("FLOAT", "java.lang.Double");
        basicTypesMap.put("DATETIME", "java.util.Date");
    }
}

