/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jxpdl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLBaseForCollectionAndComplex;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexChoice;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLSimpleElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activities;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.ActivitySets;
import org.enhydra.jxpdl.elements.ActualParameter;
import org.enhydra.jxpdl.elements.ActualParameters;
import org.enhydra.jxpdl.elements.BlockActivity;
import org.enhydra.jxpdl.elements.Condition;
import org.enhydra.jxpdl.elements.Coordinatess;
import org.enhydra.jxpdl.elements.Deadline;
import org.enhydra.jxpdl.elements.DeadlineCondition;
import org.enhydra.jxpdl.elements.Deadlines;
import org.enhydra.jxpdl.elements.ExpressionType;
import org.enhydra.jxpdl.elements.ExtendedAttribute;
import org.enhydra.jxpdl.elements.ExtendedAttributes;
import org.enhydra.jxpdl.elements.Implementation;
import org.enhydra.jxpdl.elements.Join;
import org.enhydra.jxpdl.elements.Namespace;
import org.enhydra.jxpdl.elements.Namespaces;
import org.enhydra.jxpdl.elements.NestedLanes;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.Performer;
import org.enhydra.jxpdl.elements.SchemaType;
import org.enhydra.jxpdl.elements.Split;
import org.enhydra.jxpdl.elements.TaskApplication;
import org.enhydra.jxpdl.elements.Tool;
import org.enhydra.jxpdl.elements.Tools;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.TransitionRestriction;
import org.enhydra.jxpdl.elements.Transitions;
import org.enhydra.jxpdl.elements.WebServiceFaultCatchs;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPDLRepositoryHandler {
    protected static boolean logging = false;
    protected String xpdlPrefix = "";

    public void setXPDLPrefixEnabled(boolean bl) {
        this.xpdlPrefix = bl ? "xpdl:" : "";
    }

    public boolean isXPDLPrefixEnabled() {
        return "xpdl:".equals(this.xpdlPrefix);
    }

    public void fromXML(Element element, Package package_) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        Namespaces namespaces = package_.getNamespaces();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            String string = node.getNodeName();
            if (!string.startsWith("xmlns:") || string.equals("xmlns:xsi")) continue;
            Namespace namespace = (Namespace)namespaces.generateNewElementWithXPDL1Support();
            namespace.setName(string.substring(6, string.length()));
            this.fromXML(node, (XMLAttribute)namespace.get("location"));
            namespaces.add(namespace);
        }
        this.fromXML((Node)element, (XMLComplexElement)package_);
        this.migrateToXPDL2(package_);
    }

    public void fromXML(Node node, XMLCollection xMLCollection) {
        if (node == null || !node.hasChildNodes()) {
            return;
        }
        String string = XMLUtil.getNameSpacePrefix(node);
        XMLElement xMLElement = xMLCollection.generateNewElementWithXPDL1Support();
        String string2 = xMLElement.toName();
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        if (logging) {
            System.out.println("FROMXML for " + xMLCollection.toName() + ", c=" + xMLCollection.getClass().getName());
        }
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string + string2)) continue;
            xMLElement = xMLCollection.generateNewElementWithXPDL1Support();
            if (xMLElement instanceof XMLComplexElement) {
                this.fromXML(nodeList.item(i), (XMLComplexElement)xMLElement);
            } else {
                this.fromXML(nodeList.item(i), (XMLSimpleElement)xMLElement);
            }
            xMLCollection.add(xMLElement);
        }
    }

    public void fromXML(Node node, XMLComplexElement xMLComplexElement) {
        Object object;
        int n;
        Iterator iterator;
        if (node == null || !node.hasChildNodes() && !node.hasAttributes()) {
            return;
        }
        String string = node.getPrefix();
        string = string != null ? string + ":" : "";
        if (logging) {
            System.out.println("FROMXML for " + xMLComplexElement.toName() + ", c=" + xMLComplexElement.getClass().getName());
        }
        if (node.hasAttributes()) {
            iterator = node.getAttributes();
            for (n = 0; n < iterator.getLength(); ++n) {
                object = iterator.item(n);
                try {
                    if (object.getNodeName().startsWith("xmlns") || object.getNodeName().startsWith("xsi:")) continue;
                    this.fromXML((Node)object, (XMLAttribute)xMLComplexElement.get(object.getNodeName()));
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    System.out.println("RTE while processing attrib " + object.getNodeName());
                }
            }
        }
        if (node.hasChildNodes()) {
            if (xMLComplexElement instanceof Condition && (iterator = node.getChildNodes().item(0).getNodeValue()) != null) {
                xMLComplexElement.setValue((String)((Object)iterator));
            }
            if (xMLComplexElement instanceof ExpressionType && (iterator = node.getChildNodes().item(0).getNodeValue()) != null) {
                xMLComplexElement.setValue((String)((Object)iterator));
            }
            if (xMLComplexElement instanceof SchemaType) {
                iterator = node.getChildNodes();
                for (n = 0; n < iterator.getLength(); ++n) {
                    object = iterator.item(n);
                    if (!(object instanceof Element)) continue;
                    xMLComplexElement.setValue(XMLUtil.getContent((Node)object, true));
                    break;
                }
            }
            if (xMLComplexElement instanceof ExtendedAttribute) {
                xMLComplexElement.setValue(XMLUtil.getChildNodesContent(node));
            }
            for (XMLElement xMLElement : xMLComplexElement.getXMLElements()) {
                Node node2;
                object = xMLElement.toName();
                if (xMLElement instanceof XMLComplexElement) {
                    node2 = XMLUtil.getChildByName(node, string + (String)object);
                    this.fromXML(node2, (XMLComplexElement)xMLElement);
                    continue;
                }
                if (xMLElement instanceof Deadlines || xMLElement instanceof WebServiceFaultCatchs || xMLElement instanceof Coordinatess || xMLElement instanceof NestedLanes) {
                    this.fromXML(node, (XMLCollection)xMLElement);
                    continue;
                }
                if (xMLElement instanceof XMLCollection) {
                    node2 = XMLUtil.getChildByName(node, string + (String)object);
                    this.fromXML(node2, (XMLCollection)xMLElement);
                    continue;
                }
                if (xMLElement instanceof XMLComplexChoice) {
                    this.fromXML(node, (XMLComplexChoice)xMLElement);
                    continue;
                }
                if (!(xMLElement instanceof XMLSimpleElement)) continue;
                node2 = XMLUtil.getChildByName(node, string + (String)object);
                this.fromXML(node2, (XMLSimpleElement)xMLElement);
            }
        }
    }

    public void fromXML(Node node, XMLComplexChoice xMLComplexChoice) {
        String string = XMLUtil.getNameSpacePrefix(node);
        ArrayList arrayList = xMLComplexChoice.getChoices();
        if (logging) {
            System.out.println("FROMXML for " + xMLComplexChoice.toName() + ", c=" + xMLComplexChoice.getClass().getName());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Node node2;
            XMLElement xMLElement = (XMLElement)arrayList.get(i);
            String string2 = xMLElement.toName();
            if (string2.equals("Tools")) {
                string2 = "Tool";
            }
            if (string2.equals("WebServiceFaultCatchs")) {
                string2 = "WebServiceFaultCatch";
            }
            if ((node2 = XMLUtil.getChildByName(node, string + string2)) == null) continue;
            if (xMLElement instanceof XMLComplexElement) {
                this.fromXML(node2, (XMLComplexElement)xMLElement);
            } else if (xMLElement instanceof Tools || xMLElement instanceof WebServiceFaultCatchs) {
                this.fromXML(node, (XMLCollection)xMLElement);
            } else {
                this.fromXML(node2, (XMLCollection)xMLElement);
            }
            xMLComplexChoice.setChoosen(xMLElement);
            break;
        }
    }

    public void fromXML(Node node, XMLSimpleElement xMLSimpleElement) {
        this.fromXMLBasic(node, xMLSimpleElement);
    }

    public void fromXML(Node node, XMLAttribute xMLAttribute) {
        this.fromXMLBasic(node, xMLAttribute);
    }

    public void fromXMLBasic(Node node, XMLElement xMLElement) {
        if (node != null) {
            String string;
            if (logging) {
                System.out.println("FROMXML for " + xMLElement.toName() + ", c=" + xMLElement.getClass().getName());
            }
            if (node.hasChildNodes()) {
                string = node.getChildNodes().item(0).getNodeValue();
                if (logging) {
                    System.out.println("11111");
                }
            } else {
                if (logging) {
                    System.out.println("22222");
                }
                string = node.getNodeValue();
            }
            if (logging) {
                System.out.println("NV=" + string);
            }
            if (string != null) {
                xMLElement.setValue(string);
            }
        }
    }

    public void toXML(Document document, Package package_) {
        Element element = document.createElement(this.xpdlPrefix + package_.toName());
        element.setAttribute("xmlns", "http://www.wfmc.org/2008/XPDL2.1");
        for (Namespace namespace : package_.getNamespaces().toElements()) {
            element.setAttribute("xmlns:" + namespace.getName(), namespace.getLocation());
        }
        element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttribute("xsi:schemaLocation", "http://www.wfmc.org/2008/XPDL2.1 http://www.wfmc.org/standards/docs/bpmnxpdl_31.xsd");
        this.toXML((Node)element, (XMLComplexElement)package_);
        document.appendChild(element);
    }

    public void toXML(Node node, XMLCollection xMLCollection) {
        if ((!xMLCollection.isEmpty() || xMLCollection.isRequired()) && node != null) {
            if (logging) {
                System.out.println("TOXML for " + xMLCollection.toName() + ", c=" + xMLCollection.getClass().getName() + ", parent=" + xMLCollection.getParent() + ", size=" + xMLCollection.size());
            }
            String string = xMLCollection.toName();
            Node node2 = node;
            if (!(string.equals("Deadlines") || string.equals("WebServiceFaultCatchs") || string.equals("NestedLanes") || string.equals("Coordinatess"))) {
                node2 = node.getOwnerDocument().createElement(this.xpdlPrefix + string);
            }
            for (XMLElement xMLElement : xMLCollection.toElements()) {
                if (xMLElement instanceof XMLSimpleElement) {
                    this.toXML(node2, (XMLSimpleElement)xMLElement);
                    continue;
                }
                this.toXML(node2, (XMLComplexElement)xMLElement);
            }
            if (node2 != node) {
                node.appendChild(node2);
            }
        }
    }

    public void toXML(Node node, XMLComplexElement xMLComplexElement) {
        if (xMLComplexElement.isEmpty() && !xMLComplexElement.isRequired()) {
            return;
        }
        if (node != null) {
            if (logging) {
                System.out.println("TOXML for " + xMLComplexElement.toName() + ", c=" + xMLComplexElement.getClass().getName() + ", parent=" + xMLComplexElement.getParent());
            }
            Node node2 = node;
            if (!(xMLComplexElement instanceof Package)) {
                node2 = node.getOwnerDocument().createElement(this.xpdlPrefix + xMLComplexElement.toName());
            }
            if (xMLComplexElement.toValue() != null && xMLComplexElement.toValue().length() > 0) {
                Object object;
                if (xMLComplexElement instanceof Condition && !xMLComplexElement.toValue().equals("")) {
                    object = node2.getOwnerDocument().createTextNode(xMLComplexElement.toValue());
                    node2.appendChild((Node)object);
                }
                if (xMLComplexElement instanceof ExpressionType && !xMLComplexElement.toValue().equals("")) {
                    object = node2.getOwnerDocument().createTextNode(xMLComplexElement.toValue());
                    node2.appendChild((Node)object);
                }
                if (xMLComplexElement instanceof SchemaType && (object = XMLUtil.parseSchemaNode(xMLComplexElement.toValue(), false)) != null) {
                    node2.appendChild(node2.getOwnerDocument().importNode((Node)object, true));
                }
                if (xMLComplexElement instanceof ExtendedAttribute) {
                    try {
                        object = XMLUtil.parseExtendedAttributeContent(xMLComplexElement.toValue());
                        Object object2 = object.getChildNodes();
                        for (int i = 0; i < object2.getLength(); ++i) {
                            node2.appendChild(node.getOwnerDocument().importNode(object2.item(i), true));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            for (Object object2 : xMLComplexElement.toElements()) {
                if (object2 instanceof XMLComplexElement) {
                    this.toXML(node2, (XMLComplexElement)object2);
                    continue;
                }
                if (object2 instanceof XMLCollection) {
                    this.toXML(node2, (XMLCollection)object2);
                    continue;
                }
                if (object2 instanceof XMLComplexChoice) {
                    this.toXML(node2, (XMLComplexChoice)object2);
                    continue;
                }
                if (object2 instanceof XMLSimpleElement) {
                    this.toXML(node2, (XMLSimpleElement)object2);
                    continue;
                }
                this.toXML(node2, (XMLAttribute)object2);
            }
            if (node2 != node) {
                node.appendChild(node2);
            }
        }
    }

    public void toXML(Node node, XMLComplexChoice xMLComplexChoice) {
        XMLElement xMLElement = xMLComplexChoice.getChoosen();
        if (logging) {
            System.out.println("TOXML for " + xMLComplexChoice.toName() + ", c=" + xMLComplexChoice.getClass().getName() + ", parent=" + xMLComplexChoice.getParent());
        }
        if (xMLElement != null) {
            if (xMLElement instanceof XMLComplexElement) {
                this.toXML(node, (XMLComplexElement)xMLElement);
            } else {
                this.toXML(node, (XMLCollection)xMLElement);
            }
        }
    }

    public void toXML(Node node, XMLSimpleElement xMLSimpleElement) {
        if ((!xMLSimpleElement.isEmpty() || xMLSimpleElement.isRequired()) && node != null) {
            if (logging) {
                System.out.println("TOXML for " + xMLSimpleElement.toName() + ", c=" + xMLSimpleElement.getClass().getName() + ", parent=" + xMLSimpleElement.getParent() + ", val=" + xMLSimpleElement.toValue());
            }
            Element element = node.getOwnerDocument().createElement(this.xpdlPrefix + xMLSimpleElement.toName());
            element.appendChild(node.getOwnerDocument().createTextNode(xMLSimpleElement.toValue().trim()));
            node.appendChild(element);
        }
    }

    public void toXML(Node node, XMLAttribute xMLAttribute) {
        if ((!xMLAttribute.isEmpty() || xMLAttribute.isRequired()) && node != null) {
            if (logging) {
                System.out.println("TOXML for " + xMLAttribute.toName() + ", c=" + xMLAttribute.getClass().getName() + ", parent=" + xMLAttribute.getParent() + ", val=" + xMLAttribute.toValue());
            }
            Attr attr = node.getOwnerDocument().createAttribute(xMLAttribute.toName());
            attr.setValue(xMLAttribute.toValue().trim());
            ((Element)node).setAttributeNode(attr);
        }
    }

    public void migrateToXPDL2(Package package_) {
        int n;
        Object object;
        Cloneable cloneable;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = package_.getWorkflowProcesses().toElements();
        for (int i = 0; i < arrayList2.size(); ++i) {
            WorkflowProcess workflowProcess = (WorkflowProcess)arrayList2.get(i);
            arrayList.addAll(workflowProcess.getActivities().toElements());
            cloneable = workflowProcess.getActivitySets().toElements();
            for (int j = 0; j < cloneable.size(); ++j) {
                object = (ActivitySet)cloneable.get(j);
                arrayList.addAll(((ActivitySet)object).getActivities().toElements());
            }
        }
        ArrayList arrayList3 = new ArrayList();
        for (n = 0; n < arrayList.size(); ++n) {
            cloneable = (Activity)arrayList.get(n);
            arrayList3.addAll(this.migrateGateways((Activity)cloneable));
        }
        arrayList.addAll(arrayList3);
        arrayList3.clear();
        for (n = 0; n < arrayList.size(); ++n) {
            cloneable = (Activity)arrayList.get(n);
            if (!(((Activity)cloneable).getActivityTypes().getChoosen() instanceof Implementation) || !(((Activity)cloneable).getActivityTypes().getImplementation().getImplementationTypes().getChoosen() instanceof Tools)) continue;
            arrayList3.addAll(this.migrateToolAct((Activity)cloneable));
        }
        arrayList.addAll(arrayList3);
        for (n = 0; n < arrayList.size(); ++n) {
            XMLElement xMLElement;
            cloneable = (Activity)arrayList.get(n);
            ((Activity)cloneable).getActivityTypes().getImplementation().getImplementationTypes().removeXPDL1Support();
            ArrayList arrayList4 = ((Activity)cloneable).getDeadlines().toElements();
            for (int i = 0; i < arrayList4.size(); ++i) {
                xMLElement = (Deadline)arrayList4.get(i);
                DeadlineCondition deadlineCondition = (DeadlineCondition)((XMLComplexElement)xMLElement).get("DeadlineCondition");
                if (!"".equals(deadlineCondition.toValue())) {
                    ((Deadline)xMLElement).setDeadlineDuration(deadlineCondition.toValue());
                }
                ((Deadline)xMLElement).removeXPDL1Support();
            }
            object = ((XMLComplexElement)cloneable).get("Performer").toValue();
            if (!"".equals(object)) {
                xMLElement = (Performer)((Activity)cloneable).getPerformers().generateNewElement();
                xMLElement.setValue((String)object);
                ((Activity)cloneable).getPerformers().add(xMLElement);
            }
            ((Activity)cloneable).removeXPDL1Support();
        }
        ArrayList arrayList5 = package_.getNamespaces().toElements();
        for (int i = 0; i < arrayList5.size(); ++i) {
            Namespace namespace = (Namespace)arrayList5.get(i);
            if (!"xpdl".equals(namespace.getName())) continue;
            namespace.setLocation("http://www.wfmc.org/2008/XPDL2.1");
        }
        this.migrateActivitySetIds(package_);
        this.migrateActivityIds(package_);
        XMLUtil.correctSplitsAndJoins(package_);
        package_.removeXPDL1Support();
    }

    protected List migrateToolAct(Activity activity) {
        ArrayList<Activity> arrayList = new ArrayList<Activity>();
        Tools tools = (Tools)activity.getActivityTypes().getImplementation().getImplementationTypes().getChoosen();
        if (tools.size() > 1) {
            XMLCollectionElement xMLCollectionElement3;
            String string = activity.getFinishMode();
            Set set = XMLUtil.getNonExceptionalOutgoingTransitions(activity);
            XMLCollectionElement xMLCollectionElement2 = null;
            for (XMLCollectionElement xMLCollectionElement3 : set) {
                if (!((Transition)xMLCollectionElement3).getFrom().equals(((Transition)xMLCollectionElement3).getTo())) continue;
                xMLCollectionElement2 = xMLCollectionElement3;
                break;
            }
            activity.setFinishModeNONE();
            xMLCollectionElement3 = activity;
            for (int i = 1; i < tools.size(); ++i) {
                Activity activity2 = this.splitActivity((Activity)xMLCollectionElement3, false, true);
                arrayList.add(activity2);
                xMLCollectionElement3 = activity2;
            }
            if (!string.equals("")) {
                xMLCollectionElement3.set("FinishMode", string);
            }
            if (xMLCollectionElement2 != null) {
                ((Transition)xMLCollectionElement2).setFrom(xMLCollectionElement3.getId());
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.handleTool((Activity)arrayList.get(i), (Tool)tools.get(i + 1));
        }
        this.handleTool(activity, (Tool)tools.get(0));
        return arrayList;
    }

    protected List migrateGateways(Activity activity) {
        String string;
        ArrayList<Activity> arrayList = new ArrayList<Activity>();
        int n = activity.getActivityType();
        Join join = XMLUtil.getJoin(activity);
        String string2 = join != null ? join.getType() : "";
        Split split = XMLUtil.getSplit(activity);
        Set set = XMLUtil.getNonExceptionalOutgoingTransitions(activity);
        String string3 = string = split != null && set.size() > 1 ? split.getType() : "";
        if (n == 0) {
            if (!(string.equals(string2) || string.equals("") || string2.equals(""))) {
                Activity activity2 = this.splitActivity(activity, true, true);
                arrayList.add(activity2);
            }
        } else {
            Activity activity3;
            Object object2;
            Transition transition = null;
            for (Object object2 : set) {
                if (!((Transition)object2).getFrom().equals(((Transition)object2).getTo())) continue;
                transition = object2;
                break;
            }
            object2 = null;
            String string4 = null;
            if (string2.equals("Parallel")) {
                activity3 = this.splitActivity(activity, true, false);
                arrayList.add(activity3);
                string4 = activity3.getId();
            }
            if (string.equals("Exclusive")) {
                activity3 = this.splitActivity(activity, true, true);
                arrayList.add(activity3);
                object2 = activity3.getId();
            }
            if (transition != null) {
                if (object2 != null) {
                    transition.setFrom((String)object2);
                }
                if (string4 != null) {
                    transition.setTo(string4);
                }
            }
        }
        return arrayList;
    }

    protected void handleTool(Activity activity, Tool tool) {
        activity.getActivityTypes().getImplementation().getImplementationTypes().setTask();
        activity.getActivityTypes().getImplementation().getImplementationTypes().getTask().getTaskTypes().setTaskApplication();
        TaskApplication taskApplication = activity.getActivityTypes().getImplementation().getImplementationTypes().getTask().getTaskTypes().getTaskApplication();
        taskApplication.setId(tool.getId());
        taskApplication.setDescription(tool.getDescription());
        ActualParameters actualParameters = taskApplication.getActualParameters();
        ArrayList arrayList = tool.getActualParameters().toElements();
        for (int i = 0; i < arrayList.size(); ++i) {
            ActualParameter actualParameter = (ActualParameter)arrayList.get(i);
            ActualParameter actualParameter2 = (ActualParameter)actualParameters.generateNewElement();
            actualParameter2.setValue(actualParameter.toValue());
            actualParameters.add(actualParameter2);
        }
    }

    protected void migrateActivitySetIds(Package package_) {
        ArrayList arrayList = new ArrayList();
        for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
            arrayList.addAll(workflowProcess.getActivitySets().toElements());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String[] stringArray;
            String string;
            Object object;
            ActivitySet activitySet = (ActivitySet)arrayList.get(i);
            boolean bl = XMLUtil.isIdUnique(activitySet, activitySet.getId());
            if (bl) continue;
            String string2 = XMLUtil.generateSimilarOrIdenticalUniqueId((ActivitySets)activitySet.getParent(), new HashSet(), activitySet.getId());
            List list = XMLUtil.getReferences(XMLUtil.getWorkflowProcess(activitySet), activitySet);
            for (int j = 0; j < list.size(); ++j) {
                object = (BlockActivity)list.get(j);
                ((BlockActivity)object).setActivitySetId(string2);
            }
            ExtendedAttributes extendedAttributes = XMLUtil.getWorkflowProcess(activitySet).getExtendedAttributes();
            object = "JaWE_GRAPH_START_OF_BLOCK";
            ArrayList arrayList2 = extendedAttributes.getElementsForName((String)object);
            object = "JaWE_GRAPH_END_OF_BLOCK";
            arrayList2.addAll(extendedAttributes.getElementsForName((String)object));
            for (ExtendedAttribute extendedAttribute : arrayList2) {
                int n;
                string = extendedAttribute.getVValue();
                stringArray = XMLUtil.tokenize(string, ",");
                String string3 = stringArray[0].substring((n = stringArray[0].indexOf("ACTIVITY_SET_ID=")) + "ACTIVITY_SET_ID=".length());
                if (!string3.equals(activitySet.getId())) continue;
                string = "ACTIVITY_SET_ID=" + string2 + string.substring(string.indexOf(","));
                extendedAttribute.setVValue(string);
            }
            arrayList2.clear();
            object = "JaWE_GRAPH_BLOCK_PARTICIPANT_ORDER";
            arrayList2.addAll(extendedAttributes.getElementsForName((String)object));
            for (ExtendedAttribute extendedAttribute : arrayList2) {
                string = extendedAttribute.getVValue();
                stringArray = XMLUtil.tokenize(string, ";");
                String string4 = stringArray[0];
                if (!string4.equals(activitySet.getId())) continue;
                string = string2 + string.substring(string.indexOf(";"));
                extendedAttribute.setVValue(string);
            }
            activitySet.setId(string2);
        }
    }

    protected void migrateActivityIds(Package package_) {
        Object object;
        int n;
        XMLBaseForCollectionAndComplex xMLBaseForCollectionAndComplex;
        ArrayList arrayList = new ArrayList();
        for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
            arrayList.addAll(workflowProcess.getActivities().toElements());
            xMLBaseForCollectionAndComplex = workflowProcess.getActivitySets();
            for (n = 0; n < xMLBaseForCollectionAndComplex.size(); ++n) {
                object = (ActivitySet)xMLBaseForCollectionAndComplex.get(n);
                arrayList.addAll(((ActivitySet)object).getActivities().toElements());
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string;
            Cloneable cloneable;
            xMLBaseForCollectionAndComplex = (Activity)arrayList.get(i);
            n = XMLUtil.isIdUnique((XMLCollectionElement)xMLBaseForCollectionAndComplex, ((XMLCollectionElement)xMLBaseForCollectionAndComplex).getId());
            if (n != 0) continue;
            object = XMLUtil.generateSimilarOrIdenticalUniqueId((Activities)xMLBaseForCollectionAndComplex.getParent(), new HashSet(), ((XMLCollectionElement)xMLBaseForCollectionAndComplex).getId());
            List list = XMLUtil.getReferences((Activity)xMLBaseForCollectionAndComplex);
            for (int j = 0; j < list.size(); ++j) {
                cloneable = (XMLAttribute)list.get(j);
                ((XMLAttribute)cloneable).setValue((String)object);
            }
            ExtendedAttributes extendedAttributes = XMLUtil.getWorkflowProcess(xMLBaseForCollectionAndComplex).getExtendedAttributes();
            cloneable = new ArrayList();
            if (xMLBaseForCollectionAndComplex.getParent().getParent() instanceof ActivitySet) {
                string = "JaWE_GRAPH_START_OF_BLOCK";
                cloneable.addAll(extendedAttributes.getElementsForName(string));
                string = "JaWE_GRAPH_END_OF_BLOCK";
                cloneable.addAll(extendedAttributes.getElementsForName(string));
            } else {
                string = "JaWE_GRAPH_START_OF_WORKFLOW";
                cloneable.addAll(extendedAttributes.getElementsForName(string));
                string = "JaWE_GRAPH_END_OF_WORKFLOW";
                cloneable.addAll(extendedAttributes.getElementsForName(string));
            }
            int n2 = xMLBaseForCollectionAndComplex.getParent().getParent() instanceof ActivitySet ? 2 : 1;
            Iterator iterator = cloneable.iterator();
            while (iterator.hasNext()) {
                int n3;
                ExtendedAttribute extendedAttribute = (ExtendedAttribute)iterator.next();
                String string2 = extendedAttribute.getVValue();
                String[] stringArray = XMLUtil.tokenize(string2, ",");
                String string3 = stringArray[n2].substring((n3 = stringArray[n2].indexOf("CONNECTING_ACTIVITY_ID=")) + "CONNECTING_ACTIVITY_ID=".length());
                if (!string3.equals(((XMLCollectionElement)xMLBaseForCollectionAndComplex).getId())) continue;
                String string4 = "";
                for (int j = 0; j < stringArray.length; ++j) {
                    string4 = j != n2 ? string4 + stringArray[j] : string4 + "CONNECTING_ACTIVITY_ID=" + (String)object;
                    if (j >= stringArray.length - 1) continue;
                    string4 = string4 + ",";
                }
                extendedAttribute.setVValue(string4);
            }
            ((XMLCollectionElement)xMLBaseForCollectionAndComplex).setId((String)object);
        }
    }

    protected Activity splitActivity(Activity activity, boolean bl, boolean bl2) {
        Iterator iterator;
        XMLComplexElement xMLComplexElement;
        XMLBaseForCollectionAndComplex xMLBaseForCollectionAndComplex;
        Activities activities = (Activities)activity.getParent();
        Activity activity2 = null;
        if (bl) {
            int n;
            activity2 = (Activity)activities.generateNewElementWithXPDL1Support();
            activity2.getActivityTypes().setRoute();
            for (n = 0; n < activity.getTransitionRestrictions().size(); ++n) {
                xMLBaseForCollectionAndComplex = (TransitionRestriction)activity.getTransitionRestrictions().get(n);
                xMLComplexElement = (TransitionRestriction)activity2.getTransitionRestrictions().generateNewElementWithXPDL1Support();
                xMLComplexElement.makeAs(xMLBaseForCollectionAndComplex);
                activity2.getTransitionRestrictions().add(xMLComplexElement);
            }
            for (n = 0; n < activity.getExtendedAttributes().size(); ++n) {
                xMLBaseForCollectionAndComplex = (ExtendedAttribute)activity.getExtendedAttributes().get(n);
                if (!((ExtendedAttribute)xMLBaseForCollectionAndComplex).getName().equals("JaWE_GRAPH_OFFSET") && !((ExtendedAttribute)xMLBaseForCollectionAndComplex).getName().equals("JaWE_GRAPH_PARTICIPANT_ID")) continue;
                xMLComplexElement = (ExtendedAttribute)activity2.getExtendedAttributes().generateNewElementWithXPDL1Support();
                ((ExtendedAttribute)xMLComplexElement).makeAs(xMLBaseForCollectionAndComplex);
                activity2.getExtendedAttributes().add(xMLComplexElement);
            }
        } else {
            activity2 = (Activity)activities.generateNewElementWithXPDL1Support();
            activity2.makeAs(activity);
            activity2.getDeadlines().clear();
            activity2.setStartModeNONE();
            activity2.setFinishModeNONE();
        }
        activity2.setId(XMLUtil.generateSimilarOrIdenticalUniqueId(activities, new HashSet(), activity.getId()));
        if (bl2) {
            iterator = XMLUtil.getJoin(activity2);
            xMLBaseForCollectionAndComplex = XMLUtil.getSplit(activity);
            if (iterator != null) {
                ((Join)((Object)iterator)).setTypeNONE();
                if (activity.getActivityType() == 0) {
                    activity.getActivityTypes().getRoute().getGatewayTypeAttribute().setValue(XMLUtil.getJoin(activity).getType());
                }
            }
            if (xMLBaseForCollectionAndComplex != null) {
                ((Split)xMLBaseForCollectionAndComplex).setTypeNONE();
            }
            if (activity2.getActivityType() == 0) {
                activity2.getActivityTypes().getRoute().getGatewayTypeAttribute().setValue(XMLUtil.getSplit(activity2).getType());
            }
        } else {
            iterator = XMLUtil.getSplit(activity2);
            xMLBaseForCollectionAndComplex = XMLUtil.getJoin(activity);
            if (iterator != null) {
                ((Split)((Object)iterator)).setTypeNONE();
                if (activity.getActivityType() == 0) {
                    activity.getActivityTypes().getRoute().getGatewayTypeAttribute().setValue(XMLUtil.getSplit(activity).getType());
                }
            }
            if (xMLBaseForCollectionAndComplex != null) {
                ((Join)xMLBaseForCollectionAndComplex).setTypeNONE();
            }
            if (activity2.getActivityType() == 0) {
                activity2.getActivityTypes().getRoute().getGatewayTypeAttribute().setValue(XMLUtil.getJoin(activity2).getType());
            }
        }
        activities.add(activity2);
        iterator = null;
        iterator = bl2 ? XMLUtil.getNonExceptionalOutgoingTransitions(activity).iterator() : XMLUtil.getIncomingTransitions(activity).iterator();
        while (iterator.hasNext()) {
            xMLBaseForCollectionAndComplex = (Transition)iterator.next();
            if (((Transition)xMLBaseForCollectionAndComplex).getFrom().equals(((Transition)xMLBaseForCollectionAndComplex).getTo())) continue;
            if (bl2) {
                ((Transition)xMLBaseForCollectionAndComplex).setFrom(activity2.getId());
                continue;
            }
            ((Transition)xMLBaseForCollectionAndComplex).setTo(activity2.getId());
        }
        xMLBaseForCollectionAndComplex = (Transitions)((XMLComplexElement)activities.getParent()).get("Transitions");
        xMLComplexElement = (Transition)((Transitions)xMLBaseForCollectionAndComplex).generateNewElement();
        ((XMLCollectionElement)xMLComplexElement).setId(XMLUtil.generateUniqueId((XMLCollection)xMLBaseForCollectionAndComplex, new HashSet()));
        if (bl2) {
            ((Transition)xMLComplexElement).setFrom(activity.getId());
            ((Transition)xMLComplexElement).setTo(activity2.getId());
        } else {
            ((Transition)xMLComplexElement).setFrom(activity2.getId());
            ((Transition)xMLComplexElement).setTo(activity.getId());
        }
        ((XMLCollection)xMLBaseForCollectionAndComplex).add(xMLComplexElement);
        return activity2;
    }
}

