/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jxpdl.elements;

import java.util.ArrayList;
import java.util.Iterator;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLInterface;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activities;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.ActivityTypes;
import org.enhydra.jxpdl.elements.Condition;
import org.enhydra.jxpdl.elements.Deadlines;
import org.enhydra.jxpdl.elements.Description;
import org.enhydra.jxpdl.elements.Documentation;
import org.enhydra.jxpdl.elements.Event;
import org.enhydra.jxpdl.elements.ExtendedAttributes;
import org.enhydra.jxpdl.elements.FinishMode;
import org.enhydra.jxpdl.elements.Icon;
import org.enhydra.jxpdl.elements.Implementation;
import org.enhydra.jxpdl.elements.Limit;
import org.enhydra.jxpdl.elements.NodeGraphicsInfos;
import org.enhydra.jxpdl.elements.Performer;
import org.enhydra.jxpdl.elements.Performers;
import org.enhydra.jxpdl.elements.Priority;
import org.enhydra.jxpdl.elements.Reference;
import org.enhydra.jxpdl.elements.Route;
import org.enhydra.jxpdl.elements.SimulationInformation;
import org.enhydra.jxpdl.elements.StartEvent;
import org.enhydra.jxpdl.elements.StartMode;
import org.enhydra.jxpdl.elements.SubFlow;
import org.enhydra.jxpdl.elements.Task;
import org.enhydra.jxpdl.elements.TaskManual;
import org.enhydra.jxpdl.elements.TaskReceive;
import org.enhydra.jxpdl.elements.TaskReference;
import org.enhydra.jxpdl.elements.TaskScript;
import org.enhydra.jxpdl.elements.TaskSend;
import org.enhydra.jxpdl.elements.TaskService;
import org.enhydra.jxpdl.elements.TaskUser;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.TransitionRestriction;
import org.enhydra.jxpdl.elements.TransitionRestrictions;
import org.enhydra.jxpdl.elements.Transitions;
import org.enhydra.jxpdl.elements.WorkflowProcess;

public class Activity
extends XMLCollectionElement {
    protected transient ArrayList outgoingTransitions;
    protected transient ArrayList incomingTransitions;
    protected transient ArrayList exceptionalOutgoingTransitions;
    protected transient ArrayList nonExceptionalOutgoingTransitions;
    protected transient ArrayList exceptionalIncomingTransitions;
    protected transient ArrayList nonExceptionalIncomingTransitions;

    public Activity(Activities activities, boolean bl) {
        super((XMLCollection)activities, true, bl);
    }

    @Override
    protected void fillStructure() {
        XMLAttribute xMLAttribute = new XMLAttribute((XMLElement)this, "Name", false);
        XMLAttribute xMLAttribute2 = new XMLAttribute(this, "StartMode", false, new String[]{"", "Automatic", "Manual"}, 0);
        XMLAttribute xMLAttribute3 = new XMLAttribute(this, "FinishMode", false, new String[]{"", "Automatic", "Manual"}, 0);
        Description description = new Description(this);
        Limit limit = new Limit(this);
        ActivityTypes activityTypes = new ActivityTypes(this);
        Performers performers = new Performers(this);
        Performer performer = new Performer(this);
        Priority priority = new Priority(this);
        Deadlines deadlines = new Deadlines(this, this.xpdl1support);
        SimulationInformation simulationInformation = new SimulationInformation(this);
        Icon icon = new Icon(this);
        Documentation documentation = new Documentation(this);
        TransitionRestrictions transitionRestrictions = new TransitionRestrictions(this);
        ExtendedAttributes extendedAttributes = new ExtendedAttributes(this);
        NodeGraphicsInfos nodeGraphicsInfos = new NodeGraphicsInfos(this);
        if (this.xpdl1support) {
            StartMode startMode = new StartMode(this);
            FinishMode finishMode = new FinishMode(this);
            this.add(startMode);
            this.add(finishMode);
        }
        super.fillStructure();
        this.add(xMLAttribute);
        this.add(xMLAttribute2);
        this.add(xMLAttribute3);
        this.add(description);
        this.add(limit);
        this.add(activityTypes);
        this.add(performers);
        if (this.xpdl1support) {
            this.add(performer);
        }
        this.add(priority);
        this.add(deadlines);
        this.add(simulationInformation);
        this.add(icon);
        this.add(documentation);
        this.add(transitionRestrictions);
        this.add(extendedAttributes);
        this.add(nodeGraphicsInfos);
    }

    @Override
    public void initCaches(XMLInterface xMLInterface) {
        super.initCaches(xMLInterface);
        Transitions transitions = this.getParent().getParent() instanceof WorkflowProcess ? ((WorkflowProcess)this.getParent().getParent()).getTransitions() : ((ActivitySet)this.getParent().getParent()).getTransitions();
        TransitionRestrictions transitionRestrictions = this.getTransitionRestrictions();
        ArrayList arrayList = null;
        arrayList = transitionRestrictions.size() > 0 ? ((TransitionRestriction)transitionRestrictions.get(0)).getSplit().getTransitionRefs().toElements() : new ArrayList();
        for (XMLCollectionElement xMLCollectionElement : arrayList) {
            Transition transition = transitions.getTransition(xMLCollectionElement.getId());
            this.outgoingTransitions.add(transition);
            this.putTransitionInTheRightList(transition, true);
        }
        for (XMLCollectionElement xMLCollectionElement : transitions.toElements()) {
            if (!this.outgoingTransitions.contains(xMLCollectionElement) && ((Transition)xMLCollectionElement).getFrom().equals(this.getId())) {
                this.outgoingTransitions.add(xMLCollectionElement);
                this.putTransitionInTheRightList((Transition)xMLCollectionElement, true);
            }
            if (!((Transition)xMLCollectionElement).getTo().equals(this.getId())) continue;
            this.incomingTransitions.add(xMLCollectionElement);
            this.putTransitionInTheRightList((Transition)xMLCollectionElement, false);
        }
    }

    @Override
    public void clearCaches() {
        this.clearInternalCaches();
        super.clearCaches();
    }

    protected void clearInternalCaches() {
        this.outgoingTransitions = new ArrayList();
        this.incomingTransitions = new ArrayList();
        this.exceptionalOutgoingTransitions = new ArrayList();
        this.nonExceptionalOutgoingTransitions = new ArrayList();
        this.exceptionalIncomingTransitions = new ArrayList();
        this.nonExceptionalIncomingTransitions = new ArrayList();
    }

    protected void putTransitionInTheRightList(Transition transition, boolean bl) {
        Condition condition = transition.getCondition();
        String string = condition.getType();
        if (string.equals("EXCEPTION") || string.equals("DEFAULTEXCEPTION")) {
            if (bl) {
                this.exceptionalOutgoingTransitions.add(transition);
            } else {
                this.exceptionalIncomingTransitions.add(transition);
            }
        } else if (bl) {
            this.nonExceptionalOutgoingTransitions.add(transition);
        } else {
            this.nonExceptionalIncomingTransitions.add(transition);
        }
    }

    public ArrayList getOutgoingTransitions() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.outgoingTransitions;
    }

    public ArrayList getIncomingTransitions() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.incomingTransitions;
    }

    public ArrayList getNonExceptionalOutgoingTransitions() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.nonExceptionalOutgoingTransitions;
    }

    public ArrayList getExceptionalOutgoingTransitions() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.exceptionalOutgoingTransitions;
    }

    public ArrayList getNonExceptionalIncomingTransitions() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.nonExceptionalIncomingTransitions;
    }

    public ArrayList getExceptionalIncomingTransitions() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.exceptionalIncomingTransitions;
    }

    public boolean isAndTypeSplit() {
        return XMLUtil.isANDTypeSplitOrJoin(this, 0);
    }

    public boolean isAndTypeJoin() {
        return XMLUtil.isANDTypeSplitOrJoin(this, 1);
    }

    public int getActivityStartMode() {
        return XMLUtil.getStartMode(this);
    }

    public int getActivityFinishMode() {
        return XMLUtil.getFinishMode(this);
    }

    public int getActivityType() {
        XMLElement xMLElement = this.getActivityTypes().getChoosen();
        if (xMLElement instanceof Route) {
            return 0;
        }
        if (xMLElement instanceof Implementation) {
            if ((xMLElement = ((Implementation)xMLElement).getImplementationTypes().getChoosen()) instanceof SubFlow) {
                return 3;
            }
            if (xMLElement instanceof Task) {
                XMLElement xMLElement2 = ((Task)xMLElement).getTaskTypes().getChoosen();
                if (xMLElement2 instanceof TaskService) {
                    return 8;
                }
                if (xMLElement2 instanceof TaskReceive) {
                    return 9;
                }
                if (xMLElement2 instanceof TaskManual) {
                    return 10;
                }
                if (xMLElement2 instanceof TaskReference) {
                    return 11;
                }
                if (xMLElement2 instanceof TaskScript) {
                    return 12;
                }
                if (xMLElement2 instanceof TaskSend) {
                    return 13;
                }
                if (xMLElement2 instanceof TaskUser) {
                    return 14;
                }
                return 2;
            }
            if (xMLElement instanceof Reference) {
                return 5;
            }
            return 1;
        }
        if (xMLElement instanceof Event) {
            XMLElement xMLElement3 = ((Event)xMLElement).getEventTypes().getChoosen();
            if (xMLElement3 instanceof StartEvent) {
                return 6;
            }
            return 7;
        }
        return 4;
    }

    public boolean isSubflowSynchronous() {
        if (this.getActivityType() != 3) {
            throw new RuntimeException("The activity type is not SubFlow!");
        }
        return XMLUtil.isSubflowSynchronous(this);
    }

    public String getName() {
        return this.get("Name").toValue();
    }

    public void setName(String string) {
        this.set("Name", string);
    }

    public String getStartMode() {
        return this.get("StartMode").toValue();
    }

    public void setStartModeNONE() {
        this.get("StartMode").setValue("");
    }

    public void setStartModeAUTOMATIC() {
        this.get("StartMode").setValue("Automatic");
    }

    public void setStartModeMANUAL() {
        this.get("StartMode").setValue("Manual");
    }

    public String getFinishMode() {
        return this.get("FinishMode").toValue();
    }

    public void setFinishModeNONE() {
        this.get("FinishMode").setValue("");
    }

    public void setFinishModeAUTOMATIC() {
        this.get("FinishMode").setValue("Automatic");
    }

    public void setFinishModeMANUAL() {
        this.get("FinishMode").setValue("Manual");
    }

    public Deadlines getDeadlines() {
        return (Deadlines)this.get("Deadlines");
    }

    public String getDescription() {
        return this.get("Description").toValue();
    }

    public void setDescription(String string) {
        this.set("Description", string);
    }

    public String getDocumentation() {
        return this.get("Documentation").toValue();
    }

    public void setDocumentation(String string) {
        this.set("Documentation", string);
    }

    public ExtendedAttributes getExtendedAttributes() {
        return (ExtendedAttributes)this.get("ExtendedAttributes");
    }

    public NodeGraphicsInfos getNodeGraphicsInfos() {
        return (NodeGraphicsInfos)this.get("NodeGraphicsInfos");
    }

    public String getIcon() {
        return this.get("Icon").toValue();
    }

    public void setIcon(String string) {
        this.set("Icon", string);
    }

    public String getLimit() {
        return this.get("Limit").toValue();
    }

    public void setLimit(String string) {
        this.set("Limit", string);
    }

    public Performers getPerformers() {
        return (Performers)this.get("Performers");
    }

    public String getFirstPerformer() {
        Iterator iterator = this.getPerformers().toElements().iterator();
        if (iterator.hasNext()) {
            Performer performer = (Performer)iterator.next();
            return performer.toValue();
        }
        return "";
    }

    public Performer getFirstPerformerObj() {
        Iterator iterator = this.getPerformers().toElements().iterator();
        if (iterator.hasNext()) {
            Performer performer = (Performer)iterator.next();
            return performer;
        }
        return null;
    }

    public Performer createFirstPerformerObj() {
        Performer performer = (Performer)this.getPerformers().generateNewElement();
        this.getPerformers().add(performer);
        return performer;
    }

    public void setFirstPerformer(String string) {
        Performer performer = this.getFirstPerformerObj();
        if (performer == null) {
            performer = this.createFirstPerformerObj();
        }
        performer.setValue(string);
    }

    public String getPriority() {
        return this.get("Priority").toValue();
    }

    public void setPriority(String string) {
        this.set("Priority", string);
    }

    public SimulationInformation getSimulationInformation() {
        return (SimulationInformation)this.get("SimulationInformation");
    }

    public TransitionRestrictions getTransitionRestrictions() {
        return (TransitionRestrictions)this.get("TransitionRestrictions");
    }

    public ActivityTypes getActivityTypes() {
        return (ActivityTypes)this.get("Type");
    }

    protected void removeStartFinishModes() {
        int n;
        StartMode startMode = null;
        FinishMode finishMode = null;
        for (n = 0; n < this.elements.size(); ++n) {
            Object e = this.elements.get(n);
            if (e instanceof StartMode) {
                startMode = (StartMode)e;
                continue;
            }
            if (!(e instanceof FinishMode)) continue;
            finishMode = (FinishMode)e;
        }
        if (startMode != null && (n = XMLUtil.indexOfXMLElementWithinList(this.elements, startMode)) >= 0) {
            this.elements.remove(n);
        }
        if (finishMode != null && (n = XMLUtil.indexOfXMLElementWithinList(this.elements, finishMode)) >= 0) {
            this.elements.remove(n);
        }
    }

    protected void removePerformer() {
        XMLElement xMLElement = this.get("Performer");
        if (xMLElement != null) {
            this.elements.remove(xMLElement);
            this.elementMap.remove("Performer");
        }
    }

    @Override
    public void removeXPDL1Support() {
        super.removeXPDL1Support();
        this.removePerformer();
        this.removeStartFinishModes();
    }
}

