/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jxpdl.elements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLInterface;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activities;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.ActivitySets;
import org.enhydra.jxpdl.elements.Application;
import org.enhydra.jxpdl.elements.Applications;
import org.enhydra.jxpdl.elements.DataField;
import org.enhydra.jxpdl.elements.DataFields;
import org.enhydra.jxpdl.elements.ExtendedAttributes;
import org.enhydra.jxpdl.elements.FormalParameter;
import org.enhydra.jxpdl.elements.FormalParameters;
import org.enhydra.jxpdl.elements.Participant;
import org.enhydra.jxpdl.elements.Participants;
import org.enhydra.jxpdl.elements.ProcessHeader;
import org.enhydra.jxpdl.elements.RedefinableHeader;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.Transitions;
import org.enhydra.jxpdl.elements.WorkflowProcesses;

public class WorkflowProcess
extends XMLCollectionElement {
    protected transient ArrayList startingActivities;
    protected transient ArrayList endingActivities;
    protected transient Map allVariables;

    public WorkflowProcess(WorkflowProcesses workflowProcesses) {
        super(workflowProcesses, true);
    }

    @Override
    protected void fillStructure() {
        XMLAttribute xMLAttribute = new XMLAttribute((XMLElement)this, "Name", false);
        XMLAttribute xMLAttribute2 = new XMLAttribute(this, "AccessLevel", false, new String[]{"", "PUBLIC", "PRIVATE"}, 0);
        ProcessHeader processHeader = new ProcessHeader(this);
        RedefinableHeader redefinableHeader = new RedefinableHeader(this);
        FormalParameters formalParameters = new FormalParameters(this);
        Participants participants = new Participants(this);
        Applications applications = new Applications(this);
        DataFields dataFields = new DataFields(this);
        ActivitySets activitySets = new ActivitySets(this);
        Activities activities = new Activities(this);
        Transitions transitions = new Transitions(this);
        ExtendedAttributes extendedAttributes = new ExtendedAttributes(this);
        super.fillStructure();
        this.add(xMLAttribute);
        this.add(xMLAttribute2);
        this.add(processHeader);
        this.add(redefinableHeader);
        this.add(formalParameters);
        this.add(participants);
        this.add(applications);
        this.add(dataFields);
        this.add(activitySets);
        this.add(activities);
        this.add(transitions);
        this.add(extendedAttributes);
    }

    @Override
    public void initCaches(XMLInterface xMLInterface) {
        super.initCaches(xMLInterface);
        this.getAllVariables();
        for (Activity activity : this.getActivities().toElements()) {
            Transition transition;
            ArrayList arrayList = activity.getIncomingTransitions();
            ArrayList arrayList2 = activity.getNonExceptionalOutgoingTransitions();
            if (arrayList.size() == 0) {
                this.startingActivities.add(activity);
            } else if (arrayList.size() == 1 && (transition = (Transition)arrayList.get(0)).getFrom().equals(transition.getTo())) {
                this.startingActivities.add(activity);
            }
            if (arrayList2.size() == 0) {
                this.endingActivities.add(activity);
                continue;
            }
            if (arrayList2.size() != 1 || !(transition = (Transition)arrayList2.get(0)).getFrom().equals(transition.getTo())) continue;
            this.endingActivities.add(activity);
        }
    }

    @Override
    public void clearCaches() {
        this.startingActivities = new ArrayList();
        this.endingActivities = new ArrayList();
        this.allVariables = new HashMap();
        super.clearCaches();
    }

    public ArrayList getStartingActivities() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.startingActivities;
    }

    public ArrayList getEndingActivities() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.endingActivities;
    }

    public Map getAllVariables() {
        if (this.allVariables == null || this.allVariables.size() == 0) {
            this.allVariables = new HashMap();
            for (XMLCollectionElement xMLCollectionElement : this.getDataFields().toElements()) {
                this.allVariables.put(xMLCollectionElement.getId(), xMLCollectionElement);
            }
            for (XMLCollectionElement xMLCollectionElement : XMLUtil.getPackage(this).getDataFields().toElements()) {
                if (this.allVariables.containsKey(xMLCollectionElement.getId())) continue;
                this.allVariables.put(xMLCollectionElement.getId(), xMLCollectionElement);
            }
            for (XMLCollectionElement xMLCollectionElement : this.getFormalParameters().toElements()) {
                if (this.allVariables.containsKey(xMLCollectionElement.getId())) continue;
                this.allVariables.put(xMLCollectionElement.getId(), xMLCollectionElement);
            }
        }
        Iterator iterator = new HashMap(this.allVariables);
        if (!this.isReadOnly) {
            this.allVariables.clear();
        }
        return iterator;
    }

    public Application getApplication(String string) {
        return this.getApplications().getApplication(string);
    }

    public Participant getParticipant(String string) {
        return this.getParticipants().getParticipant(string);
    }

    public DataField getDataField(String string) {
        return this.getDataFields().getDataField(string);
    }

    public FormalParameter getFormalParameter(String string) {
        return this.getFormalParameters().getFormalParameter(string);
    }

    public ActivitySet getActivitySet(String string) {
        return this.getActivitySets().getActivitySet(string);
    }

    public Activity getActivity(String string) {
        Activity activity;
        block1: {
            ActivitySet activitySet;
            activity = this.getActivities().getActivity(string);
            if (activity != null) break block1;
            Iterator iterator = this.getActivitySets().toElements().iterator();
            while (iterator.hasNext() && (activity = (activitySet = (ActivitySet)iterator.next()).getActivity(string)) == null) {
            }
        }
        return activity;
    }

    public Transition getTransition(String string) {
        Transition transition;
        block1: {
            ActivitySet activitySet;
            transition = this.getTransitions().getTransition(string);
            if (transition != null) break block1;
            Iterator iterator = this.getActivitySets().toElements().iterator();
            while (iterator.hasNext() && (transition = (activitySet = (ActivitySet)iterator.next()).getTransition(string)) == null) {
            }
        }
        return transition;
    }

    public String getName() {
        return this.get("Name").toValue();
    }

    public void setName(String string) {
        this.set("Name", string);
    }

    public XMLAttribute getAccessLevelAttribute() {
        return (XMLAttribute)this.get("AccessLevel");
    }

    public String getAccessLevel() {
        return this.getAccessLevelAttribute().toValue();
    }

    public void setAccessLevelNONE() {
        this.getAccessLevelAttribute().setValue("");
    }

    public void setAccessLevelPUBLIC() {
        this.getAccessLevelAttribute().setValue("PUBLIC");
    }

    public void setAccessLevelPRIVATE() {
        this.getAccessLevelAttribute().setValue("PRIVATE");
    }

    public Applications getApplications() {
        return (Applications)this.get("Applications");
    }

    public DataFields getDataFields() {
        return (DataFields)this.get("DataFields");
    }

    public ExtendedAttributes getExtendedAttributes() {
        return (ExtendedAttributes)this.get("ExtendedAttributes");
    }

    public ProcessHeader getProcessHeader() {
        return (ProcessHeader)this.get("ProcessHeader");
    }

    public Participants getParticipants() {
        return (Participants)this.get("Participants");
    }

    public RedefinableHeader getRedefinableHeader() {
        return (RedefinableHeader)this.get("RedefinableHeader");
    }

    public Activities getActivities() {
        return (Activities)this.get("Activities");
    }

    public Transitions getTransitions() {
        return (Transitions)this.get("Transitions");
    }

    public ActivitySets getActivitySets() {
        return (ActivitySets)this.get("ActivitySets");
    }

    public FormalParameters getFormalParameters() {
        return (FormalParameters)this.get("FormalParameters");
    }
}

