/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.wfxml;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.enhydra.jawe.JaWEConstants;
import org.enhydra.jawe.base.panel.panels.XMLBasicPanel;
import org.enhydra.jawe.components.wfxml.WfXML;

public class WfXMLComboPanel
extends XMLBasicPanel {
    private static final int MAX_URL_HISTORY_SIZE = 16;
    public static final String RURL_FILENAME = "/.rurls";
    private static String URL_HISTORY_FILE_PATH;
    private static ArrayList urls;
    protected JComboBox jcb;
    protected JButton jb;
    protected JLabel jl;
    protected Dimension textDim = new Dimension(250, 20);
    private static Dimension refButDimension;
    protected WfXML wfxml;

    public WfXMLComboPanel(WfXML wfXML, ActionListener actionListener) {
        super(null, null, "", false, false, true);
        this.wfxml = wfXML;
        this.jl = new JLabel(wfXML.getSettings().getLanguageDependentString("RegistryServiceURL") + ": ");
        this.jl.setAlignmentX(0.0f);
        this.jl.setAlignmentY(1.0f);
        this.jl.setHorizontalAlignment(2);
        if (URL_HISTORY_FILE_PATH == null) {
            URL_HISTORY_FILE_PATH = JaWEConstants.JAWE_USER_HOME + RURL_FILENAME;
            File file = new File(URL_HISTORY_FILE_PATH);
            if (file.exists()) {
                urls = (ArrayList)this.readFile(URL_HISTORY_FILE_PATH);
            }
            if (urls == null) {
                urls = new ArrayList();
            }
        }
        this.jcb = new JComboBox(new Vector(urls));
        if (urls.size() > 0) {
            this.jcb.setSelectedIndex(0);
        }
        this.jcb.setEditable(true);
        this.jcb.setAlignmentX(0.0f);
        this.jcb.setAlignmentY(1.0f);
        this.add(this.jl);
        this.add(Box.createHorizontalGlue());
        this.add(this.jcb);
        this.jb = new JButton(wfXML.getWfXMLSettings().getConnectImage());
        if (this.jb != null) {
            this.jb.setBorderPainted(false);
            this.jb.setAlignmentX(0.0f);
            this.jb.setAlignmentY(1.0f);
            this.jb.setMinimumSize(new Dimension(refButDimension));
            this.jb.setMaximumSize(new Dimension(refButDimension));
            this.jb.setPreferredSize(new Dimension(refButDimension));
            this.jb.setRolloverEnabled(true);
            this.jb.setContentAreaFilled(false);
            this.jb.setToolTipText(wfXML.getSettings().getLanguageDependentString("ConnectKey"));
            this.jb.addActionListener(actionListener);
            this.jb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)WfXMLComboPanel.this.jcb.getSelectedItem();
                    if (string != null) {
                        WfXMLComboPanel.this.addItemToCombo(string);
                    }
                }
            });
            this.add(this.jb);
        }
    }

    public String getSelectedItem() {
        try {
            Object object = this.jcb.getEditor().getItem();
            if (object != null) {
                return object.toString();
            }
            return "";
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public Object getValue() {
        return this.getSelectedItem();
    }

    public void cleanup() {
        this.jcb.removeAllItems();
        urls.clear();
        this.writeFile(urls, URL_HISTORY_FILE_PATH);
    }

    public JComboBox getComboBox() {
        return this.jcb;
    }

    protected void addItemToCombo(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        for (int i = 0; i < this.jcb.getItemCount(); ++i) {
            if (!this.jcb.getItemAt(i).toString().equals(string)) continue;
            this.jcb.removeItemAt(i);
            this.jcb.insertItemAt(string, 0);
            this.jcb.setSelectedIndex(0);
            urls.remove(i);
            urls.add(0, string);
            this.writeFile(urls, URL_HISTORY_FILE_PATH);
            this.wfxml.getSettings().adjustActions();
            return;
        }
        this.jcb.insertItemAt(string, 0);
        urls.add(0, string);
        if (this.jcb.getItemCount() > 16) {
            this.jcb.removeItemAt(16);
            urls.remove(16);
        }
        this.jcb.setSelectedIndex(0);
        this.writeFile(urls, URL_HISTORY_FILE_PATH);
        this.wfxml.getSettings().adjustActions();
    }

    private void writeFile(Object object, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Object readFile(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static {
        refButDimension = new Dimension(25, 20);
    }
}

