/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.packagenavigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.components.XPDLTreeCellRenderer;
import org.enhydra.jawe.components.XPDLTreeNode;
import org.enhydra.jawe.components.packagenavigator.PackageNavigator;
import org.enhydra.jawe.components.packagenavigator.PackageNavigatorTreeModel;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Activities;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.ActivitySets;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.Transitions;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.enhydra.jxpdl.elements.WorkflowProcesses;

public class PackageNavigatorPanel
extends JPanel
implements JaWEComponentView {
    protected PackageNavigatorTreeModel treeModel;
    protected JTree tree;
    protected JToolBar toolbar;
    protected JScrollPane scrollPane;
    protected PackageNavigator controller;
    protected int xClick;
    protected int yClick;
    protected MouseListener mouseListener;
    protected XPDLTreeCellRenderer renderer;

    public PackageNavigatorPanel(PackageNavigator packageNavigator) {
        this.controller = packageNavigator;
    }

    public void configure() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.toolbar = BarFactory.createToolbar((String)"defaultToolbar", (JaWEComponent)this.controller);
        this.toolbar.setFloatable(false);
        if (this.toolbar.getComponentCount() > 0) {
            this.add((Component)this.toolbar, "North");
        }
        this.init();
    }

    public void printTreeModel() {
        this.printTreeModel();
    }

    public void printTreeModel(XPDLTreeNode xPDLTreeNode) {
        System.err.println("There are " + xPDLTreeNode.getChildCount() + " children for " + xPDLTreeNode.getXPDLElement());
        for (int i = 0; i < xPDLTreeNode.getChildCount(); ++i) {
            this.printTreeModel((XPDLTreeNode)xPDLTreeNode.getChildAt(i));
        }
    }

    public void init() {
        this.controller.getSettings().adjustActions();
        this.treeModel = new PackageNavigatorTreeModel(this.controller);
        this.tree = new JTree((TreeModel)((Object)this.treeModel)){

            @Override
            public void scrollRectToVisible(Rectangle rectangle) {
                rectangle.x = PackageNavigatorPanel.this.scrollPane.getHorizontalScrollBar().getValue();
                super.scrollRectToVisible(rectangle);
            }
        };
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.renderer = new XPDLTreeCellRenderer((JaWEComponent)this.controller);
        Color color = this.controller.getNavigatorSettings().getBackGroundColor();
        this.renderer.setBackgroundNonSelectionColor(color);
        this.renderer.setBackgroundSelectionColor(this.controller.getNavigatorSettings().getSelectionColor());
        this.tree.setBackground(color);
        this.tree.setCellRenderer((TreeCellRenderer)this.renderer);
        this.tree.addTreeSelectionListener(this.controller);
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PackageNavigatorPanel.this.xClick = mouseEvent.getX();
                PackageNavigatorPanel.this.yClick = mouseEvent.getY();
                TreePath treePath = PackageNavigatorPanel.this.tree.getPathForLocation(PackageNavigatorPanel.this.xClick, PackageNavigatorPanel.this.yClick);
                if (treePath != null) {
                    Object object;
                    PackageNavigatorPanel.this.tree.setAnchorSelectionPath(treePath);
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        if (!PackageNavigatorPanel.this.tree.isPathSelected(treePath)) {
                            PackageNavigatorPanel.this.tree.setSelectionPath(treePath);
                        }
                        object = BarFactory.createPopupMenu((String)"default", (JaWEComponent)PackageNavigatorPanel.this.controller);
                        ((JPopupMenu)object).show(PackageNavigatorPanel.this.tree, mouseEvent.getX(), mouseEvent.getY());
                    }
                    object = (XPDLTreeNode)treePath.getLastPathComponent();
                    if (mouseEvent.getClickCount() > 1 && !SwingUtilities.isRightMouseButton(mouseEvent) && PackageNavigatorPanel.this.tree.getModel().isLeaf(object)) {
                        JaWEManager.getInstance().getJaWEController().getJaWEActions().getAction("EditProperties").actionPerformed(null);
                    }
                } else {
                    TreePath treePath2 = PackageNavigatorPanel.this.tree.getClosestPathForLocation(PackageNavigatorPanel.this.xClick, PackageNavigatorPanel.this.yClick);
                    Rectangle rectangle = PackageNavigatorPanel.this.tree.getPathBounds(treePath2);
                    if (rectangle == null || rectangle.y >= PackageNavigatorPanel.this.yClick || rectangle.y + rectangle.height <= PackageNavigatorPanel.this.yClick) {
                        JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection((XMLElement)null, false);
                        PackageNavigatorPanel.this.tree.clearSelection();
                    }
                }
                PackageNavigatorPanel.this.tree.getParent().requestFocus();
            }
        };
        this.tree.addMouseListener(this.mouseListener);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setViewportView(this.tree);
        JViewport jViewport = this.scrollPane.getViewport();
        jViewport.setScrollMode(1);
        this.scrollPane.setBackground(Color.lightGray);
        this.add((Component)this.scrollPane, "Center");
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public JTree getTree() {
        return this.tree;
    }

    public JaWEComponent getJaWEComponent() {
        return this.controller;
    }

    public JComponent getDisplay() {
        return this;
    }

    public Point getMouseClickLocation() {
        return new Point(this.xClick, this.yClick);
    }

    public void handleXPDLChangeEvent(XPDLElementChangeInfo xPDLElementChangeInfo) {
        int n = xPDLElementChangeInfo.getAction();
        XMLElement xMLElement = xPDLElementChangeInfo.getChangedElement();
        List list = xPDLElementChangeInfo.getChangedSubElements();
        this.tree.removeTreeSelectionListener(this.controller);
        if (n == 8) {
            this.tree.clearSelection();
        }
        if (n == 10) {
            this.renderer.setValidationErrors(xPDLElementChangeInfo.getChangedSubElements());
            this.tree.repaint();
        }
        if (xMLElement instanceof Activity || xMLElement instanceof Package || xMLElement instanceof WorkflowProcesses || xMLElement instanceof WorkflowProcess || xMLElement instanceof ActivitySets || xMLElement instanceof ActivitySet || xMLElement instanceof Activities || xMLElement instanceof Transitions && n == 8) {
            if (n == 3) {
                if (list != null && list.size() > 0) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        this.treeModel.insertNode((XMLElement)iterator.next());
                    }
                } else if (xMLElement instanceof Package) {
                    this.treeModel.insertNode(xMLElement);
                }
                if (xMLElement instanceof Package) {
                    this.controller.getSettings().adjustActions();
                }
            } else if (n == 5) {
                if (list != null && list.size() > 0) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        this.treeModel.removeNode((XMLElement)iterator.next());
                    }
                } else {
                    this.treeModel.removeNode(xMLElement);
                }
                if (this.treeModel.getRootNode().getChildCount() == 0) {
                    this.reinitialize();
                    return;
                }
            } else if (n == 8) {
                if (xMLElement != null) {
                    ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
                    if (list != null) {
                        arrayList.addAll(list);
                    }
                    if (arrayList.size() == 0) {
                        arrayList.add(xMLElement);
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        XMLElement xMLElement2 = (XMLElement)arrayList.get(i);
                        if (arrayList instanceof Transitions || arrayList instanceof Transition) continue;
                        XPDLTreeNode xPDLTreeNode = this.treeModel.findNode(xMLElement2);
                        TreePath treePath = null;
                        if (xPDLTreeNode != null) {
                            treePath = new TreePath(xPDLTreeNode.getPath());
                            this.tree.addSelectionPath(treePath);
                        }
                        if (treePath == null) continue;
                        this.tree.scrollPathToVisible(treePath);
                    }
                }
            } else if (n == 7) {
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                if (xMLElement instanceof XMLCollection) {
                    if (list != null) {
                        arrayList.addAll(list);
                        arrayList2.addAll((List)xPDLElementChangeInfo.getNewValue());
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        XMLElement xMLElement3 = (XMLElement)arrayList.get(i);
                        this.treeModel.repositionNode(xMLElement3, (Integer)arrayList2.get(i));
                    }
                }
            }
        }
        this.tree.addTreeSelectionListener(this.controller);
    }

    protected void reinitialize() {
        this.remove(this.scrollPane);
        this.treeModel.clearTree();
        this.tree.getSelectionModel().clearSelection();
        this.tree.removeMouseListener(this.mouseListener);
        this.tree.removeTreeSelectionListener(this.controller);
        this.tree.setCellRenderer(null);
        this.init();
    }

    public void setCurrentSelection() {
        List list = JaWEManager.getInstance().getJaWEController().getSelectionManager().getSelectedElements();
        for (int i = 0; i < list.size(); ++i) {
            XMLElement xMLElement = (XMLElement)list.get(i);
            if (!(xMLElement instanceof Package) && !(xMLElement instanceof WorkflowProcess) && !(xMLElement instanceof ActivitySet) && !(xMLElement instanceof Activity)) continue;
            XPDLTreeNode xPDLTreeNode = this.treeModel.findNode(xMLElement);
            TreePath treePath = null;
            if (xPDLTreeNode != null) {
                treePath = new TreePath(xPDLTreeNode.getPath());
                this.tree.addSelectionPath(treePath);
            }
            if (treePath == null) continue;
            this.tree.scrollPathToVisible(treePath);
        }
    }
}

