/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.problemsnavigator;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.components.problemsnavigator.ProblemsNavigatorPanel;
import org.enhydra.jawe.components.problemsnavigator.ProblemsNavigatorSettings;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Package;

public class ProblemsNavigator
implements Observer,
JaWEComponent {
    protected String type = "OTHER";
    protected ProblemsNavigatorPanel panel;
    protected boolean updateInProgress = false;
    protected ProblemsNavigatorSettings settings;

    public ProblemsNavigator(JaWEComponentSettings jaWEComponentSettings) throws Exception {
        this.settings = (ProblemsNavigatorSettings)jaWEComponentSettings;
        this.settings.init(this);
        this.init();
        JaWEManager.getInstance().getJaWEController().addObserver((Observer)this);
        JaWEManager.getInstance().getValidationOrSearchResultEditor().setValidationDisplayEnabled(false);
    }

    public JaWEComponentSettings getSettings() {
        return this.settings;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!(object instanceof XPDLElementChangeInfo)) {
            return;
        }
        XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)object;
        int n = xPDLElementChangeInfo.getAction();
        if (n != 10 && n != 8) {
            return;
        }
        long l = System.currentTimeMillis();
        JaWEManager.getInstance().getLoggingManager().info("ProblemsNavigator -> update for event " + xPDLElementChangeInfo + " started ...");
        this.update(xPDLElementChangeInfo);
        JaWEManager.getInstance().getLoggingManager().info("ProblemsNavigator -> update ended...");
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        JaWEManager.getInstance().getLoggingManager().debug("THE UPDATE OF SEARCH NAVIG COMPONENT LASTED FOR " + d + " SECONDS!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(XPDLElementChangeInfo xPDLElementChangeInfo) {
        if (this.updateInProgress) {
            return;
        }
        if (xPDLElementChangeInfo.getSource() == this) {
            return;
        }
        this.updateInProgress = true;
        try {
            if (xPDLElementChangeInfo.getAction() == 10) {
                boolean bl = false;
                if (xPDLElementChangeInfo.getNewValue() instanceof Boolean) {
                    bl = (Boolean)xPDLElementChangeInfo.getNewValue();
                }
                this.panel.refreshProblemsPanel(xPDLElementChangeInfo.getChangedElement(), xPDLElementChangeInfo.getChangedSubElements(), bl);
            } else {
                this.panel.refreshOnSelection(xPDLElementChangeInfo.getChangedElement());
            }
            this.settings.adjustActions();
        }
        finally {
            this.updateInProgress = false;
        }
    }

    public void cleanMatches() {
        this.panel.cleanup();
        this.settings.adjustActions();
    }

    public boolean hasMatches() {
        return this.panel.hasProblems();
    }

    protected void init() {
        this.panel = new ProblemsNavigatorPanel(this);
        this.panel.configure();
    }

    public JaWEComponentView getView() {
        return this.panel;
    }

    public JComponent getDisplay() {
        return this.panel.getDisplay();
    }

    public String getComponentType() {
        return this.type;
    }

    public void setComponentType(String string) {
        this.type = string;
    }

    public String getName() {
        return "ProblemsNavigator";
    }

    public boolean adjustXPDL(Package package_) {
        return false;
    }

    public List checkValidity(XMLElement xMLElement, boolean bl) {
        return null;
    }

    public boolean canCreateElement(XMLCollection xMLCollection) {
        return true;
    }

    public boolean canInsertElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canModifyElement(XMLElement xMLElement) {
        return true;
    }

    public boolean canRemoveElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canDuplicateElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canRepositionElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public void setUpdateInProgress(boolean bl) {
        this.updateInProgress = bl;
    }

    public boolean isUpdateInProgress() {
        return this.updateInProgress;
    }
}

