/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.base.controller.JaWEFrame;

public class JaWETabbedPane
extends JTabbedPane
implements MouseListener,
ActionListener {
    private boolean maximized = false;
    JMenuItem close;

    public JaWETabbedPane() {
        this.addMouseListener(this);
        this.close = new JMenuItem(ResourceManager.getLanguageDependentString("CloseLabel"));
        this.close.addActionListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 2) {
            if (this.maximized) {
                JaWEFrame jaWEFrame = JaWEManager.getInstance().getJaWEController().getJaWEFrame();
                jaWEFrame.restoreWorkingArea();
                this.maximized = false;
            } else {
                JaWEFrame jaWEFrame = JaWEManager.getInstance().getJaWEController().getJaWEFrame();
                jaWEFrame.maximizeComponent(this);
                this.maximized = true;
            }
        } else if (mouseEvent.getID() == 500 && SwingUtilities.isRightMouseButton(mouseEvent)) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(this.close);
            jPopupMenu.addSeparator();
            jPopupMenu.addSeparator();
            List list = JaWEManager.getInstance().getComponentManager().getComponents();
            for (int i = 0; i < list.size(); ++i) {
                JaWEComponent jaWEComponent = (JaWEComponent)list.get(i);
                if (jaWEComponent.getComponentType() == "UPPER_STATUS" || jaWEComponent.getComponentType() == "LOWER_STATUS") continue;
                JMenuItem jMenuItem = new JMenuItem();
                jMenuItem.setText(JaWEManager.getInstance().getJaWEController().getSettings().getLanguageDependentString("AddKey") + " " + JaWEManager.getInstance().getJaWEController().getSettings().getLanguageDependentString(jaWEComponent.getName() + "Label"));
                jMenuItem.setName(jaWEComponent.getName());
                jMenuItem.addActionListener(this);
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.close) {
            JComponent jComponent = (JComponent)this.getSelectedComponent();
            JaWEComponent jaWEComponent = this.findComponent(jComponent);
            JaWEManager.getInstance().getJaWEController().removeJaWEComonent(jaWEComponent);
        } else if (actionEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getName();
            JaWEComponent jaWEComponent = JaWEManager.getInstance().getComponentManager().getComponent(string);
            JaWEManager.getInstance().getJaWEController().changeJaWEComponentType(jaWEComponent, this.getName());
            this.setSelectedComponent(jaWEComponent.getView().getDisplay());
        }
    }

    protected JaWEComponent findComponent(JComponent jComponent) {
        List list = JaWEManager.getInstance().getComponentManager().getComponents();
        for (int i = 0; i < list.size(); ++i) {
            JaWEComponent jaWEComponent = (JaWEComponent)list.get(i);
            if (jaWEComponent.getView().getDisplay() != jComponent) continue;
            return jaWEComponent;
        }
        return null;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

