/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboPopup;
import org.enhydra.jawe.ChoiceButton;
import org.enhydra.jawe.ChoiceButtonListener;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.utilities.SequencedHashMap;

public class XMLElementChoiceButton2
extends ChoiceButton
implements ActionListener {
    protected ChoiceButtonListener parent;
    protected SequencedHashMap choiceMap = new SequencedHashMap();
    BasicComboPopup popup;
    JComboBox aList;
    protected Class choiceType;

    public XMLElementChoiceButton2(Class clazz, ChoiceButtonListener choiceButtonListener, ImageIcon imageIcon) {
        this.parent = choiceButtonListener;
        this.choiceType = clazz;
        this.aList = new JComboBox();
        this.aList.setRenderer(new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (bl) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                    if (-1 < n) {
                        Object e = XMLElementChoiceButton2.this.aList.getModel().getElementAt(n);
                        XMLElement xMLElement = null;
                        if (e != null) {
                            xMLElement = (XMLElement)XMLElementChoiceButton2.this.choiceMap.get(e);
                        }
                        String string = "";
                        string = xMLElement != null ? JaWEManager.getInstance().getTooltipGenerator().getTooltip(xMLElement) : super.getToolTipText();
                        jList.setToolTipText(string);
                    }
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
                this.setFont(jList.getFont());
                this.setText(object == null ? "" : object.toString());
                return this;
            }
        });
        this.popup = new BasicComboPopup(this.aList);
        this.aList.addActionListener(this);
        this.setIcon(imageIcon);
        this.addActionListener(this);
        this.setMargin(new Insets(1, 2, 1, 2));
        this.setSize(new Dimension(10, 8));
        this.setAlignmentY(0.5f);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this) {
            this.aList.removeActionListener(this);
            this.refresh();
            this.aList.addActionListener(this);
            if (this.choiceMap.size() > 0) {
                this.popup.show(this.getParent(), this.getX(), this.getY() + this.getHeight());
            }
        } else {
            Object object = this.aList.getSelectedItem();
            if (object != null) {
                Object object2 = this.choiceMap.get(object);
                this.parent.selectionChanged(this, object2);
            }
            this.choiceMap.clear();
            this.popup.hide();
        }
    }

    protected void refresh() {
        this.choiceMap.clear();
        this.aList.removeAllItems();
        List list = this.parent.getChoices(this);
        if (list != null) {
            for (String[] stringArray : list) {
                String string = " " + JaWEManager.getInstance().getDisplayNameGenerator().getDisplayName((XMLElement)stringArray) + " ";
                if (this.choiceMap.containsKey((Object)string) && stringArray instanceof XMLComplexElement) {
                    XMLElement xMLElement = ((XMLComplexElement)stringArray).get("Id");
                    string = string + "[" + ResourceManager.getLanguageDependentString("IdKey") + "=" + xMLElement.toValue() + "] ";
                }
                this.choiceMap.put((Object)string, (Object)stringArray);
            }
        }
        if (this.choiceMap.size() > 0) {
            String[] stringArray;
            ArrayList arrayList = new ArrayList(this.choiceMap.sequence());
            Collections.sort(arrayList);
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            for (int i = 0; i < this.choiceMap.size(); ++i) {
                this.aList.addItem(stringArray[i]);
            }
        }
    }

    @Override
    public Class getChoiceType() {
        return this.choiceType;
    }
}

