/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.controller;

import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import org.enhydra.jawe.ActionBase;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.ButtonPropertyChangedListener;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.base.controller.actions.defaultactions.Copy;
import org.enhydra.jawe.base.controller.actions.defaultactions.Cut;
import org.enhydra.jawe.base.controller.actions.defaultactions.Delete;
import org.enhydra.jawe.base.controller.actions.defaultactions.Duplicate;
import org.enhydra.jawe.base.controller.actions.defaultactions.EditProperties;
import org.enhydra.jawe.base.controller.actions.defaultactions.New;
import org.enhydra.jawe.base.controller.actions.defaultactions.Paste;
import org.enhydra.jawe.base.controller.actions.defaultactions.Redo;
import org.enhydra.jawe.base.controller.actions.defaultactions.Undo;
import org.enhydra.jxpdl.XMLUtil;

public class JaWEActions {
    public static final String EDIT_TOOLBAR = "jawe_edittoolbar";
    public static final String UNDO_REDO_TOOLBAR = "jawe_undoredo_toolbar";
    public static final String EDIT_MENU = "jawe_editmenu";
    public static final String NEW_ACTION = "New";
    public static final String DUPLICATE_ACTION = "Duplicate";
    public static final String REFERENCES = "References";
    public static final String UNDO_ACTION = "Undo";
    public static final String REDO_ACTION = "Redo";
    public static final String CUT_ACTION = "Cut";
    public static final String COPY_ACTION = "Copy";
    public static final String PASTE_ACTION = "Paste";
    public static final String DELETE_ACTION = "Delete";
    public static final String EDIT_PROPERTIES_ACTION = "EditProperties";
    protected JaWEController controller;
    protected Map commands = new HashMap();

    public JaWEActions(JaWEController jaWEController) {
        this.controller = jaWEController;
    }

    public void init() {
        Undo undo = new Undo(this.controller);
        Redo redo = new Redo(this.controller);
        Cut cut = new Cut(this.controller);
        Copy copy = new Copy(this.controller);
        Paste paste = new Paste(this.controller);
        Delete delete = new Delete(this.controller);
        EditProperties editProperties = new EditProperties(this.controller);
        New new_ = new New(this.controller);
        Duplicate duplicate = new Duplicate(this.controller);
        ActionBase actionBase = null;
        String string = "org.enhydra.jawe.base.controller.actions.defaultactions.References";
        try {
            actionBase = (ActionBase)Class.forName(string).getConstructor(JaWEComponent.class).newInstance(this.controller);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.commands.put(NEW_ACTION, new_);
        this.commands.put(DUPLICATE_ACTION, duplicate);
        this.commands.put(REFERENCES, actionBase);
        this.commands.put(UNDO_ACTION, undo);
        this.commands.put(REDO_ACTION, redo);
        this.commands.put(CUT_ACTION, cut);
        this.commands.put(COPY_ACTION, copy);
        this.commands.put(PASTE_ACTION, paste);
        this.commands.put(DELETE_ACTION, delete);
        this.commands.put(EDIT_PROPERTIES_ACTION, editProperties);
    }

    public Map getCommands() {
        return new HashMap(this.commands);
    }

    public ActionBase getAction(String string) {
        if (string == null) {
            return null;
        }
        return (ActionBase)this.commands.get(string);
    }

    public void disableAction(String string) {
        Action action = (Action)this.commands.get(string);
        if (action != null) {
            action.setEnabled(false);
        }
    }

    public void enableAction(String string) {
        Action action = (Action)this.commands.get(string);
        if (action != null) {
            action.setEnabled(true);
        }
    }

    public JButton getActionButton(String string) {
        Action action = (Action)this.commands.get(string);
        String string2 = string;
        if (action != null) {
            string2 = (String)action.getValue("Name");
        }
        JButton jButton = null;
        jButton = new JButton((Icon)this.controller.getControllerSettings().getIconFor(string)){

            @Override
            public float getAlignmentY() {
                return 0.5f;
            }
        };
        jButton.setName(string2);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        jButton.setRequestFocusEnabled(false);
        jButton.setActionCommand(string2);
        if (action != null) {
            jButton.addActionListener(action);
            jButton.setEnabled(action.isEnabled());
            action.addPropertyChangeListener(new ButtonPropertyChangedListener(jButton));
        } else {
            jButton.setEnabled(false);
        }
        String string3 = this.controller.getSettings().getLanguageDependentString(string2 + "Tooltip");
        if (string3 != null) {
            jButton.setToolTipText(string3);
        }
        return jButton;
    }

    public JMenuItem getActionMenuItem(String string, boolean bl) {
        String string2;
        Action action = (Action)this.commands.get(string);
        String string3 = string;
        if (action != null) {
            string3 = (String)action.getValue("Name");
        }
        if ((string2 = this.controller.getSettings().getLanguageDependentString(string3 + "Label")) == null) {
            string2 = string3;
        }
        JMenuItem jMenuItem = new JMenuItem(string2);
        jMenuItem.setName(string3);
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setIcon(this.controller.getControllerSettings().getIconFor(string));
        BarFactory.setAccelerator(jMenuItem, this.controller.getSettings().getLanguageDependentString(string3 + "Accel"));
        BarFactory.setMnemonic(jMenuItem, this.controller.getSettings().getLanguageDependentString(string3 + "Mnemonic"));
        jMenuItem.setActionCommand(string3);
        if (action != null) {
            jMenuItem.addActionListener(action);
            if (bl) {
                action.addPropertyChangeListener(new ButtonPropertyChangedListener(jMenuItem));
            }
            jMenuItem.setEnabled(action.isEnabled());
        } else {
            jMenuItem.setEnabled(false);
        }
        return jMenuItem;
    }

    public JToolBar getActionToolbar(String string) {
        if (string == null) {
            return null;
        }
        JToolBar jToolBar = new JToolBar();
        jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        if (string.equals(EDIT_TOOLBAR)) {
            String string2 = this.controller.getControllerSettings().getDefaultActionsEditOrder();
            String[] stringArray = XMLUtil.tokenize((String)string2, (String)" ");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-")) {
                    jToolBar.addSeparator();
                    continue;
                }
                JButton jButton = this.getActionButton(stringArray[i]);
                if (jButton == null) continue;
                jToolBar.add(jButton);
            }
            jToolBar.setName(this.controller.getSettings().getLanguageDependentString("editToolbarLabel"));
        } else if (string.equals(UNDO_REDO_TOOLBAR)) {
            jToolBar.add(this.getActionButton(UNDO_ACTION));
            jToolBar.add(this.getActionButton(REDO_ACTION));
        }
        return jToolBar;
    }

    public JMenu getActionMenu(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        JMenu jMenu = new JMenu();
        if (string.equals(EDIT_MENU)) {
            jMenu.setText(this.controller.getSettings().getLanguageDependentString("editLabel"));
            BarFactory.setMnemonic(jMenu, this.controller.getSettings().getLanguageDependentString("editMnemonic"));
            String string2 = this.controller.getControllerSettings().getDefaultActionsEditOrder();
            String[] stringArray = XMLUtil.tokenize((String)string2, (String)" ");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-")) {
                    jMenu.addSeparator();
                    continue;
                }
                JMenuItem jMenuItem = this.getActionMenuItem(stringArray[i], bl);
                if (jMenuItem == null) continue;
                jMenu.add(jMenuItem);
            }
        }
        return jMenu;
    }

    public void enableDisableActions() {
        for (ActionBase actionBase : this.commands.values()) {
            if (actionBase == null) continue;
            actionBase.enableDisableAction();
        }
    }
}

