/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.controller;

import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.base.controller.JaWEType;
import org.enhydra.jawe.base.controller.JaWETypes;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Activities;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.ActivitySets;
import org.enhydra.jxpdl.elements.ActualParameter;
import org.enhydra.jxpdl.elements.Application;
import org.enhydra.jxpdl.elements.Applications;
import org.enhydra.jxpdl.elements.Artifact;
import org.enhydra.jxpdl.elements.Artifacts;
import org.enhydra.jxpdl.elements.Association;
import org.enhydra.jxpdl.elements.Associations;
import org.enhydra.jxpdl.elements.DataField;
import org.enhydra.jxpdl.elements.DataFields;
import org.enhydra.jxpdl.elements.Deadline;
import org.enhydra.jxpdl.elements.EnumerationValue;
import org.enhydra.jxpdl.elements.ExtendedAttribute;
import org.enhydra.jxpdl.elements.ExternalPackage;
import org.enhydra.jxpdl.elements.ExternalPackages;
import org.enhydra.jxpdl.elements.FormalParameter;
import org.enhydra.jxpdl.elements.FormalParameters;
import org.enhydra.jxpdl.elements.Lane;
import org.enhydra.jxpdl.elements.Lanes;
import org.enhydra.jxpdl.elements.Member;
import org.enhydra.jxpdl.elements.Namespace;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.Participant;
import org.enhydra.jxpdl.elements.Participants;
import org.enhydra.jxpdl.elements.Pool;
import org.enhydra.jxpdl.elements.Pools;
import org.enhydra.jxpdl.elements.Responsible;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.Transitions;
import org.enhydra.jxpdl.elements.TypeDeclaration;
import org.enhydra.jxpdl.elements.TypeDeclarations;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.enhydra.jxpdl.elements.WorkflowProcesses;

public class JaWETypeResolver {
    protected JaWEController jc;
    protected JaWETypes jts;

    public JaWETypeResolver(JaWEController jaWEController) {
        this.jc = jaWEController;
        this.jts = jaWEController.getJaWETypes();
    }

    public JaWEType getJaWEType(XMLElement xMLElement) {
        JaWEType jaWEType = this.jts.compareToTemplate(xMLElement);
        if (jaWEType != null) {
            return jaWEType;
        }
        if (xMLElement instanceof Activity) {
            Activity activity = (Activity)xMLElement;
            if (activity.getActivityType() == 1) {
                jaWEType = this.jts.getType("ACTIVITY_NO");
            } else if (activity.getActivityType() == 2) {
                jaWEType = this.jts.getType("ACTIVITY_TASK_APPLICATION");
            } else if (activity.getActivityType() == 12) {
                jaWEType = this.jts.getType("ACTIVITY_TASK_SCRIPT");
            } else if (activity.getActivityType() == 4) {
                jaWEType = this.jts.getType("ACTIVITY_BLOCK");
            } else if (activity.getActivityType() == 0) {
                jaWEType = activity.getActivityTypes().getRoute().getGatewayType().equals("Parallel") ? this.jts.getType("ACTIVITY_ROUTE_PARALLEL") : (activity.getActivityTypes().getRoute().getGatewayType().equals("Inclusive") ? this.jts.getType("ACTIVITY_ROUTE_INCLUSIVE") : this.jts.getType("ACTIVITY_ROUTE_EXCLUSIVE"));
            } else if (activity.getActivityType() == 3) {
                jaWEType = this.jts.getType("ACTIVITY_SUBFLOW");
            } else if (activity.getActivityType() == 6) {
                jaWEType = this.jts.getType("ACTIVITY_START");
            } else if (activity.getActivityType() == 7) {
                jaWEType = this.jts.getType("ACTIVITY_END");
            }
        } else if (xMLElement instanceof ActivitySet) {
            jaWEType = this.jts.getType("ACTIVITYSET_DEFAULT");
        } else if (xMLElement instanceof Activities) {
            jaWEType = this.jts.getType("ACTIVITIES");
        } else if (xMLElement instanceof ActivitySets) {
            jaWEType = this.jts.getType("ACTIVITYSETS");
        } else if (xMLElement instanceof ActualParameter) {
            jaWEType = this.jts.getType("ACTUALPARAMETER_DEFAULT");
        } else if (xMLElement instanceof Application) {
            jaWEType = this.jts.getType("APPLICATION_DEFAULT");
        } else if (xMLElement instanceof Applications) {
            jaWEType = this.jts.getType("APPLICATIONS");
        } else if (xMLElement instanceof Artifact) {
            Artifact artifact = (Artifact)xMLElement;
            jaWEType = artifact.getArtifactType().equals("DataObject") ? this.jts.getType("ARTIFACT_DATA_OBJECT") : this.jts.getType("ARTIFACT_ANNOTATION");
        } else if (xMLElement instanceof Artifacts) {
            jaWEType = this.jts.getType("ARTIFACTS");
        } else if (xMLElement instanceof Association) {
            jaWEType = this.jts.getType("ASSOCIATION_DEFAULT");
        } else if (xMLElement instanceof Associations) {
            jaWEType = this.jts.getType("ASSOCIATIONS");
        } else if (xMLElement instanceof DataFields) {
            jaWEType = this.jts.getType("DATAFIELDS");
        } else if (xMLElement instanceof DataField) {
            jaWEType = this.jts.getType("DATAFIELD_DEFAULT");
        } else if (xMLElement instanceof Deadline) {
            jaWEType = this.jts.getType("DEADLINE_DEFAULT");
        } else if (xMLElement instanceof EnumerationValue) {
            jaWEType = this.jts.getType("ENUMERATIONVALUE_DEFAULT");
        } else if (xMLElement instanceof ExtendedAttribute) {
            jaWEType = this.jts.getType("EXTENDEDATTRIBUTE_DEFAULT");
        } else if (xMLElement instanceof ExternalPackage) {
            jaWEType = this.jts.getType("EXTERNALPACKAGE_DEFAULT");
        } else if (xMLElement instanceof ExternalPackages) {
            jaWEType = this.jts.getType("EXTERNALPACKAGES");
        } else if (xMLElement instanceof FormalParameter) {
            jaWEType = this.jts.getType("FORMALPARAMETER_DEFAULT");
        } else if (xMLElement instanceof FormalParameters) {
            jaWEType = this.jts.getType("FORMALPARAMETERS");
        } else if (xMLElement instanceof Lane) {
            jaWEType = this.jts.getType("LANE_DEFAULT");
        } else if (xMLElement instanceof Lanes) {
            jaWEType = this.jts.getType("LANES");
        } else if (xMLElement instanceof Member) {
            jaWEType = this.jts.getType("MEMBER_DEFAULT");
        } else if (xMLElement instanceof Namespace) {
            jaWEType = this.jts.getType("NAMESPACE_DEFAULT");
        } else if (xMLElement instanceof Package) {
            Package package_ = (Package)xMLElement;
            if (package_ == this.jc.getMainPackage()) {
                jaWEType = this.jts.getType("PACKAGE_DEFAULT");
            }
            if (jaWEType == null && !package_.isTransient()) {
                jaWEType = this.jts.getType("PACKAGE_EXTERNAL");
            }
            if (jaWEType == null) {
                jaWEType = this.jts.getType("PACKAGE_TRANSIENT");
            }
        } else if (xMLElement instanceof Participant) {
            Participant participant = (Participant)xMLElement;
            if (participant.getParticipantType().getType().equals("HUMAN")) {
                jaWEType = this.jts.getType("PARTICIPANT_HUMAN");
            } else if (participant.getParticipantType().getType().equals("ROLE")) {
                jaWEType = this.jts.getType("PARTICIPANT_ROLE");
            } else if (participant.getParticipantType().getType().equals("ORGANIZATIONAL_UNIT")) {
                jaWEType = this.jts.getType("PARTICIPANT_ORGANIZATIONAL_UNIT");
            } else if (participant.getParticipantType().getType().equals("RESOURCE")) {
                jaWEType = this.jts.getType("PARTICIPANT_RESOURCE");
            } else if (participant.getParticipantType().getType().equals("RESOURCE_SET")) {
                jaWEType = this.jts.getType("PARTICIPANT_RESOURCE_SET");
            } else if (participant.getParticipantType().getType().equals("SYSTEM")) {
                jaWEType = this.jts.getType("PARTICIPANT_SYSTEM");
            }
        } else if (xMLElement instanceof Participants) {
            jaWEType = this.jts.getType("PARTICIPANTS");
        } else if (xMLElement instanceof Responsible) {
            jaWEType = this.jts.getType("RESPONSIBLE_DEFAULT");
        } else if (xMLElement instanceof Pool) {
            jaWEType = this.jts.getType("POOL_DEFAULT");
        } else if (xMLElement instanceof Pools) {
            jaWEType = this.jts.getType("POOLS");
        } else if (xMLElement instanceof Transition) {
            Transition transition = (Transition)xMLElement;
            if (transition.getCondition().getType().equals("")) {
                jaWEType = this.jts.getType("TRANSITION_UNCONDITIONAL");
            } else if (transition.getCondition().getType().equals("CONDITION")) {
                jaWEType = this.jts.getType("TRANSITION_CONDITIONAL");
            } else if (transition.getCondition().getType().equals("OTHERWISE")) {
                jaWEType = this.jts.getType("TRANSITION_OTHERWISE");
            } else if (transition.getCondition().getType().equals("EXCEPTION")) {
                jaWEType = this.jts.getType("TRANSITION_EXCEPTION");
            } else if (transition.getCondition().getType().equals("DEFAULTEXCEPTION")) {
                jaWEType = this.jts.getType("TRANSITION_DEFAULTEXCEPTION");
            }
        } else if (xMLElement instanceof Transitions) {
            jaWEType = this.jts.getType("TRANSITIONS");
        } else if (xMLElement instanceof TypeDeclaration) {
            jaWEType = this.jts.getType("TYPEDECLARATION_DEFAULT");
        } else if (xMLElement instanceof TypeDeclarations) {
            jaWEType = this.jts.getType("TYPEDECLARATIONS");
        } else if (xMLElement instanceof WorkflowProcess) {
            jaWEType = this.jts.getType("WORKFLOWPROCESS_DEFAULT");
        } else if (xMLElement instanceof WorkflowProcesses) {
            jaWEType = this.jts.getType("WORKFLOWPROCESSES");
        }
        if (jaWEType == null) {
            jaWEType = this.jts.getType(this.jts.getDefaultType(xMLElement));
        }
        return jaWEType;
    }
}

