/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.editor;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.base.editor.StandardXPDLElementEditorSettings;
import org.enhydra.jawe.base.editor.XPDLElementEditor;
import org.enhydra.jawe.base.panel.InlinePanel;
import org.enhydra.jawe.base.panel.panels.XMLPanel;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Package;

public class StandardXPDLElementEditor
extends JDialog
implements XPDLElementEditor {
    protected String type = "OTHER";
    public static final int STATUS_OK = 0;
    public static final int STATUS_CANCEL = 1;
    protected boolean isModified = false;
    protected Properties properties = new Properties();
    protected XPDLElementEditor parentEditor;
    protected XMLElement originalElement;
    protected JButton buttonOK;
    protected JButton buttonCancel;
    protected int status = 0;
    protected InlinePanel inlinePanel;
    protected boolean undoableChange = false;
    private StandardXPDLElementEditorSettings settings;
    protected WindowListener wl = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            StandardXPDLElementEditor.this.close();
        }
    };
    JDialog dialog = this;
    protected ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StandardXPDLElementEditor.this.close();
        }
    };
    protected ActionListener okl = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (StandardXPDLElementEditor.this.inlinePanel.getViewPanel().getOwner().isReadOnly()) {
                StandardXPDLElementEditor.this.status = 1;
                StandardXPDLElementEditor.this.dispose();
            } else if (StandardXPDLElementEditor.this.canApplyChanges()) {
                StandardXPDLElementEditor.this.applyChanges();
                StandardXPDLElementEditor.this.status = 0;
                StandardXPDLElementEditor.this.dispose();
                if (StandardXPDLElementEditor.this.parentEditor != null) {
                    StandardXPDLElementEditor.this.parentEditor.setModified(true);
                }
            }
        }
    };

    @Override
    public void configure() {
    }

    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    @Override
    public JaWEComponentSettings getSettings() {
        return this.settings;
    }

    public StandardXPDLElementEditor() {
        super((Frame)JaWEManager.getInstance().getJaWEController().getJaWEFrame(), true);
        this.settings = new StandardXPDLElementEditorSettings();
        this.init();
    }

    public StandardXPDLElementEditor(boolean bl) {
        super((Frame)JaWEManager.getInstance().getJaWEController().getJaWEFrame(), true);
        this.settings = new StandardXPDLElementEditorSettings();
        this.undoableChange = bl;
        this.init();
    }

    public StandardXPDLElementEditor(StandardXPDLElementEditor standardXPDLElementEditor) {
        super((Dialog)standardXPDLElementEditor, true);
        this.settings = new StandardXPDLElementEditorSettings();
        this.init();
    }

    protected void init() {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.inlinePanel = (InlinePanel)classLoader.loadClass(JaWEManager.getInstance().getInlinePanelClassName()).newInstance();
        }
        catch (Exception exception) {
            String string = "StandardXPDLElementEditor --> Problems while instantiating InlinePanel class '" + JaWEManager.getInstance().getInlinePanelClassName() + "' - using default implementation!";
            JaWEManager.getInstance().getLoggingManager().error(string, exception);
            this.inlinePanel = new InlinePanel();
        }
        try {
            this.inlinePanel.setJaWEComponent(this);
            this.settings.init(this);
            this.inlinePanel.init();
            this.initDialog();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getLanguageDependentString(String string) {
        return ResourceManager.getLanguageDependentString(string);
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
    }

    @Override
    public XPDLElementEditor getParentEditor() {
        return this.parentEditor;
    }

    public XMLPanel getEditingPanel() {
        return this.inlinePanel.getViewPanel();
    }

    @Override
    public XMLElement getEditingElement() {
        return this.originalElement;
    }

    @Override
    public void editXPDLElement(XMLElement xMLElement) {
        this.inlinePanel.setActiveElement(xMLElement);
        if (xMLElement != null) {
            String string = this.getEditingPanel().getTitle();
            if (string == null || string.equals("")) {
                string = JaWEManager.getInstance().getLabelGenerator().getLabel(xMLElement);
            }
            this.setTitle(string);
        }
        this.setSize(this.inlinePanel.getDisplay().getSize());
        this.pack();
        this.setLocationRelativeTo(this.getParentWindow());
        this.setVisible(true);
    }

    @Override
    public void editXPDLElement() {
        this.editXPDLElement(JaWEManager.getInstance().getJaWEController().getSelectionManager().getSelectedElement());
    }

    @Override
    public boolean canApplyChanges() {
        return this.inlinePanel.canApplyChanges();
    }

    public void applyChanges() {
        XMLElement xMLElement = this.inlinePanel.getActiveElement();
        JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
        if (this.undoableChange) {
            jaWEController.startUndouableChange();
        }
        this.inlinePanel.apply();
        if (this.undoableChange) {
            ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
            arrayList.add(xMLElement);
            jaWEController.endUndouableChange(arrayList);
        }
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public Window getWindow() {
        return this;
    }

    @Override
    public Window getParentWindow() {
        if (this.parentEditor == null) {
            return JaWEManager.getInstance().getJaWEController().getJaWEFrame();
        }
        return this.parentEditor.getWindow();
    }

    protected void initDialog() {
        try {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setAlignmentX(0.0f);
            jPanel.setAlignmentY(0.0f);
            this.buttonOK = new JButton(this.getLanguageDependentString("OKKey"));
            this.buttonCancel = new JButton(this.getLanguageDependentString("CancelKey"));
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(this.buttonOK);
            jPanel.add(Box.createHorizontalStrut(4));
            jPanel.add(this.buttonCancel);
            jPanel.add(Box.createHorizontalStrut(4));
            Container container = this.getContentPane();
            container.setLayout(new BoxLayout(container, 1));
            container.add(this.inlinePanel);
            container.add(Box.createVerticalStrut(5));
            container.add(jPanel);
            this.buttonOK.addActionListener(this.okl);
            this.buttonCancel.addActionListener(this.al);
            this.addWindowListener(this.wl);
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "Cancel");
            this.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StandardXPDLElementEditor.this.al.actionPerformed(actionEvent);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
        this.buttonOK.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
    }

    @Override
    public void close() {
        int n;
        if ((this.inlinePanel.isModified() || this.isModified) && this.properties.getProperty("XPDLElementEditor.ConfirmCancelOnDataChange", "true").equals("true") && (n = JOptionPane.showConfirmDialog(this.dialog, this.getLanguageDependentString("WarningReallyQuit"), "", 0, 2)) == 1) {
            return;
        }
        this.status = 1;
        this.dispose();
    }

    @Override
    public void setModified(boolean bl) {
        this.isModified = true;
    }

    @Override
    public JaWEComponentView getView() {
        return this.inlinePanel;
    }

    public JComponent getDisplay() {
        return this.inlinePanel.getDisplay();
    }

    @Override
    public String getComponentType() {
        return this.type;
    }

    @Override
    public void setComponentType(String string) {
        this.type = string;
    }

    @Override
    public String getName() {
        return "STANDARD_XPDL_EDITOR";
    }

    @Override
    public boolean adjustXPDL(Package package_) {
        return false;
    }

    @Override
    public List checkValidity(XMLElement xMLElement, boolean bl) {
        return null;
    }

    @Override
    public boolean canCreateElement(XMLCollection xMLCollection) {
        return true;
    }

    @Override
    public boolean canInsertElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canModifyElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canModifyElement(XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canRemoveElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canDuplicateElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canRepositionElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setUpdateInProgress(boolean bl) {
    }

    @Override
    public boolean isUpdateInProgress() {
        return false;
    }
}

