/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.base.editor.TableEditor;
import org.enhydra.jawe.base.editor.TableEditorSettings;
import org.enhydra.jawe.base.panel.panels.XMLSimpleTablePanel;
import org.enhydra.jawe.base.panel.panels.XMLSimpleTableSelPanel;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;

public class TogWETableEditor
extends TableEditor
implements Observer {
    protected boolean updateInProgress = false;

    public TogWETableEditor(TableEditorSettings tableEditorSettings) {
        super(tableEditorSettings);
        this.setModal(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable observable, Object object) {
        if (!(object instanceof XPDLElementChangeInfo) || !this.isVisible() || this.updateInProgress) {
            return;
        }
        try {
            this.updateInProgress = true;
            XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)object);
            int n = xPDLElementChangeInfo.getAction();
            if (n != 5 && n != 15) {
                return;
            }
            if (xPDLElementChangeInfo.getAction() == 15) {
                for (int i = 0; i < xPDLElementChangeInfo.getChangedSubElements().size(); ++i) {
                    XPDLElementChangeInfo xPDLElementChangeInfo2 = (XPDLElementChangeInfo)((Object)xPDLElementChangeInfo.getChangedSubElements().get(i));
                    if (xPDLElementChangeInfo2.getAction() != 5) continue;
                    this.removeFromTable(xPDLElementChangeInfo2);
                }
            } else if (xPDLElementChangeInfo.getAction() == 5) {
                this.removeFromTable(xPDLElementChangeInfo);
            }
        }
        finally {
            this.updateInProgress = false;
        }
    }

    @Override
    protected void init() {
        try {
            this.setModal(false);
            JaWEManager.getInstance().getJaWEController().addObserver(this);
            this.initDialog();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeFromTable(XPDLElementChangeInfo xPDLElementChangeInfo) {
        ArrayList<XMLElement> arrayList = xPDLElementChangeInfo.getChangedSubElements();
        if (arrayList == null || arrayList.size() == 0) {
            arrayList = new ArrayList<XMLElement>();
            arrayList.add(xPDLElementChangeInfo.getChangedElement());
        }
        List list = this.panelToEdit.getElements();
        HashSet<XMLElement> hashSet = new HashSet<XMLElement>();
        if (list != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object = (XMLElement)arrayList.get(i);
                for (int j = 0; j < list.size(); ++j) {
                    XMLElement xMLElement = (XMLElement)list.get(j);
                    if (object != xMLElement && !XMLUtil.isParentsChild((XMLElement)object, (XMLElement)xMLElement)) continue;
                    hashSet.add(xMLElement);
                }
            }
            for (Object object : hashSet) {
                this.panelToEdit.removeRow((XMLElement)object);
            }
        }
    }

    @Override
    public void setUpdateInProgress(boolean bl) {
        this.updateInProgress = bl;
    }

    @Override
    public boolean isUpdateInProgress() {
        return this.updateInProgress;
    }

    @Override
    protected XMLSimpleTablePanel createSTP(String string, XMLCollection xMLCollection, List list, List list2) {
        return new XMLSimpleTableSelPanel(this.inlinePanel, xMLCollection, list2, list, string, true, true, false);
    }
}

