/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.xpdlhandler;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.base.xpdlhandler.XPDLHandlerSettings;
import org.enhydra.jxpdl.XMLInterface;
import org.enhydra.jxpdl.XMLInterfaceImpl;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.ExternalPackage;
import org.enhydra.jxpdl.elements.Package;

public class XPDLHandler
extends XMLInterfaceImpl {
    protected XPDLHandlerSettings settings;
    private Map fileLocks = new HashMap();
    private Map rndAccessFiles = new HashMap();

    public XPDLHandler() {
        this.settings = new XPDLHandlerSettings();
        this.settings.init(null);
    }

    public XPDLHandler(XPDLHandlerSettings xPDLHandlerSettings) throws Exception {
        this.settings = xPDLHandlerSettings;
        this.settings.init(null);
    }

    public Package getMainPackage() {
        return (Package)this.xmlFileToPackage.get(this.mainPackageReference);
    }

    public String getMainPackageId() {
        Package package_ = this.getMainPackage();
        if (package_ != null) {
            return package_.getId();
        }
        return null;
    }

    public String getMainPackageFilename() {
        return this.mainPackageReference;
    }

    public void registerPackage(Package package_) {
        ArrayList<Package> arrayList = (ArrayList<Package>)this.idToPackages.get(package_.getId());
        if (arrayList == null) {
            arrayList = new ArrayList<Package>();
        }
        arrayList.add(package_);
        this.idToPackages.put(package_.getId(), arrayList);
    }

    public void changePackageId(Package package_, String string, String string2) {
        ArrayList arrayList = (ArrayList)this.idToPackages.remove(string);
        arrayList = (ArrayList)this.idToPackages.get(string2);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        arrayList.add(package_);
        this.idToPackages.put(string2, arrayList);
    }

    public void registerPackageFilename(String string, Package package_) {
        Object object;
        String string2 = this.getAbsoluteFilePath(package_);
        boolean bl = false;
        if (string2 != null) {
            if (string2.equals(this.mainPackageReference)) {
                bl = true;
            }
            this.xmlFileToPackage.remove(string2);
        }
        try {
            object = (FileLock)this.fileLocks.remove(package_);
            ((FileLock)object).release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = (RandomAccessFile)this.rndAccessFiles.remove(package_);
            ((RandomAccessFile)object).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = XMLUtil.getCanonicalPath((String)string, (boolean)false);
        this.xmlFileToPackage.put(object, package_);
        if (bl || this.mainPackageReference == null) {
            this.mainPackageReference = object;
        }
        File file = new File((String)object);
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            this.rndAccessFiles.put(package_, randomAccessFile);
            if (this.settings.isFileLockingEnabled()) {
                FileLock fileLock = randomAccessFile.getChannel().tryLock();
                if (fileLock != null) {
                    this.fileLocks.put(package_, fileLock);
                } else {
                    System.out.println("Can't lock");
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.packageToParentDirectory.put(package_, file.getParentFile().getCanonicalPath());
        }
        catch (Exception exception) {
            this.packageToParentDirectory.put(package_, file.getParentFile().getAbsolutePath());
        }
    }

    public RandomAccessFile getRaf(Package package_) {
        return (RandomAccessFile)this.rndAccessFiles.get(package_);
    }

    public Package openPackage(String string, boolean bl) {
        Package package_;
        this.parsingErrorMessages.clear();
        if (this.mainPackageReference == null && bl) {
            this.mainPackageReference = string;
        }
        if ((package_ = this.openPackageRecursively(string, bl)) != null) {
            package_.setTransient(!bl);
            System.setProperty("user.dir", this.getParentDirectory(package_));
        }
        return package_;
    }

    public void printDebug() {
        super.printDebug();
        System.out.println("fileLocks=" + this.fileLocks);
        System.out.println("rndAccessFiles=" + this.rndAccessFiles);
        System.out.println("main package reference=" + this.mainPackageReference);
    }

    protected Package openPackageRecursively(String string, boolean bl) {
        ArrayList<Package> arrayList;
        Object object;
        String string2;
        File file;
        Package package_;
        block25: {
            package_ = null;
            file = null;
            String string3 = string;
            string2 = null;
            if ((string = XMLUtil.getCanonicalPath((String)string, (String)"", (boolean)false)) == null) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add("File does not exist");
                this.parsingErrorMessages.put(string3, hashSet);
                return null;
            }
            file = new File(string);
            try {
                string2 = file.getParentFile().getCanonicalPath();
            }
            catch (Exception exception) {
                string2 = file.getParentFile().getAbsolutePath();
            }
            if (this.xmlFileToPackage.containsKey(string)) {
                return this.getPackageByFilename(string);
            }
            package_ = this.parseDocument(string, true);
            try {
                if (string3.equals(this.mainPackageReference)) {
                    object = null;
                    try {
                        object = new RandomAccessFile(file, "rw");
                    }
                    catch (Exception exception) {
                        object = new RandomAccessFile(file, "r");
                    }
                    this.rndAccessFiles.put(package_, object);
                    if (!this.settings.isFileLockingEnabled()) break block25;
                    arrayList = ((RandomAccessFile)object).getChannel().tryLock();
                    if (arrayList != null) {
                        this.fileLocks.put(package_, arrayList);
                        break block25;
                    }
                    HashSet<String> hashSet = new HashSet<String>();
                    hashSet.add(ResourceManager.getLanguageDependentString("ErrorTheFileIsLocked"));
                    this.parsingErrorMessages.put(string, hashSet);
                    return null;
                }
                object = null;
                try {
                    object = new RandomAccessFile(file, "rw");
                }
                catch (Exception exception) {
                    object = new RandomAccessFile(file, "r");
                }
                this.rndAccessFiles.put(package_, object);
                if (!this.settings.isFileLockingEnabled()) break block25;
                arrayList = ((RandomAccessFile)object).getChannel().tryLock();
                if (arrayList != null) {
                    this.fileLocks.put(package_, arrayList);
                    break block25;
                }
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(ResourceManager.getLanguageDependentString("ErrorTheFileIsLocked"));
                this.parsingErrorMessages.put(string, hashSet);
                return null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (package_ != null) {
            object = package_.getId();
            if (this.idToPackages.containsKey(object)) {
                if (this.xmlFileToPackage.containsKey(string)) {
                    return this.getPackageById((String)object);
                }
                throw new RuntimeException("Can't open two packages with the same Id");
            }
            arrayList = (ArrayList<Package>)this.idToPackages.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<Package>();
            }
            arrayList.add(package_);
            this.idToPackages.put(object, arrayList);
            this.xmlFileToPackage.put(string, package_);
            try {
                this.packageToParentDirectory.put(package_, file.getParentFile().getCanonicalPath());
            }
            catch (Exception exception) {
                this.packageToParentDirectory.put(package_, file.getParentFile().getAbsolutePath());
            }
            for (ExternalPackage externalPackage : package_.getExternalPackages().toElements()) {
                String string4 = externalPackage.getHref();
                String string5 = externalPackage.getId();
                if (bl) {
                    Package package_2;
                    String string6 = XMLUtil.getCanonicalPath((String)string4, (String)string2, (boolean)false);
                    if (string6 == null) {
                        package_2 = new HashSet();
                        package_2.add("File does not exist");
                        this.parsingErrorMessages.put(string4, package_2);
                        continue;
                    }
                    package_2 = this.openPackageRecursively(string6, bl);
                    string5 = package_2.getId();
                } else if (string5 != null) {
                    string5 = XMLUtil.getExternalPackageId((String)string4);
                }
                package_.addExternalPackageMapping(string4, string5);
            }
        } else {
            System.err.println("Problems with opening file " + string);
        }
        return package_;
    }

    public synchronized List closePackages(String string) {
        Package package_ = this.getMainPackage();
        List list = super.closePackages(string);
        if (list != null) {
            for (Package package_2 : list) {
                if (package_2 == package_) {
                    this.mainPackageReference = null;
                }
                RandomAccessFile randomAccessFile = (RandomAccessFile)this.rndAccessFiles.remove(package_2);
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FileLock fileLock = (FileLock)this.fileLocks.remove(package_2);
                try {
                    fileLock.release();
                }
                catch (Exception exception) {}
            }
        }
        return list;
    }

    public synchronized Package closePackageVersion(String string, String string2) {
        Package package_ = this.getMainPackage();
        ArrayList arrayList = (ArrayList)this.idToPackages.get(string);
        if (arrayList.size() == 1) {
            return (Package)this.closePackages(string).get(0);
        }
        Package package_2 = super.closePackageVersion(string, string2);
        if (package_2 != null) {
            if (package_2 == package_) {
                this.mainPackageReference = null;
            }
            RandomAccessFile randomAccessFile = (RandomAccessFile)this.rndAccessFiles.remove(package_2);
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            FileLock fileLock = (FileLock)this.fileLocks.remove(package_2);
            try {
                fileLock.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return package_2;
    }

    public void closeAllPackages() {
        super.closeAllPackages();
        for (RandomAccessFile randomAccessFile : this.rndAccessFiles.values()) {
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {}
        }
        this.rndAccessFiles.clear();
        this.unlockAllFiles();
        this.mainPackageReference = null;
    }

    public void unlockAllFiles() {
        for (FileLock fileLock : this.fileLocks.values()) {
            try {
                fileLock.release();
            }
            catch (Exception exception) {}
        }
        this.fileLocks.clear();
    }

    public void lockAllFiles() throws Exception {
        if (!this.settings.isFileLockingEnabled()) {
            return;
        }
        Iterator iterator = this.rndAccessFiles.entrySet().iterator();
        Package package_ = (Package)this.xmlFileToPackage.get(this.mainPackageReference);
        while (iterator.hasNext()) {
            FileLock fileLock;
            Map.Entry entry = iterator.next();
            Package package_2 = (Package)entry.getKey();
            RandomAccessFile randomAccessFile = (RandomAccessFile)entry.getValue();
            if (package_2.equals((Object)package_)) {
                fileLock = randomAccessFile.getChannel().tryLock();
                if (fileLock == null) continue;
                this.fileLocks.put(package_2, fileLock);
                continue;
            }
            fileLock = randomAccessFile.getChannel().tryLock(0L, Long.MAX_VALUE, true);
            if (fileLock == null) continue;
            this.fileLocks.put(package_2, fileLock);
        }
    }

    public synchronized void synchronizePackages(XMLInterface xMLInterface) {
        for (Package package_ : xMLInterface.getAllPackages()) {
            FileLock fileLock;
            XPDLHandler xPDLHandler;
            RandomAccessFile randomAccessFile;
            String string;
            String string2 = package_.getId();
            ArrayList<Package> arrayList = (ArrayList<Package>)this.idToPackages.get(string2);
            if (arrayList != null) continue;
            arrayList = new ArrayList<Package>();
            arrayList.add(package_);
            this.idToPackages.put(string2, arrayList);
            String string3 = xMLInterface.getAbsoluteFilePath(package_);
            if (string3 != null) {
                this.xmlFileToPackage.put(string3, package_);
            }
            if ((string = xMLInterface.getParentDirectory(package_)) != null) {
                this.packageToParentDirectory.put(package_, string);
            }
            if ((randomAccessFile = (xPDLHandler = (XPDLHandler)xMLInterface).getRaf(package_)) != null) {
                this.rndAccessFiles.put(package_, randomAccessFile);
            }
            if ((fileLock = (FileLock)xPDLHandler.fileLocks.get(package_)) == null) continue;
            if (xPDLHandler.getMainPackage() == package_) {
                try {
                    fileLock.release();
                }
                catch (Exception exception) {
                    System.err.println("Failed to release file lock for package " + package_.getId());
                }
                fileLock = null;
                try {
                    fileLock = randomAccessFile.getChannel().tryLock();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (fileLock == null) continue;
            this.fileLocks.put(package_, fileLock);
        }
    }
}

