/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.enhydra.jawe.components.graph.CopiedActivityOrArtifactInfo;
import org.enhydra.jawe.components.graph.Graph;

public class CopyOrCutInfo {
    private Point referencePoint;
    private Map actInfoToActRect;
    private Point pasteTo;
    private Map graphToOffsetPoint = new HashMap();

    public CopyOrCutInfo(Point point, Map map) {
        this.referencePoint = point;
        this.actInfoToActRect = map;
    }

    public Point getReferencePoint() {
        return this.referencePoint;
    }

    public void setPastePoint(Point point) {
        this.pasteTo = point;
    }

    public Point getPastePoint() {
        return this.pasteTo;
    }

    public Point getOffsetPoint(Graph graph) {
        Point point = (Point)this.graphToOffsetPoint.get((Object)graph);
        if (point == null) {
            point = new Point(10, 10);
            this.graphToOffsetPoint.put(graph, point);
        }
        return point;
    }

    public void incrementOffsetPoint(Graph graph) {
        Point point = this.getOffsetPoint(graph);
        point = new Point(point.x + 10, point.y + 10);
        if (point.x > 150 || point.y > 150) {
            point = new Point(10, 10);
        }
        this.graphToOffsetPoint.put(graph, point);
    }

    public Rectangle getActivityBounds(CopiedActivityOrArtifactInfo copiedActivityOrArtifactInfo) {
        for (Map.Entry entry : this.actInfoToActRect.entrySet()) {
            CopiedActivityOrArtifactInfo copiedActivityOrArtifactInfo2 = (CopiedActivityOrArtifactInfo)entry.getKey();
            Rectangle rectangle = (Rectangle)entry.getValue();
            if (!copiedActivityOrArtifactInfo.getLaneId().equals(copiedActivityOrArtifactInfo2.getLaneId()) || !copiedActivityOrArtifactInfo.getOffsetPoint().equals(copiedActivityOrArtifactInfo2.getOffsetPoint())) continue;
            return rectangle;
        }
        return null;
    }

    public void removeGraphInfo(Graph graph) {
        this.graphToOffsetPoint.remove((Object)graph);
    }

    public String toString() {
        String string = "---------CopyOrCutInfo----------------";
        string = string + "\nReferencePoint=" + this.referencePoint;
        string = string + "\nPasteTo=" + this.pasteTo;
        string = string + "\nActInfoToRectg=" + this.actInfoToActRect;
        string = string + "--------- End of CopyOrCutInfo----------------";
        return string;
    }
}

