/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.components.graph.GraphActivityInterface;
import org.enhydra.jawe.components.graph.GraphActivityRendererInterface;
import org.enhydra.jawe.components.graph.GraphActivityViewInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jawe.components.graph.MultiLinedRenderer;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.NodeGraphicsInfo;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexView;

public class DefaultGraphActivityRenderer
extends MultiLinedRenderer
implements GraphActivityRendererInterface {
    protected static int arc = 15;

    @Override
    public void paint(Graphics graphics) {
        GraphActivityInterface graphActivityInterface = (GraphActivityInterface)this.view.getCell();
        Activity activity = (Activity)graphActivityInterface.getUserObject();
        int n = activity.getActivityType();
        if (n == 0) {
            this.paintRoot(activity, graphics);
            return;
        }
        Color color = this.getFillColor();
        this.bordercolor = this.getBorderColor();
        Dimension dimension = this.getBounds().getSize();
        int n2 = dimension.width;
        int n3 = dimension.height;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.selected) {
            color = GraphUtilities.getGraphController().getGraphSettings().getSelectedActivityColor();
        }
        int n4 = color.getRed();
        int n5 = color.getGreen();
        int n6 = color.getBlue();
        Color color2 = new Color(n4, n5, n6, 255);
        Color color3 = new Color(n4, n5, n6, 0);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color2, n2, n3, color3);
        graphics2D.setPaint(gradientPaint);
        graphics.fillRoundRect(0, 0, n2 - 1, n3 - 1, arc, arc);
        super.setOpaque(false);
        Graphics graphics2 = graphics.create(1, 1, n2 - 2, n3 - 2);
        this.graph.setHighlightColor(color);
        super.paint(graphics2);
        this.setForeground(this.bordercolor);
        graphics.setColor(this.bordercolor);
        graphics2D.setStroke(this.borderStroke);
        graphics.drawRoundRect(0, 0, n2 - 1, n3 - 1, arc, arc);
        if (n == 4 || n == 3) {
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics.setColor(Color.BLACK);
            graphics.drawRoundRect(n2 / 2 - 7, n3 - 16, 15, 15, 3, 3);
            graphics.drawLine(n2 / 2, n3 - 11, n2 / 2, n3 - 5);
            graphics.drawLine(n2 / 2 - 3, n3 - 8, n2 / 2 + 3, n3 - 8);
        }
    }

    protected void paintRoot(Activity activity, Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = ((GraphActivityViewInterface)this.view).getOriginalBounds();
        Graphics graphics2 = graphics.create((int)(rectangle2.getX() - rectangle.getX()), (int)(rectangle2.getY() - rectangle.getY()), (int)rectangle2.getWidth(), (int)rectangle2.getHeight());
        Graphics2D graphics2D = (Graphics2D)graphics2;
        Dimension dimension = rectangle2.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        Color color = this.getFillColor();
        this.bordercolor = this.getBorderColor();
        String string = activity.getActivityTypes().getRoute().getGatewayType();
        if (this.selected) {
            color = GraphUtilities.getGraphController().getGraphSettings().getSelectedActivityColor();
        }
        int[] nArray = new int[]{0, n / 2, n - 1, n / 2, 0};
        int[] nArray2 = new int[]{n2 / 2, 0, n2 / 2, n2 - 1, n2 / 2};
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        Color color2 = new Color(n3, n4, n5, 255);
        Color color3 = new Color(n3, n4, n5, 0);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color2, n - 1, n2 - 1, color3);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillPolygon(nArray, nArray2, 5);
        super.setOpaque(false);
        this.setBorder(BorderFactory.createLineBorder(this.bordercolor, 0));
        this.setForeground(this.bordercolor);
        graphics2D.setColor(this.bordercolor);
        graphics2D.setStroke(this.borderStroke);
        graphics2D.drawPolygon(nArray, nArray2, 5);
        graphics2D.setColor(Color.BLACK);
        if (string.equals("Parallel")) {
            DefaultGraphActivityRenderer.drawLine(graphics2D, n / 2, n2 / 4 + 2, n / 2, 3 * n2 / 4 - 2, 3, true);
            DefaultGraphActivityRenderer.drawLine(graphics2D, n / 4 + 2, n2 / 2, 3 * n / 4 - 2, n2 / 2, 3, false);
        } else if (string.equals("Inclusive")) {
            DefaultGraphActivityRenderer.drawCircle(graphics2D, n / 2, n2 / 2, n / 4 - 1, 3);
        } else {
            DefaultGraphActivityRenderer.drawLine(graphics2D, n / 4 + 5, n2 / 4 + 3, 3 * n / 4 - 5, 3 * n2 / 4 - 3, 3, true);
            DefaultGraphActivityRenderer.drawLine(graphics2D, n / 4 + 5, 3 * n2 / 4 - 3, 3 * n / 4 - 5, n2 / 4 + 3, 3, true);
        }
        String string2 = activity.getName();
        if (!string2.trim().equals("")) {
            this.paintLabel(graphics, string2, dimension.height);
        }
    }

    @Override
    public ImageIcon getIcon() {
        Activity activity = (Activity)((GraphActivityInterface)this.view.getCell()).getUserObject();
        if (activity.getActivityType() == 0) {
            return null;
        }
        String string = activity.getIcon();
        if (activity.getActivityType() == 1 && string.equals("")) {
            return null;
        }
        ImageIcon imageIcon = null;
        if (!string.equals("")) {
            imageIcon = (ImageIcon)Utils.getOriginalActivityIconsMap().get((Object)string);
        }
        if (imageIcon == null) {
            imageIcon = JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)activity).getIcon();
        }
        return imageIcon;
    }

    public Color getBorderColor() {
        GraphActivityInterface graphActivityInterface = (GraphActivityInterface)this.view.getCell();
        Activity activity = (Activity)graphActivityInterface.getUserObject();
        NodeGraphicsInfo nodeGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)activity);
        Color color = null;
        if (nodeGraphicsInfo != null) {
            color = Utils.getColor(nodeGraphicsInfo.getBorderColor());
        }
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public Color getFillColor() {
        GraphActivityInterface graphActivityInterface = (GraphActivityInterface)this.view.getCell();
        Activity activity = (Activity)graphActivityInterface.getUserObject();
        NodeGraphicsInfo nodeGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)activity);
        Color color = null;
        if (nodeGraphicsInfo != null) {
            color = Utils.getColor(nodeGraphicsInfo.getFillColor());
        }
        if (color == null) {
            color = JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)activity).getColor();
        }
        return color;
    }

    protected void paintLabel(Graphics graphics, String string, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics.setFont(this.getFont());
        if (string != null && string.length() > 0) {
            Dimension dimension = this.getLabelDimension((GraphActivityViewInterface)this.view);
            int n2 = (int)graphics.getClipBounds().getWidth();
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n3 = fontMetrics.getHeight();
            graphics.setFont(font);
            graphics.setColor(this.getBackground());
            graphics.setColor(Color.BLACK);
            graphics.drawString(string, dimension.width < n2 ? (n2 - dimension.width) / 2 : 0, n + n3 - 3);
        }
    }

    @Override
    public Dimension getLabelDimension(GraphActivityViewInterface graphActivityViewInterface) {
        GraphActivityInterface graphActivityInterface = (GraphActivityInterface)graphActivityViewInterface.getCell();
        Activity activity = (Activity)graphActivityInterface.getUserObject();
        if (!(activity.getActivityType() != 0 && activity.getActivityType() != 7 && activity.getActivityType() != 6 || activity.getName().trim().equals(""))) {
            String string = activity.getName();
            Font font = GraphConstants.getFont((Map)graphActivityViewInterface.getAllAttributes());
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n = fontMetrics.stringWidth(string);
            int n2 = fontMetrics.getHeight();
            return new Dimension(n, n2);
        }
        return new Dimension(0, 0);
    }

    @Override
    public Point2D getPerimeterPoint(VertexView vertexView, Point2D point2D) {
        GraphActivityInterface graphActivityInterface = (GraphActivityInterface)vertexView.getCell();
        Activity activity = (Activity)graphActivityInterface.getUserObject();
        int n = activity.getActivityType();
        Point2D point2D2 = null;
        point2D2 = n != 0 ? super.getPerimeterPoint(vertexView, point2D) : this._getPerimeterPoint(vertexView, point2D);
        return point2D2;
    }

    public Point2D _getPerimeterPoint(VertexView vertexView, Point2D point2D) {
        GraphActivityViewInterface graphActivityViewInterface = (GraphActivityViewInterface)vertexView;
        Point2D point2D2 = AbstractCellView.getCenterPoint((CellView)vertexView);
        double d = graphActivityViewInterface.getOriginalBounds().getWidth() / 2.0;
        double d2 = graphActivityViewInterface.getOriginalBounds().getHeight() / 2.0;
        Point2D.Double double_ = new Point2D.Double(point2D2.getX(), point2D2.getY() - d2);
        Point2D.Double double_2 = new Point2D.Double(point2D2.getX(), point2D2.getY() + d2);
        Point2D.Double double_3 = new Point2D.Double(point2D2.getX() - d, point2D2.getY());
        Point2D.Double double_4 = new Point2D.Double(point2D2.getX() + d, point2D2.getY());
        if (point2D2.getX() == point2D.getX()) {
            if (point2D2.getY() > point2D.getY()) {
                return double_;
            }
            return double_2;
        }
        if (point2D2.getY() == point2D.getY()) {
            if (point2D2.getX() > point2D.getX()) {
                return double_3;
            }
            return double_4;
        }
        Point2D point2D3 = point2D.getX() < point2D2.getX() ? (point2D.getY() < point2D2.getY() ? this.intersection(vertexView, point2D, point2D2, double_, double_3) : this.intersection(vertexView, point2D, point2D2, double_2, double_3)) : (point2D.getY() < point2D2.getY() ? this.intersection(vertexView, point2D, point2D2, double_, double_4) : this.intersection(vertexView, point2D, point2D2, double_2, double_4));
        return point2D3;
    }

    private Point2D intersection(VertexView vertexView, Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        double d = (point2D2.getY() - point2D.getY()) / (point2D2.getX() - point2D.getX());
        double d2 = point2D.getY() - d * point2D.getX();
        double d3 = (point2D4.getY() - point2D3.getY()) / (point2D4.getX() - point2D3.getX());
        double d4 = point2D3.getY() - d3 * point2D3.getX();
        double d5 = (d2 - d4) / (d3 - d);
        double d6 = d * d5 + d2;
        Point2D point2D5 = vertexView.getAttributes().createPoint(d5, d6);
        return point2D5;
    }

    protected static void drawCircle(Graphics graphics, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n4; ++i) {
            graphics.drawOval(n - (n3 - i), n2 - (n3 - i), 2 * (n3 - i), 2 * (n3 - i));
        }
    }

    protected static void drawLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        graphics.drawLine(n, n2, n3, n4);
        int n6 = 0;
        int n7 = 0;
        for (int i = 1; i < n5; ++i) {
            if (bl) {
                n6 = i;
            } else {
                n7 = i;
            }
            graphics.drawLine(n - n6, n2 - n7, n3 - n6, n4 - n7);
            graphics.drawLine(n + n6, n2 + n7, n3 + n6, n4 + n7);
        }
    }
}

