/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Map;
import javax.swing.ImageIcon;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.components.graph.GraphArtifactInterface;
import org.enhydra.jawe.components.graph.GraphArtifactRendererInterface;
import org.enhydra.jawe.components.graph.GraphArtifactViewInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jawe.components.graph.MultiLinedRenderer;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Artifact;
import org.enhydra.jxpdl.elements.NodeGraphicsInfo;
import org.jgraph.graph.GraphConstants;

public class DefaultGraphArtifactRenderer
extends MultiLinedRenderer
implements GraphArtifactRendererInterface {
    protected static int arc = 8;

    @Override
    public void paint(Graphics graphics) {
        GraphArtifactInterface graphArtifactInterface = (GraphArtifactInterface)this.view.getCell();
        Artifact artifact = (Artifact)graphArtifactInterface.getUserObject();
        String string = artifact.getArtifactType();
        Dimension dimension = ((GraphArtifactViewInterface)this.view).getOriginalBounds().getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        Color color = this.getFillColor();
        this.bordercolor = this.getBorderColor();
        if (this.selected) {
            color = GraphUtilities.getGraphController().getGraphSettings().getSelectedActivityColor();
        }
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        Color color2 = new Color(n3, n4, n5, 255);
        Color color3 = new Color(n3, n4, n5, 0);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color2, n, n2, color3);
        if (string.equals("DataObject")) {
            Rectangle rectangle = this.getBounds();
            Rectangle rectangle2 = ((GraphArtifactViewInterface)this.view).getOriginalBounds();
            Graphics graphics2 = graphics.create((int)(rectangle2.getX() - rectangle.getX()), (int)(rectangle2.getY() - rectangle.getY()), (int)rectangle2.getWidth(), (int)rectangle2.getHeight());
            Graphics2D graphics2D = (Graphics2D)graphics2;
            Object object = RenderingHints.VALUE_ANTIALIAS_ON;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            int[] nArray = new int[]{0, n - arc, n - 1, n - 1, 0, 0};
            int[] nArray2 = new int[]{0, 0, arc, n2 - 1, n2 - 1, 0};
            int[] nArray3 = new int[]{n - arc, n - 1, n - arc, n - arc};
            int[] nArray4 = new int[]{0, arc, arc, 0};
            if (super.isOpaque()) {
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillPolygon(nArray, nArray2, 6);
                gradientPaint = new GradientPaint(0.0f, 0.0f, Color.WHITE, n, n2, Color.WHITE);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillPolygon(nArray3, nArray4, 4);
            }
            graphics2D.setColor(this.bordercolor);
            graphics2D.drawPolygon(nArray, nArray2, 6);
            graphics2D.drawPolygon(nArray3, nArray4, 4);
            String string2 = graphArtifactInterface.toString();
            this.paintLabel(graphics, string2, new Point(0, rectangle2.height));
        } else {
            super.setOpaque(false);
            Graphics2D graphics2D = (Graphics2D)graphics.create(1, 1, n - 2, n2 - 2);
            graphics2D.setColor(color2);
            graphics2D.fillRect(0, 0, n - 2, n2 - 2);
            super.paint(graphics2D);
            graphics.setColor(this.bordercolor);
            ((Graphics2D)graphics).setStroke(this.borderStroke);
            graphics.drawLine(0, 0, n / 4, 0);
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(0, n2 - 1, n / 4, n2 - 1);
            if (this.selected || this.hasFocus) {
                ((Graphics2D)graphics).setStroke(GraphConstants.SELECTION_STROKE);
                graphics.setColor(this.graph.getHighlightColor());
                graphics.drawLine(0, 0, n / 4, 0);
                graphics.drawLine(0, 0, 0, n2 - 1);
                graphics.drawLine(0, n2 - 1, n / 4, n2 - 1);
            }
        }
    }

    protected void paintLabel(Graphics graphics, String string, Point point) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics.setFont(this.getFont());
        if (string != null && string.length() > 0) {
            Dimension dimension = this.getLabelDimension((GraphArtifactViewInterface)this.view);
            graphics.setColor(this.getBackground());
            graphics.setColor(Color.BLACK);
            graphics.drawString(string, point.x, point.y + dimension.height);
        }
    }

    @Override
    public Dimension getLabelDimension(GraphArtifactViewInterface graphArtifactViewInterface) {
        GraphArtifactInterface graphArtifactInterface = (GraphArtifactInterface)graphArtifactViewInterface.getCell();
        String string = graphArtifactInterface.toString();
        Font font = GraphConstants.getFont((Map)graphArtifactViewInterface.getAllAttributes());
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        return new Dimension(n, n2);
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    public Color getBorderColor() {
        GraphArtifactInterface graphArtifactInterface = (GraphArtifactInterface)this.view.getCell();
        Artifact artifact = (Artifact)graphArtifactInterface.getUserObject();
        NodeGraphicsInfo nodeGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)artifact);
        Color color = null;
        if (nodeGraphicsInfo != null) {
            color = Utils.getColor(nodeGraphicsInfo.getBorderColor());
        }
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public Color getFillColor() {
        GraphArtifactInterface graphArtifactInterface = (GraphArtifactInterface)this.view.getCell();
        Artifact artifact = (Artifact)graphArtifactInterface.getUserObject();
        NodeGraphicsInfo nodeGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)artifact);
        Color color = null;
        if (nodeGraphicsInfo != null) {
            color = Utils.getColor(nodeGraphicsInfo.getFillColor());
        }
        if (color == null) {
            color = JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)artifact).getColor();
        }
        return color;
    }
}

