/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Map;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.components.graph.DefaultGraphTransitionView;
import org.enhydra.jawe.components.graph.GraphArtifactInterface;
import org.enhydra.jawe.components.graph.GraphCommonInterface;
import org.enhydra.jawe.components.graph.GraphTransitionInterface;
import org.enhydra.jawe.components.graph.GraphTransitionRendererInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.Association;
import org.enhydra.jxpdl.elements.ConnectorGraphicsInfo;
import org.enhydra.jxpdl.elements.Transition;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.GraphConstants;

public class DefaultGraphTransitionRenderer
extends EdgeRenderer
implements GraphTransitionRendererInterface {
    public void paint(Graphics graphics) {
        GraphTransitionInterface graphTransitionInterface = (GraphTransitionInterface)this.view.getCell();
        XMLCollectionElement xMLCollectionElement = (XMLCollectionElement)graphTransitionInterface.getUserObject();
        Color color = this.getFillColor();
        AttributeMap attributeMap = this.view.getAttributes();
        attributeMap.put((Object)"foregroundColor", (Object)color);
        attributeMap.put((Object)"labelEnabled", (Object)new Boolean(GraphUtilities.getGraphController().getSelectedGraph().shouldShowTransitionConditions()));
        if (xMLCollectionElement instanceof Transition) {
            Activity activity;
            Transition transition = (Transition)xMLCollectionElement;
            attributeMap.put((Object)"lineEnd", (Object)2);
            if (transition.getCondition().getType().equals("OTHERWISE") || transition.getCondition().getType().equals("DEFAULTEXCEPTION")) {
                attributeMap.put((Object)"lineBegin", (Object)7);
            }
            if ((transition.getCondition().getType().equals("CONDITION") || !transition.getCondition().toValue().equals("")) && (activity = XMLUtil.getFromActivity((Transition)transition)) != null && activity.getActivityType() != 0) {
                attributeMap.put((Object)"lineBegin", (Object)9);
                attributeMap.put((Object)"beginFill", (Object)false);
                attributeMap.put((Object)"beginSize", (Object)11);
            }
        } else {
            attributeMap.put((Object)"dashPattern", (Object)new float[]{2.0f});
            Association association = (Association)xMLCollectionElement;
            GraphCommonInterface graphCommonInterface = graphTransitionInterface.getSourceActivityOrArtifact();
            if (association.getAssociationDirection().equals("None")) {
                attributeMap.put((Object)"lineBegin", (Object)0);
                attributeMap.put((Object)"lineEnd", (Object)0);
            } else if (association.getAssociationDirection().equals("Both")) {
                attributeMap.put((Object)"lineBegin", (Object)2);
                attributeMap.put((Object)"lineEnd", (Object)2);
            } else if (association.getAssociationDirection().equals("From")) {
                attributeMap.put((Object)"lineBegin", (Object)(graphCommonInterface instanceof GraphArtifactInterface ? 2 : 0));
                attributeMap.put((Object)"lineEnd", (Object)(graphCommonInterface instanceof GraphArtifactInterface ? 0 : 2));
            } else if (association.getAssociationDirection().equals("To")) {
                attributeMap.put((Object)"lineBegin", (Object)(graphCommonInterface instanceof GraphArtifactInterface ? 0 : 2));
                attributeMap.put((Object)"lineEnd", (Object)(graphCommonInterface instanceof GraphArtifactInterface ? 2 : 0));
            }
        }
        this.view.setAttributes(attributeMap);
        if (this.view instanceof DefaultGraphTransitionView) {
            ((DefaultGraphTransitionView)this.view).mergeAttributes();
        }
        this.installAttributes((CellView)this.view);
        this.createShape();
        super.paint(graphics);
    }

    protected Shape createLineEnd(int n, int n2, Point2D point2D, Point2D point2D2) {
        if (point2D == null || point2D2 == null) {
            return null;
        }
        if (n2 == 7 || n2 == 8) {
            Point2D point2D3;
            GeneralPath generalPath = new GeneralPath(1, 4);
            int n3 = this.view.getPointCount();
            if (n3 <= 1) {
                return super.createLineEnd(n, n2, point2D, point2D2);
            }
            Point2D[] point2DArray = null;
            point2DArray = new Point2D[n3];
            for (int i = 0; i < n3; ++i) {
                point2D3 = this.view.getPoint(i);
                if (point2D3 == null) {
                    return null;
                }
                point2DArray[i] = new Point2D.Double(point2D3.getX(), point2D3.getY());
            }
            Point2D point2D4 = point2DArray[0];
            point2D3 = point2DArray[1];
            point2D2 = point2D4;
            Point2D point2D5 = point2DArray[n3 - 2];
            point2D = point2D5.equals(point2D4) || GraphConstants.getRouting((Map)this.view.getAllAttributes()) == GraphConstants.ROUTING_SIMPLE ? point2D3 : point2D5;
            int n4 = (int)Math.min(7.0, point2D2.distance(point2D));
            if (n4 == 0) {
                n4 = 1;
            }
            double d = Math.atan((point2D.getY() - point2D2.getY()) / (point2D.getX() - point2D2.getX()));
            double d2 = Math.abs((double)n4 * Math.cos(d));
            double d3 = Math.abs((double)n4 * Math.sin(d));
            double d4 = point2D2.getX() + (point2D2.getX() > point2D.getX() ? -d2 : d2);
            double d5 = point2D2.getY() + (point2D2.getY() > point2D.getY() ? -d3 : d3);
            int n5 = 11;
            double d6 = (double)(n5 / 2) * Math.sin(0.7853981633974483 - d);
            double d7 = (double)(n5 / 2) * Math.cos(0.7853981633974483 - d);
            double d8 = d4 - d6;
            double d9 = d5 - d7;
            double d10 = d4 + d6;
            double d11 = d5 + d7;
            generalPath.moveTo(d8, d9);
            generalPath.lineTo(d10, d11);
            if (n2 == 8) {
                double d12 = 3.0 * Math.cos(d);
                double d13 = 3.0 * Math.sin(d);
                generalPath.moveTo(d8 + d12, d9 + d13);
                generalPath.lineTo(d10 + d12, d11 + d13);
            }
            return generalPath;
        }
        return super.createLineEnd(n, n2, point2D, point2D2);
    }

    public Color getForeground() {
        Color color = GraphConstants.getForeground((Map)this.view.getAttributes());
        return color;
    }

    public Color getFillColor() {
        GraphTransitionInterface graphTransitionInterface = (GraphTransitionInterface)this.view.getCell();
        XMLCollectionElement xMLCollectionElement = (XMLCollectionElement)graphTransitionInterface.getUserObject();
        ConnectorGraphicsInfo connectorGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getConnectorGraphicsInfo(xMLCollectionElement);
        Color color = null;
        if (connectorGraphicsInfo != null) {
            color = Utils.getColor(connectorGraphicsInfo.getFillColor());
        }
        if (color == null) {
            color = JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)xMLCollectionElement).getColor();
        }
        return color;
    }
}

