/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import org.enhydra.jawe.ChoiceButton;
import org.enhydra.jawe.ChoiceButtonListener;
import org.enhydra.jawe.HistoryManager;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.base.xpdlhandler.XPDLHandler;
import org.enhydra.jawe.components.graph.CommonExpressionParticipant;
import org.enhydra.jawe.components.graph.CopiedActivityOrArtifactInfo;
import org.enhydra.jawe.components.graph.CopyOrCutInfo;
import org.enhydra.jawe.components.graph.FreeTextExpressionParticipant;
import org.enhydra.jawe.components.graph.Graph;
import org.enhydra.jawe.components.graph.GraphCommonInterface;
import org.enhydra.jawe.components.graph.GraphControllerPanel;
import org.enhydra.jawe.components.graph.GraphManager;
import org.enhydra.jawe.components.graph.GraphMarqueeHandler;
import org.enhydra.jawe.components.graph.GraphObjectFactory;
import org.enhydra.jawe.components.graph.GraphObjectRendererFactory;
import org.enhydra.jawe.components.graph.GraphOverview;
import org.enhydra.jawe.components.graph.GraphSettings;
import org.enhydra.jawe.components.graph.GraphSwimlaneInterface;
import org.enhydra.jawe.components.graph.GraphTransitionInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jawe.components.graph.JaWEGraphModel;
import org.enhydra.jawe.components.graph.WorkflowElement;
import org.enhydra.jawe.components.graph.actions.SimpleGraphLayout;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLInterface;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.Artifact;
import org.enhydra.jxpdl.elements.Association;
import org.enhydra.jxpdl.elements.ExtendedAttribute;
import org.enhydra.jxpdl.elements.Lane;
import org.enhydra.jxpdl.elements.NestedLane;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.Participant;
import org.enhydra.jxpdl.elements.Pool;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.enhydra.jxpdl.utilities.SequencedHashMap;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.GraphModel;

public class GraphController
extends Observable
implements Observer,
JaWEComponent,
ChoiceButtonListener,
GraphSelectionListener {
    protected String type = "MAIN";
    protected boolean updateInProgress = false;
    protected GraphObjectFactory graphObjectFactory;
    protected GraphObjectRendererFactory graphObjectRendererFactory;
    protected GraphMarqueeHandler graphMarqueeHandler;
    protected Graph selectedGraph;
    protected GraphControllerPanel panel;
    protected GraphOverview overview;
    protected Map graphMap = new SequencedHashMap();
    protected CopyOrCutInfo copyOrCutInfo;
    protected GraphSettings settings;
    protected HistoryManager hm;

    public GraphController(JaWEComponentSettings jaWEComponentSettings) throws Exception {
        Constructor<?> constructor;
        this.settings = (GraphSettings)jaWEComponentSettings;
        this.settings.init(this);
        try {
            constructor = this.settings.historyManagerClass();
            if (constructor != null && !((String)((Object)constructor)).equals("")) {
                this.hm = (HistoryManager)Class.forName((String)((Object)constructor)).newInstance();
                this.hm.init(this.settings.historySize());
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to instantiate history manager for " + this);
        }
        this.graphObjectFactory = (GraphObjectFactory)Class.forName(this.settings.getGraphObjectFactory()).newInstance();
        this.graphObjectRendererFactory = (GraphObjectRendererFactory)Class.forName(this.settings.getGraphObjectRendererFactory()).newInstance();
        constructor = Class.forName(this.settings.getGraphMarqueeHandler()).getConstructor(GraphController.class);
        this.graphMarqueeHandler = (GraphMarqueeHandler)((Object)constructor.newInstance(this));
        constructor = Class.forName(this.settings.getGraphControllerPanel()).getConstructor(GraphController.class);
        this.panel = (GraphControllerPanel)constructor.newInstance(this);
        if (this.settings.shouldShowGraphOverview()) {
            try {
                String string = this.settings.overviewClass();
                if (string != null && !string.equals("")) {
                    this.overview = (GraphOverview)Class.forName(string).newInstance();
                    this.overview.init(this);
                }
            }
            catch (Exception exception) {
                System.err.println("Failed to instantiate GraphOverview!");
            }
        }
        this.init();
        JaWEManager.getInstance().getJaWEController().addObserver(this);
        if (this.overview != null) {
            JaWEManager.getInstance().getComponentManager().addComponent(this.overview);
            JaWEManager.getInstance().getJaWEController().registerJaWEComponent(this.overview);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable observable, Object object) {
        if (this.updateInProgress) {
            return;
        }
        if (!(object instanceof XPDLElementChangeInfo)) {
            return;
        }
        XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)object);
        XMLElement xMLElement = xPDLElementChangeInfo.getChangedElement();
        int n = xPDLElementChangeInfo.getAction();
        if (xPDLElementChangeInfo.getSource() == this || xMLElement == null && n != 8) {
            return;
        }
        if (n != 1 && n != 3 && n != 5 && n != 7 && n != 8 && n != 14 && n != 16 && n != 17 && n != 18 && n != 19) {
            return;
        }
        long l = System.currentTimeMillis();
        JaWEManager.getInstance().getLoggingManager().info("GraphController -> update for event " + (Object)((Object)xPDLElementChangeInfo) + " started ...");
        this.updateInProgress = true;
        try {
            if (n == 18 || n == 19) {
                this.copyOrCutInfo = null;
                if (this.selectedGraph != null) {
                    Object object2;
                    GraphManager graphManager = this.selectedGraph.getGraphManager();
                    HashMap<CopiedActivityOrArtifactInfo, Rectangle> hashMap = new HashMap<CopiedActivityOrArtifactInfo, Rectangle>();
                    for (Rectangle[] rectangleArray : xPDLElementChangeInfo.getChangedSubElements()) {
                        if (!(rectangleArray instanceof Activity) && !(rectangleArray instanceof Artifact)) continue;
                        object2 = (XMLCollectionElement)rectangleArray;
                        GraphCommonInterface graphCommonInterface = null;
                        graphCommonInterface = object2 instanceof Activity ? graphManager.getGraphActivity((Activity)object2) : graphManager.getGraphArtifact((Artifact)object2);
                        if (graphCommonInterface == null) continue;
                        CopiedActivityOrArtifactInfo copiedActivityOrArtifactInfo = new CopiedActivityOrArtifactInfo(JaWEManager.getInstance().getXPDLUtils().getLaneId((XMLCollectionElement)object2), GraphUtilities.getOffsetPoint(object2));
                        Rectangle rectangle = graphManager.getCBounds(graphCommonInterface, new HashMap());
                        hashMap.put(copiedActivityOrArtifactInfo, rectangle);
                    }
                    if (hashMap.size() > 0) {
                        Rectangle[] rectangleArray;
                        rectangleArray = new Rectangle[hashMap.size()];
                        hashMap.values().toArray(rectangleArray);
                        object2 = graphManager.getUnionBounds(rectangleArray).getLocation();
                        this.copyOrCutInfo = new CopyOrCutInfo((Point)object2, hashMap);
                    }
                }
            } else if (n == 16 || n == 17 || n == 14) {
                if (n == 14) {
                    GraphUtilities.adjustPackageOnUndoableChangeEvent(xPDLElementChangeInfo.getChangedSubElements());
                } else {
                    GraphUtilities.adjustPackageOnUndoOrRedoEvent(xPDLElementChangeInfo.getChangedSubElements(), n == 16);
                }
            } else {
                this.update(xPDLElementChangeInfo);
            }
        }
        finally {
            this.updateInProgress = false;
        }
        JaWEManager.getInstance().getLoggingManager().info("GraphController -> update ended");
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        JaWEManager.getInstance().getLoggingManager().debug("THE UPDATE OF GRAPH COMPONENT LASTED FOR " + d + " SECONDS!");
    }

    @Override
    public JaWEComponentSettings getSettings() {
        return this.settings;
    }

    @Override
    public JaWEComponentView getView() {
        return this.panel;
    }

    @Override
    public String getName() {
        return "GraphComponent";
    }

    @Override
    public String getComponentType() {
        return this.type;
    }

    @Override
    public void setComponentType(String string) {
        this.type = string;
    }

    @Override
    public boolean adjustXPDL(Package package_) {
        return GraphUtilities.scanExtendedAttributes(package_);
    }

    @Override
    public List checkValidity(XMLElement xMLElement, boolean bl) {
        return null;
    }

    @Override
    public boolean canCreateElement(XMLCollection xMLCollection) {
        return true;
    }

    @Override
    public boolean canInsertElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        if (xMLElement == null) {
            return true;
        }
        ExtendedAttribute extendedAttribute = null;
        if (xMLElement instanceof ExtendedAttribute) {
            extendedAttribute = (ExtendedAttribute)xMLElement;
        } else if (xMLElement.getParent() instanceof ExtendedAttribute) {
            extendedAttribute = (ExtendedAttribute)xMLElement.getParent();
        }
        if (extendedAttribute != null) {
            return !GraphUtilities.isMyKindOfExtendedAttribute(extendedAttribute);
        }
        return true;
    }

    @Override
    public boolean canModifyElement(XMLElement xMLElement) {
        if (xMLElement == null) {
            return true;
        }
        ExtendedAttribute extendedAttribute = null;
        if (xMLElement instanceof ExtendedAttribute) {
            extendedAttribute = (ExtendedAttribute)xMLElement;
        } else if (xMLElement.getParent() instanceof ExtendedAttribute) {
            extendedAttribute = (ExtendedAttribute)xMLElement.getParent();
        }
        if (extendedAttribute != null) {
            return !GraphUtilities.isMyKindOfExtendedAttribute(extendedAttribute);
        }
        return true;
    }

    @Override
    public boolean canRemoveElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        if (xMLElement == null) {
            return true;
        }
        ExtendedAttribute extendedAttribute = null;
        if (xMLElement instanceof ExtendedAttribute) {
            extendedAttribute = (ExtendedAttribute)xMLElement;
        } else if (xMLElement.getParent() instanceof ExtendedAttribute) {
            extendedAttribute = (ExtendedAttribute)xMLElement.getParent();
        }
        if (extendedAttribute != null) {
            boolean bl = GraphUtilities.isMyKindOfExtendedAttribute(extendedAttribute);
            if (bl) {
                String string = extendedAttribute.getName();
                return string.equals("JaWE_GRAPH_END_OF_WORKFLOW") || string.equals("JaWE_GRAPH_START_OF_WORKFLOW") || string.equals("JaWE_GRAPH_START_OF_BLOCK") || string.equals("JaWE_GRAPH_END_OF_BLOCK");
            }
        } else if (xMLElement instanceof FreeTextExpressionParticipant || xMLElement instanceof CommonExpressionParticipant) {
            return false;
        }
        return true;
    }

    @Override
    public boolean canDuplicateElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        if (xMLElement == null) {
            return true;
        }
        ExtendedAttribute extendedAttribute = null;
        if (xMLElement instanceof ExtendedAttribute) {
            extendedAttribute = (ExtendedAttribute)xMLElement;
        } else if (xMLElement.getParent() instanceof ExtendedAttribute) {
            extendedAttribute = (ExtendedAttribute)xMLElement.getParent();
        }
        if (extendedAttribute != null) {
            return !GraphUtilities.isMyKindOfExtendedAttribute(extendedAttribute);
        }
        return !(xMLElement instanceof FreeTextExpressionParticipant) && !(xMLElement instanceof CommonExpressionParticipant);
    }

    @Override
    public boolean canRepositionElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        if (xMLElement == null) {
            return true;
        }
        ExtendedAttribute extendedAttribute = null;
        if (xMLElement instanceof ExtendedAttribute) {
            extendedAttribute = (ExtendedAttribute)xMLElement;
        } else if (xMLElement.getParent() instanceof ExtendedAttribute) {
            extendedAttribute = (ExtendedAttribute)xMLElement.getParent();
        }
        if (extendedAttribute != null) {
            return !GraphUtilities.isMyKindOfExtendedAttribute(extendedAttribute);
        }
        return !(xMLElement instanceof FreeTextExpressionParticipant) && !(xMLElement instanceof CommonExpressionParticipant);
    }

    @Override
    public void selectionChanged(ChoiceButton choiceButton, Object object) {
        if (this.updateInProgress) {
            return;
        }
        if (this.getSelectedGraph() == null) {
            return;
        }
        if (choiceButton.getChoiceType() == Participant.class) {
            Object object2;
            Participant participant = (Participant)object;
            this.setUpdateInProgress(true);
            JaWEManager.getInstance().getJaWEController().startUndouableChange();
            Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(this.getSelectedGraph().getXPDLObject());
            Lane lane = null;
            lane = participant instanceof FreeTextExpressionParticipant ? GraphUtilities.createDefaultLane(pool) : GraphUtilities.createLaneForPerformer(pool, participant.getId());
            GraphUtilities.createNodeGraphicsInfo((XMLCollectionElement)lane, null, null, true);
            XMLElement xMLElement = JaWEManager.getInstance().getJaWEController().getSelectionManager().getSelectedElement();
            Point point = null;
            if (xMLElement instanceof Participant) {
                object2 = GraphUtilities.getLaneForPerformer(pool, ((Participant)xMLElement).getId());
                GraphSwimlaneInterface graphSwimlaneInterface = this.getSelectedGraph().getGraphManager().getGraphParticipant(object2);
                if (graphSwimlaneInterface != null) {
                    Rectangle rectangle = this.getSelectedGraph().getGraphManager().getCBounds(graphSwimlaneInterface, new HashMap());
                    point = new Point(rectangle.x + 11, rectangle.y + 11);
                    NestedLane nestedLane = (NestedLane)object2.getNestedLanes().generateNewElement();
                    nestedLane.setLaneId(lane.getId());
                    object2.getNestedLanes().add((XMLElement)nestedLane);
                }
            }
            this.getSelectedGraph().getGraphManager().insertParticipantAndArrangeParticipants(lane, point);
            object2 = new ArrayList();
            object2.add(participant);
            JaWEManager.getInstance().getJaWEController().endUndouableChange((List)object2);
            this.selectedGraph.clearSelection();
            this.selectedGraph.selectParticipant(lane);
            this.setUpdateInProgress(false);
            this.adjustActions();
        } else if (choiceButton.getChoiceType() == ActivitySet.class) {
            ActivitySet activitySet = (ActivitySet)object;
            this.setSelectedGraph(this.getGraph((XMLCollectionElement)activitySet));
            JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection((XMLElement)activitySet, true);
        }
    }

    @Override
    public Object getSelectedObject(ChoiceButton choiceButton) {
        if (choiceButton.getChoiceType() == Participant.class) {
            return null;
        }
        return null;
    }

    @Override
    public List getChoices(ChoiceButton choiceButton) {
        ArrayList arrayList = new ArrayList();
        if (this.selectedGraph == null) {
            return arrayList;
        }
        if (choiceButton.getChoiceType() == Participant.class) {
            WorkflowProcess workflowProcess = this.selectedGraph.getWorkflowProcess();
            SequencedHashMap sequencedHashMap = XMLUtil.getPossibleParticipants((WorkflowProcess)workflowProcess, (XMLInterface)JaWEManager.getInstance().getXPDLHandler());
            List list = this.selectedGraph.getGraphManager().getDisplayedParticipants();
            Iterator iterator = sequencedHashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!list.contains(entry.getValue())) continue;
                iterator.remove();
            }
            arrayList.addAll(sequencedHashMap.values());
        } else if (choiceButton.getChoiceType() == ActivitySet.class) {
            WorkflowProcess workflowProcess = this.selectedGraph.getWorkflowProcess();
            arrayList = workflowProcess.getActivitySets().toElements();
        }
        return arrayList;
    }

    public void valueChanged(GraphSelectionEvent graphSelectionEvent) {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        Object[] objectArray = this.getSelectedGraph().getSelectionCells();
        Lane lane = null;
        ArrayList<XMLComplexElement> arrayList = new ArrayList<XMLComplexElement>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                WorkflowElement workflowElement;
                XMLComplexElement xMLComplexElement;
                if (!(objectArray[i] instanceof WorkflowElement) || (xMLComplexElement = (workflowElement = (WorkflowElement)objectArray[i]).getPropertyObject()) == null) continue;
                if (xMLComplexElement instanceof Lane) {
                    lane = (Lane)xMLComplexElement;
                }
                arrayList.add(xMLComplexElement);
            }
        }
        if (arrayList.size() != 0) {
            if (lane != null) {
                Participant participant = GraphUtilities.getParticipantForLane(lane, null);
                if (participant == null) {
                    this.setUpdateInProgress(true);
                    JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection((XMLElement)null, false);
                    this.setUpdateInProgress(false);
                } else {
                    JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection((XMLElement)participant, false);
                }
            } else if (arrayList.get(0) instanceof Pool) {
                JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection((XMLElement)JaWEManager.getInstance().getXPDLUtils().getProcessForPool((Pool)arrayList.get(0)), true);
            } else {
                JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(arrayList, true);
            }
        } else {
            JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection((XMLElement)this.selectedGraph.getXPDLObject(), true);
        }
        this.adjustActions();
        this.updateInProgress = false;
    }

    protected void init() throws Exception {
        this.panel = this.createPanel();
        this.adjustActions();
    }

    public GraphSettings getGraphSettings() {
        return this.settings;
    }

    public void update(XPDLElementChangeInfo xPDLElementChangeInfo) {
        XMLElement xMLElement = xPDLElementChangeInfo.getChangedElement();
        List list = xPDLElementChangeInfo.getChangedSubElements();
        int n = xPDLElementChangeInfo.getAction();
        if (n == 8) {
            if (this.selectedGraph != null) {
                if (this.overview != null && this.overview.getGraph() != null) {
                    this.overview.getGraph().clearSelection();
                }
                this.selectedGraph.clearSelection();
            }
            if (xMLElement != null) {
                ArrayList arrayList;
                Object object;
                Graph graph = null;
                XMLElement xMLElement2 = xMLElement;
                if (list.size() > 0) {
                    xMLElement2 = (XMLElement)list.get(list.size() - 1);
                }
                if (this.graphMap.containsKey(xMLElement2)) {
                    graph = this.getGraph((XMLCollectionElement)xMLElement2);
                }
                if (graph == null && this.selectedGraph != null) {
                    if (xMLElement2 instanceof Participant && (object = GraphUtilities.getLaneForPerformer(JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(this.selectedGraph.getXPDLObject()), ((Participant)xMLElement2).getId())) != null) {
                        xMLElement2 = object;
                    }
                    if (xMLElement2 instanceof Lane && this.selectedGraph.getGraphManager().getGraphParticipant((Lane)xMLElement2) != null) {
                        graph = this.selectedGraph;
                    } else if (xMLElement2 instanceof Activity && this.selectedGraph.getGraphManager().getGraphActivity((Activity)xMLElement2) != null) {
                        graph = this.selectedGraph;
                    } else if (xMLElement2 instanceof Transition && this.selectedGraph.getGraphManager().getGraphTransition((XMLCollectionElement)((Transition)xMLElement2)) != null) {
                        graph = this.selectedGraph;
                    } else if (xMLElement2 instanceof Association && this.selectedGraph.getGraphManager().getGraphTransition((XMLCollectionElement)((Association)xMLElement2)) != null) {
                        graph = this.selectedGraph;
                    }
                }
                if (graph == null) {
                    object = xMLElement2;
                    while ((object = object.getParent()) != null && !(object instanceof ActivitySet) && !(object instanceof WorkflowProcess)) {
                    }
                    if (object != null) {
                        graph = this.getGraph((XMLCollectionElement)object);
                    } else if (this.selectedGraph != null && XMLUtil.getPackage((XMLElement)xMLElement2) == XMLUtil.getPackage((XMLElement)this.selectedGraph.getXPDLObject())) {
                        graph = this.selectedGraph;
                    }
                }
                if (graph == null && (object = XMLUtil.getPackage((XMLElement)xMLElement2)) != null && (arrayList = object.getWorkflowProcesses().toElements()).size() != 0) {
                    graph = this.getGraph((XMLCollectionElement)arrayList.get(0));
                }
                if (graph != this.selectedGraph) {
                    this.setSelectedGraph(graph);
                }
                if (this.selectedGraph != null) {
                    this.selectedGraph.clearSelection();
                }
                object = null;
                arrayList = null;
                if (this.selectedGraph != null) {
                    ArrayList<XMLElement> arrayList2 = new ArrayList<XMLElement>();
                    ArrayList<XMLElement> arrayList3 = new ArrayList<XMLElement>();
                    ArrayList<XMLElement> arrayList4 = new ArrayList<XMLElement>();
                    if (list == null || list.size() == 0) {
                        arrayList4.add(xMLElement);
                    } else {
                        arrayList4.addAll(list);
                    }
                    for (XMLElement xMLElement3 : arrayList4) {
                        Lane lane;
                        if (xMLElement3 instanceof Participant && (lane = GraphUtilities.getLaneForPerformer(JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(this.selectedGraph.getXPDLObject()), ((Participant)xMLElement3).getId())) != null) {
                            xMLElement3 = lane;
                        }
                        object = this.selectedGraph.getGraphInterface(xMLElement3);
                        if (this.overview != null && object != null && !(object instanceof GraphTransitionInterface)) {
                            arrayList3.add((XMLElement)object);
                        }
                        if (object == null) continue;
                        arrayList = object;
                        arrayList2.add((XMLElement)object);
                    }
                    this.selectedGraph.selectElements(arrayList2.toArray(), true, true);
                    if (this.overview != null) {
                        this.overview.getGraph().selectElements(arrayList3.toArray(), true, true);
                    }
                }
                if (arrayList != null) {
                    this.selectedGraph.scrollCellToVisible(arrayList);
                }
            }
        } else if (xMLElement instanceof Package && (n == 3 || n == 5)) {
            Object object;
            Package package_;
            ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
            if (list != null) {
                arrayList.addAll(list);
            }
            if (list.size() == 0) {
                arrayList.add(xMLElement);
            }
            boolean bl = (package_ = JaWEManager.getInstance().getJaWEController().getMainPackage()) != null && !arrayList.contains(package_);
            for (int i = 0; i < list.size(); ++i) {
                object = (Package)list.get(i);
                if (n == 3) {
                    this.insertPackage((Package)object);
                    continue;
                }
                if (n != 5) continue;
                this.removePackage((Package)object);
            }
            if (bl) {
                XPDLHandler xPDLHandler = JaWEManager.getInstance().getXPDLHandler();
                object = new ArrayList(xPDLHandler.getAllPackages());
                object.removeAll(list);
                Map map = this.getAllPackageParticipants(list);
                List list2 = this.getAllWorkflowProcessesAndActivitySetsForAdjustment((List)object);
                for (XMLCollectionElement xMLCollectionElement : list2) {
                    GraphUtilities.adjustWorkflowProcessOrActivitySetOnUndoableChangeEvent(new ArrayList(), xMLCollectionElement, map, n == 3);
                }
            }
        } else if (n == 3 || n == 5 || n == 1) {
            ArrayList<XPDLElementChangeInfo> arrayList = new ArrayList<XPDLElementChangeInfo>();
            arrayList.add(xPDLElementChangeInfo);
            GraphUtilities.adjustPackageOnUndoableChangeEvent(arrayList);
        }
        this.adjustActions();
    }

    protected List getAllWorkflowProcessesAndActivitySetsForAdjustment(List list) {
        ArrayList arrayList = new ArrayList();
        for (Package package_ : list) {
            if (package_.isReadOnly()) continue;
            arrayList.addAll(package_.getWorkflowProcesses().toElements());
            for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
                arrayList.addAll(workflowProcess.getActivitySets().toElements());
            }
        }
        return arrayList;
    }

    protected Map getAllPackageParticipants(List list) {
        HashMap<String, Participant> hashMap = new HashMap<String, Participant>();
        for (Package package_ : list) {
            for (Participant participant : package_.getParticipants().toElements()) {
                String string = participant.getId();
                if (hashMap.containsKey(string)) continue;
                hashMap.put(string, participant);
            }
        }
        return hashMap;
    }

    protected GraphControllerPanel createPanel() {
        this.panel.configure();
        this.panel.init();
        return this.panel;
    }

    public GraphMarqueeHandler getGraphMarqueeHandler() {
        return this.graphMarqueeHandler;
    }

    public GraphObjectFactory getGraphObjectFactory() {
        return this.graphObjectFactory;
    }

    public GraphObjectRendererFactory getGraphObjectRendererFactory() {
        return this.graphObjectRendererFactory;
    }

    public XMLCollectionElement getDisplayedXPDLObject() {
        if (this.selectedGraph != null) {
            return this.selectedGraph.getXPDLObject();
        }
        return null;
    }

    public void createGraph(WorkflowProcess workflowProcess) {
        if (this.graphMap.get(workflowProcess) != null) {
            return;
        }
        Graph graph = new Graph(this, (GraphModel)new JaWEGraphModel(), (BasicMarqueeHandler)this.graphMarqueeHandler, workflowProcess);
        graph.addGraphSelectionListener(this);
        this.graphMap.put(workflowProcess, graph);
        graph.clearSelection();
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)graph));
    }

    public void createGraph(ActivitySet activitySet) {
        if (this.graphMap.get(activitySet) != null) {
            return;
        }
        Graph graph = new Graph(this, (GraphModel)new JaWEGraphModel(), (BasicMarqueeHandler)this.graphMarqueeHandler, activitySet);
        graph.addGraphSelectionListener(this);
        this.graphMap.put(activitySet, graph);
        graph.clearSelection();
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)graph));
    }

    protected Graph createGraph() {
        try {
            String string = this.settings.getGraphClass();
            Constructor<?> constructor = Class.forName(string).getConstructor(this.getClass(), JaWEGraphModel.class, GraphMarqueeHandler.class);
            return (Graph)((Object)constructor.newInstance(new Object[]{this, this.createGraphModel(), this.graphMarqueeHandler}));
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected JaWEGraphModel createGraphModel() {
        try {
            String string = this.settings.getGraphModelClass();
            return (JaWEGraphModel)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Graph getSelectedGraph() {
        return this.selectedGraph;
    }

    public Graph getGraph(XMLCollectionElement xMLCollectionElement) {
        return (Graph)((Object)this.graphMap.get(xMLCollectionElement));
    }

    protected void setSelectedGraph(Graph graph) {
        Graph graph2 = this.selectedGraph;
        if (this.selectedGraph != null) {
            this.selectedGraph.clearSelection();
        }
        this.selectedGraph = graph;
        this.panel.graphSelected(this.selectedGraph);
        if (this.selectedGraph != null) {
            this.getGraphMarqueeHandler().setSelectionMode();
        }
        if (this.overview != null) {
            this.overview.displayGraph();
        }
        if (this.hm != null) {
            this.hm.addToHistory((XMLElement)(graph2 != null ? graph2.getXPDLObject() : null), (XMLElement)(graph != null ? graph.getXPDLObject() : null));
        }
        this.adjustActions();
    }

    public void selectGraphForElement(XMLCollectionElement xMLCollectionElement) {
        Graph graph;
        Graph graph2 = this.selectedGraph;
        this.selectedGraph = graph = (Graph)((Object)this.graphMap.get(xMLCollectionElement));
        this.panel.graphSelected(this.selectedGraph);
        if (this.selectedGraph != null) {
            JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection((XMLElement)this.selectedGraph.getXPDLObject(), true);
            this.getGraphMarqueeHandler().setSelectionMode();
            if (this.overview != null) {
                this.overview.displayGraph();
            }
        }
        if (this.hm != null) {
            this.hm.addToHistory((XMLElement)(graph2 != null ? graph2.getXPDLObject() : null), (XMLElement)(graph != null ? graph.getXPDLObject() : null));
        }
        this.adjustActions();
    }

    protected void removeGraph(XMLCollectionElement xMLCollectionElement) {
        Graph graph = (Graph)((Object)this.graphMap.remove(xMLCollectionElement));
        ToolTipManager.sharedInstance().unregisterComponent((JComponent)((Object)graph));
        graph.removeGraphSelectionListener(this);
        if (this.selectedGraph == graph) {
            this.selectedGraph = null;
            this.panel.graphSelected(this.selectedGraph);
        }
        graph.clearXPDLObjectReferences();
        if (this.copyOrCutInfo != null) {
            this.copyOrCutInfo.removeGraphInfo(graph);
        }
        if (this.overview != null) {
            this.overview.displayGraph();
        }
        if (this.hm != null) {
            this.hm.removeFromHistory((XMLElement)xMLCollectionElement);
        }
        this.adjustActions();
    }

    public void displayPreviousGraph() {
        XMLCollectionElement xMLCollectionElement;
        Graph graph;
        if (this.hm != null && this.hm.canGoBack() && (graph = this.getGraph(xMLCollectionElement = (XMLCollectionElement)this.hm.getPrevious((XMLElement)(this.selectedGraph != null ? this.selectedGraph.getXPDLObject() : null)))) != this.selectedGraph) {
            this.selectedGraph = graph;
            this.panel.graphSelected(this.selectedGraph);
            if (this.selectedGraph != null) {
                this.getGraphMarqueeHandler().setSelectionMode();
            }
            if (this.overview != null) {
                this.overview.displayGraph();
            }
            if (graph != null) {
                JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection((XMLElement)graph.getXPDLObject(), true);
            }
        }
        this.adjustActions();
    }

    public void displayNextGraph() {
        XMLCollectionElement xMLCollectionElement;
        Graph graph;
        if (this.hm != null && this.hm.canGoForward() && (graph = this.getGraph(xMLCollectionElement = (XMLCollectionElement)this.hm.getNext((XMLElement)(this.selectedGraph != null ? this.selectedGraph.getXPDLObject() : null)))) != this.selectedGraph) {
            this.selectedGraph = graph;
            this.panel.graphSelected(this.selectedGraph);
            if (this.selectedGraph != null) {
                this.getGraphMarqueeHandler().setSelectionMode();
            }
            if (this.overview != null) {
                this.overview.displayGraph();
            }
            if (graph != null) {
                JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection((XMLElement)graph.getXPDLObject(), true);
            }
        }
        this.adjustActions();
    }

    protected void insertPackage(Package package_) {
        Iterator iterator = package_.getWorkflowProcesses().toElements().iterator();
        boolean bl = package_.isReadOnly();
        while (iterator.hasNext()) {
            WorkflowProcess workflowProcess = (WorkflowProcess)iterator.next();
            this.createGraph(workflowProcess);
            if (this.settings.performAutomaticLayoutOnInsertion()) {
                if (bl) {
                    workflowProcess.setReadOnly(false);
                }
                SimpleGraphLayout.layoutGraph(this, this.getGraph((XMLCollectionElement)workflowProcess));
                if (bl) {
                    workflowProcess.setReadOnly(true);
                }
            }
            for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
                this.createGraph(activitySet);
                if (!this.settings.performAutomaticLayoutOnInsertion()) continue;
                if (bl) {
                    workflowProcess.setReadOnly(false);
                }
                SimpleGraphLayout.layoutGraph(this, this.getGraph((XMLCollectionElement)activitySet));
                if (!bl) continue;
                workflowProcess.setReadOnly(true);
            }
        }
    }

    protected void removePackage(Package package_) {
        for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
            this.removeGraph((XMLCollectionElement)workflowProcess);
            for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
                this.removeGraph((XMLCollectionElement)activitySet);
            }
        }
    }

    protected XPDLElementChangeInfo createInfo(XMLElement xMLElement, List list, int n) {
        XPDLElementChangeInfo xPDLElementChangeInfo = new XPDLElementChangeInfo();
        xPDLElementChangeInfo.setChangedElement(xMLElement);
        if (list.size() != 0) {
            xPDLElementChangeInfo.setChangedElement((XMLElement)list.iterator().next());
        }
        xPDLElementChangeInfo.setChangedSubElements(list);
        xPDLElementChangeInfo.setAction(n);
        xPDLElementChangeInfo.setSource(this);
        return xPDLElementChangeInfo;
    }

    @Override
    public void setUpdateInProgress(boolean bl) {
        this.updateInProgress = bl;
    }

    @Override
    public boolean isUpdateInProgress() {
        return this.updateInProgress;
    }

    public CopyOrCutInfo getCopyOrCutInfo() {
        return this.copyOrCutInfo;
    }

    public GraphOverview getOverview() {
        return this.overview;
    }

    public HistoryManager getHistoryManager() {
        return this.hm;
    }

    public void adjustActions() {
        this.settings.adjustActions();
        this.panel.enableDisableButtons();
    }
}

