/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph.overviewpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.components.graph.Graph;
import org.enhydra.jawe.components.graph.GraphController;
import org.enhydra.jawe.components.graph.GraphOverview;
import org.enhydra.jawe.components.graph.overviewpanel.GraphOverviewGraphUI;
import org.enhydra.jawe.components.graph.overviewpanel.GraphOverviewMarqueeHandler;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Package;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellView;
import org.jgraph.plaf.GraphUI;

public class GraphOverviewPanel
extends JPanel
implements GraphOverview,
JaWEComponentView,
GraphSelectionListener,
ComponentListener {
    protected String type = "SPECIAL";
    protected Graph graph;
    protected GraphController controller;
    protected boolean update = false;

    @Override
    public JaWEComponentSettings getSettings() {
        return null;
    }

    @Override
    public void configure() {
    }

    @Override
    public void init() {
    }

    @Override
    public void init(GraphController graphController) {
        this.controller = graphController;
    }

    @Override
    public JaWEComponent getJaWEComponent() {
        return this.controller;
    }

    @Override
    public JComponent getDisplay() {
        return this;
    }

    @Override
    public JaWEComponentView getView() {
        return this;
    }

    @Override
    public String getComponentType() {
        return this.type;
    }

    @Override
    public void setComponentType(String string) {
        this.type = string;
    }

    @Override
    public String getName() {
        return "GraphOverview";
    }

    @Override
    public boolean adjustXPDL(Package package_) {
        return false;
    }

    @Override
    public List checkValidity(XMLElement xMLElement, boolean bl) {
        return null;
    }

    @Override
    public boolean canCreateElement(XMLCollection xMLCollection) {
        return true;
    }

    @Override
    public boolean canInsertElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canModifyElement(XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canRemoveElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canDuplicateElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canRepositionElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public GraphOverviewPanel() {
        this.addComponentListener(this);
    }

    @Override
    public void displayGraph() {
        Graph graph = this.controller.getSelectedGraph();
        if (graph != null) {
            this.graph = new Graph(graph);
            this.graph.setGridEnabled(false);
            this.graph.setGridVisible(false);
            this.graph.setMarqueeHandler(new GraphOverviewMarqueeHandler(this.controller));
            this.graph.setUI((GraphUI)new GraphOverviewGraphUI());
            graph.addComponentListener(this);
            this.graph.setAntiAliased(true);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.graph.setEditable(false);
            this.graph.setMoveable(false);
            this.graph.setSelectionEnabled(true);
            this.graph.addGraphSelectionListener(this);
            if (graph.getSelectionCell() != null) {
                this.graph.setSelectionCell(graph.getSelectionCell());
            }
            this.setLayout(new BorderLayout());
            this.removeAll();
            this.add((Component)((Object)this.graph), "Center");
            this.componentResized(null);
            this.repaint();
        } else {
            this.graph = null;
            if (this.getComponentCount() != 0) {
                this.removeAll();
                this.repaint();
            }
        }
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueChanged(GraphSelectionEvent graphSelectionEvent) {
        if (!this.controller.isUpdateInProgress()) {
            if (this.update) {
                return;
            }
            try {
                this.update = true;
                if (this.controller.getSelectedGraph() != null && graphSelectionEvent.getCell() != null) {
                    this.controller.getSelectedGraph().setSelectionCells(this.graph.getSelectionCells());
                    this.controller.getSelectedGraph().scrollCellToVisible(graphSelectionEvent.getCell());
                }
            }
            finally {
                this.update = false;
            }
        }
    }

    public void setUpdate(boolean bl) {
        this.update = bl;
    }

    public boolean getUpdate() {
        return this.update;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.graph == null) {
            return;
        }
        Rectangle rectangle = null;
        rectangle = AbstractCellView.getBounds((CellView[])this.graph.getGraphLayoutCache().getRoots()) != null ? AbstractCellView.getBounds((CellView[])this.graph.getGraphLayoutCache().getRoots()).getBounds() : this.controller.getSelectedGraph().getBounds();
        double d = 0.5;
        if (rectangle != null) {
            Dimension dimension = new Dimension(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            Dimension dimension2 = this.getSize();
            double d2 = dimension2.getWidth() * 0.95 / dimension.getWidth();
            double d3 = dimension2.getHeight() * 0.95 / dimension.getHeight();
            d = Math.min(Math.max(Math.min(d2, d3), 0.05), 0.5);
        }
        this.graph.setScale(d);
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.componentResized(componentEvent);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void setUpdateInProgress(boolean bl) {
    }

    @Override
    public boolean isUpdateInProgress() {
        return false;
    }
}

