/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.simplenavigator;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.components.XPDLTreeNode;
import org.enhydra.jawe.components.simplenavigator.SimpleNavigatorPanel;
import org.enhydra.jawe.components.simplenavigator.SimpleNavigatorSettings;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Package;

public class SimpleNavigator
implements JaWEComponent,
Observer,
TreeSelectionListener {
    protected String type = "TREE";
    protected SimpleNavigatorPanel panel;
    protected boolean updateInProgress = false;
    protected SimpleNavigatorSettings settings;

    public SimpleNavigator(JaWEComponentSettings jaWEComponentSettings) throws Exception {
        this.settings = (SimpleNavigatorSettings)jaWEComponentSettings;
        this.settings.init(this);
        this.init();
        JaWEManager.getInstance().getJaWEController().addObserver(this);
    }

    @Override
    public JaWEComponentSettings getSettings() {
        return this.settings;
    }

    public SimpleNavigatorSettings getNavigatorSettings() {
        return this.settings;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!(object instanceof XPDLElementChangeInfo)) {
            return;
        }
        XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)object);
        int n = xPDLElementChangeInfo.getAction();
        if (n != 1 && n != 3 && n != 5 && n != 7 && n != 8 && n != 15 && n != 16 && n != 17) {
            return;
        }
        long l = System.currentTimeMillis();
        JaWEManager.getInstance().getLoggingManager().info("SimpleNavigator -> update for event " + (Object)((Object)xPDLElementChangeInfo) + " started ...");
        if (n == 15 || n == 16 || n == 17) {
            for (int i = 0; i < xPDLElementChangeInfo.getChangedSubElements().size(); ++i) {
                this.update((XPDLElementChangeInfo)((Object)xPDLElementChangeInfo.getChangedSubElements().get(i)));
            }
        } else {
            this.update(xPDLElementChangeInfo);
        }
        JaWEManager.getInstance().getLoggingManager().info("SimpleNavigator -> update ended...");
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        JaWEManager.getInstance().getLoggingManager().debug("THE UPDATE OF NAVIG COMPONENT LASTED FOR " + d + " SECONDS!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(XPDLElementChangeInfo xPDLElementChangeInfo) {
        if (this.updateInProgress) {
            return;
        }
        if (xPDLElementChangeInfo.getSource() == this) {
            return;
        }
        this.updateInProgress = true;
        try {
            this.panel.handleXPDLChangeEvent(xPDLElementChangeInfo);
        }
        finally {
            this.updateInProgress = false;
        }
    }

    protected void init() {
        this.panel = new SimpleNavigatorPanel(this);
        this.panel.configure();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        XPDLTreeNode xPDLTreeNode;
        int n;
        if (this.updateInProgress) {
            return;
        }
        JaWEManager.getInstance().getLoggingManager().info("SimpleNavigator -> selection changed ...");
        TreePath treePath = treeSelectionEvent.getOldLeadSelectionPath();
        TreePath[] treePathArray = treeSelectionEvent.getPaths();
        ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        for (int i = 0; i < treePathArray.length; ++i) {
            if (treePathArray[i] != treeSelectionEvent.getNewLeadSelectionPath()) continue;
            n2 = i;
            break;
        }
        TreePath treePath2 = treePathArray[n2];
        treePathArray[n2] = treePathArray[treePathArray.length - 1];
        treePathArray[treePathArray.length - 1] = treePath2;
        for (n = 0; n < treePathArray.length; ++n) {
            if (treeSelectionEvent.isAddedPath(treePathArray[n])) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if (treePath == null) {
            bl = false;
            bl2 = false;
        }
        for (n = 0; n < treePathArray.length; ++n) {
            if (!treeSelectionEvent.isAddedPath(treePathArray[n])) continue;
            xPDLTreeNode = (XPDLTreeNode)treePathArray[n].getLastPathComponent();
            if (xPDLTreeNode == null || xPDLTreeNode.getXPDLElement() == null) {
                return;
            }
            arrayList.add(xPDLTreeNode.getXPDLElement());
        }
        if (bl && bl2) {
            JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(arrayList, true);
        } else if (bl && !bl2) {
            JaWEManager.getInstance().getJaWEController().getSelectionManager().addToSelection(arrayList);
        } else {
            arrayList.clear();
            if (this.panel.tree.isSelectionEmpty()) {
                arrayList.add(((XPDLTreeNode)treePathArray[0].getLastPathComponent()).getXPDLElement());
            } else {
                treePathArray = this.panel.tree.getSelectionPaths();
                for (n = 0; n < treePathArray.length; ++n) {
                    xPDLTreeNode = (XPDLTreeNode)treePathArray[n].getLastPathComponent();
                    if (xPDLTreeNode == null || xPDLTreeNode.getXPDLElement() == null) {
                        return;
                    }
                    arrayList.add(xPDLTreeNode.getXPDLElement());
                }
            }
            JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(arrayList, true);
        }
        JaWEManager.getInstance().getLoggingManager().info("SimpleNavigator -> observers notified about selection changed!");
    }

    @Override
    public JaWEComponentView getView() {
        return this.panel;
    }

    public JComponent getDisplay() {
        return this.panel.getDisplay();
    }

    @Override
    public String getComponentType() {
        return this.type;
    }

    @Override
    public void setComponentType(String string) {
        this.type = string;
    }

    @Override
    public String getName() {
        return "SimpleNavigatorComponent";
    }

    @Override
    public boolean adjustXPDL(Package package_) {
        return false;
    }

    @Override
    public List checkValidity(XMLElement xMLElement, boolean bl) {
        return null;
    }

    @Override
    public boolean canCreateElement(XMLCollection xMLCollection) {
        return true;
    }

    @Override
    public boolean canInsertElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canModifyElement(XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canRemoveElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canDuplicateElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canRepositionElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public void setUpdateInProgress(boolean bl) {
        this.updateInProgress = bl;
    }

    @Override
    public boolean isUpdateInProgress() {
        return this.updateInProgress;
    }
}

