/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.xpdlview;

import java.awt.Color;
import java.net.URL;
import java.util.Properties;
import javax.swing.ImageIcon;
import org.enhydra.jawe.AdditionalResourceManager;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;

public class XPDLViewSettings
extends JaWEComponentSettings {
    @Override
    public void init(JaWEComponent jaWEComponent) {
        this.PROPERTYFILE_PATH = "org/enhydra/jawe/components/xpdlview/properties/";
        this.PROPERTYFILE_NAME = "togwexpdlview.properties";
        super.init(jaWEComponent);
    }

    @Override
    public void loadDefault(JaWEComponent jaWEComponent, Properties properties) {
        this.arm = new AdditionalResourceManager(properties);
        this.componentSettings.put("ShowHighlight", new Boolean(properties.getProperty("ShowHighlight", "false").equals("true")));
        this.componentSettings.put("ShowXPDLDetails", new Boolean(properties.getProperty("ShowXPDLDetails", "false").equals("true")));
        URL uRL = ResourceManager.getResource(properties, "Image.FindNext");
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon(ResourceManager.class.getClassLoader().getResource("org/enhydra/jawe/images/findnext.png"));
        this.componentSettings.put("FindNext", imageIcon);
        Color color = null;
        try {
            color = Utils.getColor(ResourceManager.getResourceString(properties, "BackgroundColor"));
        }
        catch (Exception exception) {
            color = Utils.getColor("R=245,G=245,B=245");
        }
        this.componentSettings.put("BackgroundColor", color);
        this.componentSettings.putAll(Utils.loadAllMenusAndToolbars(properties));
        this.componentAction.putAll(Utils.loadActions(properties, jaWEComponent, this.componentAction));
    }

    public boolean showHighlight() {
        return (Boolean)this.componentSettings.get("ShowHighlight");
    }

    public boolean showXPDLDetails() {
        return (Boolean)this.componentSettings.get("ShowXPDLDetails");
    }

    public ImageIcon getFindNextIcon() {
        return (ImageIcon)this.componentSettings.get("FindNext");
    }

    public Color getBackgroundColor() {
        return (Color)this.componentSettings.get("BackgroundColor");
    }
}

