/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph.actions.jped;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.CachedImageHandlerBase64Encoder;
import org.apache.batik.svggen.GenericImageHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.enhydra.jawe.ActionBase;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.components.graph.Graph;
import org.enhydra.jawe.components.graph.GraphController;
import org.enhydra.jxpdl.XMLElement;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SaveAsSVG
extends ActionBase {
    public SaveAsSVG(JaWEComponent jaWEComponent) {
        super(jaWEComponent);
    }

    public void enableDisableAction() {
        GraphController graphController = (GraphController)this.jawecomponent;
        if (graphController.getSelectedGraph() != null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = JaWEManager.getInstance().getJaWEController().saveDialog(ResourceManager.getLanguageDependentString((String)"SaveAsSVGLabel"), 2, JaWEManager.getInstance().getDisplayNameGenerator().getDisplayName((XMLElement)((GraphController)this.jawecomponent).getSelectedGraph().getXPDLObject()));
            if (string != null && string.length() > 0) {
                SaveAsSVG.saveGraphAsSVG(string, ((GraphController)this.jawecomponent).getSelectedGraph());
            }
        }
        catch (Exception exception) {
            String string = ResourceManager.getLanguageDependentString((String)"ErrorSVGSavingFailed");
            JaWEManager.getInstance().getJaWEController().message(string, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveGraphAsSVG(String string, Graph graph) throws Exception {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, JaWEManager.getInstance().getJaWEController().getControllerSettings().getEncoding());
            DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
            String string2 = "http://www.w3.org/2000/svg";
            Document document = dOMImplementation.createDocument(string2, "svg", null);
            graph.setDoubleBuffered(false);
            RepaintManager repaintManager = RepaintManager.currentManager((JComponent)graph);
            boolean bl = repaintManager.isDoubleBufferingEnabled();
            System.out.println("saving as svg");
            SVGGeneratorContext sVGGeneratorContext = SVGGeneratorContext.createDefault((Document)document);
            sVGGeneratorContext.setPrecision(4);
            sVGGeneratorContext.setEmbeddedFontsOn(true);
            CachedImageHandlerBase64Encoder cachedImageHandlerBase64Encoder = new CachedImageHandlerBase64Encoder();
            sVGGeneratorContext.setGenericImageHandler((GenericImageHandler)cachedImageHandlerBase64Encoder);
            SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(sVGGeneratorContext, false);
            Rectangle2D rectangle2D = graph.getCellBounds(graph.getRoots());
            Graphics graphics = sVGGraphics2D.create(0, 0, (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            repaintManager.setDoubleBufferingEnabled(false);
            try {
                graph.printAll(graphics);
            }
            finally {
                repaintManager.setDoubleBufferingEnabled(bl);
            }
            boolean bl2 = true;
            sVGGraphics2D.stream((Writer)outputStreamWriter, bl2);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }
}

