/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph.jped;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.ChapterAutoNumber;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.Section;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.base.controller.JaWEType;
import org.enhydra.jawe.components.graph.Graph;
import org.enhydra.jawe.components.graph.jped.PDFChain;
import org.enhydra.jawe.components.graph.jped.PDFDocumentChain;
import org.enhydra.jawe.components.graph.jped.PDFElementChain;
import org.enhydra.jawe.components.graph.jped.PDFSectionChain;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Activities;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.DataField;
import org.enhydra.jxpdl.elements.DataFields;
import org.enhydra.jxpdl.elements.ExtendedAttribute;
import org.enhydra.jxpdl.elements.ExtendedAttributes;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.Transitions;
import org.enhydra.jxpdl.elements.WorkflowProcess;

public class PDFPlugin {
    private static Logger log = Logger.getLogger(PDFPlugin.class.getName());
    private static Font CHAPTER_FONT = FontFactory.getFont((String)"Helvetica", (float)24.0f, (int)1, (BaseColor)BaseColor.BLACK);
    private static Font SECTION_FONT = FontFactory.getFont((String)"Helvetica", (float)16.0f, (int)1, (BaseColor)BaseColor.BLACK);
    private static Font NORMAL_FONT = FontFactory.getFont((String)"Helvetica", (float)10.0f, (int)0, (BaseColor)BaseColor.BLACK);
    private static Font PARAMETER_FONT = FontFactory.getFont((String)"Helvetica", (float)10.0f, (int)2, (BaseColor)BaseColor.BLACK);
    private static Font TRANSITION_CONDITION_FONT = FontFactory.getFont((String)"Helvetica", (float)8.0f, (int)0, (BaseColor)BaseColor.BLACK);
    private Graph graph;
    private com.itextpdf.text.Image graphImage;
    private Map transitionPictures = new HashMap();
    public static List excludedAttributes = new ArrayList();

    private com.itextpdf.text.Image getGraphImage() {
        BufferedImage bufferedImage = null;
        Object[] objectArray = this.graph.getRoots();
        if (objectArray.length <= 0) {
            return null;
        }
        double d = this.graph.getScale();
        java.awt.Rectangle rectangle = this.graph.getCellBounds(objectArray).getBounds();
        this.graph.toScreen((Rectangle2D)rectangle);
        Dimension dimension = rectangle.getSize();
        bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.graph.paint((Graphics)graphics2D);
        this.graph.setScale(d);
        try {
            this.graphImage = com.itextpdf.text.Image.getInstance((Image)bufferedImage, null);
        }
        catch (BadElementException badElementException) {
            badElementException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this.graphImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertGraphImage(Document document, WorkflowProcess workflowProcess) {
        Rectangle rectangle = document.getPageSize();
        try {
            com.itextpdf.text.Image image = this.getGraphImage();
            if (image != null) {
                float f = (rectangle.getWidth() - rectangle.getBorderWidthLeft() - rectangle.getBorderWidthRight()) * 0.8f;
                float f2 = (rectangle.getHeight() - rectangle.getBorderWidthTop() - rectangle.getBorderWidthBottom()) * 0.8f;
                image.setAlignment(1);
                float f3 = f / f2;
                float f4 = image.getScaledWidth() / image.getScaledHeight();
                if (f3 > 1.0f && f4 < 1.0f || f3 < 1.0f && f4 > 1.0f) {
                    image.setRotationDegrees(-90.0f);
                    f4 = 1.0f / f4;
                }
                float f5 = f4 > f3 ? f / image.getScaledWidth() : f2 / image.getScaledHeight();
                image.scaleToFit(image.getScaledWidth() * f5, image.getScaledHeight() * f5);
                Paragraph paragraph = new Paragraph();
                paragraph.setAlignment(1);
                paragraph.add((Element)new Phrase(workflowProcess.getId(), SECTION_FONT));
                document.add((Element)paragraph);
                document.add((Element)Chunk.NEWLINE);
                Paragraph paragraph2 = new Paragraph();
                paragraph2.add((Element)new Phrase(workflowProcess.getProcessHeader().getDescription(), NORMAL_FONT));
                document.add((Element)paragraph2);
                document.newPage();
                document.add((Element)image);
                document.newPage();
            }
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
        finally {
            document.setPageSize(rectangle);
        }
    }

    private boolean addParameterRow(PdfPTable pdfPTable, XMLElement xMLElement, PDFChain pDFChain) throws DocumentException {
        Element element;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("creating row for element " + xMLElement + "(name=" + xMLElement.toName() + ")");
        }
        if ((element = pDFChain.startProcessElement(xMLElement)) != null) {
            pdfPTable.addCell(this.makeBorderLessCell((Element)new Phrase(JaWEManager.getInstance().getLabelGenerator().getLabel(xMLElement), PARAMETER_FONT)));
            pdfPTable.addCell(this.makeBorderLessCell(element));
            return true;
        }
        return false;
    }

    private boolean addParameterRowNoId(PdfPTable pdfPTable, XMLElement xMLElement, PDFChain pDFChain) throws DocumentException {
        Element element;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("creating row for element " + xMLElement + "(name=" + xMLElement.toName() + ")");
        }
        if ((element = pDFChain.startProcessElement(xMLElement)) != null) {
            PdfPCell pdfPCell = this.makeBorderLessCell(element);
            pdfPCell.setColspan(2);
            pdfPTable.addCell(pdfPCell);
            return true;
        }
        return false;
    }

    private boolean addAttributeRow(PdfPTable pdfPTable, ExtendedAttribute extendedAttribute, PDFChain pDFChain) throws DocumentException {
        Element element = pDFChain.startProcessElement((XMLElement)extendedAttribute);
        if (element != null) {
            pdfPTable.addCell(this.makeBorderLessCell((Element)new Phrase(extendedAttribute.getName(), PARAMETER_FONT)));
            pdfPTable.addCell(this.makeBorderLessCell(element));
            return true;
        }
        return false;
    }

    private PdfPTable makeDataFieldReport(DataField dataField, PDFChain pDFChain) throws DocumentException {
        PdfPTable pdfPTable = new PdfPTable(2);
        this.addParameterRow(pdfPTable, dataField.get("Id"), pDFChain);
        this.addParameterRow(pdfPTable, dataField.get("Name"), pDFChain);
        this.addParameterRow(pdfPTable, dataField.get("InitialValue"), pDFChain);
        this.addParameterRow(pdfPTable, dataField.get("Description"), pDFChain);
        this.addParameterRow(pdfPTable, dataField.get("ExtendedAttributes"), pDFChain);
        return pdfPTable;
    }

    private PdfPCell makeBorderLessCell(Element element) {
        PdfPCell pdfPCell;
        if (element instanceof Phrase) {
            pdfPCell = new PdfPCell((Phrase)element);
        } else if (element instanceof PdfPTable) {
            pdfPCell = new PdfPCell((PdfPTable)element);
        } else if (element instanceof com.itextpdf.text.Image) {
            pdfPCell = new PdfPCell((com.itextpdf.text.Image)element);
        } else {
            pdfPCell = new PdfPCell();
            pdfPCell.addElement(element);
        }
        pdfPCell.setBorderWidth(0.0f);
        return pdfPCell;
    }

    private com.itextpdf.text.Image getTransitionPicture(JaWEType jaWEType, boolean bl, String string) throws Exception {
        int n;
        if (!this.transitionPictures.containsKey(jaWEType)) {
            this.transitionPictures.put(jaWEType, new com.itextpdf.text.Image[4]);
        }
        com.itextpdf.text.Image[] imageArray = (com.itextpdf.text.Image[])this.transitionPictures.get(jaWEType);
        int n2 = n = string.length() == 0 ? 0 : 1;
        if (bl) {
            n += 2;
        }
        if (imageArray[n] == null) {
            BufferedImage bufferedImage = new BufferedImage(90, 37, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 1, 90, 37);
            graphics.setColor(jaWEType.getColor());
            int n3 = string.length() == 0 ? 3 : 9;
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (bl) {
                graphics2D.setTransform(new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 90.0f, 0.0f));
            }
            graphics2D.setStroke(new BasicStroke(n3, 1, 2));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawLine(3, 17, 84 - n3, 17);
            graphics2D.drawLine(85, 17, 61, 5);
            graphics2D.drawLine(85, 17, 61, 29);
            com.itextpdf.text.Image image = com.itextpdf.text.Image.getInstance((Image)bufferedImage, null);
            image.scaleToFit(30.0f, 19.0f);
            imageArray[n] = image;
        }
        return imageArray[n];
    }

    private com.itextpdf.text.Image getTransitionPicture(Transition transition, boolean bl) throws Exception {
        JaWEType jaWEType = JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)transition);
        return this.getTransitionPicture(jaWEType, bl, transition.getCondition().toValue());
    }

    private List getActivityOutgoingTransitions(Activity activity) {
        WorkflowProcess workflowProcess = (WorkflowProcess)activity.getParent().getParent();
        Transitions transitions = workflowProcess.getTransitions();
        ArrayList arrayList = transitions.toElements();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Transition && ((Transition)e).getFrom().equals(activity.getId())) continue;
            iterator.remove();
        }
        return arrayList;
    }

    private List getActivityIngoingTransitions(Activity activity) {
        WorkflowProcess workflowProcess = (WorkflowProcess)activity.getParent().getParent();
        Transitions transitions = workflowProcess.getTransitions();
        ArrayList arrayList = transitions.toElements();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Transition && ((Transition)e).getTo().equals(activity.getId())) continue;
            iterator.remove();
        }
        return arrayList;
    }

    private PdfPTable makeActivityTable(Activity activity, PDFSectionChain pDFSectionChain) throws DocumentException {
        String string;
        PdfPTable pdfPTable = new PdfPTable(2);
        pdfPTable.setWidthPercentage(100.0f);
        pdfPTable.setKeepTogether(true);
        Rectangle rectangle = new Rectangle(0.0f, 0.0f);
        rectangle.setBorderWidth(0.0f);
        PdfPTable pdfPTable2 = new PdfPTable(new float[]{0.3f, 0.7f});
        this.addParameterRow(pdfPTable2, activity.get("Id"), pDFSectionChain);
        this.addParameterRow(pdfPTable2, activity.get("Name"), pDFSectionChain);
        this.addParameterRow(pdfPTable2, (XMLElement)activity.getFirstPerformerObj(), pDFSectionChain);
        this.addParameterRow(pdfPTable2, activity.get("Deadlines"), pDFSectionChain);
        PdfPCell pdfPCell = this.makeBorderLessCell((Element)pdfPTable2);
        pdfPTable.addCell(pdfPCell);
        pdfPTable2 = new PdfPTable(new float[]{0.2f, 0.3f, 0.5f});
        List list = this.getActivityIngoingTransitions(activity);
        if (!list.isEmpty()) {
            pdfPCell = new PdfPCell(new Phrase("Incoming transitions"));
            pdfPCell.setColspan(3);
            pdfPTable2.addCell(pdfPCell);
            for (Transition transition : list) {
                string = transition.getCondition().toValue();
                try {
                    pdfPTable2.addCell(this.makeBorderLessCell((Element)this.getTransitionPicture(transition, true)));
                    pdfPTable2.addCell(this.makeBorderLessCell((Element)new Phrase(transition.getFrom(), TRANSITION_CONDITION_FONT)));
                    pdfPTable2.addCell(this.makeBorderLessCell((Element)new Phrase(string, TRANSITION_CONDITION_FONT)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (!(list = this.getActivityOutgoingTransitions(activity)).isEmpty()) {
            pdfPCell = new PdfPCell(new Phrase("Outgoing transitions"));
            pdfPCell.setColspan(3);
            pdfPTable2.addCell(pdfPCell);
            for (Transition transition : list) {
                string = transition.getCondition().toValue();
                try {
                    pdfPTable2.addCell(this.makeBorderLessCell((Element)this.getTransitionPicture(transition, false)));
                    pdfPTable2.addCell(this.makeBorderLessCell((Element)new Phrase(transition.getTo(), TRANSITION_CONDITION_FONT)));
                    pdfPTable2.addCell(this.makeBorderLessCell((Element)new Phrase(string, TRANSITION_CONDITION_FONT)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        pdfPCell = this.makeBorderLessCell((Element)pdfPTable2);
        pdfPTable.addCell(pdfPCell);
        pdfPTable2 = new PdfPTable(new float[]{0.3f, 0.7f});
        this.addParameterRowNoId(pdfPTable2, activity.get("Description"), pDFSectionChain);
        this.addParameterRow(pdfPTable2, activity.get("ExtendedAttributes"), pDFSectionChain);
        pdfPCell = this.makeBorderLessCell((Element)pdfPTable2);
        pdfPCell.setColspan(2);
        pdfPTable.addCell(pdfPCell);
        return pdfPTable;
    }

    public Document processDocument(PDFDocumentChain pDFDocumentChain) throws DocumentException {
        this.graph = pDFDocumentChain.getGraph();
        Document document = null;
        if (pDFDocumentChain.getElement() instanceof WorkflowProcess) {
            document = new Document(PageSize.A4);
            PdfWriter.getInstance((Document)document, (OutputStream)pDFDocumentChain.getOutputStream());
            document.open();
            WorkflowProcess workflowProcess = (WorkflowProcess)pDFDocumentChain.getElement();
            this.insertGraphImage(document, workflowProcess);
            document.add((Element)pDFDocumentChain.startProcessSection((XMLElement)workflowProcess.getDataFields()));
            document.add((Element)pDFDocumentChain.startProcessSection((XMLElement)workflowProcess.getActivities()));
        }
        this.graph = null;
        return document;
    }

    public Element processElement(PDFElementChain pDFElementChain) throws DocumentException {
        if (log.isLoggable(Level.FINER)) {
            if (pDFElementChain.getElement() == null) {
                log.finer("received a null element to processElement");
            } else {
                log.finer("processing element of type " + pDFElementChain.getElement().getClass().getName() + "(value=" + pDFElementChain.getElement().toValue() + ")");
            }
        }
        if (pDFElementChain.getElement() instanceof ExtendedAttributes) {
            ArrayList arrayList = ((ExtendedAttributes)pDFElementChain.getElement()).toElements();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("There are " + arrayList.size() + " extended attributes to process");
            }
            boolean bl = false;
            PdfPTable pdfPTable = new PdfPTable(2);
            pdfPTable.setWidthPercentage(100.0f);
            pdfPTable.setKeepTogether(true);
            for (ExtendedAttribute extendedAttribute : arrayList) {
                if (excludedAttributes.contains(extendedAttribute.getName())) continue;
                bl |= this.addAttributeRow(pdfPTable, extendedAttribute, pDFElementChain);
            }
            if (bl) {
                return pdfPTable;
            }
            return null;
        }
        String string = null;
        XMLElement xMLElement = pDFElementChain.getElement();
        if (xMLElement != null) {
            XMLComplexElement xMLComplexElement;
            string = pDFElementChain.getElement().toValue();
            if (pDFElementChain.getElement() instanceof XMLComplexElement && (xMLComplexElement = (XMLComplexElement)pDFElementChain.getElement()).containsName("Value")) {
                string = xMLComplexElement.get("Value").toValue();
            }
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        return new Paragraph(string, NORMAL_FONT);
    }

    public Section processSection(PDFSectionChain pDFSectionChain) throws DocumentException {
        if (pDFSectionChain.getElement() instanceof DataFields) {
            Chunk chunk = new Chunk("Variables", CHAPTER_FONT);
            Paragraph paragraph = new Paragraph("", CHAPTER_FONT);
            paragraph.add((Element)chunk);
            ChapterAutoNumber chapterAutoNumber = new ChapterAutoNumber(paragraph);
            ArrayList arrayList = ((DataFields)pDFSectionChain.getElement()).toElements();
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    DataField dataField = (DataField)object;
                    DataField dataField2 = (DataField)object2;
                    return dataField.getId().compareTo(dataField2.getId());
                }
            });
            Section section = pDFSectionChain.getEnclosingSection();
            pDFSectionChain.setEnclosingSection((Section)chapterAutoNumber);
            for (DataField dataField : arrayList) {
                pDFSectionChain.startProcessSection((XMLElement)dataField);
            }
            pDFSectionChain.setEnclosingSection(section);
            return chapterAutoNumber;
        }
        if (pDFSectionChain.getElement() instanceof DataField) {
            DataField dataField = (DataField)pDFSectionChain.getElement();
            String string = dataField.getId();
            Paragraph paragraph = new Paragraph(string, SECTION_FONT);
            Section section = pDFSectionChain.getEnclosingSection().addSection(paragraph);
            section.add((Element)Chunk.NEWLINE);
            section.add((Element)this.makeDataFieldReport(dataField, pDFSectionChain));
            return section;
        }
        if (pDFSectionChain.getElement() instanceof Activities) {
            Chunk chunk = new Chunk("Activities", CHAPTER_FONT);
            Paragraph paragraph = new Paragraph("", CHAPTER_FONT);
            paragraph.add((Element)chunk);
            ChapterAutoNumber chapterAutoNumber = new ChapterAutoNumber(paragraph);
            ArrayList arrayList = ((Activities)pDFSectionChain.getElement()).toElements();
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    Activity activity = (Activity)object;
                    Activity activity2 = (Activity)object2;
                    return activity.getId().compareTo(activity2.getId());
                }
            });
            Section section = pDFSectionChain.getEnclosingSection();
            pDFSectionChain.setEnclosingSection((Section)chapterAutoNumber);
            for (Activity activity : arrayList) {
                pDFSectionChain.startProcessSection((XMLElement)activity);
            }
            pDFSectionChain.setEnclosingSection(section);
            return chapterAutoNumber;
        }
        if (pDFSectionChain.getElement() instanceof Activity) {
            Activity activity = (Activity)pDFSectionChain.getElement();
            String string = activity.getName();
            if (string == null || string.length() == 0) {
                string = activity.getId();
            }
            Paragraph paragraph = new Paragraph(string, SECTION_FONT);
            Section section = pDFSectionChain.getEnclosingSection().addSection(paragraph);
            section.add((Element)Chunk.NEWLINE);
            PdfPTable pdfPTable = this.makeActivityTable(activity, pDFSectionChain);
            section.add((Element)pdfPTable);
            return section;
        }
        log.warning("Could not handle section for " + pDFSectionChain.getElement() + " in code pdf plugin");
        return null;
    }

    static {
        excludedAttributes.add("JaWE_GRAPH_PARTICIPANT_ID");
        excludedAttributes.add("JaWE_GRAPH_OFFSET");
    }
}

