/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class FindDialog
extends JDialog
implements ActionListener {
    private JButton buttonFind;
    private JButton buttonReplace;
    private JButton buttonCancel;
    private JLabel labelFind;
    private JLabel labelReplace;
    private JTextField textFind;
    private JTextField textReplace;
    private TextEditorPane textPane;
    private Checkbox back;
    private Checkbox forward;

    public FindDialog(TextEditorPane pane) {
        this.textPane = pane;
        this.setTitle("Find");
        this.setSize(300, 200);
        this.setDefaultCloseOperation(2);
        this.createComponent();
        this.setResizable(false);
        this.setModal(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int y = screenSize.height / 2 - this.getHeight() / 2;
        int x = screenSize.width / 2 - this.getWidth() / 2;
        this.setLocation(x, y);
        this.addWindowListener(new FindDialogListener());
        this.setVisible(true);
    }

    private void createComponent() {
        this.setLayout(new GridLayout(6, 2));
        this.labelFind = new JLabel("Find", 0);
        this.getContentPane().add(this.labelFind);
        this.textFind = new JTextField("");
        this.getContentPane().add(this.textFind);
        this.labelReplace = new JLabel("Replace With", 0);
        this.getContentPane().add(this.labelReplace);
        this.textReplace = new JTextField("");
        this.getContentPane().add(this.textReplace);
        this.getContentPane().add(new JLabel(""));
        this.getContentPane().add(new JLabel(""));
        CheckboxGroup group = new CheckboxGroup();
        this.back = new Checkbox("Back", group, false);
        this.forward = new Checkbox("Forward", group, true);
        this.getContentPane().add(this.back);
        this.getContentPane().add(this.forward);
        this.buttonReplace = new JButton("Replace");
        this.buttonReplace.addActionListener(this);
        this.getContentPane().add(this.buttonReplace);
        this.getContentPane().add(new JLabel(""));
        this.buttonFind = new JButton("Find");
        this.buttonFind.addActionListener(this);
        this.getContentPane().add(this.buttonFind);
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.addActionListener(this);
        this.getContentPane().add(this.buttonCancel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.buttonCancel)) {
            this.textPane.resetFind();
            this.dispose();
        } else if (source.equals(this.buttonFind)) {
            if (!this.textFind.getText().equalsIgnoreCase("")) {
                if (this.back.getState()) {
                    this.textPane.findBack(this.textFind.getText());
                } else {
                    this.textPane.findForward(this.textFind.getText());
                }
            } else {
                JOptionPane.showMessageDialog(this, "You must insert some word/s in the TextField Find", "Error", 0);
            }
        } else if (source.equals(this.buttonReplace)) {
            if (this.textReplace.getText().equalsIgnoreCase("")) {
                JOptionPane.showMessageDialog(this, "You must insert some word/s in the TextField Replace", "Error", 0);
            } else if (this.textPane.getSelectedText() == null) {
                JOptionPane.showMessageDialog(this, "You must select some text", "Error", 0);
            } else {
                this.textPane.replaceSelection(this.textReplace.getText());
            }
        }
    }

    class FindDialogListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent e) {
            FindDialog.this.textPane.resetFind();
        }
    }
}

