/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.AWTKeyStroke;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.browser.BrowserView;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.TaskManager;

public class VFSFileNameField
extends HistoryTextField {
    private VFSBrowser browser;

    public VFSFileNameField(VFSBrowser browser, String model) {
        super(model);
        this.setEnterAddsToHistory(false);
        this.browser = browser;
        Dimension dim = this.getPreferredSize();
        dim.width = Integer.MAX_VALUE;
        this.setMaximumSize(dim);
        boolean FORWARD = false;
        HashSet<AWTKeyStroke> keys = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
        keys.remove(AWTKeyStroke.getAWTKeyStroke("pressed TAB"));
        this.setFocusTraversalKeys(0, keys);
    }

    @Override
    public void processKeyEvent(KeyEvent evt) {
        if (evt.getID() == 401) {
            String path = this.getText();
            switch (evt.getKeyCode()) {
                case 9: {
                    this.doComplete(path);
                    break;
                }
                case 37: {
                    if ((evt.getModifiers() & 8) > 0) {
                        this.browser.previousDirectory();
                        evt.consume();
                        break;
                    }
                    super.processKeyEvent(evt);
                    break;
                }
                case 38: {
                    if ((evt.getModifiers() & 8) > 0) {
                        String p = this.browser.getDirectory();
                        this.browser.setDirectory(MiscUtilities.getParentOfPath(p));
                        evt.consume();
                        break;
                    }
                    this.browser.getBrowserView().getTable().processKeyEvent(evt);
                    break;
                }
                case 39: {
                    if ((evt.getModifiers() & 8) > 0) {
                        evt.consume();
                        this.browser.nextDirectory();
                        break;
                    }
                    super.processKeyEvent(evt);
                    break;
                }
                case 33: 
                case 34: 
                case 40: {
                    this.browser.getBrowserView().getTable().processKeyEvent(evt);
                    break;
                }
                case 10: {
                    this.browser.filesActivated(evt.isShiftDown() ? 1 : 0, false);
                    this.setText(null);
                    evt.consume();
                    break;
                }
                default: {
                    super.processKeyEvent(evt);
                    break;
                }
            }
        } else if (evt.getID() == 400) {
            char ch = evt.getKeyChar();
            if (ch > ' ' && ch != '\u007f' && ch != '\u00ff') {
                super.processKeyEvent(evt);
                String path = this.getText();
                BrowserView view = this.browser.getBrowserView();
                view.selectNone();
                if (MiscUtilities.getLastSeparatorIndex(path) == -1) {
                    int mode = this.browser.getMode();
                    view.getTable().doTypeSelect(path, mode == 3 || mode == 1);
                }
            } else {
                super.processKeyEvent(evt);
            }
        }
    }

    public String doComplete(String path, String complete, boolean dirsOnly) {
        Log.log(1, VFSFileNameField.class, "doComplete(" + path + "," + complete + "," + dirsOnly);
        while (complete.length() != 0) {
            int index = MiscUtilities.getFirstSeparatorIndex(complete);
            if (index == -1) {
                return path;
            }
            String newPath = VFSFile.findCompletion(path, complete.substring(0, index), this.browser, true);
            if (newPath == null) {
                return null;
            }
            path = newPath;
            complete = complete.substring(index + 1);
        }
        return path;
    }

    private void doComplete(String currentText) {
        String newText;
        int index = MiscUtilities.getLastSeparatorIndex(currentText);
        String dir2 = index != -1 ? currentText.substring(0, index + 1) : "";
        if (MiscUtilities.isAbsolutePath(currentText)) {
            if (dir2.startsWith("/")) {
                dir2 = dir2.substring(1);
            }
            if ((dir2 = this.doComplete(VFSBrowser.getRootDirectory(), dir2, false)) == null) {
                return;
            }
            this.browser.setDirectory(dir2);
            TaskManager.instance.waitForIoTasks();
            if (index == -1) {
                if (currentText.startsWith("/")) {
                    currentText = currentText.substring(1);
                }
            } else {
                currentText = currentText.substring(index + 1);
            }
        } else if (dir2.length() != 0) {
            dir2 = this.doComplete(this.browser.getDirectory(), dir2, false);
            if (dir2 == null) {
                return;
            }
            this.browser.setDirectory(dir2);
            TaskManager.instance.waitForIoTasks();
            currentText = currentText.substring(index + 1);
        }
        BrowserView view = this.browser.getBrowserView();
        view.selectNone();
        view.getTable().doTypeSelect(currentText, this.browser.getMode() == 3);
        VFSFile[] files = view.getSelectedFiles();
        if (files.length == 0) {
            newText = currentText;
        } else {
            String path = files[0].getPath();
            String name = files[0].getName();
            String parent = MiscUtilities.getParentOfPath(path);
            newText = MiscUtilities.isAbsolutePath(currentText) && !currentText.startsWith(this.browser.getDirectory()) ? path : (MiscUtilities.pathsEqual(parent, this.browser.getDirectory()) ? name : path);
        }
        this.setText(newText);
    }

    private void goToParent() {
        String name = MiscUtilities.getFileName(this.browser.getDirectory());
        String parent = MiscUtilities.getParentOfPath(this.browser.getDirectory());
        this.browser.setDirectory(parent);
        VFS vfs = VFSManager.getVFSForPath(parent);
        if ((vfs.getCapabilities() & 0x40) != 0) {
            TaskManager.instance.waitForIoTasks();
            this.setText(name);
            this.browser.getBrowserView().getTable().doTypeSelect(name, this.browser.getMode() == 3);
        }
    }
}

