/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.Timer;

public class AnimatedIcon
extends ImageIcon {
    private Image[] frames;
    private int current;
    private int delay;
    private Timer timer;
    private Component host;
    private Image icon;

    public AnimatedIcon(Image icon, Image[] frames, int rate, Component host) {
        super(icon);
        this.icon = icon;
        this.frames = frames;
        this.delay = 1000 / rate;
        this.host = host;
    }

    public Image[] getFrames() {
        return this.frames;
    }

    public Image getIcon() {
        return this.icon;
    }

    public int getRate() {
        return 1000 / this.delay;
    }

    public void setFrames(Image[] frames) {
        this.frames = frames;
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    public void setRate(int rate) {
        this.delay = 1000 / rate;
    }

    public void start() {
        if (this.timer != null) {
            return;
        }
        this.timer = new Timer(this.delay, new Animator());
        this.timer.start();
    }

    public void stop() {
        this.current = 0;
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        this.setImage(this.icon);
        this.host.repaint();
    }

    class Animator
    implements ActionListener {
        Animator() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AnimatedIcon.this.current = (AnimatedIcon.this.current + 1) % AnimatedIcon.this.frames.length;
            AnimatedIcon.this.setImage(AnimatedIcon.this.frames[AnimatedIcon.this.current]);
            AnimatedIcon.this.host.repaint();
        }
    }
}

