/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import javax.annotation.Nonnull;
import org.gjt.sp.jedit.io.Encoding;

public class CharsetEncoding
implements Encoding {
    private final Charset body;

    public CharsetEncoding(String name) {
        this.body = Charset.forName(name);
    }

    @Override
    @Nonnull
    public Reader getTextReader(@Nonnull InputStream in) throws IOException {
        return new InputStreamReader(in, this.body.newDecoder());
    }

    @Override
    @Nonnull
    public Writer getTextWriter(@Nonnull OutputStream out) throws IOException {
        return new OutputStreamWriter(out, this.body.newEncoder());
    }

    @Override
    @Nonnull
    public Reader getPermissiveTextReader(@Nonnull InputStream in) throws IOException {
        CharsetDecoder permissive = this.body.newDecoder();
        permissive.onMalformedInput(CodingErrorAction.REPLACE);
        permissive.onUnmappableCharacter(CodingErrorAction.REPLACE);
        return new InputStreamReader(in, permissive);
    }
}

