/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.syntax.XModeHandler;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ModeProvider {
    public static ModeProvider instance = new ModeProvider();
    private final LinkedHashMap<String, Mode> modes = new LinkedHashMap(180);

    public void removeAll() {
        this.modes.clear();
    }

    public Mode getMode(String name) {
        return this.modes.get(name);
    }

    public Mode getModeForFile(String filename, String firstLine) {
        return this.getModeForFile(null, filename, firstLine);
    }

    public Mode getModeForFile(String filepath, String filename, String firstLine) {
        if (filepath != null && filepath.endsWith(".gz")) {
            filepath = filepath.substring(0, filepath.length() - 3);
        }
        if (filename != null && filename.endsWith(".gz")) {
            filename = filename.substring(0, filename.length() - 3);
        }
        ArrayList<Mode> acceptable = new ArrayList<Mode>(1);
        for (Mode mode : this.modes.values()) {
            if (!mode.accept(filepath, filename, firstLine)) continue;
            acceptable.add(mode);
        }
        if (acceptable.size() == 1) {
            return (Mode)acceptable.get(0);
        }
        if (acceptable.size() > 1) {
            Collections.reverse(acceptable);
            for (Mode mode : acceptable) {
                if (!mode.acceptIdentical(filepath, filename)) continue;
                return mode;
            }
            for (Mode mode : acceptable) {
                if (!mode.acceptFile(filepath, filename) || !mode.acceptFirstLine(firstLine)) continue;
                return mode;
            }
            for (Mode mode : acceptable) {
                if (!mode.acceptFile(filepath, filename)) continue;
                return mode;
            }
            return (Mode)acceptable.get(0);
        }
        return null;
    }

    public Mode[] getModes() {
        return this.modes.values().toArray(new Mode[this.modes.size()]);
    }

    public void addMode(Mode mode) {
        String name = mode.getName();
        this.modes.remove(name);
        this.modes.put(name, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMode(Mode mode, XModeHandler xmh) {
        BufferedInputStream grammar;
        XMLReader parser;
        String fileName = (String)mode.getProperty("file");
        Log.log(5, this, "Loading edit mode " + fileName);
        try {
            parser = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException saxe) {
            Log.log(9, this, saxe);
            return;
        }
        mode.setTokenMarker(xmh.getTokenMarker());
        try {
            grammar = new BufferedInputStream(new FileInputStream(fileName));
        }
        catch (FileNotFoundException e1) {
            InputStream resource = ModeProvider.class.getResourceAsStream(fileName);
            if (resource == null) {
                this.error(fileName, e1);
            }
            grammar = new BufferedInputStream(resource);
        }
        try {
            InputSource isrc = new InputSource(grammar);
            isrc.setSystemId("jedit.jar");
            parser.setContentHandler(xmh);
            parser.setDTDHandler(xmh);
            parser.setEntityResolver(xmh);
            parser.setErrorHandler(xmh);
            parser.parse(isrc);
            mode.setProperties(xmh.getModeProperties());
        }
        catch (Throwable e) {
            this.error(fileName, e);
        }
        finally {
            IOUtilities.closeQuietly((Closeable)grammar);
        }
    }

    public void loadMode(Mode mode) {
        XModeHandler xmh = new XModeHandler(mode.getName()){

            @Override
            public void error(String what, Object subst) {
                Log.log(9, this, subst);
            }

            @Override
            public TokenMarker getTokenMarker(String modeName) {
                Mode mode = ModeProvider.this.getMode(modeName);
                if (mode == null) {
                    return null;
                }
                return mode.getTokenMarker();
            }
        };
        this.loadMode(mode, xmh);
    }

    protected void error(String file, Throwable e) {
        Log.log(9, this, e);
    }
}

