/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Point;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

class TextAreaDropHandler
extends DropTargetAdapter {
    private final TextArea textArea;
    private JEditBuffer savedBuffer;
    private int savedCaret;

    TextAreaDropHandler(TextArea textArea) {
        this.textArea = textArea;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        Log.log(1, this, "Drag enter");
        this.savedBuffer = this.textArea.getBuffer();
        this.savedCaret = this.textArea.getCaretPosition();
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Point p = dtde.getLocation();
        p = SwingUtilities.convertPoint(this.textArea, p, this.textArea.getPainter());
        int pos = this.textArea.xyToOffset(p.x, p.y, !this.textArea.getPainter().isBlockCaretEnabled() && !this.textArea.isOverwriteEnabled());
        if (pos != -1) {
            this.textArea.moveCaretPosition(pos, 2);
        }
    }

    @Override
    public void dragExit(DropTargetEvent dtde) {
        Log.log(1, this, "Drag exit");
        if (this.textArea.getBuffer() == this.savedBuffer) {
            this.textArea.moveCaretPosition(this.savedCaret, 2);
        }
        this.savedBuffer = null;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Log.log(1, this, "Drop");
        this.savedBuffer = null;
    }
}

