/*
 * Decompiled with CFR 0.152.
 */
package jnpad;

import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.LogManager;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import jnpad.JNPadFrame;
import jnpad.JNPadInput;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.config.Mode;
import jnpad.text.JNPadTextArea;
import jnpad.ui.plaf.LAFUtils;
import jnpad.util.Platform;
import jnpad.util.Utilities;
import jnpad.util.Version;

public final class JNPad {
    public static final String JNPAD_HOME;
    public static final String PROPS_DIR;
    public static final String LOGGERING_FILE_PATH;
    public static final String TITLE = "jNPad";
    public static final String EMAIL = "rgsevero@gmail.com";
    private static Mode mode;
    private static List<JNPadInput> inputFiles;
    private static String sessionPath;

    static {
        String bootFullName = JNPad.class.getResource("JNPad.class").toString();
        File jNPadDir = null;
        try {
            if (!bootFullName.startsWith("jar:")) {
                File startingDir = new File(new URI(bootFullName)).getParentFile();
                while (startingDir != null && !new File(startingDir.getParentFile(), "classes").isDirectory()) {
                    startingDir = startingDir.getParentFile();
                }
                if (startingDir != null) {
                    jNPadDir = startingDir.getParentFile();
                }
            } else {
                int classIndex = bootFullName.indexOf("!");
                String bootName = bootFullName.substring(4, classIndex);
                File finalFile = new File(new URI(bootName));
                jNPadDir = finalFile.getParentFile();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        JNPAD_HOME = jNPadDir != null ? jNPadDir.getAbsolutePath() : System.getProperty("user.dir");
        PROPS_DIR = String.valueOf(JNPAD_HOME) + Utilities.DIR_SEPARATOR + "props";
        LOGGERING_FILE_PATH = String.valueOf(PROPS_DIR) + Utilities.DIR_SEPARATOR + "log.properties";
    }

    private JNPad() {
    }

    private static void printUsage() {
        System.out.println("Usage:");
        System.out.println("  jnpad [options] [[-e] <files-to-edit>] [-v <files-to-view>] [-s <session-file>]");
        System.out.println();
        System.out.println("jNPad v" + Version.getVersion() + " - Simple text editor");
        System.out.println();
        System.out.println("Where:");
        System.out.println("  -e, -edit, --edit <files-to-edit>       Files to edit");
        System.out.println("  -v, -view, --view <files-to-view>       Files to view (read only)");
        System.out.println("  -s, -session, --session <session-file>  Load a specific session");
        System.out.println();
        System.out.println("Options:");
        System.out.println("  -h, -help, --help, -?, /?               Give this help list");
        System.out.println("  -b, -basic, --basic                     Run in basic mode");
        System.out.println("  -d, -default, --default                 Run in default mode");
        System.out.println("  -m, -minimalist, --minimalist           Run in minimalist mode");
        System.out.println("  -version, --version                     Displays the version of the program");
        System.out.println();
        Utilities.exitSuccess();
    }

    private static void printVersion() {
        System.out.println(TITLE);
        System.out.println("version " + Version.getVersion());
        System.out.println(EMAIL);
        Utilities.exitSuccess();
    }

    public static void main(String[] args) {
        try {
            JNPad.checkJVMVersion();
            JNPad.checkHeadless();
            JNPad.configureLogging();
            JNPad.parseCommandLine(args);
            if (mode != null) {
                Config.setMode(mode);
            }
            if (Accelerators.isUsingCompositeShortcuts()) {
                KeyboardFocusManager.setCurrentKeyboardFocusManager(new JNPadFocusManager());
            }
            try {
                LAFUtils.setLookAndFeel(Config.JNPAD_LAF.getValue());
            }
            catch (Exception ex) {
                System.err.println("Look and feel error: " + ex);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new JNPadFrame(inputFiles, sessionPath);
                }
            });
        }
        catch (Exception e) {
            System.err.println("***************************************************");
            System.err.println("    jNPad - ERROR                                \n");
            e.printStackTrace();
            System.err.println("***************************************************");
        }
    }

    private static boolean isKey(String s) {
        return s.equals("-e") || s.equals("-edit") || s.equalsIgnoreCase("--edit") || s.equals("-v") || s.equals("-view") || s.equalsIgnoreCase("--view") || s.equals("-s") || s.equals("-session") || s.equalsIgnoreCase("--session") || s.equals("-b") || s.equals("-basic") || s.equalsIgnoreCase("--basic") || s.equals("-d") || s.equals("-default") || s.equalsIgnoreCase("--default") || s.equals("-m") || s.equals("-minimal") || s.equalsIgnoreCase("--minimal") || s.equals("-version") || s.equalsIgnoreCase("--version") || s.equals("-h") || s.equals("-help") || s.equalsIgnoreCase("--help") || s.equals("-?") || s.equals("/?");
    }

    private static void parseCommandLine(String[] args) {
        if (args == null) {
            return;
        }
        try {
            ArrayList<String> l_e = new ArrayList<String>();
            ArrayList<String> l_v = new ArrayList<String>();
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-help") || args[i].equals("-h") || args[i].equalsIgnoreCase("--help") || args[i].equals("-?") || args[i].equals("/?")) {
                    JNPad.printUsage();
                }
                if (args[i].equals("-version") || args[i].equalsIgnoreCase("--version")) {
                    JNPad.printVersion();
                }
                if (mode == null && (args[i].equals("-b") || args[i].equals("-basic") || args[i].equalsIgnoreCase("--basic"))) {
                    mode = Mode.BASIC;
                } else if (mode == null && (args[i].equals("-d") || args[i].equals("-default") || args[i].equalsIgnoreCase("--default"))) {
                    mode = Mode.DEFAULT;
                } else if (mode == null && (args[i].equals("-m") || args[i].equals("-minimalist") || args[i].equalsIgnoreCase("--minimalist"))) {
                    mode = Mode.MINIMALIST;
                } else if (args[i].equals("-s") || args[i].equals("-session") || args[i].equalsIgnoreCase("--session")) {
                    if (++i >= args.length) {
                        JNPad.printUsage();
                    }
                    sessionPath = args[i];
                } else if (args[i].equals("-e") || args[i].equals("-edit") || args[i].equalsIgnoreCase("--edit")) {
                    if (++i >= args.length) {
                        JNPad.printUsage();
                    }
                    while (i < args.length && !JNPad.isKey(args[i])) {
                        if (!l_e.contains(args[i])) {
                            l_e.add(args[i]);
                        } else {
                            JNPad.notifyDuplicateFile(args[i]);
                        }
                        ++i;
                    }
                    if (i < args.length && JNPad.isKey(args[i])) {
                        --i;
                    }
                } else if (args[i].equals("-v") || args[i].equals("-view") || args[i].equalsIgnoreCase("--view")) {
                    if (++i >= args.length) {
                        JNPad.printUsage();
                    }
                    while (i < args.length && !JNPad.isKey(args[i])) {
                        if (!l_v.contains(args[i])) {
                            l_v.add(args[i]);
                        } else {
                            JNPad.notifyDuplicateFile(args[i]);
                        }
                        ++i;
                    }
                    if (i < args.length && JNPad.isKey(args[i])) {
                        --i;
                    }
                } else if (!JNPad.isKey(args[i])) {
                    if (!l_e.contains(args[i])) {
                        l_e.add(args[i]);
                    } else {
                        JNPad.notifyDuplicateFile(args[i]);
                    }
                }
                ++i;
            }
            inputFiles = new ArrayList<JNPadInput>();
            for (String e : l_e) {
                inputFiles.add(new JNPadInput(e, 0, false, false, false));
            }
            for (String v : l_v) {
                inputFiles.add(new JNPadInput(v, 0, true, false, false));
            }
        }
        catch (Exception ex) {
            System.err.println("Error: " + ex);
            Utilities.exitFailure();
        }
    }

    private static void notifyDuplicateFile(String file) {
        System.out.println("WARNING: Duplicate file '" + file + "'");
    }

    private static void configureLogging() {
        InputStream is = null;
        try {
            try {
                boolean bl;
                File f = new File(PROPS_DIR);
                if (!f.exists()) {
                    bl = f.mkdir();
                }
                if (!(f = new File(String.valueOf(JNPAD_HOME) + Utilities.DIR_SEPARATOR + "logs")).exists()) {
                    bl = f.mkdir();
                }
                is = new FileInputStream(LOGGERING_FILE_PATH);
                LogManager.getLogManager().readConfiguration(is);
            }
            catch (IOException iOException) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void checkJVMVersion() {
        if (!Platform.isJRESupported()) {
            System.err.println("You are using version " + Platform.getJREVersion() + ". jNPad requires Java 1.6 or later.");
            Utilities.exitFailure();
        }
    }

    private static void checkHeadless() {
        if (GraphicsEnvironment.isHeadless()) {
            System.err.println("Unable to detect graphics environment.");
            Utilities.exitFailure();
        }
    }

    private static class JNPadFocusManager
    extends DefaultKeyboardFocusManager {
        JNPadFocusManager() {
            this.setDefaultFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        }

        @Override
        public boolean postProcessKeyEvent(KeyEvent e) {
            if (!e.isConsumed()) {
                Component comp = (Component)e.getSource();
                if (!comp.isShowing()) {
                    return true;
                }
                while (true) {
                    if (comp instanceof JNPadFrame) {
                        ((JNPadFrame)comp).processKeyEvent(e);
                        return true;
                    }
                    if (comp == null || comp instanceof Window || comp instanceof JNPadTextArea) break;
                    comp = comp.getParent();
                }
            }
            return super.postProcessKeyEvent(e);
        }
    }
}

