/*
 * Decompiled with CFR 0.152.
 */
package jnpad;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.KeyStroke;
import jnpad.action.JNPadAction;
import jnpad.config.Accelerators;

public class JNPadKeyboardHandler
extends KeyAdapter {
    private Map bindings = new HashMap();
    private Map currentBindings = new HashMap();

    public void addKeyBinding(String keyBinding, Action action) {
        Map current = this.bindings;
        StringTokenizer st = new StringTokenizer(keyBinding);
        while (st.hasMoreTokens()) {
            KeyStroke keyStroke = Accelerators.parseKeyStroke(st.nextToken());
            if (keyStroke == null) {
                return;
            }
            if (st.hasMoreTokens()) {
                Object o = current.get(keyStroke);
                if (o instanceof Map) {
                    current = (Map)o;
                    continue;
                }
                o = new HashMap();
                current.put(keyStroke, o);
                current = (Map)o;
                continue;
            }
            current.put(keyStroke, action);
        }
        this.currentBindings = this.bindings;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        int modifiers = e.getModifiers();
        if (keyCode == 17 || keyCode == 16 || keyCode == 18 || keyCode == 157) {
            return;
        }
        if (e.isShiftDown()) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
            Object o = this.currentBindings.get(keyStroke);
            if (o == null) {
                if (this.currentBindings != this.bindings) {
                    Toolkit.getDefaultToolkit().beep();
                    e.consume();
                }
                this.currentBindings = this.bindings;
            } else if (o instanceof Action) {
                this.currentBindings = this.bindings;
                JNPadKeyboardHandler.executeAction((Action)o, e.getSource(), null);
                e.consume();
            } else if (o instanceof Map) {
                this.currentBindings = (Map)o;
                e.consume();
            }
        } else if (!e.isShiftDown() || e.isActionKey() || keyCode == 8 || keyCode == 127 || keyCode == 10 || keyCode == 9 || keyCode == 27) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
            Object o = this.currentBindings.get(keyStroke);
            if (o == null) {
                if (this.currentBindings != this.bindings) {
                    Toolkit.getDefaultToolkit().beep();
                    e.consume();
                }
                this.currentBindings = this.bindings;
            } else if (o instanceof Action) {
                this.currentBindings = this.bindings;
                JNPadKeyboardHandler.executeAction((Action)o, e.getSource(), null);
                e.consume();
            } else if (o instanceof Map) {
                this.currentBindings = (Map)o;
                e.consume();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
        if (c != '\uffff' && !e.isAltDown() && c >= ' ' && c != '\u007f') {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(Character.toUpperCase(c));
            Object o = this.currentBindings.get(keyStroke);
            if (o == null) {
                if (this.currentBindings != this.bindings) {
                    Toolkit.getDefaultToolkit().beep();
                    e.consume();
                }
                this.currentBindings = this.bindings;
                return;
            }
            if (o instanceof Map) {
                this.currentBindings = (Map)o;
                e.consume();
                return;
            }
            if (o instanceof Action) {
                this.currentBindings = this.bindings;
                JNPadKeyboardHandler.executeAction((Action)o, e.getSource(), String.valueOf(c));
                e.consume();
                return;
            }
            this.currentBindings = this.bindings;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private static void executeAction(Action action, Object source, String actionCommand) {
        if (action.isEnabled()) {
            if (action instanceof JNPadAction && ((JNPadAction)action).isStateAction()) {
                ((JNPadAction)action).setSelected(!((JNPadAction)action).isSelected());
            } else {
                ActionEvent e = new ActionEvent(source, 1001, actionCommand);
                action.actionPerformed(e);
            }
        }
    }
}

