/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jnpad.GUIUtilities;
import jnpad.JNPadBundle;
import jnpad.JNPadFrame;
import jnpad.action.ActionBundle;
import jnpad.ui.EscapableDialog;
import jnpad.ui.JNPadLabel;
import jnpad.ui.layout.VerticalFlowLayout;
import jnpad.ui.plaf.LAFUtils;
import jnpad.ui.status.StatusDisplayable;
import jnpad.util.Version;

class AboutDialog
extends EscapableDialog {
    JPanel contentPane;
    JPanel pnBackground = new JPanel();
    JPanel pnIcon = new JPanel();
    JPanel pnLabels = new JPanel();
    JPanel pnClose = new JPanel();
    JButton btClose = new JButton();
    JLabel lbIcon = new JNPadLabel();
    JLabel lnProduct = new JNPadLabel();
    JLabel lbVersion = new JNPadLabel();
    JLabel lbCopyright = new JNPadLabel();
    JLabel lbEmail = new JNPadLabel();
    JLabel lbSourceForge = new JNPadLabel();
    private JNPadFrame jNPad;
    private static final Logger LOGGER = Logger.getLogger(AboutDialog.class.getName());
    private static final long serialVersionUID = 2305689107733217463L;

    AboutDialog(JNPadFrame jNPad) {
        super(jNPad, ActionBundle.getString("about".concat(".title"), new Object[0]), true);
        try {
            this.jNPad = jNPad;
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(jNPad);
            this.setVisible(true);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            jNPad.setStatus(StatusDisplayable.StatusType.ERROR, "Error - ".concat(this.getTitle()));
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.pnBackground, "North");
        this.contentPane.add((Component)this.pnClose, "South");
        MouseAdapter hyperlinkMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Object obj = e.getSource();
                if (obj == AboutDialog.this.lbEmail) {
                    AboutDialog.this.open("mailto:rgsevero@gmail.com?subject=jNPad");
                } else if (obj == AboutDialog.this.lbSourceForge) {
                    AboutDialog.this.open("http://sourceforge.net/projects/jnpad");
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                e.getComponent().setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        this.lnProduct.setIcon(GUIUtilities.loadIcon(ActionBundle.getString("about".concat(".product"), new Object[0]), false));
        this.lbVersion.setHorizontalAlignment(11);
        this.lbVersion.setText(ActionBundle.getString("about".concat(".version"), Version.getVersion()));
        this.lbCopyright.setHorizontalAlignment(11);
        this.lbCopyright.setText("Copyright \u00a9 2014-2017  rgs");
        if (LAFUtils.isDarkLAF()) {
            this.lbSourceForge.setText("<html><a href=\"sourceforge.net/projects/jnpad\"><font color=\"#00CCFF\">http://sourceforge.net/projects/jnpad</font></a></html>");
            this.lbEmail.setText("<html><a href=\"mailto:rgsevero@gmail.com\"><font color=\"#00CCFF\">rgsevero@gmail.com</font></a></html>");
        } else {
            this.lbSourceForge.setText("<html><a href=\"http://sourceforge.net/projects/jnpad\">http://sourceforge.net/projects/jnpad</a></html>");
            this.lbEmail.setText("<html><a href=\"mailto:rgsevero@gmail.com\">rgsevero@gmail.com</a></html>");
        }
        this.lbEmail.setToolTipText("rgsevero@gmail.com");
        this.lbEmail.setHorizontalAlignment(11);
        this.lbEmail.addMouseListener(hyperlinkMouseListener);
        this.lbSourceForge.setIcon(GUIUtilities.loadIcon("sourceforge.png"));
        this.lbSourceForge.setToolTipText("http://sourceforge.net/projects/jnpad");
        this.lbSourceForge.setHorizontalAlignment(11);
        this.lbSourceForge.addMouseListener(hyperlinkMouseListener);
        this.lbIcon.setIcon(GUIUtilities.loadIcon("icon-jnpad48.png", false));
        this.pnIcon.setBorder(GUIUtilities.createEmptyBorder(5));
        this.pnIcon.add((Component)this.lbIcon, null);
        this.pnLabels.setLayout(new VerticalFlowLayout());
        this.pnLabels.setBorder(GUIUtilities.createEmptyBorder(5));
        this.pnLabels.add((Component)this.lnProduct, null);
        this.pnLabels.add((Component)this.lbVersion, null);
        this.pnLabels.add((Component)this.lbCopyright, null);
        this.pnLabels.add((Component)this.lbEmail, null);
        this.pnLabels.add((Component)this.lbSourceForge, null);
        this.pnBackground.setLayout(new BorderLayout());
        this.pnBackground.add((Component)this.pnIcon, "West");
        this.pnBackground.add((Component)this.pnLabels, "Center");
        this.pnClose.setLayout(new FlowLayout(4));
        this.pnClose.add((Component)this.btClose, null);
        GUIUtilities.setLocalizedText(this.btClose, JNPadBundle.getCloseButtonText());
        this.btClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
    }

    @Override
    protected void escapePressed() {
        this.dispose();
    }

    private void open(String str) {
        try {
            GUIUtilities.openBrowser(str);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            this.jNPad.setStatus(StatusDisplayable.StatusType.ERROR, ActionBundle.getString("about".concat(".notSupported"), new Object[0]));
        }
    }
}

