/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import jnpad.JNPadFrame;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.text.Buffer;
import jnpad.text.IEditAction;
import jnpad.text.ISelectionAction;
import jnpad.text.JNPadTextArea;
import jnpad.ui.status.StatusDisplayable;
import jnpad.util.Utilities;

public abstract class AlignStringsAction
extends JNPadAction
implements IEditAction,
ISelectionAction {
    private static final Logger LOGGER = Logger.getLogger(AlignStringsAction.class.getName());
    private static final long serialVersionUID = 5112316692835817588L;

    protected AlignStringsAction(JNPadFrame jNPad, String name, KeyStroke defaultAccelerator) {
        super(jNPad, name, JNPadActions.Group.FORMAT, defaultAccelerator, null);
    }

    protected void alignStrings(String delimiter) {
        Buffer buffer = this.jNPad.getActiveBuffer();
        if (buffer != null) {
            try {
                buffer.beginCompoundEdit();
                JNPadTextArea textArea = buffer.getSelectedTextArea();
                if (!textArea.isEditable() || !textArea.hasSelection()) {
                    return;
                }
                int startLine = textArea.getLineOfOffset(textArea.getSelectionStart());
                int endLine = textArea.getLineOfOffset(textArea.getSelectionEnd());
                if (endLine - startLine < 1) {
                    return;
                }
                int max = -1;
                int i = startLine;
                while (i <= endLine) {
                    String text = textArea.getLineText(i);
                    int count = Utilities.countMatches(text, delimiter);
                    if (count > max) {
                        max = count;
                    }
                    ++i;
                }
                if (max < 0) {
                    return;
                }
                try {
                    int pos = 0;
                    int i2 = 0;
                    while (i2 < max) {
                        pos = this.alignStrings(textArea, delimiter, pos + 1);
                        ++i2;
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    this.jNPad.setStatus(StatusDisplayable.StatusType.ERROR, "Error - ".concat(this.getLabel()));
                }
            }
            finally {
                buffer.endCompoundEdit();
            }
        }
    }

    private int alignStrings(JNPadTextArea textArea, String delimiter, int pos) throws BadLocationException {
        int col;
        String text;
        int startLine = textArea.getLineOfOffset(textArea.getSelectionStart());
        int endLine = textArea.getLineOfOffset(textArea.getSelectionEnd());
        if (endLine - startLine < 1) {
            return -1;
        }
        int maxCol = -1;
        int i = startLine;
        while (i <= endLine) {
            text = textArea.getLineText(i);
            col = Utilities.indexOf(text, delimiter, pos);
            if (col > maxCol) {
                maxCol = col;
            }
            ++i;
        }
        if (maxCol < 0) {
            return -1;
        }
        i = startLine;
        while (i <= endLine) {
            text = textArea.getLineText(i);
            col = Utilities.indexOf(text, delimiter, pos);
            if (col != -1 && col < maxCol) {
                String spaces = Utilities.spaces(maxCol - col);
                textArea.insert(spaces, col + textArea.getLineStartOffset(i));
            }
            ++i;
        }
        return maxCol;
    }
}

