/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import javax.swing.JOptionPane;
import jnpad.JNPadFrame;
import jnpad.action.ActionBundle;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.text.EditPane;
import jnpad.text.JNPadTextArea;
import jnpad.text.TextUtilities;
import jnpad.util.Utilities;

public final class GoToLineAction
extends JNPadAction {
    private static final long serialVersionUID = -2107743998850078847L;

    public GoToLineAction(JNPadFrame jNPad) {
        super(jNPad, "go-to-line", JNPadActions.Group.SEARCH, Accelerators.GO_TO_LINE, "go-to-line.png");
    }

    @Override
    public void performAction() {
        EditPane editPane = this.jNPad.getActiveEditPane();
        if (editPane != null) {
            JNPadTextArea textArea = editPane.getTextArea();
            int nro_of_lines = textArea.getLineCount();
            if (nro_of_lines < 1) {
                return;
            }
            String response = JOptionPane.showInputDialog(editPane, ActionBundle.getString("go-to-line".concat(".message"), nro_of_lines), ActionBundle.getString("go-to-line".concat(".title"), new Object[0]), 3);
            if (Utilities.isBlankString(response)) {
                return;
            }
            try {
                int line;
                int column = 0;
                int index = response.indexOf(58);
                if (index != -1) {
                    line = Integer.parseInt(response.substring(0, index).trim());
                    column = Integer.parseInt(response.substring(index + 1).trim());
                } else {
                    line = Integer.parseInt(response.trim());
                }
                if (line < 1) {
                    line = 1;
                } else if (line > nro_of_lines) {
                    line = nro_of_lines;
                }
                int pos = TextUtilities.getDocPositionFor(textArea.getDocument(), line, column);
                textArea.jumpToOffset(pos);
            }
            catch (Exception ex) {
                JOptionPane.showConfirmDialog(editPane, ActionBundle.getString("go-to-line".concat(".error.message"), response), ActionBundle.getString("go-to-line".concat(".error.title"), new Object[0]), -1, 0);
            }
        }
    }
}

