/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.util.MissingResourceException;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.action.ActionBundle;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.util.Platform;

public abstract class JNPadAction
extends AbstractAction
implements ItemListener {
    public static final String LABEL = "jNPad-Label";
    public static final String IS_STATE = "jNPad-State";
    public static final String GROUP = "jNPad-Group";
    public static final String KEY_BINDING = "jNPad-KeyBinding";
    public static final String BUTTON_TOOLTIP = "jNPad-ButtonToolTip";
    public static final String BUTTON_TEXT = "jNPad-ButtonText";
    protected JNPadFrame jNPad;
    private boolean performActionInSeparateThread;
    private boolean isItemStateChangedEnabled = true;
    private static boolean isGlobalItemStateChangedEnabled = true;
    private static final Logger LOGGER = Logger.getLogger(JNPadAction.class.getName());
    private static final long serialVersionUID = -3418755109014701639L;

    protected JNPadAction(JNPadFrame jNPad, String name, JNPadActions.Group group) {
        super(name);
        this.jNPad = jNPad;
        this.setGroup(group);
    }

    protected JNPadAction(JNPadFrame jNPad, String name, JNPadActions.Group group, KeyStroke defaultAccelerator, String picture) {
        this(jNPad, name, group);
        this.setActionLabel(ActionBundle.getString(name.concat(".label"), new Object[0]));
        this.setDescription(ActionBundle.getString(name.concat(".description"), new Object[0]));
        if (picture != null && Config.isDefaultMode()) {
            this.setIcon("".equals(picture) ? GUIUtilities.EMPTY_ICON : GUIUtilities.loadIcon(picture));
        }
        if (defaultAccelerator != null) {
            if (Accelerators.isUsingCompositeShortcuts()) {
                this.setKeyBinding(Accelerators.getShortcutLabel(name));
                this.setButtonToolTipText(ActionBundle.getString(name.concat(".button.tooltip"), this.getKeyBinding()));
            } else if (Config.isUsingCustomShortcuts()) {
                KeyStroke ks = Accelerators.getPropAccelerator(name.concat(".shortcut"), null);
                if (ks != null) {
                    this.setAccelerator(ks);
                    this.setButtonToolTipText(ActionBundle.getString(name.concat(".button.tooltip"), this.getAcceleratorText()));
                }
            } else {
                this.setAccelerator(Accelerators.getPropAccelerator(name.concat(".shortcut"), defaultAccelerator));
                this.setButtonToolTipText(ActionBundle.getString(name.concat(".button.tooltip"), this.getAcceleratorText()));
            }
        }
    }

    public String getLabel() {
        return (String)this.getValue(LABEL);
    }

    public void setLabel(String label) {
        this.putValue(LABEL, label);
    }

    public void setGroup(JNPadActions.Group group) {
        this.putValue(GROUP, (Object)group);
    }

    public JNPadActions.Group getGroup() {
        return (JNPadActions.Group)((Object)this.getValue(GROUP));
    }

    public String getKeyBinding() {
        return (String)this.getValue(KEY_BINDING);
    }

    public void setKeyBinding(String keyBinding) {
        this.putValue(KEY_BINDING, keyBinding);
    }

    public String getButtonText() {
        return (String)this.getValue(BUTTON_TEXT);
    }

    public void setButtonText(String text) {
        this.putValue(BUTTON_TEXT, text);
    }

    public String getButtonToolTipText() {
        return (String)this.getValue(BUTTON_TOOLTIP);
    }

    public void setButtonToolTipText(String toolTipText) {
        this.putValue(BUTTON_TOOLTIP, toolTipText);
    }

    public boolean isStateAction() {
        Boolean state = (Boolean)this.getValue(IS_STATE);
        return state != null && state != false;
    }

    public void setStateAction() {
        this.setStateAction(true);
    }

    public void setStateAction(boolean state) {
        this.putValue(IS_STATE, state);
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public void setName(String name) {
        this.putValue("Name", name);
    }

    public int getMnemonic() {
        Integer value = (Integer)this.getValue("MnemonicKey");
        if (value != null) {
            return value;
        }
        return 0;
    }

    public void setMnemonic(String mnemonic) {
        if (mnemonic != null && mnemonic.length() > 0) {
            this.putValue("MnemonicKey", mnemonic.charAt(0));
        }
    }

    public void setMnemonic(int mnemonic) {
        this.putValue("MnemonicKey", mnemonic);
    }

    public void setMnemonic(char mnemonic) {
        int vk = mnemonic;
        if (vk >= 97 && vk <= 122) {
            vk -= 32;
        }
        this.setMnemonic(vk);
    }

    public String getToolTipText() {
        return (String)this.getValue("ShortDescription");
    }

    public void setToolTipText(String toolTipText) {
        this.putValue("ShortDescription", toolTipText);
    }

    public String getDescription() {
        return (String)this.getValue("LongDescription");
    }

    public void setDescription(String description) {
        this.putValue("LongDescription", description);
    }

    public boolean isSelected() {
        Boolean value = (Boolean)this.getValue("SwingSelectedKey");
        return value != null && value != false;
    }

    public void setSelected(boolean b) {
        this.putValue("SwingSelectedKey", b);
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public Icon getLargeIcon() {
        return (Icon)this.getValue("SwingLargeIconKey");
    }

    public void setLargeIcon(Icon icon) {
        this.putValue("SwingLargeIconKey", icon);
    }

    public KeyStroke getAccelerator() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    public void setAccelerator(KeyStroke accelerator) {
        this.putValue("AcceleratorKey", accelerator);
    }

    protected boolean acceleratorsEqual(KeyStroke ks1, KeyStroke ks2) {
        return ks1.getKeyChar() == ks2.getKeyChar() && ks1.getKeyCode() == ks2.getKeyCode() && ks1.getModifiers() == ks2.getModifiers();
    }

    public boolean isAccelerator(KeyStroke keyStroke) {
        KeyStroke accelerator = this.getAccelerator();
        return accelerator != null && this.acceleratorsEqual(accelerator, keyStroke);
    }

    public String getAcceleratorText() {
        KeyStroke accelerator = this.getAccelerator();
        if (accelerator == null) {
            return null;
        }
        String text = KeyEvent.getKeyText(accelerator.getKeyCode());
        int modifiers = accelerator.getModifiers();
        if (modifiers != 0) {
            text = String.valueOf(KeyEvent.getKeyModifiersText(modifiers)) + "+" + text;
        }
        return text;
    }

    public void dispose() {
        PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener listener = propertyChangeListenerArray[n2];
            this.removePropertyChangeListener(listener);
            ++n2;
        }
    }

    public boolean performActionInSeparateThread() {
        return this.performActionInSeparateThread;
    }

    public void setPerformActionInSeparateThread(boolean performActionInSeparateThread) {
        this.performActionInSeparateThread = performActionInSeparateThread;
    }

    public void setItemStateChangedEnabled(boolean b) {
        this.isItemStateChangedEnabled = b;
    }

    public boolean isItemStateChangedEnabled() {
        return this.isItemStateChangedEnabled;
    }

    public static void setGlobalItemStateChangedEnabled(boolean b) {
        isGlobalItemStateChangedEnabled = b;
    }

    public static boolean isGlobalItemStateChangedEnabled() {
        return isGlobalItemStateChangedEnabled;
    }

    public static void checkSelection(JNPadAction a, boolean b) {
        JNPadAction.setGlobalItemStateChangedEnabled(false);
        if (b != a.isSelected()) {
            a.setSelected(b);
        }
        JNPadAction.setGlobalItemStateChangedEnabled(true);
    }

    public void performAction() {
    }

    public void handleStateChanged(ItemEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this.isStateAction()) {
            return;
        }
        this.setSelected(1 == e.getStateChange());
        if (!this.isItemStateChangedEnabled() || !JNPadAction.isGlobalItemStateChangedEnabled()) {
            return;
        }
        this.handleStateChanged(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isStateAction()) {
            return;
        }
        if (this.performActionInSeparateThread()) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    JNPadAction.this.performAction();
                }
            };
            new Thread(r).start();
        } else {
            this.performAction();
        }
    }

    protected static int getCurrentEventModifiers() {
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        return modifiers;
    }

    public void setActionLabel(String label) {
        if (label == null) {
            return;
        }
        int i = GUIUtilities.findMnemonicAmpersand(label);
        if (i < 0) {
            this.setLabel(label);
            this.setMnemonic(0);
        } else {
            this.setLabel(String.valueOf(label.substring(0, i)) + label.substring(i + 1));
            if (Platform.isMac) {
                this.setMnemonic(0);
            } else {
                char ch = label.charAt(i + 1);
                if (label.startsWith("<html>")) {
                    this.setLabel(String.valueOf(label.substring(0, i)) + "<u>" + ch + "</u>" + label.substring(i + 2));
                    i += 3;
                }
                if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') {
                    this.setMnemonic(ch);
                } else {
                    try {
                        int latinCode = GUIUtilities.getLatinKeycode(ch);
                        this.setMnemonic(latinCode);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.getClass().toString());
        sb.append(":");
        try {
            Object[] keys = this.getKeys();
            int i = 0;
            while (i < keys.length) {
                sb.append(keys[i]);
                sb.append('=');
                sb.append(this.getValue((String)keys[i]).toString());
                if (i < keys.length - 1) {
                    sb.append(',');
                }
                ++i;
            }
            sb.append(']');
        }
        catch (Exception ex) {
            LOGGER.warning(ex.getMessage());
        }
        return sb.toString();
    }
}

