/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.event.ItemEvent;
import jnpad.JNPadFrame;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.config.ViewActionScope;
import jnpad.text.Viewer;

public final class MarkOccurrencesAction
extends JNPadAction {
    private static final long serialVersionUID = 2266115409347487330L;

    public MarkOccurrencesAction(JNPadFrame jNPad) {
        super(jNPad, "mark-occurrences", JNPadActions.Group.VIEW, Accelerators.MARK_OCCURRENCES, "mark-occurrences.png");
        this.setSelected(Config.OCCURRENCES_HIGHLIGHTER_VISIBLE.getValue());
        this.setStateAction(true);
    }

    @Override
    public void handleStateChanged(ItemEvent e) {
        ViewActionScope scope = Config.VIEW_ACTION_SCOPE.getValue();
        Viewer viewer = this.jNPad.getViewer();
        switch (scope) {
            case VIEWER: {
                viewer.setOccurrencesHighlighterVisible(1 == e.getStateChange());
                break;
            }
            case BUFFER_SET: {
                viewer.getActiveBufferSet().setOccurrencesHighlighterVisible(1 == e.getStateChange());
                break;
            }
            case EDIT_PANE: {
                viewer.getActiveEditPane().setOccurrencesHighlighterVisible(1 == e.getStateChange());
                break;
            }
            default: {
                viewer.getActiveBuffer().setOccurrencesHighlighterVisible(1 == e.getStateChange());
            }
        }
    }
}

