/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import jnpad.JNPadBundle;
import jnpad.JNPadFrame;
import jnpad.action.ActionBundle;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Config;
import jnpad.config.Mode;

public final class SelectModeAction
extends JNPadAction {
    private Mode mode;
    static final String NAME = "select-mode";
    private static Map<String, JNPadAction> map = new HashMap<String, JNPadAction>();
    private static final long serialVersionUID = 1035038012551175498L;

    public SelectModeAction(JNPadFrame jNPad, Mode mode) {
        super(jNPad, NAME, JNPadActions.Group.CONFIGURE);
        boolean selected;
        String name;
        String description;
        String actionLabel;
        this.mode = mode;
        switch (mode) {
            case MINIMALIST: {
                actionLabel = ActionBundle.getString(NAME.concat(".minimalist.label"), new Object[0]);
                description = ActionBundle.getString(NAME.concat(".minimalist.description"), "minimalist");
                name = "select-mode minimalist";
                selected = Config.isMininalistMode();
                break;
            }
            case BASIC: {
                actionLabel = ActionBundle.getString(NAME.concat(".basic.label"), new Object[0]);
                description = ActionBundle.getString(NAME.concat(".basic.description"), "basic");
                name = "select-mode basic";
                selected = Config.isBasicMode();
                break;
            }
            case DISTRACTION_FREE: {
                actionLabel = ActionBundle.getString(NAME.concat(".distraction-free.label"), new Object[0]);
                description = ActionBundle.getString(NAME.concat(".distraction-free.description"), "distraction-free");
                name = "select-mode distraction-free";
                selected = Config.isDistractionFreeMode();
                break;
            }
            default: {
                actionLabel = ActionBundle.getString(NAME.concat(".default.label"), new Object[0]);
                description = ActionBundle.getString(NAME.concat(".default.description"), "default");
                name = "select-mode default";
                selected = Config.isDefaultMode();
            }
        }
        this.setName(name);
        this.setActionLabel(actionLabel);
        this.setDescription(description);
        this.setSelected(selected);
        this.setStateAction(true);
        map.put(name, this);
    }

    @Override
    public void handleStateChanged(ItemEvent e) {
        if (1 == e.getStateChange()) {
            Config.JNPAD_MODE.setValue(this.mode);
            Config.setAdjustPostModeChangedEnabled(true);
            String msg = ActionBundle.getString("select-mode.message", this.getLabel());
            this.jNPad.setStatus(msg, 10);
            Object[] options = new String[]{JNPadBundle.getYesOptionText(), JNPadBundle.getNoOptionText()};
            int option = JOptionPane.showOptionDialog(this.jNPad, JNPadBundle.getString("JNPad.restart", msg), JNPadBundle.getString("select-mode.title", new Object[0]), -1, 1, null, options, options[0]);
            if (option == 1 || option == -1) {
                return;
            }
            this.jNPad.restart();
        }
    }

    static List<String> getCompletionsForPrefix(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : map.keySet()) {
            JNPadAction action = map.get(key);
            if (!key.startsWith(prefix) || !action.isEnabled()) continue;
            list.add(key);
        }
        Collections.sort(list);
        return list;
    }

    static boolean performAction(String name) {
        JNPadAction action = map.get(name);
        if (action != null && action.isEnabled()) {
            action.setSelected(!action.isSelected());
            return true;
        }
        return false;
    }
}

