/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import jnpad.JNPadFrame;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.text.Buffer;
import jnpad.text.IEditAction;
import jnpad.text.JNPadTextArea;
import jnpad.text.TextUtilities;
import jnpad.ui.status.StatusDisplayable;

public final class SortLinesAscendingAction
extends JNPadAction
implements IEditAction {
    private static final Logger LOGGER = Logger.getLogger(SortLinesAscendingAction.class.getName());
    private static final long serialVersionUID = 937378897708771763L;

    public SortLinesAscendingAction(JNPadFrame jNPad) {
        super(jNPad, "sort-lines-in-ascending-order", JNPadActions.Group.EDIT, Accelerators.SORT_LINES_ASCENDING, null);
    }

    @Override
    public void performAction() {
        block7: {
            Buffer buffer = this.jNPad.getActiveBuffer();
            if (buffer != null) {
                try {
                    try {
                        buffer.beginCompoundEdit();
                        JNPadTextArea textArea = buffer.getSelectedTextArea();
                        Document doc = textArea.getDocument();
                        if (textArea.hasSelection()) {
                            TextUtilities.sort(doc, textArea.getSelectionStart(), textArea.getSelectionEnd() - textArea.getSelectionStart(), false);
                            break block7;
                        }
                        TextUtilities.sort(doc, false);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                        this.jNPad.setStatus(StatusDisplayable.StatusType.ERROR, "Error - ".concat(this.getLabel()));
                        buffer.endCompoundEdit();
                    }
                }
                finally {
                    buffer.endCompoundEdit();
                }
            }
        }
    }
}

