/*
 * Decompiled with CFR 0.152.
 */
package jnpad.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.BadLocationException;
import jnpad.GUIUtilities;
import jnpad.JNPadBundle;
import jnpad.JNPadFrame;
import jnpad.search.SearchBundle;
import jnpad.search.SearchContext;
import jnpad.search.SearchManagerDialog;
import jnpad.search.Text;
import jnpad.text.Buffer;
import jnpad.text.EditPane;
import jnpad.text.JNPadTextArea;
import jnpad.ui.EdgeBorder;
import jnpad.ui.EscapableDialog;
import jnpad.ui.JNPadCheckBox;
import jnpad.ui.JNPadComboBox;
import jnpad.ui.JNPadLabel;
import jnpad.ui.ReporterUtilities;
import jnpad.ui.status.StatusDisplayable;
import jnpad.util.Utilities;

public abstract class SearchDialog
extends EscapableDialog {
    JPanel contentPane;
    JPanel pnAllButtons = new JPanel();
    JPanel pnAllOptions = new JPanel();
    JPanel pnButtons = new JPanel();
    JPanel pnOptions = new JPanel();
    JPanel pnOptionsN = new JPanel();
    JPanel pnOptionsS = new JPanel();
    JPanel pnOptionsSW = new JPanel();
    JPanel pnOptionsSE = new JPanel();
    JPanel pnFind = new JPanel();
    JLabel lbFind = new JNPadLabel();
    JComboBox cmbFind = new JNPadComboBox();
    static final int ACTIVE_DOCUMENT = 0;
    static final int OPEN_DOCUMENTS = 1;
    static final int SELECTION = 2;
    JPanel pnLookIn = new JPanel();
    JLabel lbLookIn = new JNPadLabel();
    JComboBox cmbLookIn = new JNPadComboBox(new String[]{SearchBundle.getString("SearchDialog.lookIn.activeDocument", new Object[0]), SearchBundle.getString("SearchDialog.lookIn.openDocuments", new Object[0]), SearchBundle.getString("SearchDialog.lookIn.selection", new Object[0])});
    JCheckBox cbMatchCase = new JNPadCheckBox();
    JCheckBox cbFindFromCursor = new JNPadCheckBox();
    JCheckBox cbMatchWholeWord = new JNPadCheckBox();
    JPanel pnFindDirection = new JPanel();
    JRadioButton rbFindFoward = new JRadioButton();
    JRadioButton rbFindBackward = new JRadioButton();
    ButtonGroup findDirection = new ButtonGroup();
    JButton btFind = new JButton();
    JButton btClose = new JButton();
    JLabel lbStatusBar = new JNPadLabel();
    Buffer _buffer;
    int _actualPosition;
    int _minPosition;
    int _maxPosition;
    int _inc;
    int _lastInc;
    JNPadFrame jNPad;
    SearchManagerDialog searchManagerDialog;
    final ActionListener actionHandler = new ActionHandler();
    final KeyListener keyHandler = new KeyHandler();
    static final Logger LOGGER = Logger.getLogger(SearchDialog.class.getName());
    private static final long serialVersionUID = -7753041887038443611L;

    SearchDialog(JNPadFrame jNPad, String title) {
        super(jNPad, title, true);
        try {
            this.jNPad = jNPad;
            this.jbInit();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            jNPad.setStatus(StatusDisplayable.StatusType.ERROR, ex.getMessage());
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout(5, 5));
        this.contentPane.setBorder(GUIUtilities.createEmptyBorder(5));
        this.contentPane.add((Component)this.pnAllButtons, "East");
        this.contentPane.add((Component)this.pnAllOptions, "Center");
        this.contentPane.add((Component)this.lbStatusBar, "South");
        this.searchManagerDialog = new SearchManagerDialog(this.jNPad, this);
        this.lbStatusBar.setBorder(new EdgeBorder(1));
        this.lbStatusBar.setText(" ");
        this.lbFind.setText(SearchBundle.getString("SearchDialog.find", new Object[0]));
        this.lbLookIn.setText(SearchBundle.getString("SearchDialog.lookIn", new Object[0]));
        this.cbMatchCase.setText(SearchBundle.getString("SearchDialog.matchCase", new Object[0]));
        this.cbFindFromCursor.setText(SearchBundle.getString("SearchDialog.findFromCursor", new Object[0]));
        this.cbMatchWholeWord.setText(SearchBundle.getString("SearchDialog.matchWholeWord", new Object[0]));
        this.rbFindFoward.setText(SearchBundle.getString("SearchDialog.findFoward", new Object[0]));
        this.rbFindBackward.setText(SearchBundle.getString("SearchDialog.findBackward", new Object[0]));
        this.findDirection.add(this.rbFindFoward);
        this.findDirection.add(this.rbFindBackward);
        this.cmbFind.setEditable(true);
        this.cmbFind.getEditor().getEditorComponent().addKeyListener(this.keyHandler);
        this.cmbLookIn.addActionListener(this.actionHandler);
        this.btFind.setText(SearchBundle.getString("SearchDialog.findNext", new Object[0]));
        this.btFind.addActionListener(this.actionHandler);
        this.btClose.setText(SearchBundle.getString("SearchDialog.close", new Object[0]));
        this.btClose.addActionListener(this.actionHandler);
        this.pnAllButtons.setLayout(new BorderLayout());
        this.pnAllButtons.add((Component)this.pnButtons, "North");
        this.pnButtons.setLayout(new GridLayout(0, 1, 5, 5));
        this.pnAllOptions.setLayout(new BorderLayout());
        this.pnAllOptions.add((Component)this.pnOptions, "North");
        this.pnOptions.setLayout(new BorderLayout(5, 5));
        this.pnOptions.add((Component)this.pnOptionsN, "North");
        this.pnOptions.add((Component)this.pnOptionsS, "South");
        this.pnOptionsN.setLayout(new GridLayout(0, 1, 5, 5));
        this.pnFind.setLayout(new BorderLayout(5, 5));
        this.pnFind.add((Component)this.lbFind, "West");
        this.pnFind.add((Component)this.cmbFind, "Center");
        this.pnLookIn.setLayout(new BorderLayout(5, 5));
        this.pnLookIn.add((Component)this.lbLookIn, "West");
        this.pnLookIn.add((Component)this.cmbLookIn, "Center");
        this.pnOptionsS.setLayout(new BorderLayout(5, 5));
        this.pnOptionsS.add((Component)this.pnOptionsSW, "West");
        this.pnOptionsS.add((Component)this.pnOptionsSE, "East");
        this.pnOptionsSW.setLayout(new GridLayout(0, 1));
        this.pnOptionsSW.add((Component)this.cbMatchCase, null);
        this.pnOptionsSW.add((Component)this.cbFindFromCursor, null);
        this.pnOptionsSW.add((Component)this.cbMatchWholeWord, null);
        this.pnOptionsSE.setLayout(new BorderLayout());
        this.pnOptionsSE.add((Component)this.pnFindDirection, "North");
        this.pnFindDirection.setBorder(BorderFactory.createTitledBorder(SearchBundle.getString("SearchDialog.direction", new Object[0])));
        this.pnFindDirection.setLayout(new GridLayout(0, 1));
        this.pnFindDirection.add((Component)this.rbFindFoward, null);
        this.pnFindDirection.add((Component)this.rbFindBackward, null);
        this.setResizable(false);
    }

    abstract void loadState();

    abstract void saveState();

    abstract boolean initialize(boolean var1);

    String getSearchFor() {
        return GUIUtilities.getItem(this.cmbFind);
    }

    abstract SearchContext getSearchContext();

    boolean checkBuffer() {
        if (this._buffer == null) {
            this._buffer = this.jNPad.getActiveBuffer();
        }
        return this._buffer != null;
    }

    void resetFind() {
        if (!this.checkBuffer()) {
            return;
        }
        this.resetFind(true);
        if (this.cbFindFromCursor.isSelected()) {
            this._actualPosition = this._buffer.getCaretPosition();
        }
    }

    void resetReplace() {
    }

    void resetFind(boolean next) {
        boolean selection;
        JNPadTextArea textArea = this._buffer.getSelectedTextArea();
        this._lastInc = 0;
        this._inc = this.rbFindFoward.isSelected() ? 1 : -1;
        boolean bl = selection = this.cmbLookIn.getSelectedIndex() == 2;
        if (next) {
            if (selection) {
                this._actualPosition = this.rbFindFoward.isSelected() ? textArea.getSelectionStart() : textArea.getSelectionEnd();
                this._minPosition = textArea.getSelectionStart();
                this._maxPosition = textArea.getSelectionEnd();
            } else {
                if (this.rbFindFoward.isSelected()) {
                    this._actualPosition = 0;
                } else {
                    this._actualPosition = textArea.getDocument().getLength() - 1;
                    if (this._actualPosition < 0) {
                        this._actualPosition = 0;
                    }
                }
                this._minPosition = 0;
                this._maxPosition = textArea.getDocument().getLength() - 1;
                if (this._maxPosition < 0) {
                    this._maxPosition = 0;
                }
            }
        } else if (selection) {
            this._actualPosition = this.rbFindFoward.isSelected() ? textArea.getSelectionEnd() : textArea.getSelectionStart();
            this._minPosition = textArea.getSelectionStart();
            this._maxPosition = textArea.getSelectionEnd();
        } else {
            if (this.rbFindFoward.isSelected()) {
                this._actualPosition = textArea.getDocument().getLength() - 1;
                if (this._actualPosition < 0) {
                    this._actualPosition = 0;
                }
            } else {
                this._actualPosition = 0;
            }
            this._minPosition = 0;
            this._maxPosition = textArea.getDocument().getLength() - 1;
            if (this._maxPosition < 0) {
                this._maxPosition = 0;
            }
        }
    }

    boolean searchNext() {
        if (this.rbFindFoward.isSelected()) {
            this._inc = 1;
            if (this._lastInc == -1) {
                this._actualPosition += 2;
            }
        } else {
            this._inc = -1;
            if (this._lastInc == 1) {
                this._actualPosition -= 2;
            }
        }
        return this.find(false);
    }

    boolean searchPrevious() {
        if (this.rbFindFoward.isSelected()) {
            this._inc = -1;
            if (this._lastInc == 1) {
                this._actualPosition -= 2;
            }
        } else {
            this._inc = 1;
            if (this._lastInc == -1) {
                this._actualPosition += 2;
            }
        }
        return this.find(false);
    }

    boolean find(boolean all) {
        return this.checkBuffer() && this.doFind(this._buffer, all);
    }

    boolean doFind(Buffer buffer, boolean all) {
        char[] searchForArray;
        char[] searchInArray;
        EditPane editPane = buffer.getSelectedEditPane();
        JNPadTextArea textArea = buffer.getSelectedTextArea();
        SearchContext context = this.getSearchContext();
        this.removeHighlight(editPane, context);
        String searchIn = textArea.getText();
        String searchFor = this.getSearchFor();
        if (this.cbMatchCase.isSelected()) {
            searchInArray = searchIn.toCharArray();
            searchForArray = searchFor.toCharArray();
        } else {
            searchInArray = searchIn.toLowerCase().toCharArray();
            searchForArray = searchFor.toLowerCase().toCharArray();
        }
        if (all) {
            this.jNPad.setFindResultsVisible(true);
        }
        boolean addNewFound = false;
        int len = searchInArray.length;
        while (this._actualPosition < len && this._actualPosition <= this._maxPosition && this._actualPosition >= this._minPosition) {
            if (searchInArray[this._actualPosition] == searchForArray[0] && this._actualPosition + searchForArray.length - 1 <= this._maxPosition) {
                int endPosition = this._actualPosition + 1;
                int ln = 1;
                while (ln < searchForArray.length && searchInArray[endPosition] == searchForArray[ln]) {
                    ++endPosition;
                    ++ln;
                }
                if (ln == searchForArray.length && this.checkWholeWord(searchInArray, this._actualPosition, ln, this._minPosition, this._maxPosition)) {
                    if (all) {
                        if (!addNewFound) {
                            this.jNPad.addNewFound(this.getSearchFor(), buffer.getFilePath());
                            addNewFound = true;
                        }
                        try {
                            String line = textArea.getLineTextOfOffset(this._actualPosition);
                            line = Utilities.removeNewLine(line);
                            this.jNPad.addNewText(new Text(line, context, buffer.getFilePath(), this._actualPosition, endPosition));
                        }
                        catch (BadLocationException ex) {
                            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                        }
                    } else {
                        try {
                            editPane.highlightSearch(context, this._actualPosition, endPosition);
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                        }
                        this._actualPosition += this._inc;
                        this._lastInc = this._inc;
                        return true;
                    }
                }
            }
            this._actualPosition += this._inc;
        }
        if (all) {
            editPane.highlightAllOccurrences(context);
            this.jNPad.showFoundTarget();
        }
        return false;
    }

    abstract void removeHighlight(EditPane var1, SearchContext var2);

    void reportWordNotFound() {
        ReporterUtilities.reportError(this, SearchBundle.getString("SearchDialog.notFound", this.getSearchFor()), this.getTitle());
    }

    int reportWordNotFound2() {
        Object[] options = new String[]{JNPadBundle.getYesOptionText(), JNPadBundle.getCancelOptionText()};
        int option = this.rbFindFoward.isSelected() ? JOptionPane.showOptionDialog(this, SearchBundle.getString("SearchDialog.options.message.next", this.getSearchFor()), JNPadBundle.getInformationTitle(), -1, 1, null, options, options[0]) : JOptionPane.showOptionDialog(this, SearchBundle.getString("SearchDialog.options.message.previous", this.getSearchFor()), JNPadBundle.getInformationTitle(), -1, 1, null, options, options[0]);
        return option;
    }

    boolean replace(boolean all) {
        return false;
    }

    boolean checkWholeWord(char[] searchInArray, int index, int len, int minIndex, int maxIndex) {
        boolean wsBefore = true;
        boolean wsAfter = true;
        if (this.cbMatchWholeWord.isSelected()) {
            if (index - 1 >= minIndex) {
                boolean bl = wsBefore = !Character.isUnicodeIdentifierPart(searchInArray[index - 1]);
            }
            if (index + len <= maxIndex) {
                boolean bl = wsAfter = !Character.isUnicodeIdentifierPart(searchInArray[index + len]);
            }
        }
        return wsBefore && wsAfter;
    }

    abstract void handleKeyPressed(KeyEvent var1);

    void handleActionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.btClose) {
            this.setVisible(false);
        } else if (obj == this.btFind && this.initialize(true)) {
            if (this.find(false)) {
                this.searchManagerDialog.loadState();
            } else {
                this.reportWordNotFound();
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchDialog.this.handleActionPerformed(e);
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            SearchDialog.this.handleKeyPressed(e);
        }
    }
}

