/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.Color;
import java.awt.Rectangle;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import jnpad.GUIUtilities;
import jnpad.config.Configurable;
import jnpad.text.EditPane;
import jnpad.text.JNPadDocument;
import jnpad.text.TextUtilities;

public abstract class AbstractTextArea
extends JTextArea
implements Configurable {
    EditPane editPane;
    private static final long serialVersionUID = 155332570251202612L;

    public AbstractTextArea(EditPane editPane) {
        this.editPane = editPane;
    }

    public Rectangle getViewRect() {
        return null;
    }

    public boolean isViewRectVisible() {
        return false;
    }

    public void setViewRectVisible(boolean b) {
    }

    public abstract String getContentType();

    @Override
    protected Document createDefaultModel() {
        return new JNPadDocument();
    }

    public JNPadDocument getJNPadDocument() {
        return (JNPadDocument)this.getDocument();
    }

    public abstract boolean isRightMarginLineVisible();

    public abstract int getRightMarginLineWidth();

    public abstract Color getRightMarginLineColor();

    public void setRightMarginLineWidth(int width) {
    }

    public void setRightMarginLineVisible(boolean b) {
    }

    public void setRightMarginLineColor(Color c) {
    }

    public void setCaret0() {
        this.setCaretPosition(0);
    }

    public void setCaretEnd() {
        final Document doc = this.getDocument();
        GUIUtilities.runOrInvokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractTextArea.this.setCaretPosition(doc.getLength());
            }
        });
    }

    public String getLineText(int line) throws BadLocationException {
        return this.getJNPadDocument().getLineText(line);
    }

    public String getLineTextOfOffset(int offset) throws BadLocationException {
        return this.getJNPadDocument().getLineTextOfOffset(offset);
    }

    public String getLineTextOfOffsetOnlyUpToPos(int offset) throws BadLocationException {
        return this.getJNPadDocument().getLineTextOfOffsetOnlyUpToPos(offset);
    }

    public Element getLine(int line) throws BadLocationException {
        return this.getJNPadDocument().getLine(line);
    }

    public boolean hasSelection() {
        Caret caret = this.getCaret();
        return caret.getMark() != caret.getDot();
    }

    public int getCaretLineNumber() {
        try {
            return this.getLineOfOffset(this.getCaretPosition());
        }
        catch (BadLocationException ble) {
            return 0;
        }
    }

    public int getCaretOffsetFromLineStart() {
        try {
            int pos = this.getCaretPosition();
            return pos - this.getLineStartOffset(this.getLineOfOffset(pos));
        }
        catch (BadLocationException ble) {
            return 0;
        }
    }

    public void scrollToMiddle(int pos) {
        TextUtilities.scrollToMiddle(this, pos);
    }

    public void scrollToMiddle(int pos, float ratio) {
        TextUtilities.scrollToMiddle(this, pos, ratio);
    }

    public void jumpToOffset(int offset) {
        if (offset < 0 || offset > this.getDocument().getLength()) {
            return;
        }
        this.requestFocusInWindow();
        this.scrollToMiddle(offset);
        this.setCaretPosition(offset);
    }

    public void moveToOffset(int offset) {
        if (offset < 0 || offset > this.getDocument().getLength()) {
            return;
        }
        this.requestFocusInWindow();
        this.scrollToMiddle(offset);
        this.moveCaretPosition(offset);
    }

    public boolean jumpToLineNumber(int line) {
        int offset;
        block3: {
            try {
                offset = this.getLineStartOffset(line);
                if (offset >= 0 && offset <= this.getDocument().getLength()) break block3;
                return false;
            }
            catch (BadLocationException ex) {
                return false;
            }
        }
        this.requestFocusInWindow();
        this.scrollToMiddle(offset);
        this.setCaretPosition(offset);
        return true;
    }

    public boolean moveToLineNumber(int line) {
        int offset;
        block3: {
            try {
                offset = this.getLineStartOffset(line);
                if (offset >= 0 && offset <= this.getDocument().getLength()) break block3;
                return false;
            }
            catch (BadLocationException ex) {
                return false;
            }
        }
        this.requestFocusInWindow();
        this.scrollToMiddle(offset);
        this.moveCaretPosition(offset);
        return true;
    }

    abstract boolean isMain();
}

