/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.Segment;
import jnpad.GUIUtilities;
import jnpad.JNPadBundle;
import jnpad.action.ActionManager;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.config.Controlable;
import jnpad.search.SearchContext;
import jnpad.text.ActiveLine;
import jnpad.text.Buffer;
import jnpad.text.DocumentRange;
import jnpad.text.Gutter;
import jnpad.text.GutterBase;
import jnpad.text.IView;
import jnpad.text.JNPadTextActions;
import jnpad.text.JNPadTextArea;
import jnpad.text.MarkStrip;
import jnpad.text.MinimapWindow;
import jnpad.text.OccurrencesContext;
import jnpad.text.TextBundle;
import jnpad.text.TextUtilities;
import jnpad.text.highlighter.BracketHighlightPainter;
import jnpad.text.highlighter.IHighlightPainter;
import jnpad.text.highlighter.OccurrenceHighlightPainter;
import jnpad.text.highlighter.OccurrencesHighlightable;
import jnpad.text.highlighter.SearchHighlightPainter;
import jnpad.ui.ColorUtilities;
import jnpad.ui.JNPadCheckBoxMenuItem;
import jnpad.ui.JNPadMenuItem;
import jnpad.ui.JNPadScrollPane;
import jnpad.ui.icon.IconUtilities;
import jnpad.ui.plaf.LAFUtils;
import jnpad.util.LinePosition;
import jnpad.util.Utilities;

public final class EditPane
extends JPanel
implements OccurrencesHighlightable,
Controlable,
IView {
    JPopupMenu popupMenu = new JPopupMenu();
    JNPadTextArea textArea;
    JScrollPane scrollPane = new JNPadScrollPane();
    private static IHighlightPainter searchHP = new SearchHighlightPainter();
    private static IHighlightPainter occurrenceHP = new OccurrenceHighlightPainter();
    private static IHighlightPainter bracketHP = new BracketHighlightPainter();
    private ActiveLine activeLine;
    private Gutter gutter;
    private GutterBase gutterBase;
    private MarkStrip markStrip;
    private JViewport originalRowHeader;
    public static final String PROPERTY_OCCURRENCES_CHANGED = "EditPane.occurrencesChanged";
    public static final String PROPERTY_BOOKMARKS_CHANGED = "EditPane.bookmarksChanged";
    public static final String PROPERTY_SEARCH_CHANGED = "EditPane.searchChanged";
    private Object bracketHighlightTag;
    private Object otherBracketHighlightTag;
    private int bracketLine = -1;
    private int otherBracketLine = -1;
    private int lastBracketPosition = -1;
    private int lastOtherBracketPosition = -1;
    private boolean isBracketHighlighterVisible;
    private Object searchHighlightTag;
    private SearchContext searchContext;
    private List<Object> l_occurrencesTags = new ArrayList<Object>();
    private List<DocumentRange> l_occurrences = new ArrayList<DocumentRange>();
    private OccurrencesContext occurrencesContext;
    private TreeSet<DocumentRange> bookmarks = new TreeSet();
    private boolean lastHasSelection;
    private int lastSelectionLength;
    private boolean isMarkStripVisible = Config.MARKER_VISIBLE.getValue();
    private boolean isGutterVisible = Config.GUTTER_VISIBLE.getValue();
    private boolean isActiveLineVisible = Config.ACTIVE_LINE_VISIBLE.getValue();
    private boolean isOccurrencesHighlighterVisible = Config.OCCURRENCES_HIGHLIGHTER_VISIBLE.getValue();
    private boolean isBookmarkingEnabled = Config.BOOKMARKING_ENABLED.getValue();
    private boolean occurrencesCicularNavigation = Config.OCCURRENCES_CIRCULAR_NAVIGATION.getValue();
    private boolean bookmarksCicularNavigation = Config.BOOKMARKS_CIRCULAR_NAVIGATION.getValue();
    private LinePosition linePosition = new LinePosition();
    JNPadTextActions actions;
    Buffer buffer;
    JToggleButton tbShowMinimap = new JToggleButton();
    private MinimapWindow minimapWindow;
    private static Logger LOGGER = Logger.getLogger(EditPane.class.getName());
    private static final long serialVersionUID = 9206830119174114528L;

    public EditPane(Buffer buffer) {
        super(new BorderLayout());
        this.buffer = buffer;
        try {
            this.textArea = new JNPadTextArea(this);
            this.jbInit();
            this.setBracketHighlighterVisible(Config.BRACKET_HIGHLIGHTER_VISIBLE.getValue());
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    public EditPane(Buffer buffer, String text) {
        this(buffer);
        this.textArea.setText(text);
    }

    EditPane(Buffer buffer, EditPane oldEditPane) {
        super(new BorderLayout());
        this.buffer = buffer;
        try {
            this.textArea = new JNPadTextArea(this, oldEditPane.textArea);
            this.isMarkStripVisible = oldEditPane.isMarkStripVisible;
            this.isGutterVisible = oldEditPane.isGutterVisible;
            this.isActiveLineVisible = oldEditPane.isActiveLineVisible;
            this.isOccurrencesHighlighterVisible = oldEditPane.isOccurrencesHighlighterVisible;
            this.jbInit();
            this.setEditable(oldEditPane.isEditable());
            this.setDocument(oldEditPane.getDocument());
            this.setBracketHighlighterVisible(oldEditPane.isBracketHighlighterVisible);
            this.textArea.setCaretPosition(oldEditPane.textArea.getCaretPosition());
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void jbInit() throws Exception {
        this.actions = JNPadTextActions.getActions(this.textArea);
        this.markStrip = new MarkStrip(this);
        this.setOpaque(false);
        this.scrollPane.getViewport().add((Component)this.textArea, null);
        this.gutterBase = new GutterBase(this);
        this.scrollPane.setCorner("LOWER_LEFT_CORNER", this.gutterBase);
        this.originalRowHeader = this.scrollPane.getRowHeader();
        this.doSetLineNumbersVisible(this.isLineNumbersVisible());
        this.doSetActiveLineVisible(this.isActiveLineVisible());
        this.textArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                LinePosition p = TextUtilities.getLinePosition(EditPane.this.textArea, e.getDot());
                EditPane.this.linePosition.set(p);
                EditPane.this.markStrip.caretUpdate();
                EditPane.this.updateControls(1024);
                EditPane.this.updateSelection();
                if (EditPane.this.isBracketHighlighterVisible()) {
                    EditPane.this.updateBracketHighlighters();
                }
            }
        });
        this.textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                EditPane.this.handleMousePressed(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                EditPane.this.handleMouseClicked(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                EditPane.this.handleMouseReleased(e);
            }
        });
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.markStrip, "After");
        if (!this.isMarkStripVisible()) {
            this.markStrip.setVisible(false);
        }
        ActionManager actionManager = ActionManager.INSTANCE;
        this.popupMenu.add(new JNPadMenuItem(actionManager.get("cut")));
        this.popupMenu.add(new JNPadMenuItem(actionManager.get("cut-line")));
        this.popupMenu.add(new JNPadMenuItem(actionManager.get("copy")));
        this.popupMenu.add(new JNPadMenuItem(actionManager.get("copy-line")));
        this.popupMenu.add(new JNPadMenuItem(actionManager.get("paste")));
        this.popupMenu.add(new JNPadMenuItem(actionManager.get("delete-line")));
        this.popupMenu.add(new JNPadMenuItem(actionManager.get("select-all")));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JNPadMenuItem(actionManager.get("find")));
        this.popupMenu.add(new JNPadMenuItem(actionManager.get("replace")));
        this.popupMenu.addSeparator();
        ButtonGroup bgScope = new ButtonGroup();
        JMenu mScope = GUIUtilities.createMenu(JNPadBundle.getString("menu.view.scope", new Object[0]), GUIUtilities.EMPTY_ICON);
        mScope.add(new JNPadCheckBoxMenuItem(actionManager.get("select-view-action-scope-viewer"), bgScope));
        mScope.add(new JNPadCheckBoxMenuItem(actionManager.get("select-view-action-scope-buffer-set"), bgScope));
        mScope.add(new JNPadCheckBoxMenuItem(actionManager.get("select-view-action-scope-buffer"), bgScope));
        mScope.add(new JNPadCheckBoxMenuItem(actionManager.get("select-view-action-scope-edit-pane"), bgScope));
        this.popupMenu.add(mScope);
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JNPadMenuItem(actionManager.get("right-indent")));
        this.popupMenu.add(new JNPadMenuItem(actionManager.get("left-indent")));
        JMenu mCharCaseChange = GUIUtilities.createMenu(JNPadBundle.getString("PopupButton.charCaseChange", new Object[0]), GUIUtilities.EMPTY_ICON);
        mCharCaseChange.add(new JNPadMenuItem(actionManager.get("to-upper-case")));
        mCharCaseChange.add(new JNPadMenuItem(actionManager.get("to-lower-case")));
        mCharCaseChange.add(new JNPadMenuItem(actionManager.get("invert-upper-lower")));
        mCharCaseChange.add(new JNPadMenuItem(actionManager.get("capitalize")));
        mCharCaseChange.add(new JNPadMenuItem(actionManager.get("to-title")));
        this.popupMenu.add(mCharCaseChange);
        JMenu mAlignStrings = GUIUtilities.createMenu(JNPadBundle.getString("menu.format.alignStrings", new Object[0]), GUIUtilities.EMPTY_ICON);
        mAlignStrings.add(new JNPadMenuItem(actionManager.get("align-strings-by-comma")));
        mAlignStrings.add(new JNPadMenuItem(actionManager.get("align-strings-by-equal")));
        mAlignStrings.add(new JNPadMenuItem(actionManager.get("align-strings-by-clipboard")));
        this.popupMenu.add(mAlignStrings);
        this.popupMenu.addSeparator();
        JMenu mSplitting = GUIUtilities.createMenu(JNPadBundle.getString("menu.window.splitting", new Object[0]), GUIUtilities.EMPTY_ICON);
        mSplitting.add(new JNPadMenuItem(actionManager.get("unsplit-current")));
        mSplitting.add(new JNPadMenuItem(actionManager.get("unsplit")));
        mSplitting.add(new JNPadMenuItem(actionManager.get("split-horizontally")));
        mSplitting.add(new JNPadMenuItem(actionManager.get("split-vertically")));
        mSplitting.add(new JNPadMenuItem(actionManager.get("restore-split")));
        mSplitting.addSeparator();
        mSplitting.add(new JNPadMenuItem(actionManager.get("previous-edit-pane")));
        mSplitting.add(new JNPadMenuItem(actionManager.get("next-edit-pane")));
        mSplitting.addSeparator();
        mSplitting.add(new JNPadMenuItem(actionManager.get("unsplit-viewer-current")));
        mSplitting.add(new JNPadMenuItem(actionManager.get("unsplit-viewer")));
        mSplitting.add(new JNPadMenuItem(actionManager.get("split-viewer-horizontally")));
        mSplitting.add(new JNPadMenuItem(actionManager.get("split-viewer-vertically")));
        mSplitting.add(new JNPadMenuItem(actionManager.get("restore-viewer-split")));
        mSplitting.addSeparator();
        mSplitting.add(new JNPadMenuItem(actionManager.get("next-buffer-set")));
        mSplitting.add(new JNPadMenuItem(actionManager.get("previous-buffer-set")));
        this.popupMenu.add(mSplitting);
        ActionListener showPopupActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Point p = EditPane.this.textArea.getCaret().getMagicCaretPosition();
                int x = (int)p.getX();
                int y = (int)p.getY();
                SwingUtilities.updateComponentTreeUI(EditPane.this.popupMenu);
                EditPane.this.popupMenu.pack();
                int popupMenuWidth = EditPane.this.popupMenu.getPreferredSize().width;
                int popupMenuHeight = EditPane.this.popupMenu.getPreferredSize().height;
                int fontHeight = EditPane.this.textArea.getFont().getSize();
                int widthLimit = EditPane.this.textArea.getSize().width - popupMenuWidth;
                int heightLimit = EditPane.this.textArea.getSize().height - (popupMenuHeight + 2);
                if (x >= widthLimit) {
                    x -= popupMenuWidth;
                }
                if (y >= heightLimit) {
                    y -= popupMenuHeight + fontHeight;
                }
                EditPane.this.popupMenu.show(EditPane.this, x, y);
            }
        };
        this.textArea.registerKeyboardAction(showPopupActionHandler, "show-popup-menu", Accelerators.getPropAccelerator("show-popup-menu.shortcut", Accelerators.SHOW_POPUP_MENU), 1);
        this.textArea.registerKeyboardAction(showPopupActionHandler, "show-popup-menu2", Accelerators.getPropAccelerator("show-popup-menu.shortcut2", Accelerators.SHOW_POPUP_MENU2), 1);
        if (Config.isDistractionFreeMode()) {
            this.textArea.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    if (EditPane.this.scrollPane.isWheelScrollingEnabled() && e.getWheelRotation() != 0) {
                        int newValue;
                        JScrollBar toScroll;
                        boolean isHorizontal;
                        boolean bl = isHorizontal = (e.getModifiersEx() & 0x40) != 0;
                        if (isHorizontal) {
                            toScroll = EditPane.this.scrollPane.getHorizontalScrollBar();
                            int value = toScroll.getValue();
                            FontMetrics fm = EditPane.this.textArea.getFontMetrics(EditPane.this.textArea.getFont());
                            int characterWidth = fm.stringWidth("M");
                            newValue = value += e.getUnitsToScroll() * characterWidth;
                        } else {
                            toScroll = EditPane.this.scrollPane.getVerticalScrollBar();
                            int value = toScroll.getValue();
                            FontMetrics fm = EditPane.this.textArea.getFontMetrics(EditPane.this.textArea.getFont());
                            int lineHeight = fm.getHeight();
                            newValue = value += e.getUnitsToScroll() * lineHeight;
                        }
                        toScroll.setValue(newValue);
                    }
                }
            });
        }
        this.tbShowMinimap.setIcon(new IconUtilities.EyeIcon(10, 10, true, ColorUtilities.giveYellowTouch(LAFUtils.getControl())));
        this.tbShowMinimap.setToolTipText(TextBundle.getString("EditPane.minimap", new Object[0]));
        this.tbShowMinimap.setBorder(BorderFactory.createEmptyBorder());
        this.tbShowMinimap.setBorderPainted(false);
        this.tbShowMinimap.setRequestFocusEnabled(false);
        this.tbShowMinimap.setMargin(LAFUtils.isNimbusLAF() ? new Insets(0, -7, 0, -7) : new Insets(0, 0, 0, 0));
        this.tbShowMinimap.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (EditPane.this.tbShowMinimap.isSelected()) {
                    EditPane.this.minimapWindow = new MinimapWindow(EditPane.this);
                } else if (EditPane.this.minimapWindow != null) {
                    EditPane.this.minimapWindow.dispose();
                    EditPane.this.minimapWindow = null;
                    Utilities.gc();
                }
            }
        });
        this.scrollPane.setCorner("LOWER_RIGHT_CORNER", this.tbShowMinimap);
    }

    public void setDocument(Document doc) {
        this.textArea.setDocument(doc);
    }

    public Document getDocument() {
        return this.textArea.getDocument();
    }

    public SearchContext getSearchContext() {
        return this.searchContext;
    }

    public OccurrencesContext getOccurrencesContext() {
        return this.occurrencesContext;
    }

    void updateSelection() {
        int selectionLength;
        boolean hasSelection = this.hasSelection();
        if (hasSelection != this.lastHasSelection) {
            this.lastHasSelection = hasSelection;
            this.updateControls(8);
        }
        if ((selectionLength = this.textArea.getSelectionEnd() - this.textArea.getSelectionStart()) != this.lastSelectionLength) {
            this.lastSelectionLength = selectionLength;
            this.buffer.getStatusBar().setSelection(selectionLength);
        }
    }

    public boolean getBookmarksCircularNavigation() {
        return this.bookmarksCicularNavigation;
    }

    public void setBookmarksCircularNavigation(boolean b) {
        this.bookmarksCicularNavigation = b;
    }

    public boolean getOccurrencesCircularNavigation() {
        return this.occurrencesCicularNavigation;
    }

    public void setOccurrencesCircularNavigation(boolean b) {
        this.occurrencesCicularNavigation = b;
    }

    public boolean isBookmarkingEnabled() {
        return this.isBookmarkingEnabled;
    }

    public void setBookmarkingEnabled(boolean b) {
        if (b != this.isBookmarkingEnabled) {
            this.isBookmarkingEnabled = b;
            if (!b) {
                this.clearAllBookmarks();
            }
        }
    }

    private void addBookmark(DocumentRange range) {
        if (this.bookmarks.add(range)) {
            this.repaintGutter();
            this.updateControls(64);
            this.firePropertyChange(PROPERTY_BOOKMARKS_CHANGED, this.bookmarks.size() - 1, this.bookmarks.size());
        }
    }

    private void removeBookmark(DocumentRange range) {
        if (this.bookmarks.remove(range)) {
            this.repaintGutter();
            this.updateControls(64);
            this.firePropertyChange(PROPERTY_BOOKMARKS_CHANGED, this.bookmarks.size() + 1, this.bookmarks.size());
        }
    }

    public void addBookmark(int line) {
        if (!this.isBookmarkingEnabled()) {
            return;
        }
        try {
            this.removeBookmark(line);
            this.addBookmark(this.getRange(line));
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    public void addBookmarks(Collection<? extends Integer> lines) {
        if (!this.isBookmarkingEnabled() || lines == null || lines.isEmpty()) {
            return;
        }
        try {
            int old = this.bookmarks.size();
            for (Integer n : lines) {
                int line = n;
                this.removeBookmark(line);
                this.bookmarks.add(this.getRange(line));
            }
            if (old != this.bookmarks.size()) {
                this.repaintGutter();
                this.updateControls(64);
                this.firePropertyChange(PROPERTY_BOOKMARKS_CHANGED, old, this.bookmarks.size());
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private DocumentRange getRange(int line) throws BadLocationException {
        Document doc = this.textArea.getDocument();
        Element lineElem = this.textArea.getLine(line);
        int start = lineElem.getStartOffset();
        int end = lineElem.getEndOffset();
        DocumentRange range = new DocumentRange();
        range.start = start == 0 ? doc.createPosition(1) : doc.createPosition(start);
        range.end = doc.createPosition(end);
        range.first = start == 0;
        return range;
    }

    public void removeBookmark(int line) {
        if (!this.isBookmarkingEnabled()) {
            return;
        }
        DocumentRange target = this.getBookmark(line);
        if (target != null) {
            this.removeBookmark(target);
        }
    }

    public boolean toggleBookmark(int line) {
        if (!this.isBookmarkingEnabled()) {
            return false;
        }
        DocumentRange target = this.getBookmark(line);
        if (target != null) {
            this.removeBookmark(target);
            return false;
        }
        this.addBookmark(line);
        return true;
    }

    public DocumentRange getBookmark(int line) {
        for (DocumentRange range : this.bookmarks) {
            try {
                int ln = this.textArea.getLineOfOffset(range.getStartOffset());
                if (line != ln) continue;
                return range;
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.FINE, ex.getMessage(), ex);
            }
        }
        return null;
    }

    public int getBookmarksCount() {
        return this.bookmarks.size();
    }

    public boolean hasBookmarks() {
        return this.bookmarks.size() > 0;
    }

    public DocumentRange[] getBookmarks() {
        return this.bookmarks.toArray(new DocumentRange[this.bookmarks.size()]);
    }

    public void clearAllBookmarks() {
        int old = this.bookmarks.size();
        if (old != 0) {
            this.bookmarks.clear();
            this.repaintGutter();
            this.updateControls(64);
            this.firePropertyChange(PROPERTY_BOOKMARKS_CHANGED, old, 0);
        }
    }

    public void nextBookmark() {
        if (!this.hasBookmarks()) {
            return;
        }
        DocumentRange[] bookmarks_ = this.getBookmarks();
        int actualPosition = this.textArea.getCaretPosition();
        int result = Integer.MAX_VALUE;
        int i = bookmarks_.length - 1;
        while (i >= 0) {
            int aa = bookmarks_[i].getStartOffset();
            if (aa <= actualPosition) break;
            result = Math.min(result, aa);
            --i;
        }
        if (this.getBookmarksCircularNavigation() && (result < 0 || result == Integer.MAX_VALUE)) {
            result = bookmarks_[0].getStartOffset();
        }
        try {
            if (result >= 0 && result < Integer.MAX_VALUE) {
                this.textArea.setCaretPosition(result);
                this.textArea.scrollToMiddle(result);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(this.textArea);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    public void previousBookmark() {
        if (!this.hasBookmarks()) {
            return;
        }
        DocumentRange[] bookmarks_ = this.getBookmarks();
        int actualPosition = this.textArea.getCaretPosition();
        int result = -1;
        DocumentRange[] documentRangeArray = bookmarks_;
        int n = bookmarks_.length;
        int n2 = 0;
        while (n2 < n) {
            DocumentRange aBookmarks_ = documentRangeArray[n2];
            int aa = aBookmarks_.getStartOffset();
            if (aa >= actualPosition) break;
            result = Math.max(result, aa);
            ++n2;
        }
        if (this.getBookmarksCircularNavigation() && (result < 0 || result == Integer.MAX_VALUE)) {
            result = bookmarks_[bookmarks_.length - 1].getStartOffset();
        }
        try {
            if (result >= 0) {
                this.textArea.setCaretPosition(result);
                this.textArea.scrollToMiddle(result);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(this.textArea);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    public String getFilePath() {
        return this.buffer.getFilePath();
    }

    public JNPadTextActions getActions() {
        return this.actions;
    }

    void handleMouseClicked(MouseEvent e) {
        if (e.getSource() == this.textArea && !e.isPopupTrigger()) {
            this.clearSearchHighlight();
            if (e.getClickCount() == 2) {
                this.doubleClicked(e);
            } else {
                this.lineClicked(e);
            }
        }
    }

    void handleMousePressed(MouseEvent e) {
        if (e.getSource() == this.textArea && e.isPopupTrigger()) {
            this.requestFocus();
            this.showPopupMenu(e);
        }
    }

    void handleMouseReleased(MouseEvent e) {
        if (e.getSource() == this.textArea && e.isPopupTrigger()) {
            this.requestFocus();
            this.showPopupMenu(e);
        }
    }

    private void showPopupMenu(MouseEvent e) {
        SwingUtilities.updateComponentTreeUI(this.popupMenu);
        this.popupMenu.pack();
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private void lineClicked(MouseEvent e) {
        this.clearAllOccurrences();
    }

    private void doubleClicked(MouseEvent e) {
        if (this.isOccurrencesHighlighterVisible()) {
            if (e.isAltDown() && e.isControlDown()) {
                this.doHighlightAllOccurrences(true, true);
            } else if (e.isAltDown()) {
                this.doHighlightAllOccurrences(true, false);
            } else if (e.isControlDown()) {
                this.doHighlightAllOccurrences(false, true);
            } else {
                this.doHighlightAllOccurrences(false, false);
            }
        }
    }

    private void doHighlightAllOccurrences(boolean matchCase, boolean wholeWord) {
        int sl = this.textArea.getSelectionEnd() - this.textArea.getSelectionStart();
        if (sl > 0 && sl < 1000) {
            String sel = this.textArea.getSelectedText();
            if (sel == null) {
                this.clearAllOccurrences();
                return;
            }
            sel = sel.trim();
            SearchContext searchContext = new SearchContext(sel);
            searchContext.setMatchCase(matchCase);
            searchContext.setWholeWord(wholeWord);
            searchContext.setHighlightAll(true);
            searchContext.setSearchForward(true);
            this.highlightAllOccurrences(searchContext);
        }
    }

    public void highlightSearch(SearchContext context, int begin, int end) throws BadLocationException {
        this.doClearSearchHighlight();
        this.searchHighlightTag = this.textArea.getHighlighter().addHighlight(begin, end, searchHP);
        this.textArea.setCaretPosition(begin);
        this.scrollRectToVisible(this.textArea.modelToView(begin));
        this.updateControls(128);
        SearchContext old = this.searchContext;
        this.searchContext = context;
        this.firePropertyChange(PROPERTY_SEARCH_CHANGED, old, this.searchContext);
        if (context.getHighlightAll()) {
            SearchContext context2;
            if (this.occurrencesContext != null && context.equals2(context2 = this.occurrencesContext.getSearchContext())) {
                return;
            }
            this.highlightAllOccurrences(context);
        }
    }

    public void clearSearchHighlight() {
        if (this.doClearSearchHighlight()) {
            this.updateControls(128);
            SearchContext old = this.searchContext;
            this.searchContext = null;
            this.firePropertyChange(PROPERTY_SEARCH_CHANGED, old, this.searchContext);
        }
    }

    private boolean doClearSearchHighlight() {
        if (this.searchHighlightTag != null) {
            this.textArea.getHighlighter().removeHighlight(this.searchHighlightTag);
            this.searchHighlightTag = null;
            return true;
        }
        return false;
    }

    @Override
    public void clearAllOccurrences() {
        if (this.doClearAllOccurrences()) {
            this.updateControls(32);
            OccurrencesContext old = this.occurrencesContext;
            this.occurrencesContext = null;
            this.firePropertyChange(PROPERTY_OCCURRENCES_CHANGED, old, this.occurrencesContext);
        }
    }

    private boolean doClearAllOccurrences() {
        if (this.l_occurrencesTags.size() > 0) {
            for (Object tag : this.l_occurrencesTags) {
                this.textArea.getHighlighter().removeHighlight(tag);
            }
            this.l_occurrencesTags.clear();
            this.l_occurrences.clear();
            return true;
        }
        return false;
    }

    @Override
    public void highlightAllOccurrences(SearchContext searchContext) {
        this.doClearAllOccurrences();
        String searchFor = searchContext.getSearchFor();
        boolean ignoreCase = !searchContext.getMatchCase();
        boolean wholeWord = searchContext.getWholeWord();
        if (Utilities.isEmptyString(searchFor)) {
            return;
        }
        int len = searchFor.length();
        String target = ignoreCase ? searchFor.toLowerCase() : searchFor;
        try {
            int[] visibleBounds = TextUtilities.getVisibleDocPosBounds(this.textArea, this.scrollPane);
            String part = this.textArea.getText(visibleBounds[0], visibleBounds[1] - visibleBounds[0]);
            if (ignoreCase) {
                part = part.toLowerCase();
            }
            int pos = -1;
            while ((pos = Utilities.indexOf(part, target, pos + 1, false, wholeWord)) >= 0) {
                this.l_occurrencesTags.add(this.textArea.getHighlighter().addHighlight(pos + visibleBounds[0], pos + visibleBounds[0] + target.length(), occurrenceHP));
            }
            Document doc = this.textArea.getDocument();
            part = TextUtilities.getText(doc);
            if (ignoreCase) {
                part = part.toLowerCase();
            }
            pos = -1;
            while ((pos = Utilities.indexOf(part, target, pos + 1, false, wholeWord)) >= 0) {
                DocumentRange range = new DocumentRange();
                range.start = pos == 0 ? doc.createPosition(1) : doc.createPosition(pos);
                range.end = doc.createPosition(pos + len);
                range.first = pos == 0;
                this.l_occurrences.add(range);
                if (pos >= visibleBounds[0] && pos <= visibleBounds[1]) continue;
                this.l_occurrencesTags.add(this.textArea.getHighlighter().addHighlight(pos, pos + len, occurrenceHP));
            }
            if (this.l_occurrences.size() != this.l_occurrencesTags.size()) {
                LOGGER.info("l_occurrences.size() != l_occurrencesTags.size()");
            }
            this.updateControls(32);
            OccurrencesContext old = this.occurrencesContext;
            this.occurrencesContext = new OccurrencesContext(searchContext, this.l_occurrences.size());
            this.firePropertyChange(PROPERTY_OCCURRENCES_CHANGED, old, this.occurrencesContext);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    public void focusOnTextArea() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditPane.this.textArea.requestFocus();
            }
        });
    }

    void refreshCaretPosition() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditPane.this.textArea.setCaretPosition(EditPane.this.textArea.getCaretPosition());
            }
        });
    }

    public boolean hasSearched() {
        return this.searchHighlightTag != null;
    }

    public DocumentRange getSearched() {
        DocumentRange range = null;
        if (this.searchHighlightTag != null && this.searchHighlightTag instanceof Highlighter.Highlight) {
            Highlighter.Highlight h = (Highlighter.Highlight)this.searchHighlightTag;
            int start = h.getStartOffset();
            int end = h.getEndOffset();
            Document doc = this.textArea.getDocument();
            try {
                range = new DocumentRange();
                range.start = start == 0 ? doc.createPosition(1) : doc.createPosition(start);
                range.end = doc.createPosition(end);
                range.first = start == 0;
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.FINE, ex.getMessage(), ex);
            }
        }
        return range;
    }

    public int getOccurrencesCount() {
        return this.l_occurrences.size();
    }

    public boolean hasOccurrences() {
        return this.l_occurrences.size() > 1;
    }

    public DocumentRange[] getOccurrences() {
        return this.l_occurrences.toArray(new DocumentRange[this.l_occurrences.size()]);
    }

    public void nextOccurrence() {
        if (!this.hasOccurrences()) {
            return;
        }
        int actualPosition = this.textArea.getCaretPosition();
        int result = Integer.MAX_VALUE;
        int i = this.l_occurrences.size() - 1;
        while (i >= 0) {
            int aa = this.l_occurrences.get(i).getStartOffset();
            if (aa <= actualPosition) break;
            result = Math.min(result, aa);
            --i;
        }
        if (this.getOccurrencesCircularNavigation() && (result < 0 || result == Integer.MAX_VALUE)) {
            result = this.l_occurrences.get(0).getStartOffset();
        }
        try {
            if (result >= 0 && result < Integer.MAX_VALUE) {
                this.textArea.setCaretPosition(result);
                this.textArea.scrollToMiddle(result);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(this.textArea);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    public void previousOccurrence() {
        if (!this.hasOccurrences()) {
            return;
        }
        int actualPosition = this.textArea.getCaretPosition();
        int result = -1;
        for (DocumentRange l_occurrence : this.l_occurrences) {
            int aa = l_occurrence.getStartOffset();
            if (aa >= actualPosition) break;
            result = Math.max(result, aa);
        }
        if (this.getOccurrencesCircularNavigation() && (result < 0 || result == Integer.MAX_VALUE)) {
            result = this.l_occurrences.get(this.l_occurrences.size() - 1).getStartOffset();
        }
        try {
            if (result >= 0) {
                this.textArea.setCaretPosition(result);
                this.textArea.scrollToMiddle(result);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(this.textArea);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    @Override
    public void configure(int cfg) {
        this.textArea.configure(cfg);
        this.markStrip.configure(cfg);
        this.gutterBase.configure(cfg);
        if (this.gutter != null) {
            this.gutter.configure(cfg);
        }
        if (this.activeLine != null) {
            this.activeLine.configure(cfg);
        }
        searchHP.configure(cfg);
        occurrenceHP.configure(cfg);
        bracketHP.configure(cfg);
        if ((cfg & 4) != 0) {
            this.setOccurrencesHighlighterVisible(Config.OCCURRENCES_HIGHLIGHTER_VISIBLE.getValue());
            this.setLineNumbersVisible(Config.GUTTER_VISIBLE.getValue());
            this.setActiveLineVisible(Config.ACTIVE_LINE_VISIBLE.getValue());
            this.setBookmarkingEnabled(Config.BOOKMARKING_ENABLED.getValue());
            this.setOccurrencesCircularNavigation(Config.OCCURRENCES_CIRCULAR_NAVIGATION.getValue());
            this.setBookmarksCircularNavigation(Config.BOOKMARKS_CIRCULAR_NAVIGATION.getValue());
        }
        if (this.minimapWindow != null) {
            this.minimapWindow.configure(cfg);
        }
    }

    @Override
    public void updateControls() {
        this.updateControls(8191);
    }

    @Override
    public void updateControls(int ctrls) {
        if ((ctrls & 8) != 0 || (ctrls & 0x200) != 0) {
            if ((ctrls & 8) != 0) {
                this.lastSelectionLength = this.textArea.getSelectionEnd() - this.textArea.getSelectionStart();
                this.buffer.getStatusBar().setSelection(this.lastSelectionLength);
            }
            ActionManager.INSTANCE.setEnabledBy(this.isEditable(), this.hasSelection(), this.buffer.canUndo(), this.buffer.canRedo(), this.buffer.isDirty());
        }
        if ((ctrls & 0x100) != 0) {
            ActionManager.INSTANCE.setEnabled("line-wrap", "text/plain" == this.textArea.getContentType());
        }
        if ((ctrls & 0x20) != 0) {
            boolean b = this.hasOccurrences();
            ActionManager.INSTANCE.setEnabled("next-occurrence", b);
            ActionManager.INSTANCE.setEnabled("previous-occurrence", b);
            this.buffer.getStatusBar().setOccurrences(this.l_occurrences.size());
        }
        if ((ctrls & 0x400) != 0) {
            this.buffer.getStatusBar().setLinePosition(this.linePosition);
            int pos = this.textArea.getCaretPosition();
            int len = this.textArea.getDocument().getLength();
            this.buffer.getStatusBar().setPosition(pos, len);
            if (pos < len) {
                try {
                    this.buffer.getStatusBar().setCharacter(this.textArea.getText(pos, 1).charAt(0));
                }
                catch (BadLocationException blex) {
                    this.buffer.clearStatusMessageCharacter();
                }
            } else {
                this.buffer.clearStatusMessageCharacter();
            }
        }
        if ((ctrls & 2) != 0) {
            // empty if block
        }
        this.markStrip.updateControls(ctrls);
        this.gutterBase.updateControls(ctrls);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String text) {
        this.textArea.setText(text);
        this.textArea.setCaretPosition(0);
    }

    public boolean hasSelection() {
        return this.textArea.hasSelection();
    }

    public boolean isEditable() {
        return this.textArea.isEditable();
    }

    public void setEditable(boolean b) {
        this.textArea.setEditable(b);
        this.actions.setEditable(b);
    }

    public Font getEditorFont() {
        return this.textArea.getFont();
    }

    public void setEditorFont(Font f) {
        this.textArea.setFont(f);
    }

    public boolean getLineWrap() {
        return this.textArea.getLineWrap();
    }

    @Override
    public void setLineWrap(boolean b) {
        this.textArea.setLineWrap(b);
        this.textArea.setWrapStyleWord(b);
        if (b) {
            this.tbShowMinimap.setSelected(false);
        }
        this.tbShowMinimap.setEnabled(!b);
    }

    @Override
    public void setRightMarginLineVisible(boolean b) {
        this.textArea.setRightMarginLineVisible(b);
    }

    public boolean isRightMarginLineVisible() {
        return this.textArea.isRightMarginLineVisible();
    }

    @Override
    public void setMarkStripVisible(boolean b) {
        if (this.isMarkStripVisible != b) {
            this.markStrip.setVisible(b);
            this.isMarkStripVisible = b;
        }
    }

    public boolean isMarkStripVisible() {
        return this.isMarkStripVisible;
    }

    public Gutter getLineNumbers() {
        return this.gutter;
    }

    public JNPadTextArea getTextArea() {
        return this.textArea;
    }

    public boolean isLineNumbersVisible() {
        return this.isGutterVisible;
    }

    @Override
    public void setLineNumbersVisible(boolean b) {
        if (this.isGutterVisible != b) {
            this.doSetLineNumbersVisible(b);
            this.isGutterVisible = b;
            this.revalidate();
            this.repaint();
        }
    }

    private void doSetLineNumbersVisible(boolean b) {
        if (b) {
            if (this.gutter == null) {
                this.gutter = new Gutter(this.textArea);
            }
            this.scrollPane.setRowHeaderView(this.gutter);
        } else {
            this.scrollPane.setRowHeader(this.originalRowHeader);
        }
        if (this.minimapWindow != null) {
            this.minimapWindow.setLineNumbersVisible(b);
        }
    }

    void repaintGutter() {
        if (this.gutter != null) {
            this.gutter.repaint();
        }
        if (this.minimapWindow != null) {
            this.minimapWindow.repaintGutter();
        }
    }

    public boolean isActiveLineVisible() {
        return this.isActiveLineVisible;
    }

    @Override
    public void setActiveLineVisible(boolean b) {
        if (this.isActiveLineVisible != b) {
            this.doSetActiveLineVisible(b);
            this.isActiveLineVisible = b;
            this.revalidate();
            this.repaint();
        }
    }

    private void doSetActiveLineVisible(boolean b) {
        if (b) {
            if (this.activeLine == null) {
                this.activeLine = new ActiveLine(this.textArea);
            } else {
                this.activeLine.setVisible(true);
            }
        } else if (this.activeLine != null) {
            this.activeLine.setVisible(false);
        }
        if (this.minimapWindow != null) {
            this.minimapWindow.setActiveLineVisible(b);
        }
    }

    public boolean isOccurrencesHighlighterVisible() {
        return this.isOccurrencesHighlighterVisible;
    }

    @Override
    public void setOccurrencesHighlighterVisible(boolean b) {
        if (this.isOccurrencesHighlighterVisible != b) {
            if (b) {
                this.doHighlightAllOccurrences(false, false);
            } else {
                this.clearAllOccurrences();
            }
            this.actions.highlightAllOccurrencesAction.setEnabled(b);
            this.actions.nextOccurrenceAction.setEnabled(b);
            this.actions.previousOccurrenceAction.setEnabled(b);
            this.isOccurrencesHighlighterVisible = b;
        }
    }

    public boolean isBracketHighlighterVisible() {
        return this.isBracketHighlighterVisible;
    }

    @Override
    public void setBracketHighlighterVisible(boolean b) {
        block11: {
            block12: {
                block10: {
                    if (this.isBracketHighlighterVisible == b) {
                        return;
                    }
                    if (this.bracketHighlightTag == null) break block10;
                    if (b) break block11;
                    this.textArea.getHighlighter().removeHighlight(this.bracketHighlightTag);
                    this.bracketHighlightTag = null;
                    break block12;
                }
                if (b) {
                    try {
                        this.bracketHighlightTag = this.textArea.getHighlighter().addHighlight(0, 0, bracketHP);
                    }
                    catch (BadLocationException ex) {
                        LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
            }
            if (this.otherBracketHighlightTag != null) {
                if (!b) {
                    this.textArea.getHighlighter().removeHighlight(this.otherBracketHighlightTag);
                    this.otherBracketHighlightTag = null;
                }
            } else if (b) {
                try {
                    this.otherBracketHighlightTag = this.textArea.getHighlighter().addHighlight(0, 0, bracketHP);
                }
                catch (BadLocationException ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
        }
        this.isBracketHighlighterVisible = b;
    }

    void updateBracketHighlighters() {
        Document doc = this.textArea.getDocument();
        int caretPosition = this.textArea.getCaretPosition();
        try {
            int offset = -1;
            int bracket = 32;
            Segment segment = new Segment();
            if (caretPosition >= 0 && offset < 0) {
                doc.getText(caretPosition, 1, segment);
                bracket = segment.array[segment.offset];
                switch (bracket) {
                    case 40: 
                    case 41: 
                    case 91: 
                    case 93: 
                    case 123: 
                    case 125: {
                        offset = caretPosition;
                        break;
                    }
                }
            }
            if (caretPosition > 0 && offset < 0) {
                doc.getText(caretPosition - 1, 1, segment);
                bracket = segment.array[segment.offset];
                switch (bracket) {
                    case 40: 
                    case 41: 
                    case 91: 
                    case 93: 
                    case 123: 
                    case 125: {
                        offset = caretPosition - 1;
                        break;
                    }
                }
            }
            int iOtherOffset = -1;
            if (offset >= 0) {
                switch (bracket) {
                    case 40: {
                        iOtherOffset = TextUtilities.locateBracketForward(doc, offset, '(', ')');
                        break;
                    }
                    case 41: {
                        iOtherOffset = TextUtilities.locateBracketBackward(doc, offset, '(', ')');
                        break;
                    }
                    case 91: {
                        iOtherOffset = TextUtilities.locateBracketForward(doc, offset, '[', ']');
                        break;
                    }
                    case 93: {
                        iOtherOffset = TextUtilities.locateBracketBackward(doc, offset, '[', ']');
                        break;
                    }
                    case 123: {
                        iOtherOffset = TextUtilities.locateBracketForward(doc, offset, '{', '}');
                        break;
                    }
                    case 125: {
                        iOtherOffset = TextUtilities.locateBracketBackward(doc, offset, '{', '}');
                        break;
                    }
                }
                if (iOtherOffset >= 0) {
                    this.setHighlightedBracket(offset);
                    this.setOtherHighlightedBracket(iOtherOffset);
                    int iBracketLine = this.textArea.getLineOfOffset(offset);
                    int iOtherBracketLine = this.textArea.getLineOfOffset(iOtherOffset);
                    this.bracketLine = Math.min(iBracketLine, iOtherBracketLine);
                    this.otherBracketLine = Math.max(iBracketLine, iOtherBracketLine);
                } else {
                    this.setHighlightedBracket(-1);
                    this.setOtherHighlightedBracket(-1);
                    this.bracketLine = -1;
                    this.otherBracketLine = -1;
                }
            } else {
                this.setHighlightedBracket(-1);
                this.setOtherHighlightedBracket(-1);
                this.bracketLine = -1;
                this.otherBracketLine = -1;
            }
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    void setHighlightedBracket(int pos) {
        if (this.bracketHighlightTag == null) {
            return;
        }
        if (pos == this.lastBracketPosition) {
            return;
        }
        this.lastBracketPosition = pos;
        try {
            if (pos == -1) {
                this.textArea.getHighlighter().changeHighlight(this.bracketHighlightTag, 0, 0);
            } else {
                this.textArea.getHighlighter().changeHighlight(this.bracketHighlightTag, pos, pos + 1);
            }
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
        this.repaintGutter();
    }

    void setOtherHighlightedBracket(int pos) {
        if (this.otherBracketHighlightTag == null) {
            return;
        }
        if (pos == this.lastOtherBracketPosition) {
            return;
        }
        this.lastOtherBracketPosition = pos;
        try {
            if (pos == -1) {
                this.textArea.getHighlighter().changeHighlight(this.otherBracketHighlightTag, 0, 0);
            } else {
                this.textArea.getHighlighter().changeHighlight(this.otherBracketHighlightTag, pos, pos + 1);
            }
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
        this.repaintGutter();
    }

    int getBracketLineIndex() {
        return this.bracketLine;
    }

    int getOtherBracketLineIndex() {
        return this.otherBracketLine;
    }

    @Override
    public void requestFocus() {
        this.textArea.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.textArea.requestFocusInWindow();
    }
}

